<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use Mmanager\Domain\Factory\InvoiceFactory;
use Mmanager\Extensions\Mrepair\MRepair as MRepair;

class Client extends Basic_Controller {
	
	protected $invoice_number;
	protected $shaInPassPhrase;
	protected $pspid;
	protected $toHash;
	protected $hash;
	protected $acceptUrl;
	protected $amount;
	protected $cancelUrl;
	protected $currency;
	protected $declineUrl;
	protected $exceptionUrl;
	protected $language;
	protected $orderID;
	protected $name_company;
	protected $client_id;
	protected $client_language;
	protected $langData;
	protected $tpUrl;
	protected $homeUrl;
	protected $catalogUrl;
	protected $paypalAmount;
	protected $mollieAmount;
	protected $paypalApp;

	// Stripe
	protected $stripe;
	public function __construct()
	{
		parent::__construct();
		if ( !client_logged_in() )
		{
			// redirect them to the login page
			redirect('auth/client_login');
		} else {
			$this->client_id = _eID($_SESSION['client_id']);
		}
		$this->stripe = array(
		  "secret_key"      => get_option('stripe_secret_key'),
		  "publishable_key" => get_option('stripe_publishable_key')
		);
		
		\Stripe\Stripe::setApiKey($this->stripe['secret_key']);

		$this->paypalApp = array(
		  "sandbox_id"      => 0 == get_option('paypal_production_credentials') ? get_option('paypal_client_id') : "",
		  "production_id" => 0 == get_option('paypal_production_credentials') ? "" : get_option('paypal_client_id'),
		  "environment" => 0 == get_option('paypal_production_credentials') ? "sandbox" : "production"
		);
	}
	public function index($a = null, $id = null)
	{
		$this->load->model('clients/clients_model', 'clients');
		$view_data['pageJs'] = array(
            'clients.js',
            'products.js',
            'invoices.js',
            'payments.js'

        );
        if( _has_option('geolocation_enabled') ) {
        	$api_key = null != get_option('maps_api_key') ? get_option('maps_api_key'): false;
        	if ($api_key) {
        		$view_data['externalPluginJs'] = array(
        		    'https://maps.googleapis.com/maps/api/js?key='.$api_key,
        		    
        		);
        		$view_data['localPluginJs'] = array(
        		    'jgooglemap/jquery.googlemap.js'
        		);
        	}
        }
 
        $id = $_SESSION['client_id'];

        $this->client_language = client($id, 'client_language');
        $this->langData = client_language_meta($id);
        $this->lang->load('application', lang_code_to_string($this->client_language));
        $this->name_company = client($id, 'name_company');
        $data = array(
        	'client_id'       => $this->client_id,
        	'langdata'        => $this->langData,
        	'has_password'    => has_password($id),
        	'name_company'	  => $this->name_company,
        	'total_income'    => income_by_client($id),
        	'total_due'       => unpaid_invoice_by_client($id),
        	'unpaid_invoices_list'	  => client_invoices($id),
        	'clients'	=> client($id),
        	'client_type' => array(
        		'1' => __('option_individual', $id),
        		'2' => __('option_professional', $id)
        		),
        	'client_status' => array(
        		'1' => __('label_active', $id),
        		'0' => __('label_inactive', $id)
        		),
        	'filter' => '',
        	'stripe' => $this->stripe,
        	'paypalApp' => $this->paypalApp,
        	'stripe_publishable_key' => $this->stripe['publishable_key']
        	);
        $view_data['content'] = $this->Template->render('clients', 'client_view.phtml', $data, TRUE);
        $this->Template->render('templates', 'client_account.phtml', $view_data);
	}
	public function edit()
	{
		$view_data['pageJs'] = array(
            'clients.js',
            'products.js',
            'invoices.js'
        );
        $view_data['externalPluginJs'] = array(
            'https://maps.googleapis.com/maps/api/js?key=AIzaSyCC9-4zhLwMQcrpSgrs_zOkUso0Varmlj0',
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
            
        );
        $view_data['localPluginJs'] = array(
            'jgooglemap/jquery.googlemap.js'
        );
		$id = isset($_REQUEST['id']) ? _dID($_REQUEST['id']) : NULL;
		$this->client_id = $_REQUEST['id'];
		$this->client_language = client($id, 'client_language');
		$this->langData = client_language_meta($id);
		$this->lang->load('application', lang_code_to_string($this->client_language));
		$this->name_company = client($id, 'name_company');
		$data = array(
			'page_breadcrumb' => __('clients_edit', $id),
			'langdata'        => $this->langData,
			'has_password'    => has_password($id),
			'name_company' => $this->name_company,
			'disabled' => 'disabled',
			'hidden' => 'hidden',
			'readonly' => 'readonly',
			'client_id' => _eID($id),
			'clients'	=> client($id),
			'client_type' => array(
				'1' => __('option_individual', $id),
				'2' => __('option_professional', $id)
				),
			'client_status' => array(
				'1' => __('label_active', $id),
				'0' => __('label_inactive', $id)
				)
			);
		$view_data['content'] = $this->Template->render('clients', 'frontend_client_edit.phtml', $data, TRUE);
		$this->Template->render('templates', 'client_account.phtml', $view_data);
	}
	public function income_by_client()
	{
		$id = _dID($_REQUEST['id']);
		$range = $_REQUEST['range'];
		$income = income_by_client($id, $range);
		$unpaid = unpaid_invoice_by_client($id, $range);
		echo json_encode(array($income, $unpaid));
	}
	public function get_client_invoices()
	{
		$this->load->helper('security');
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$id = _dID($_REQUEST['id']);
		$change_rate = client($id, 'client_change_rate');
		$encrypt_id = $_REQUEST['id'];
		$invoices = client_invoices($id, $filter);
		if ($invoices)
		{
			foreach ($invoices as $invoice) {
				if ($invoice->amount_paid > $invoice->amount_refunded AND $invoice->invoice_status == 'Refunded')
				{
					$status = __('label_partially_refunded', $id);
				}
				elseif ($invoice->amount_paid > 0 AND $invoice->invoice_status !== 'Paid')
				{
					$status = __('label_partially_paid', $id);
				}
				elseif( $invoice->invoice_status == 'Expired' || $invoice->invoice_status == 'Open' || $invoice->invoice_status == 'Pending' || $invoice->invoice_status == 'Failed')
				{
					$status = __('unpaid', $id);
				}
				else
				{
					$status = __( strtolower($invoice->invoice_status), $id);
				}
				$this->orderID = $invoice->invoice_number;

				$this->acceptUrl = base_url("index.php/ingenico/return_page/is_accept?invoice_number=").$this->orderID;

				// Check if client has already paid by other means
				$last_amount_paid = floatval( get_invoice_vars($invoice->invoice_number, 'amount_paid') );
				if ( $last_amount_paid > 0)
				{
					$this->amount = round( ( ($invoice->total - $last_amount_paid) * $change_rate), 2) * 100;
					$this->paypalAmount = round( ( ($invoice->total - $last_amount_paid) * $change_rate), 2);
					$this->mollieAmount = round( ( ($invoice->total - $last_amount_paid) * $change_rate), 2);
				}
				else
				{
					$this->amount = round( ($invoice->total * $change_rate), 2) * 100;
					$this->paypalAmount = round( ($invoice->total * $change_rate), 2);
					$this->mollieAmount = round( ($invoice->total * $change_rate), 2);
				}
				$this->cancelUrl = base_url("index.php/ingenico/return_page/is_cancel?invoice_number=").$this->orderID;
				$this->catalogUrl = get_option('ingenico_catalog_url');
				$this->currency = client($id, 'client_currency');
				$this->declineUrl = base_url("index.php/ingenico/return_page/is_decline?invoice_number=").$this->orderID;
				$this->exceptionUrl = base_url("index.php/ingenico/return_page/is_exception?invoice_number=").$this->orderID;
				$this->homeUrl = get_option('ingenico_home_url');
				$this->language = client($id, 'client_language');
				$this->pspid = get_option('ingenico_pspid');
				$this->shaInPassPhrase = get_option('ingenico_shain');
				$this->tpUrl = 'template.html';
			
				$this->toHash = 'ACCEPTURL='.$this->acceptUrl.$this->shaInPassPhrase;
				$this->toHash .='AMOUNT='.$this->amount.$this->shaInPassPhrase;
				$this->toHash .='CANCELURL='.$this->cancelUrl.$this->shaInPassPhrase;
				$this->toHash .='CATALOGURL='.$this->catalogUrl.$this->shaInPassPhrase;
				$this->toHash .='CURRENCY='.$this->currency.$this->shaInPassPhrase;
				$this->toHash .='DECLINEURL='.$this->declineUrl.$this->shaInPassPhrase;
				$this->toHash .='EXCEPTIONURL='.$this->exceptionUrl.$this->shaInPassPhrase;
				$this->toHash .='HOMEURL='.$this->homeUrl.$this->shaInPassPhrase;
				$this->toHash .='LANGUAGE='.$this->language.$this->shaInPassPhrase;
				$this->toHash .='ORDERID='.$this->orderID.$this->shaInPassPhrase;
				$this->toHash .='PSPID='.$this->pspid.$this->shaInPassPhrase;
				$this->toHash .='TP='.$this->tpUrl.$this->shaInPassPhrase;

				$this->hash = do_hash($this->toHash);
				array_push($list, array(
					'id' 			  	  => $invoice->id,
					'invoice_number'      => $invoice->invoice_number,
					'enc_invoice_number'  => _eID($invoice->invoice_number),
					'date'   	 		  => _fdate( client( $invoice->client_id, 'client_language' ), $invoice->date ),
					'due_date' 		  	  => _fdate( client( $invoice->client_id, 'client_language' ), $invoice->due_date ),
					'total' 		  	  => format_number($invoice->total),
					'amount_refunded' 	  => format_number($invoice->amount_refunded),
					'amount_paid' 	      => format_number($invoice->amount_paid),
					'amount_due' 	      => format_number($invoice->amount_due),
					'totalnf' 		  	  => $invoice->total,
					'company'			  => get_option('company'),
					'invoice_number_str'  => __('invoices_invoice', $invoice->client_id) . ' ' .invoice_number_format(). '#' .$invoice->invoice_number,
					'client_id'			  => $encrypt_id,
					'status'              => $status,
					'stbool'			  => invoice_status($invoice->invoice_number),
					'pspID'				  => $this->pspid,
					'orderID'			  => $this->orderID,
					'amount'			  => $this->amount,
					'paypal_amount'		  => $this->paypalAmount,
					'mollie_amount'		  => $this->mollieAmount,
					'currency'			  => $this->currency,
					'language'			  => $this->language,
					'shasign'			  => $this->hash,
					'acceptUrl'			  => $this->acceptUrl,
					'declineUrl'		  => $this->declineUrl,
					'exceptionUrl'		  => $this->exceptionUrl,
					'cancelUrl'			  => $this->cancelUrl,
					'tpUrl'			      => $this->tpUrl,
					'homeUrl'			  => $this->homeUrl,
					'catalogUrl'		  => $this->catalogUrl
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function products_services()
	{
		$list = [];
		$id = _dID($_REQUEST['id']);

		$products_services = client_products_services($id);
		if ($products_services)
		{
			foreach ($products_services as $products_service) {
				array_push($list, array(
					'name' 		  		  => $products_service->name,
					'value' 	          => $products_service->value
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function check_password()
	{
		$this->load->library('encryption');
		$password = $_REQUEST['password'];
		$client_id = $_REQUEST['client_id'];
		
		$hash_password = $password;
		$client_password = $this->encryption->decrypt(client(_dID($client_id), 'client_password'));
		if ($hash_password === $client_password)
		{
			$this->session->set_userdata('pwd_verified', true);
			echo json_encode(array('success' => 1));
		}
		else
		{
			echo json_encode(array('success' => 0));
		}
	}
	/**
	 * Get client currency details and change range
	 */
	public function get_client_currency()
	{
		$client_id = $_REQUEST['client_id'];
		$currency = null !== client($client_id, 'client_currency') ? client($client_id, 'client_currency'): get_option('user_currency');
		$reponse = array(
			'currency_str' => $currency,
			'currency_symb' => get_currencies($currency, 'symbol'),
			'change_rate' => get_change_rate($currency)
			);
		echo json_encode($reponse);
	}
	public function view_repair_status()
	{
		$data = [
			'repairs' => []
		];
		$view_data['ticket_data'] 	= $this->Template->render('repair', 'view_status.phtml', $data, TRUE );
		$this->Template->render('repair', 'search.phtml', $view_data);
	}
	public function get_repair_status() {
		$ref = $_REQUEST['reference'];
		$output = [];
		if ($ref) {
			$repair = \Mmanager\Extensions\Mrepair\MRepair::searchRepairByReference($ref);
			$messages = \Mmanager\Extensions\Mrepair\MRepair::getRepairMessages($ref);
			if ($messages) {
				foreach ($messages as $value) {
					$from = new DateTime($value->created_on);
					$now = new DateTime("now");
					$since = timerFormat($from->getTimestamp(), $now->getTimestamp());

					$output[] = [
						'ticket_reference' => $value->ticket_reference,
						'ticket_title' => \Mmanager\Extensions\Mrepair\MRepair::getRepairTicket($value->ticket_reference, 'ticket_title'),
						'quote' => base_url('index.php/viewquote/view?id='). _eID(\Mmanager\Extensions\Mrepair\MRepair::getRepairTicket($value->ticket_reference, 'quote_number')),
						'created_on' => $value->created_on,
						'message' => $value->message,
						'since' => $since,
						'status' => strtoupper(\Mmanager\Extensions\Mrepair\MRepair::getRepairStatuses(\Mmanager\Extensions\Mrepair\MRepair::getRepairTicket($value->ticket_reference, 'ticket_status'), true)),
						'agent' => get_user_var($value->message_from, 'first_name')
					];
				}
				echo json_encode(array('success' => 1, 'status' => json_encode($output)));
			} else {
				echo json_encode(array('success' => 0, 'status' => __('label_invalid')));
			}
		}
	}
	public function view() {
		$e = isset($_REQUEST['e']) ? $_REQUEST['e'] : false;
		if ($e) {
			switch ($e) {
				case 'quotes':
					$this->load->model('clients/clients_model', 'clients');
					$view_data['pageJs'] = array(
			            'clients-invoices-index.js'
			        );
			        $id = $_SESSION['client_id'];

			        $this->client_id = _eID($id);
			        $this->client_language = client($id, 'client_language');
			        $this->langData = client_language_meta($id);
			        $this->lang->load('application', lang_code_to_string($this->client_language));
			        $this->name_company = client($id, 'name_company');
			        $data = array(
			        	'client_id'       => $this->client_id,
			        	'langdata'        => $this->langData,
			        	'has_password'    => has_password($id),
			        	'name_company'	  => $this->name_company,
			        	'total_income'    => income_by_client($id),
			        	'total_due'       => unpaid_invoice_by_client($id),
			        	'unpaid_invoices_list'	  => client_invoices($id),
			        	'clients'	=> client($id),
			        	'client_type' => array(
			        		'1' => __('option_individual', $id),
			        		'2' => __('option_professional', $id)
			        		),
			        	'client_status' => array(
			        		'1' => __('label_active', $id),
			        		'0' => __('label_inactive', $id)
			        		),
			        	'filter' => '',
			        	);
			        $view_data['content'] = $this->Template->render('clients', 'client_quotes.phtml', $data, TRUE);
			        $this->Template->render('templates', 'client_account.phtml', $view_data);
					break;
				case 'proforma':
					$this->load->model('clients/clients_model', 'clients');
					$view_data['pageJs'] = array(
			            'proforma-index.js'
			        );
			        $id = $_SESSION['client_id'];

			        $this->client_id = _eID($id);
			        $this->client_language = client($id, 'client_language');
			        $this->langData = client_language_meta($id);
			        $this->lang->load('application', lang_code_to_string($this->client_language));
			        $this->name_company = client($id, 'name_company');
			        $data = array(
			        	'client_id'       => $this->client_id,
			        	'langdata'        => $this->langData,
			        	'has_password'    => has_password($id),
			        	'name_company'	  => $this->name_company,
			        	'total_income'    => income_by_client($id),
			        	'total_due'       => unpaid_invoice_by_client($id),
			        	'unpaid_invoices_list'	  => client_invoices($id),
			        	'clients'	=> client($id),
			        	'client_type' => array(
			        		'1' => __('option_individual', $id),
			        		'2' => __('option_professional', $id)
			        		),
			        	'client_status' => array(
			        		'1' => __('label_active', $id),
			        		'0' => __('label_inactive', $id)
			        		),
			        	'filter' => '',
			        	);
			        $view_data['content'] = $this->Template->render('clients', 'client_proforma.phtml', $data, TRUE);
			        $this->Template->render('templates', 'client_account.phtml', $view_data);
					break;
				case 'repair':
					$this->load->model('clients/clients_model', 'clients');
					$view_data['pageJs'] = array(
			            'proforma-index.js'
			        );
			        $id = $_SESSION['client_id'];

			        $this->client_id = _eID($id);
			        $this->client_language = client($id, 'client_language');
			        $this->langData = client_language_meta($id);
			        $this->lang->load('application', lang_code_to_string($this->client_language));
			        $this->name_company = client($id, 'name_company');
			        $data = array(
			        	'client_id'       => $this->client_id,
			        	'langdata'        => $this->langData,
			        	'has_password'    => has_password($id),
			        	'name_company'	  => $this->name_company,
			        	'total_income'    => income_by_client($id),
			        	'total_due'       => unpaid_invoice_by_client($id),
			        	'unpaid_invoices_list'	  => client_invoices($id),
			        	'clients'	=> client($id),
			        	'repairs'	=> MRepair::getClientRepairTickets($id),
			        	'client_type' => array(
			        		'1' => __('option_individual', $id),
			        		'2' => __('option_professional', $id)
			        		),
			        	'client_status' => array(
			        		'1' => __('label_active', $id),
			        		'0' => __('label_inactive', $id)
			        		),
			        	'filter' => '',
			        	);
			        $view_data['content'] 	= $this->Template->render('repair', 'view_status.phtml', $data, TRUE );
			        $this->Template->render('templates', 'client_account.phtml', $view_data);
					break;
				
				default:
					# code...
					break;
			}
		}
	}
	public function quotes_list()
	{
		$list = [];
		$filter = $_REQUEST['filter'];
		$quotes = get_quotes(null, $_SESSION['client_id']);
		$invoiceObj = new InvoiceFactory;
		if ($quotes)
		{
			foreach ($quotes as $quote) {
				array_push($list, array(
					'id' 				  => $quote->id,
					'client_id'           => _eID($quote->client_id),
					'quote_number'   	  => $quote->quote_number,
					'enc_quote_number'    => _eID($quote->quote_number),
					'name_company'		  => $invoiceObj->getCustomer($quote->client_id,'name_company'),
					'date'				  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $quote->date),
					'due_date'			  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $quote->due_date),
					'total'				  => format_number($quote->total),
					'status'              => __(strtolower($quote->quote_status)),
					'stbool'			  => quote_status($quote->quote_number)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function mass_quotes_email()
	{
		$protected = [];
		$to_send = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (quoted_to_guest($i) > 0)
				{
					array_push($to_send, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_send);
			$response['fail'] = count($protected);

			if(!empty($to_send))
			{
				foreach ($to_send as $quote_number) {
					$this->m_manager->send_quote_email($quote_number);
				}
			}
		}
		echo json_encode($response);
	}
	public function mark_approved()
	{
		$protected = [];
		$to_mark_approved = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (quote_status($i) !== 'is_accepted')
				{
					array_push($to_mark_approved, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_approved);
			$response['fail'] = count($protected);

			if(!empty($to_mark_approved))
			{
				mass_approved($to_mark_approved);
			}
		}
		echo json_encode($response);
	}
	public function proforma_list()
	{
		$list = [];
	
		$proformas = get_proforma($_SESSION['client_id']);
		$invoiceObj = new InvoiceFactory;
		if ($proformas)
		{
			foreach ($proformas as $proforma) {
				if (get_option('annual_numbering')) {
					$inv_f_number = null == get_option('proforma_prefix') ? __('proforma_prefix_short') . date('y', strtotime($proforma->updated_on)). sprintf( "%04s", $proforma->annual_number_key) : get_option('proforma_prefix') . date('y', strtotime($proforma->updated_on)).sprintf( "%04s", $proforma->annual_number_key );
				} else {
					$inv_f_number = null == get_option('proforma_prefix') ? __('proforma_prefix_short') . sprintf( "%04s", $proforma->proforma_number ) : get_option('proforma_prefix') . sprintf( "%04s", $proforma->proforma_number );
				}
				array_push($list, array(
					'id' 				  => $proforma->id,
					'client_id'           => _eID($proforma->client_id),
					'inv_f_number'   	  => $inv_f_number,
					'enc_proforma_number' => _eID($proforma->proforma_number),
					'proforma_number'   	  => $proforma->proforma_number,
					'status'   	  				=> $proforma->proforma_status,
					'stbool'			  => get_proforma_vars($proforma->proforma_number, 'proforma_status'),
					'name_company'		  => 0 < $proforma->client_id ? client($proforma->client_id, 'name_company') : null,
					'date'				  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $proforma->date ),
					'due_date'			  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $proforma->due_date ),
					'total'				  => format_number($proforma->total)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function mass_proforma_email()
	{
		$protected = [];
		$to_send = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (proforma_for_guest($i) > 0)
				{
					array_push($to_send, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_send);
			$response['fail'] = count($protected);

			if(!empty($to_send))
			{
				foreach ($to_send as $proforma_number) {
					$this->m_manager->send_proforma_email($proforma_number);
				}
			}
		}
		echo json_encode($response);
	}
}