<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Provider extends Basic_Controller {
	
	protected $purchase_number;
	protected $amount;
	protected $currency;
	protected $language;
	protected $name_company;
	protected $provider_id;
	protected $langData;
	protected $view_data;

	public function __construct()
	{
		parent::__construct();
		$this->load->model('providers/providers_model', 'providers');
		
    	if ( _has_option( 'is_indian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'india-purchase-order.js'
            );
    	}
    	elseif ( _has_option( 'is_romanian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'romania-purchase-order.js'
            );
    	}
    	else
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'purchase-order.js'
            );
    	}
    	$this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
	}
	public function index($a = null, $id = null)
	{
		if (!isset($_REQUEST['id']))
		{
			die();
		}
		else
		{
			$id = _dID($_REQUEST['id']);
			$this->provider_id = $id;
			$this->langData = provider_language_meta($this->provider_id);
			$this->name_company = provider($id, 'name_company');
			$data = array(
				'provider_id'     => _eID($this->provider_id),
				'langdata'        => $this->langData,
				'has_password'    => provider_has_password($id),
				'name_company'	  => $this->name_company,
				'total_income'    => purchases_by_provider($id),
				'total_due'       => unpaid_purchase_by_provider($id),
				'unpaid_invoices_list'	  => provider_purchases($id),
				'providers'	=> provider($id),
				'provider_type' => array(
					'1' => __('option_individual', $id),
					'2' => __('option_professional', $id)
					),
				'provider_status' => array(
					'1' => __('label_active', $id),
					'0' => __('label_inactive', $id)
					),
				'filter' => ''
				);
			$this->view_data['content'] = $this->Template->render('providers', 'provider_view.phtml', $data, TRUE);
			$this->Template->render('templates', 'provider_account.phtml', $this->view_data);
		}
	}
	public function edit()
	{
		$id = isset($_REQUEST['id']) ? _dID($_REQUEST['id']) : NULL;
		$this->provider_id = $_REQUEST['id'];
		$this->langData = provider_language_meta($id);
		$this->name_company = provider($id, 'name_company');
		$data = array(
			'page_breadcrumb' => __('clients_edit', $id),
			'langdata'        => $this->langData,
			'has_password'    => provider_has_password($id),
			'name_company' => $this->name_company,
			'disabled' => 'disabled',
			'hidden' => 'hidden',
			'readonly' => 'readonly',
			'provider_id' => _eID($id),
			'providers'	=> provider($id),
			'provider_type' => array(
				'1' => __('option_individual'),
				'2' => __('option_professional')
				),
			'provider_status' => array(
				'1' => __('label_active'),
				'0' => __('label_inactive')
				)
			);
		$this->view_data['content'] = $this->Template->render('providers', 'frontend_provider_edit.phtml', $data, TRUE);
		$this->Template->render('templates', 'provider_account.phtml', $this->view_data);
	}
	public function editPurchase()
	{
		$id = _dID($_REQUEST['id']);
		$this->provider_id = $_REQUEST['providerid'];
		$this->langData = provider_language_meta($this->provider_id);
		$this->name_company = provider($this->provider_id, 'name_company');
		$view_data = array(
			'breadcrumb' 		=> anchor('purchases', __('link_purchase_orders')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_purchase_orders'),
			'langdata'        	=> $this->langData,
			'name_company' 		=> $this->name_company,
			'page_description' 	=> __('message_manage') .' '.__('label_purchase'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'purchases' 		=> get_purchase_by_number($id),
			'purchase_items' 	=> get_purchased_items($id),
			'providers' 		=> json_encode(providers()),
			'provider_id'		=> _eID($this->provider_id),
			'purchase_status' 	=> array(
				'Accepted' 		=> __('label_accepted'),
				'Declined' 		=> __('label_declined'),
				'Pending' 		=> __('label_pending'),
				'In Progress' 		=> __('label_progress'),
				'Draft' 		=> __('label_draft'),
				'Cancelled' 	=> __('label_cancelled'),
				'Paid' 			=> __('label_paid')
				),
			'shipment_status' 	=> array(
				'Pending' 		=> __('label_pending'),
				'In Progress' 		=> __('label_progress'),
				'Is sent' 		=> __('label_sent'),
				'Received' 		=> __('label_received')
				)
			);
		$this->view_data['content'] = $this->Template->render('purchases', 'edit_purchase_form.phtml', $view_data, true);
		$this->Template->render('templates', 'provider_account.phtml', $this->view_data);
	}
	public function income_by_provider()
	{
		$id = _dID($_REQUEST['id']);
		$range = $_REQUEST['range'];
		$income = income_by_provider($id, $range);
		$unpaid = unpaid_invoice_by_provider($id, $range);
		echo json_encode(array($income, $unpaid));
	}
	public function get_client_invoices()
	{
		$this->load->helper('security');
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$id = _dID($_REQUEST['id']);
		$change_rate = provider($id, 'client_change_rate');
		$encrypt_id = $_REQUEST['id'];
		$invoices = client_invoices($id, $filter);
		if ($invoices)
		{
			foreach ($invoices as $invoice) {
				if ($invoice->amount_paid > $invoice->amount_refunded AND $invoice->invoice_status == 'Refunded')
				{
					$status = __('label_partially_refunded', $id);
				}
				elseif ($invoice->amount_paid > 0 AND $invoice->invoice_status !== 'Paid')
				{
					$status = __('label_partially_paid', $id);
				}
				elseif( $invoice->invoice_status == 'Expired' || $invoice->invoice_status == 'Open' || $invoice->invoice_status == 'Pending' || $invoice->invoice_status == 'Failed')
				{
					$status = __('unpaid', $id);
				}
				else
				{
					$status = __( strtolower($invoice->invoice_status), $id);
				}
				$this->orderID = $invoice->purchase_number;

				$this->acceptUrl = base_url("index.php/ingenico/return_page/is_accept?purchase_number=").$this->orderID;

				// Check if client has already paid by other means
				$last_amount_paid = floatval( get_invoice_vars($invoice->purchase_number, 'amount_paid') );
				if ( $last_amount_paid > 0)
				{
					$this->amount = round( ( ($invoice->total - $last_amount_paid) * $change_rate), 2) * 100;
					$this->paypalAmount = round( ( ($invoice->total - $last_amount_paid) * $change_rate), 2);
					$this->mollieAmount = round( ( ($invoice->total - $last_amount_paid) * $change_rate), 2);
				}
				else
				{
					$this->amount = round( ($invoice->total * $change_rate), 2) * 100;
					$this->paypalAmount = round( ($invoice->total * $change_rate), 2);
					$this->mollieAmount = round( ($invoice->total * $change_rate), 2);
				}
				$this->cancelUrl = base_url("index.php/ingenico/return_page/is_cancel?purchase_number=").$this->orderID;
				$this->catalogUrl = get_option('ingenico_catalog_url');
				$this->currency = provider($id, 'client_currency');
				$this->declineUrl = base_url("index.php/ingenico/return_page/is_decline?purchase_number=").$this->orderID;
				$this->exceptionUrl = base_url("index.php/ingenico/return_page/is_exception?purchase_number=").$this->orderID;
				$this->homeUrl = get_option('ingenico_home_url');
				$this->language = provider($id, 'provider_language');
				$this->pspid = get_option('ingenico_pspid');
				$this->shaInPassPhrase = get_option('ingenico_shain');
				$this->tpUrl = 'template.html';
			
				$this->toHash = 'ACCEPTURL='.$this->acceptUrl.$this->shaInPassPhrase;
				$this->toHash .='AMOUNT='.$this->amount.$this->shaInPassPhrase;
				$this->toHash .='CANCELURL='.$this->cancelUrl.$this->shaInPassPhrase;
				$this->toHash .='CATALOGURL='.$this->catalogUrl.$this->shaInPassPhrase;
				$this->toHash .='CURRENCY='.$this->currency.$this->shaInPassPhrase;
				$this->toHash .='DECLINEURL='.$this->declineUrl.$this->shaInPassPhrase;
				$this->toHash .='EXCEPTIONURL='.$this->exceptionUrl.$this->shaInPassPhrase;
				$this->toHash .='HOMEURL='.$this->homeUrl.$this->shaInPassPhrase;
				$this->toHash .='LANGUAGE='.$this->language.$this->shaInPassPhrase;
				$this->toHash .='ORDERID='.$this->orderID.$this->shaInPassPhrase;
				$this->toHash .='PSPID='.$this->pspid.$this->shaInPassPhrase;
				$this->toHash .='TP='.$this->tpUrl.$this->shaInPassPhrase;

				$this->hash = do_hash($this->toHash);
				array_push($list, array(
					'id' 			  	  => $invoice->id,
					'purchase_number'      => $invoice->purchase_number,
					'enc_purchase_number'  => _eID($invoice->purchase_number),
					'date'   	 		  => _fdate( provider( $invoice->provider_id, 'provider_language' ), $invoice->date ),
					'due_date' 		  	  => _fdate( provider( $invoice->provider_id, 'provider_language' ), $invoice->due_date ),
					'total' 		  	  => format_number($invoice->total),
					'amount_refunded' 	  => format_number($invoice->amount_refunded),
					'amount_paid' 	      => format_number($invoice->amount_paid),
					'amount_due' 	      => format_number($invoice->amount_due),
					'totalnf' 		  	  => $invoice->total,
					'company'			  => get_option('company'),
					'purchase_number_str'  => __('invoices_invoice', $invoice->provider_id) . ' ' .purchase_number_format(). '#' .$invoice->purchase_number,
					'provider_id'			  => $encrypt_id,
					'status'              => $status,
					'stbool'			  => invoice_status($invoice->purchase_number),
					'pspID'				  => $this->pspid,
					'orderID'			  => $this->orderID,
					'amount'			  => $this->amount,
					'paypal_amount'		  => $this->paypalAmount,
					'mollie_amount'		  => $this->mollieAmount,
					'currency'			  => $this->currency,
					'language'			  => $this->language,
					'shasign'			  => $this->hash,
					'acceptUrl'			  => $this->acceptUrl,
					'declineUrl'		  => $this->declineUrl,
					'exceptionUrl'		  => $this->exceptionUrl,
					'cancelUrl'			  => $this->cancelUrl,
					'tpUrl'			      => $this->tpUrl,
					'homeUrl'			  => $this->homeUrl,
					'catalogUrl'		  => $this->catalogUrl
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function products_services()
	{
		$list = [];
		$id = _dID($_REQUEST['id']);

		$products_services = provider_products_services($id);
		if ($products_services)
		{
			foreach ($products_services as $products_service) {
				array_push($list, array(
					'name' 		  		  => $products_service->name,
					'value' 	          => $products_service->value,
					'price'				  => $products_service->price,
					'total_value'		  => $products_service->value * $products_service->price
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function check_password()
	{
		$this->load->library('encryption');
		$password = $_REQUEST['password'];
		$provider_id = $_REQUEST['provider_id'];
		
		$hash_password = $password;
		$provider_password = $this->encryption->decrypt( provider( _dID($provider_id), 'provider_password' ) );
		if ($hash_password === $provider_password)
		{
			$this->session->set_userdata('pwd_verified', true);
			echo json_encode( array( 'success' => 1 ) );
		}
		else
		{
			echo json_encode( array( 'success' => 0 ) );
		}
	}
	/**
	 * Get client currency details and change range
	 */
	public function get_client_currency()
	{
		$provider_id = $_REQUEST['provider_id'];
		$currency = null !== provider($provider_id, 'client_currency') ? provider($provider_id, 'client_currency'): get_option('user_currency');
		$reponse = array(
			'currency_str' => $currency,
			'currency_symb' => get_currencies($currency, 'symbol'),
			'change_rate' => get_change_rate($currency)
			);
		echo json_encode($reponse);
	}
	public function get_provider_purchases()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$id = _dID($_REQUEST['id']);
		$purchases = provider_purchases($id, $filter);
		if ($purchases)
		{
			foreach ($purchases as $purchase) {
				array_push($list, array(
					'id' 			  	  => $purchase->id,
					'purchase_number'      => $purchase->purchase_number,
					'enc_purchase_number'  => _eID($purchase->purchase_number),
					'date'   	 		  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $purchase->date),
					'shipping_date' 		  	  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $purchase->shipping_date),
					'total' 		  	  => format_number($purchase->total),
					'status'              => __(strtolower($purchase->purchase_status)),
					'stbool'			  => purchase_status($purchase->purchase_number)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function next_purchase_order_number()
	{
		echo json_encode(next_purchase_order_number());
	}
	public function purchase_autocomplete()
	{
		$data = [];
		$results = get_all_items(1);
		if(! empty($results) )
		{
			if (! _has_option('is_indian') )
			{
				foreach($results as $row)
				{
					$name = $row->sku .'|'. $row->name .'|' .$row->purchase_price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate. '|'. $row->product_mpn;
					array_push($data, $name);
				}
			}
			else
			{
				foreach($results as $row)
				{
					$name = $row->sku .'|'. $row->name .'|' .$row->purchase_price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate. '|'. $row->product_mpn;
					array_push($data, $name);
				}
			}
		}
		echo json_encode($data);
	}
	public function purchases_by_provider()
	{
		$id = _dID($_REQUEST['id']);
		$range = $_REQUEST['range'];
		$income = purchases_by_provider($id, $range);
		$unpaid = unpaid_purchase_by_provider($id, $range);
		echo json_encode(array($income, $unpaid));
	}
}