<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Viewinvoice extends Basic_Controller {
	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_invoice = [];

	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_client = [];
	protected $_client_id;

	/**
	 * Index
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type Mixed
	 * @since 1.0.6
	 */
	public function view()
	{
		if ( !is_dir( getcwd().'/uploads/pdf/invoices/' ) ) mkdir ( getcwd().'/uploads/pdf/invoices/', 0777, true);
        
        if( chmod(getcwd().'/uploads/pdf/invoices/', 0755) ) 
        {
            chmod(getcwd().'/uploads/pdf/invoices/', 0777);
        }

		$data['transactions'] 	= FALSE;
		$data['balance'] 		= FALSE;

		if ( isset($_REQUEST['id']) ) 
		{
			$id 	= _dID($_REQUEST['id']);
			if ($this->set_invoice_vars($id)) {
				$this->set_client_vars($this->_invoice['client_id']);
				if ( $this->session->userdata('user_id') >= 1)
				{
					$lang = get_option( 'user_language', 'users_options' );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
					$lang_code = language_string_to_locale_notation( $lang );
				}
				else
				{
					$lang = lang_code_to_string( client( $this->_invoice['client_id'], 'client_language' ) );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
					$lang_code = client( $this->_invoice['client_id'], 'client_language' );
				}
				// Load system language file to handle dynamic localization
				$this->lang->load( 'application', $lang );
				$this->load->helper( 'file' );
				
				$path_invoice_terms = './notifications/' . $terms_lang . '/invoices/invoice_terms.php';
				$path_invoice_footer = './notifications/' . $terms_lang . '/invoices/invoice_footer.php';
				$template = read_file( $path_invoice_terms );
				$template_footer = read_file( $path_invoice_footer );
				$tr = substr( $template, 0, null != get_option('terms_conditions_length') ? get_option('terms_conditions_length'): 1000 );


				# Get all the items of the invoice
				$data['invoiceitems'] = get_invoiced_items( $id );
				$results = get_invoice_tax( $id );
				$tax = [];
				if ( $results )
				{
					foreach ( $results as $key => $value ) {
						$tax[] = array(
							'tax_rate' => $value->taxRate,
							'tax_sum' => $value->taxAmount
						);
					}
				}
				$data['tax_value'] = $tax;
				$data['non_formatted_invoice_number'] = $this->_invoice['invoice_number'];

				$data['logo'] = get_option( 'logo' );
				$data['invoice_footer'] = $this->parser->parse_string( $template_footer, array(), TRUE );
				$data['user_company'] = get_option('company');

				// Set PDF vars
				$data['status'] = __( strtolower( $this->_invoice['invoice_status'] ) );
				$data['is_credit_note'] = $this->_invoice['is_credit_note'];
				$data['initial_invoice_number'] = $this->_invoice['initial_invoice_number'];

				if (get_option('annual_numbering')) {
					$data['format_initial_invoice_number'] = get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['annual_number_key'] );
				} else {
					$data['format_initial_invoice_number'] = get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['initial_invoice_number'] );
				}
				
				if ($this->_invoice['invoice_status'] == 'Refunded') {
					if (get_option('annual_numbering')) {
						$title = get_option('credit_note_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['annual_number_key'] ). '*';
					} else {
						$title = get_option('credit_note_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['invoice_number'] ). '*';
					}
					$data['credit_note'] = true;
				}
				else
				{
					if (get_option('annual_numbering')) {
						$title = get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['annual_number_key'] );
					} else {
						$title = get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['invoice_number'] );
					}
				}
				$data['subject'] = $this->_invoice['subject'];
				$data['invoice_title'] = __('invoice') . ' ' . $title;
				$data['client_id'] = $this->_invoice['client_id'];

				if ($this->_invoice['discount_amount'] > 0 )
				{
					$data['discount'] = TRUE;
					$data['discount_amount'] = $this->_invoice['discount_amount'];
					$data['discount_name'] = __('label_discount_amount');
				}
				else
				{
					$data['discount'] = FALSE;
				}

				$data['page_title'] = $title;

				if (get_option('annual_numbering')) {
					$data['invoice_number'] = get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['annual_number_key'] );
					$data['invoice_numb'] = __('invoice') . ' ' . get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['annual_number_key'] ) . '.pdf';
				} else {
					$data['invoice_number'] = get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['invoice_number'] );
					$data['invoice_numb'] = __('invoice') . ' ' . get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $this->_invoice['invoice_number'] ) . '.pdf';
				}
				
				$date = _fdate( $lang_code, $this->_invoice['date']);
				$due_date = _fdate( $lang_code, $this->_invoice['due_date']);
				$date_paid = _fdate( $lang_code, $this->_invoice['due_date']);

				$data['subtotal'] = $this->_invoice['subtotal'];
				$data['tax_amount'] = $this->_invoice['tax_amount'];
				if ($data['tax_amount'] <= 0)
				{
					$data['taxname'] = FALSE;
				}
				else
				{
					$data['taxname'] = __('label_tax');
					$data['taxname'] = TRUE;
				}
				$data['credit'] = $this->_invoice['credit_used'];
				if ($data['credit'] <= 0)
				{
					$data['credit'] = FALSE;
				}
				$data['total'] = $this->_invoice['total'];
				$data['amount_paid'] = $this->_invoice['amount_paid'];
				if ($data['amount_paid'] <= 0)
				{
					$data['amount_paid'] = FALSE;
					$data['transactions'] = FALSE;
				}
				$data['balance'] = $this->_invoice['amount_due'];
				$data['date'] = $date;
				$data['due_date'] = $due_date;
				$data['current_date'] = _fdate( $lang_code, date( 'Y-m-d' ) );

				$data['notes'] = $this->_invoice['notes'];
				$data['terms'] = $this->parser->parse_string( $tr, array(), TRUE );

				if ($this->_invoice['amount_paid'] > 0 )
				{
					$data['transactions'] = TRUE;
					$transactions = [];
					$data['transactions'] = TRUE;
					$results = get_payment_history($this->_invoice['invoice_number']);
					if ($results)
					{
						foreach ($results as $r) {
							array_push($transactions, array(
									'date' => _fdate( $lang_code, $r->date_paid ),
									'gateway' => $r->payment_method,
									'transid' => $r->payment_reference,
									'amount' => $r->payment_amount
								)
							);
						}
					}
					$data['transactions'] = $transactions;
					$data['balance'] = $this->_invoice['amount_due'];
				}
				if ( $this->_invoice['amount_due'] === 0)
				{
					$data['status'] = __('paid');
					$data['amount_refunded'] = FALSE;
				}
				if ( $this->_invoice['amount_refunded'] > 0)
				{
					$data['amount_refunded'] = $this->_invoice['amount_refunded'];
					if ($this->_invoice['amount_refunded'] < $this->_invoice['amount_paid'])
					{
						$data['status'] = __('label_short_partially_refunded');
						$data['has_refund'] = TRUE;
					}
					else
					{
						$data['status'] = __('label_refunded', $this->client_id);
					}
				}
				else
				{
					$data['amount_refunded'] = FALSE;
					$data['has_refund'] = FALSE;
				}
				$data['client'] = array(
						'name_company' => $this->_client['name_company'],
						'billing_name_company' => "" != $this->_client['billing_name_company'] ? $this->_client['billing_name_company'] : $this->_client['name_company'],
						'shipping_name_company' => "" != $this->_client['shipping_name_company'] ? $this->_client['shipping_name_company'] : $this->_client['name_company'],
						'address1' => $this->_client['client_address1'],
						'billing_address1' => "" != $this->_client['billing_address1'] ? $this->_client['billing_address1']: $this->_client['client_address1'],
						'shipping_address1' => "" != $this->_client['shipping_address1'] ? $this->_client['shipping_address1'] : $this->_client['client_address1'],
						'address2' => $this->_client['client_address2'],
						'billing_address2' => "" != $this->_client['billing_address2'] ? $this->_client['billing_address2'] : $this->_client['client_address2'],
						'shipping_address2' => "" != $this->_client['shipping_address2'] ? $this->_client['shipping_address2'] : $this->_client['client_address2'],
						'postcode' => $this->_client['client_postcode'],
						'billing_postcode' => "" != $this->_client['billing_postcode'] ? $this->_client['billing_postcode'] : $this->_client['client_postcode'],
						'shipping_postcode' => "" != $this->_client['shipping_postcode'] ? $this->_client['shipping_postcode'] : $this->_client['client_postcode'],
						'city' => $this->_client['client_city'],
						'billing_city' => "" != $this->_client['billing_city'] ? $this->_client['billing_city'] : $this->_client['client_city'],
						'shipping_city' => "" != $this->_client['shipping_city'] ? $this->_client['shipping_city'] : $this->_client['client_city'],
						'state' => $this->_client['client_state'],
						'billing_state' => "" != $this->_client['billing_state'] ? $this->_client['billing_state'] : $this->_client['client_state'],
						'shipping_state' => "" != $this->_client['shipping_state'] ? $this->_client['shipping_state'] : $this->_client['client_state'],
						'country' => $this->_client['client_country'],
						'billing_country' => "" != $this->_client['billing_country'] ? $this->_client['billing_country'] : $this->_client['client_country'],
						'shipping_country' => "" != $this->_client['shipping_country'] ? $this->_client['shipping_country'] : $this->_client['client_country'],
						'client_tax_number' => $this->_client['client_tax_number'],
						'client_chamber_com' => $this->_client['client_chamber_com'],
						'client_bank_name' => $this->_client['client_bank_name'],
						'client_bank_number' => $this->_client['client_bank_number'],
						'client_fiscal_code' => isset($this->_client['client_fiscal_code']) ? $this->_client['client_fiscal_code']: '',
						'client_type' => isset($this->_client['client_type']) ? $this->_client['client_type'] : 1,
						'client_phone' => $this->_client['client_phone'],
						'billing_phone' => "" != $this->_client['billing_phone'] ? $this->_client['billing_phone'] : $this->_client['client_phone'],
						'shipping_phone' => "" != $this->_client['shipping_phone'] ? $this->_client['shipping_phone'] : $this->_client['client_phone']
						);
				$data['user_address'] = array(
						'user_address1' => get_option('address1'),
						'user_address2' => get_option('address2'),
						'user_city' => get_option('city'),
						'user_postcode' => get_option('postcode'),
						'user_state' => get_option('state'),
						'user_country' => 'None' == get_countries(get_option('country')) ? '' : get_countries(get_option('country'))
						);
				$data['tax_id'] = null !== get_option('tax_id') ? get_option('tax_id') : "";
				$data['chamber_commerce_id'] = null !== get_option('chamber_commerce_id') ? get_option('chamber_commerce_id') : "";
				$data['bank_name'] = null !== get_option('bank_name') ? get_option('bank_name') : "";
				$data['bank_number'] = null !== get_option('bank_number') ? get_option('bank_number') : "";
				$data['bank_name'] = null !== get_option('bank_name') ? get_option('bank_name') : "";
				$data['change_rate'] = $this->_invoice['change_rate'];
				$data['phone'] = null !== get_option('phone') ? get_option('phone') : "";
				$data['mobile'] = null !== get_option('mobile') ? get_option('mobile') : "";
				$layout = null !== get_option('invoice_layout') ? get_option('invoice_layout') : 1;

				// Get additional tax if any
				$data['additional_taxes'] = $this->_invoice['additional_taxes'];


				if( !$this->session->userdata('user_id') )
				{
					$event = array(
						'action' 					=> 'invoice_opened',
						'referrer' 					=> 'invoices',
						'referrer_id' 				=> $this->_invoice['invoice_number'],
						'referrer_value' 			=> $this->_invoice['invoice_number'],
						'client_id' 				=> $this->_invoice['client_id'],
						'status' 					=> 'success'
					);
					record_event($event);
				}
				$this->Template->render('invoices', 'invoice_tpl_'. $layout, $data);
			}
		}
		else
		{
			show_custom404();
		}
	}
	/**
	 * set_invoice_vars 
	 * @param type $invoice_number 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_invoice_vars($invoice_number)
	{
		$results = get_invoice_by_number($invoice_number);
		if ($results) {
			foreach ($results as $value) 
			{
				if ($value->client_id == 0)
				{
					$currency = get_option('user_currency');
				}
				else
				{
					$currency = client($value->client_id, 'client_currency');
				}
				if ( _has_option( 'change_currency' ) )
				{
					$change_rate = get_change_rate( $currency );
				}
				else
				{
					$change_rate = 1;
				}
				$this->_invoice = [
					'id'				=> $value->id,
					'client_id' 		=> $value->client_id,
					'invoice_number' 	=> $value->invoice_number,
					'subject' 			=> $value->subject,
					'pay_type' 			=> $value->pay_type,
					'date' 				=> $value->date,
					'due_date' 			=> $value->due_date,
					'next_duedate' 		=> $value->next_duedate,
					'date_paid' 		=> $value->date_paid,
					'subtotal' 			=> $value->subtotal,
					'tax_amount' 		=> $value->tax_amount,
					'credit_used' 		=> $value->credit_used,
					'discount_amount' 	=> $value->discount_amount,
					'total' 			=> $value->total,
					'amount_paid' 		=> $value->amount_paid,
					'amount_refunded' 	=> $value->amount_refunded,
					'payment_method' 	=> strtoupper( __($value->payment_method, $value->client_id) ),
					'transaction_id' 	=> $value->transaction_id,
					'amount_due' 		=> $value->amount_due,
					'is_credit_note' 	=> $value->is_credit_note,
					'initial_invoice_number' 	=> $value->initial_invoice_number,
					'annual_number_key' 	=> $value->annual_number_key,
					'invoice_status' 	=> convert_payment_gateway_status( $value->invoice_status ),
					'notes' 			=> $value->notes,
					'additional_taxes' 			=> json_decode($value->additional_taxes, true),
					'change_rate'		=> $change_rate
				];
			}
			return true;
		} else {
			show_custom404();
		}
	}
	/**
	 * Set_client_var($id)
	 * @param type $id 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_client_vars($id=null)
	{
		if (!$id)
		{
			$this->client_id = 0;
			$this->_client = [
				'client_id'        => 0,
				'name_company'     => __('label_guest'),
				'billing_name_company' => __('label_guest'),
				'shipping_name_company' => __('label_guest'),
				'client_address1'  => '',
				'billing_address1'  => '',
				'shipping_address1'  => '',
				'client_address2'  => '',
				'billing_address2'  => '',
				'shipping_address2'  => '',
				'client_postcode'  => '',
				'billing_postcode'  => '',
				'shipping_postcode'  => '',
				'client_city'      => '',
				'billing_city'      => '',
				'shipping_city'      => '',
				'client_state'     => '',
				'billing_state'     => '',
				'shipping_state'     => '',
				'client_tax_number' => '',
				'client_country'   => '',
				'billing_country'   => '',
				'shipping_country'   => '',
				'client_tax_number' => '',
				'client_chamber_com' => '',
				'client_bank_name' => '',
				'client_bank_number' => '',
				'client_phone' => '',
				'billing_phone' => '',
				'shipping_phone' => ''
			];
			if (is_italian_company()) {
				add_italian_fields();
				$this->client ['client_fiscal_code'] = '';
			}
		}
		else
		{
			if (is_italian_company()) {
				add_italian_fields();
			}
			$results = client($id);
			foreach ($results as $client) {

				if ("None" == $client->client_country || null == $client->client_country) {
					$country_code = -1;
				} else {
					$country_code = $client->client_country;
				}
				if ("None" == $client->billing_country || null == $client->billing_country) {
					$billing_country_code = -1;
				} else {
					$billing_country_code = $client->billing_country;
				}
				if ("None" == $client->shipping_country || null == $client->shipping_country) {
					$shipping_country_code = -1;
				} else {
					$shipping_country_code = $client->shipping_country;
				}
				$this->client_id = $client->client_id;
				$this->_client = [
					'client_id'        => $client->client_id,
					'client_type'        => $client->client_type,
					'name_company'     => $client->name_company,
					'billing_name_company'     => $client->billing_name_company,
					'shipping_name_company'     => $client->shipping_name_company,
					'client_address1'  => $client->client_address1,
					'billing_address1'  => $client->billing_address1,
					'shipping_address1'  => $client->shipping_address1,
					'client_address2'  => $client->client_address2,
					'billing_address2'  => $client->billing_address2,
					'shipping_address2'  => $client->shipping_address2,
					'client_postcode'  => $client->client_postcode,
					'billing_postcode'  => $client->billing_postcode,
					'shipping_postcode'  => $client->shipping_postcode,
					'client_city'      => $client->client_city,
					'billing_city'      => $client->billing_city,
					'shipping_city'      => $client->shipping_city,
					'client_state'     => $client->client_state,
					'billing_state'     => $client->billing_state,
					'shipping_state'     => $client->shipping_state,
					'client_tax_number' => $client->client_tax_number,
					'client_chamber_com' => $client->client_chamber_com,
					'client_bank_name' => $client->client_bank_name,
					'client_fiscal_code' => isset($client->client_fiscal_code) ? $client->client_fiscal_code: '',
					'client_bank_number' => $client->client_bank_number,
					'client_phone'		=> isset($client->client_phone) ? $client->client_phone : "",
					'billing_phone'		=> isset($client->billing_phone) ? $client->billing_phone : "",
					'shipping_phone'		=> isset($client->shipping_phone) ? $client->shipping_phone : "",
					'client_country'   => get_countries($country_code),
					'billing_country'   => get_countries($billing_country_code),
					'shipping_country'   => get_countries($shipping_country_code)
				];
			}
		}
	}
}