<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Vieworderpickinglist extends Basic_Controller {
	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_order = [];

	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_client = [];
	protected $_client_id;

	/**
	 * Index
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type Mixed
	 * @since 1.0.6
	 */
	public function view()
	{
		$data['transactions'] 	= FALSE;
		$data['balance'] 		= FALSE;

		if ( isset($_REQUEST['id']) ) 
		{
			$id 	= _dID($_REQUEST['id']);
			if ($this->set_order_vars($id)) {
				$this->set_client_vars($this->_order['client_id']);
				if ( $this->session->userdata('user_id') >= 1)
				{
					$lang = get_option( 'user_language', 'users_options' );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
					$lang_code = language_string_to_locale_notation( $lang );
				}
				else
				{
					$lang = lang_code_to_string( client( $this->_order['client_id'], 'client_language' ) );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
					$lang_code = client( $this->_order['client_id'], 'client_language' );
				}
				// Load system language file to handle dynamic localization
				$this->lang->load( 'application', $lang );
				$this->load->helper( 'file' );
				
				$path_order_terms = './notifications/' . $terms_lang . '/orders/invoice_terms.php';
				$path_order_footer = './notifications/' . $terms_lang . '/orders/invoice_footer.php';
				$template = read_file( $path_order_terms );
				$template_footer = read_file( $path_order_footer );
				$tr = substr( $template, 0, null != get_option('terms_conditions_length') ? get_option('terms_conditions_length'): 1000 );


				# Get all the items of the invoice
				$data['invoiceitems'] = get_sale_picked_items( $id );
				$results = get_order_tax( $id );
				$tax = [];
				if ( $results )
				{
					foreach ( $results as $key => $value ) {
						$tax[] = array(
							'tax_rate' => $value->taxRate,
							'tax_sum' => $value->taxAmount
						);
					}
				}
				$data['tax_value'] = $tax;
				$data['logo'] = get_option( 'logo' );
				$data['invoice_footer'] = $this->parser->parse_string( $template_footer, array(), TRUE );
				$data['user_company'] = get_option('company');

				// Set PDF vars
				$data['status'] = __( strtolower( $this->_order['order_status'] ) );
				$data['is_credit_note'] = $this->_order['is_credit_note'];

				if ($this->_order['order_status'] == 'Refunded') {
					$title = get_option('credit_note_prefix').invoice_number_format() . sprintf("%04s", $this->_order['order_number'] ). '*';
					$data['credit_note'] = true;
				}
				else
				{
					$title = get_option('sale_order_prefix').invoice_number_format() . sprintf("%04s", $this->_order['order_number'] );
				}
				$data['subject'] = $this->_order['subject'];
				$data['invoice_title'] = __('invoice') . ' ' . $title;
				$data['client_id'] = $this->_order['client_id'];

				if ($this->_order['discount_amount'] > 0 )
				{
					$data['discount'] = TRUE;
					$data['discount_amount'] = $this->_order['discount_amount'];
					$data['discount_name'] = __('label_discount_amount');
				}
				else
				{
					$data['discount'] = FALSE;
				}

				$data['page_title'] = $title;
				$data['order_number'] = get_option('sale_order_prefix').invoice_number_format() . sprintf("%04s", $this->_order['order_number'] );
				$data['invoice_numb'] = __('invoice') . ' ' . get_option('sale_order_prefix').invoice_number_format() . sprintf("%04s", $this->_order['order_number'] ) . '.pdf';

				$date = _fdate( $lang_code, $this->_order['date']);
				$due_date = _fdate( $lang_code, $this->_order['due_date']);
				$date_paid = _fdate( $lang_code, $this->_order['due_date']);

				$data['subtotal'] = $this->_order['subtotal'];
				$data['tax_amount'] = $this->_order['tax_amount'];
				if ($data['tax_amount'] <= 0)
				{
					$data['taxname'] = FALSE;
				}
				else
				{
					$data['taxname'] = __('label_tax');
					$data['taxname'] = TRUE;
				}
				$data['credit'] = $this->_order['credit_used'];
				if ($data['credit'] <= 0)
				{
					$data['credit'] = FALSE;
				}
				$data['total'] = $this->_order['total'];
				$data['amount_paid'] = $this->_order['amount_paid'];
				if ($data['amount_paid'] <= 0)
				{
					$data['amount_paid'] = FALSE;
					$data['transactions'] = FALSE;
				}
				$data['balance'] = $this->_order['amount_due'];
				$data['date'] = $date;
				$data['due_date'] = $due_date;
				$data['current_date'] = _fdate( $lang_code, date( 'Y-m-d' ) );

				$data['notes'] = $this->_order['notes'];
				$data['terms'] = $this->parser->parse_string( $tr, array(), TRUE );

				if ($this->_order['amount_paid'] > 0 )
				{
					$data['transactions'] = TRUE;
					$transactions = [];
					$data['transactions'] = TRUE;
					$results = get_payment_history($this->_order['order_number']);
					if ($results)
					{
						foreach ($results as $r) {
							array_push($transactions, array(
									'date' => _fdate( $lang_code, $r->date_paid ),
									'gateway' => $r->payment_method,
									'transid' => $r->payment_reference,
									'amount' => $r->payment_amount
								)
							);
						}
					}
					$data['transactions'] = $transactions;
					$data['balance'] = $this->_order['amount_due'];
				}
				if ( $this->_order['amount_due'] === 0)
				{
					$data['status'] = __('paid');
					$data['amount_refunded'] = FALSE;
				}
				if ( $this->_order['amount_refunded'] > 0)
				{
					$data['amount_refunded'] = $this->_order['amount_refunded'];
					if ($this->_order['amount_refunded'] < $this->_order['amount_paid'])
					{
						$data['status'] = __('label_short_partially_refunded');
						$data['has_refund'] = TRUE;
					}
					else
					{
						$data['status'] = __('label_refunded', $this->client_id);
					}
				}
				else
				{
					$data['amount_refunded'] = FALSE;
					$data['has_refund'] = FALSE;
				}
				$data['client'] = array(
						'name_company' => $this->_client['name_company'],
						'billing_name_company' => "" != $this->_client['billing_name_company'] ? $this->_client['billing_name_company'] : $this->_client['name_company'],
						'shipping_name_company' => "" != $this->_client['shipping_name_company'] ? $this->_client['shipping_name_company'] : $this->_client['name_company'],
						'address1' => $this->_client['client_address1'],
						'billing_address1' => "" != $this->_client['billing_address1'] ? $this->_client['billing_address1']: $this->_client['client_address1'],
						'shipping_address1' => "" != $this->_client['shipping_address1'] ? $this->_client['shipping_address1'] : $this->_client['client_address1'],
						'address2' => $this->_client['client_address2'],
						'billing_address2' => "" != $this->_client['billing_address2'] ? $this->_client['billing_address2'] : $this->_client['client_address2'],
						'shipping_address2' => "" != $this->_client['shipping_address2'] ? $this->_client['shipping_address2'] : $this->_client['client_address2'],
						'postcode' => $this->_client['client_postcode'],
						'billing_postcode' => "" != $this->_client['billing_postcode'] ? $this->_client['billing_postcode'] : $this->_client['client_postcode'],
						'shipping_postcode' => "" != $this->_client['shipping_postcode'] ? $this->_client['shipping_postcode'] : $this->_client['client_postcode'],
						'city' => $this->_client['client_city'],
						'billing_city' => "" != $this->_client['billing_city'] ? $this->_client['billing_city'] : $this->_client['client_city'],
						'shipping_city' => "" != $this->_client['shipping_city'] ? $this->_client['shipping_city'] : $this->_client['client_city'],
						'state' => $this->_client['client_state'],
						'billing_state' => "" != $this->_client['billing_state'] ? $this->_client['billing_state'] : $this->_client['client_state'],
						'shipping_state' => "" != $this->_client['shipping_state'] ? $this->_client['shipping_state'] : $this->_client['client_state'],
						'country' => $this->_client['client_country'],
						'billing_country' => "" != $this->_client['billing_country'] ? $this->_client['billing_country'] : $this->_client['client_country'],
						'shipping_country' => "" != $this->_client['shipping_country'] ? $this->_client['shipping_country'] : $this->_client['client_country'],
						'client_tax_number' => $this->_client['client_tax_number'],
						'client_chamber_com' => $this->_client['client_chamber_com'],
						'client_bank_name' => $this->_client['client_bank_name'],
						'client_bank_number' => $this->_client['client_bank_number'],
						'client_phone' => $this->_client['client_phone'],
						'billing_phone' => "" != $this->_client['billing_phone'] ? $this->_client['billing_phone'] : $this->_client['client_phone'],
						'shipping_phone' => "" != $this->_client['shipping_phone'] ? $this->_client['shipping_phone'] : $this->_client['client_phone']
						);
				$data['user_address'] = array(
						'user_address1' => get_option('address1'),
						'user_address2' => get_option('address2'),
						'user_city' => get_option('city'),
						'user_postcode' => get_option('postcode'),
						'user_state' => get_option('state'),
						'user_country' => 'None' == get_countries(get_option('country')) ? '' : get_countries(get_option('country'))
						);
				$data['tax_id'] = null !== get_option('tax_id') ? get_option('tax_id') : "";
				$data['chamber_commerce_id'] = null !== get_option('chamber_commerce_id') ? get_option('chamber_commerce_id') : "";
				$data['bank_name'] = null !== get_option('bank_name') ? get_option('bank_name') : "";
				$data['bank_number'] = null !== get_option('bank_number') ? get_option('bank_number') : "";
				$data['bank_name'] = null !== get_option('bank_name') ? get_option('bank_name') : "";
				$data['change_rate'] = $this->_order['change_rate'];
				$data['phone'] = null !== get_option('phone') ? get_option('phone') : "";
				$data['mobile'] = null !== get_option('mobile') ? get_option('mobile') : "";
				$layout = 1;

				if( !$this->session->userdata('user_id') )
				{
					$event = array(
						'action' 					=> 'invoice_opened',
						'referrer' 					=> 'orders',
						'referrer_id' 				=> $this->_order['order_number'],
						'referrer_value' 			=> $this->_order['order_number'],
						'client_id' 				=> $this->_order['client_id'],
						'status' 					=> 'success'
					);
					record_event($event);
				}
				$this->Template->render('orders', 'picking_tpl_'. $layout, $data);
			} else {
				show_custom404();
			}
		}
		else
		{
			show_custom404();
		}
	}
	/**
	 * set_order_vars 
	 * @param type $order_number 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_order_vars($order_number)
	{
		$results = get_order_by_number($order_number);
		if ($results) {
			foreach ($results as $value) 
			{
				if ($value->client_id == 0)
				{
					$currency = get_option('user_currency');
				}
				else
				{
					$currency = client($value->client_id, 'client_currency');
				}
				if ( _has_option( 'change_currency' ) )
				{
					$change_rate = get_change_rate( $currency );
				}
				else
				{
					$change_rate = 1;
				}
				$this->_order = [
					'id'				=> $value->id,
					'client_id' 		=> $value->client_id,
					'order_number' 		=> $value->order_number,
					'subject' 			=> $value->subject,
					'pay_type' 			=> $value->pay_type,
					'date' 				=> $value->date,
					'due_date' 			=> $value->due_date,
					'next_duedate' 		=> $value->next_duedate,
					'date_paid' 		=> $value->date_paid,
					'subtotal' 			=> $value->subtotal,
					'tax_amount' 		=> $value->tax_amount,
					'credit_used' 		=> $value->credit_used,
					'discount_amount' 	=> $value->discount_amount,
					'total' 			=> $value->total,
					'amount_paid' 		=> $value->amount_paid,
					'amount_refunded' 	=> $value->amount_refunded,
					'payment_method' 	=> strtoupper( __($value->payment_method, $value->client_id) ),
					'transaction_id' 	=> $value->transaction_id,
					'amount_due' 		=> $value->amount_due,
					'is_credit_note' 	=> $value->is_credit_note,
					'order_status' 		=> convert_payment_gateway_status( $value->order_status ),
					'notes' 			=> $value->notes,
					'change_rate'		=> $change_rate
				];
			}
			return true;
		} else {
			show_custom404();
		}
	}
	/**
	 * Set_client_var($id)
	 * @param type $id 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_client_vars($id=null)
	{
		if (!$id)
		{
			$this->client_id = 0;
			$this->_client = [
				'client_id'        => 0,
				'name_company'     => __('label_guest'),
				'billing_name_company' => __('label_guest'),
				'shipping_name_company' => __('label_guest'),
				'client_address1'  => '',
				'billing_address1'  => '',
				'shipping_address1'  => '',
				'client_address2'  => '',
				'billing_address2'  => '',
				'shipping_address2'  => '',
				'client_postcode'  => '',
				'billing_postcode'  => '',
				'shipping_postcode'  => '',
				'client_city'      => '',
				'billing_city'      => '',
				'shipping_city'      => '',
				'client_state'     => '',
				'billing_state'     => '',
				'shipping_state'     => '',
				'client_tax_number' => '',
				'client_country'   => '',
				'billing_country'   => '',
				'shipping_country'   => '',
				'client_tax_number' => '',
				'client_chamber_com' => '',
				'client_bank_name' => '',
				'client_bank_number' => '',
				'client_phone' => '',
				'billing_phone' => '',
				'shipping_phone' => ''
			];
		}
		else
		{
			$results = client($id);
			foreach ($results as $client) {
				$this->client_id = $client->client_id;
				$this->_client = [
					'client_id'        => $client->client_id,
					'name_company'     => $client->name_company,
					'billing_name_company'     => $client->billing_name_company,
					'shipping_name_company'     => $client->shipping_name_company,
					'client_address1'  => $client->client_address1,
					'billing_address1'  => $client->billing_address1,
					'shipping_address1'  => $client->shipping_address1,
					'client_address2'  => $client->client_address2,
					'billing_address2'  => $client->billing_address2,
					'shipping_address2'  => $client->shipping_address2,
					'client_postcode'  => $client->client_postcode,
					'billing_postcode'  => $client->billing_postcode,
					'shipping_postcode'  => $client->shipping_postcode,
					'client_city'      => $client->client_city,
					'billing_city'      => $client->billing_city,
					'shipping_city'      => $client->shipping_city,
					'client_state'     => $client->client_state,
					'billing_state'     => $client->billing_state,
					'shipping_state'     => $client->shipping_state,
					'client_tax_number' => $client->client_tax_number,
					'client_chamber_com' => $client->client_chamber_com,
					'client_bank_name' => $client->client_bank_name,
					'client_bank_number' => $client->client_bank_number,
					'client_phone'		=> isset($client->client_phone) ? $client->client_phone : "",
					'billing_phone'		=> isset($client->billing_phone) ? $client->billing_phone : "",
					'shipping_phone'		=> isset($client->shipping_phone) ? $client->shipping_phone : "",
					'client_country'   => 'None' == get_countries($client->client_country) ? '': get_countries($client->client_country),
					'billing_country'   => null == $client->billing_country ? '': get_countries($client->billing_country),
					'shipping_country'   => null == $client->shipping_country ? '': get_countries($client->shipping_country)
				];
			}
		}
	}
}