<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Viewpurchase extends Basic_Controller {
	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_purchase = [];

	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_provider = [];
	protected $_provider_id;

	/**
	 * Index
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type Mixed
	 * @since 1.0.6
	 */
	public function view()
	{
		if ( !is_dir( getcwd().'/uploads/pdf/purchases/' ) ) mkdir ( getcwd().'/uploads/pdf/purchases/', 0777, true);
        
        if( chmod(getcwd().'/uploads/pdf/purchases/', 0755) ) 
        {
            chmod(getcwd().'/uploads/pdf/purchases/', 0777);
        }

		$data['transactions'] 	= FALSE;
		$data['balance'] 		= FALSE;

		if ( isset($_REQUEST['id']) ) 
		{
			$id 	= _dID($_REQUEST['id']);
			if ($this->set_purchase_vars($id)) {
				$this->set_provider_vars($this->_purchase['provider_id']);
				if ( $this->session->userdata('user_id') >= 1)
				{
					$lang = get_option( 'user_language', 'users_options' );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
					$lang_code = language_string_to_locale_notation( $lang );
				}
				else
				{
					$lang = lang_code_to_string( provider( $this->_purchase['provider_id'], 'provider_language' ) );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
					$lang_code = provider( $this->_purchase['provider_id'], 'provider_language' );
				}
				// Load system language file to handle dynamic localization
				$this->lang->load( 'application', $lang );
				$this->load->helper( 'file' );
				
				$path_invoice_terms = './notifications/' . $terms_lang . '/invoices/invoice_terms.php';
				$path_purchase_footer = './notifications/' . $terms_lang . '/invoices/purchase_footer.php';
				$template = read_file( $path_invoice_terms );
				$template_footer = read_file( $path_purchase_footer );
				$tr = substr( $template, 0, null != get_option('terms_conditions_length') ? get_option('terms_conditions_length'): 1000 );


				# Get all the items of the invoice
				$data['invoiceitems'] = get_purchased_items( $id );
				$results = get_purchase_tax( $id );
				$tax = [];
				if ( $results )
				{
					foreach ( $results as $key => $value ) {
						$tax[] = array(
							'tax_rate' => $value->taxRate,
							'tax_sum' => $value->taxAmount
						);
					}
				}
				$data['non_formatted_purchase_number'] = $this->_purchase['purchase_number'];
				$data['tax_value'] = $tax;
				$data['logo'] = get_option( 'logo' );
				$data['purchase_footer'] = $this->parser->parse_string( $template_footer, array(), TRUE );
				$data['user_company'] = get_option('company');

				// Set PDF vars
				$data['status'] = __( strtolower( $this->_purchase['purchase_status'] ) );
				$data['subject'] = $this->_purchase['subject'];
				$data['purchase_title'] = __('label_purchase_order') . ' ' . get_option('purchase_order_prefix').invoice_number_format() . sprintf("%04s", $this->_purchase['purchase_number'] );
				$data['provider_id'] = $this->_purchase['provider_id'];

				if ($this->_purchase['discount_amount'] > 0 )
				{
					$data['discount'] = TRUE;
					$data['discount_amount'] = $this->_purchase['discount_amount'];
					$data['discount_name'] = __('label_discount_amount');
				}
				else
				{
					$data['discount'] = FALSE;
				}

				$data['page_title'] = __('label_purchase_order') . ' ' . get_option('purchase_order_prefix').invoice_number_format() . sprintf("%04s", $this->_purchase['purchase_number'] );
				$data['purchase_number'] = get_option('purchase_order_prefix').invoice_number_format() . sprintf("%04s", $this->_purchase['purchase_number'] );
				$data['invoice_numb'] = __('invoice') . ' ' . get_option('purchase_order_prefix').invoice_number_format() . sprintf("%04s", $this->_purchase['purchase_number'] ) . '.pdf';

				$date = _fdate( $lang_code, $this->_purchase['date']);
				$shipping_date = _fdate( $lang_code, $this->_purchase['shipping_date']);
				$date_paid = _fdate( $lang_code, $this->_purchase['shipping_date']);

				$data['subtotal'] = $this->_purchase['subtotal'];
				$data['tax_amount'] = $this->_purchase['tax_amount'];
				if ($data['tax_amount'] <= 0)
				{
					$data['taxname'] = FALSE;
				}
				else
				{
					$data['taxname'] = __('label_tax');
					$data['taxname'] = TRUE;
				}
				$data['credit'] = $this->_purchase['credit_used'];
				if ($data['credit'] <= 0)
				{
					$data['credit'] = FALSE;
				}
				$data['total'] = $this->_purchase['total'];
				$data['shipping_amount'] = $this->_purchase['shipping_amount'];
				$data['other_expenses'] = $this->_purchase['other_expenses'];
				$data['amount_paid'] = $this->_purchase['amount_paid'];
				if ($data['amount_paid'] <= 0)
				{
					$data['amount_paid'] = FALSE;
					$data['transactions'] = FALSE;
				}
				$data['balance'] = $this->_purchase['amount_due'];
				$data['date'] = $date;
				$data['shipping_date'] = $shipping_date;
				$data['current_date'] = _fdate( $lang_code, date( 'Y-m-d' ) );

				$data['notes'] = $this->_purchase['notes'];
				$data['terms'] = $this->parser->parse_string( $tr, array(), TRUE );

				if ($this->_purchase['amount_paid'] > 0 )
				{
					$data['transactions'] = TRUE;
					$transactions = [];
					$data['transactions'] = TRUE;
					$results = get_purchase_payment_history($this->_purchase['purchase_number']);
					if ($results)
					{
						foreach ($results as $r) {
							array_push($transactions, array(
									'date' => _fdate( $lang_code, $r->date_paid ),
									'gateway' => $r->payment_method,
									'transid' => $r->payment_reference,
									'amount' => $r->payment_amount
								)
							);
						}
					}
					$data['transactions'] = $transactions;
					$data['balance'] = $this->_purchase['amount_due'];
				}
				if ( $this->_purchase['amount_due'] === 0)
				{
					$data['status'] = __('paid');
					$data['amount_refunded'] = FALSE;
				}
				if ( $this->_purchase['amount_refunded'] > 0)
				{
					$data['amount_refunded'] = $this->_purchase['amount_refunded'];
					if ($this->_purchase['amount_refunded'] < $this->_purchase['amount_paid'])
					{
						$data['status'] = __('label_short_partially_refunded');
						$data['has_refund'] = TRUE;
					}
					else
					{
						$data['status'] = __('label_refunded', $this->provider_id);
					}
				}
				else
				{
					$data['amount_refunded'] = FALSE;
					$data['has_refund'] = FALSE;
				}
				$data['provider'] = array(
						'name_company' => $this->_provider['name_company'],
						'address1' => $this->_provider['provider_address1'],
						'address2' => $this->_provider['provider_address2'],
						'postcode' => $this->_provider['provider_postcode'],
						'city' => $this->_provider['provider_city'],
						'state' => $this->_provider['provider_state'],
						'country' => $this->_provider['provider_country'],
						'provider_tax_number' => $this->_provider['provider_tax_number'],
						'provider_chamber_com' => $this->_provider['provider_chamber_com'],
						'provider_bank_name' => $this->_provider['provider_bank_name'],
						'provider_bank_number' => $this->_provider['provider_bank_number'],
						'provider_phone' => $this->_provider['provider_phone']
						);
				$data['user_address'] = array(
						'user_address1' => get_option('address1'),
						'user_address2' => get_option('address2'),
						'user_city' => get_option('city'),
						'user_postcode' => get_option('postcode'),
						'user_state' => get_option('state'),
						'user_country' => 'None' == get_countries(get_option('country')) ? '' : get_countries(get_option('country'))
						);
				$data['tax_id'] = null !== get_option('tax_id') ? get_option('tax_id') : "";
				$data['chamber_commerce_id'] = null !== get_option('chamber_commerce_id') ? get_option('chamber_commerce_id') : "";
				$data['bank_name'] = null !== get_option('bank_name') ? get_option('bank_name') : "";
				$data['bank_number'] = null !== get_option('bank_number') ? get_option('bank_number') : "";
				$data['bank_name'] = null !== get_option('bank_name') ? get_option('bank_name') : "";
				$data['change_rate'] = $this->_purchase['change_rate'];
				$data['phone'] = null !== get_option('phone') ? get_option('phone') : "";
				$data['mobile'] = null !== get_option('mobile') ? get_option('mobile') : "";
				$layout = 1;

				// Shipping address
				$data['shippingDetails'] = array(
					'ship_to' => $this->_purchase['ship_to'],
					'name_company' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'name_company') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'name_company') : get_option('company'),
					'address1' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'address1') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'address1') : get_option('address1'),
					'address2' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'address2') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'address2') : get_option('address2'),
					'city' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'city') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'city') : get_option('city'),
					'state' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'state') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'state') : get_option('state'),
					'postcode' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'postcode') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'postcode') : get_option('postcode'),
					'country' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'country') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'country') : get_option('country'),
					'phone' => null != get_company_shipment_addresses($this->_purchase['ship_to'], 'phone') ? get_company_shipment_addresses($this->_purchase['ship_to'], 'phone') : get_option('phone')
				);

				if( !$this->session->userdata('user_id') )
				{
					$event = array(
						'action' 					=> 'order_opened',
						'referrer' 					=> 'purchase_purchase',
						'referrer_id' 				=> $this->_purchase['purchase_number'],
						'referrer_value' 			=> $this->_purchase['purchase_number'],
						'provider_id' 				=> $this->_purchase['provider_id'],
						'status' 					=> 'success'
					);
					record_event($event);
				}
				$this->Template->render('purchases', 'purchase_tpl_'. $layout, $data);
			} else {
				show_custom404();
			}
		}
		else
		{
			show_custom404();
		}
	}
	/**
	 * set_invoice_vars 
	 * @param type $invoice_number 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_purchase_vars($purchase_number)
	{
		$results = get_purchase_by_number($purchase_number);
		if ($results) {
			foreach ($results as $value) 
			{
				if ($value->provider_id == 0)
				{
					$currency = get_option('user_currency');
				}
				else
				{
					$currency = provider($value->provider_id, 'provider_currency');
				}
				if ( _has_option( 'change_currency' ) )
				{
					$change_rate = get_change_rate( $currency );
				}
				else
				{
					$change_rate = 1;
				}
				$this->_purchase = [
					'id'				=> $value->id,
					'provider_id' 		=> $value->provider_id,
					'ship_to' 			=> $value->ship_to,
					'purchase_number' 	=> $value->purchase_number,
					'subject' 			=> $value->subject,
					'pay_type' 			=> $value->pay_type,
					'date' 				=> $value->date,
					'shipping_date' 	=> $value->shipping_date,
					'next_duedate' 		=> $value->next_duedate,
					'date_paid' 		=> $value->date_paid,
					'subtotal' 			=> $value->subtotal,
					'purchase_status' 	=> $value->purchase_status,
					'tax_amount' 		=> $value->tax_amount,
					'credit_used' 		=> $value->credit_used,
					'discount_amount' 	=> $value->discount_amount,
					'shipping_amount' 	=> $value->shipping_amount,
					'other_expenses' 	=> $value->other_expenses,
					'total' 			=> $value->total + $value->shipping_amount + $value->other_expenses,
					'amount_paid' 		=> $value->amount_paid,
					'amount_refunded' 	=> $value->amount_refunded,
					'payment_method' 	=> strtoupper( __($value->payment_method, $value->provider_id) ),
					'transaction_id' 	=> $value->payment_id,
					'amount_due' 		=> $value->amount_due,
					'invoice_status' 	=> convert_payment_gateway_status( $value->purchase_status ),
					'notes' 			=> $value->notes,
					'change_rate'		=> $change_rate
				];
			}
			return true;
		}
	}
	/**
	 * Set_client_var($id)
	 * @param type $id 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_provider_vars($id=null)
	{
		if (!$id)
		{
			$this->provider_id = 0;
			$this->_provider = [
				'provider_id'        => 0,
				'name_company'     => __('label_guest'),
				'provider_address1'  => '',
				'provider_address2'  => '',
				'provider_postcode'  => '',
				'provider_city'      => '',
				'provider_state'     => '',
				'provider_tax_number' => '',
				'provider_country'   => '',
				'provider_tax_number' => '',
				'provider_chamber_com' => '',
				'provider_bank_name' => '',
				'provider_bank_number' => '',
				'provider_phone' => ''
			];
		}
		else
		{
			$results = provider($id);
			foreach ($results as $provider) {
				$this->provider_id = $provider->provider_id;
				$this->_provider = [
					'provider_id'        => $provider->provider_id,
					'name_company'     => $provider->name_company,
					'provider_address1'  => $provider->provider_address1,
					'provider_address2'  => $provider->provider_address2,
					'provider_postcode'  => $provider->provider_postcode,
					'provider_city'      => $provider->provider_city,
					'provider_state'     => $provider->provider_state,
					'provider_tax_number' => $provider->provider_tax_number,
					'provider_chamber_com' => $provider->provider_chamber_com,
					'provider_bank_name' => $provider->provider_bank_name,
					'provider_bank_number' => $provider->provider_bank_number,
					'provider_phone'		=> isset($provider->provider_phone) ? $provider->provider_phone : "",
					'provider_country'   => 'None' == get_countries($provider->provider_country) ? '': get_countries($provider->provider_country)
				];
			}
		}
	}
}