<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Viewquote extends Basic_Controller {
	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_quote = [];

	/**
	 * @var type array
	 * @since 1.0.6
	 */
	protected $_client = [];

	/**
	 * Index
	 * @param type|null $a 
	 * @param type|null $quote_number 
	 * @return type Mixed
	 * @since 1.0.6
	 */
	public function view()
	{
		if ( ! $_REQUEST['id'] )
		{
			show_custom404();
		}
		else
		{
			if ( !is_dir( getcwd().'/uploads/pdf/quotes/' ) ) mkdir ( getcwd().'/uploads/pdf/quotes/', 0777, true);
	        
	        if( chmod(getcwd().'/uploads/pdf/quotes/', 0755) ) 
	        {
	            chmod(getcwd().'/uploads/pdf/quotes/', 0777);
	        }
			$quote_number 			= _dID( $_REQUEST['id'] );
			// Set quote vars
			if ($this->set_quote_vars( $quote_number )) {
				// Set client vars
				$this->set_client_vars( $this->_quote['client_id'] );
				// Pdf terms and condition and footer are in a local folder ./notifications
				// Load these files based on the language
				// If pdf is loaded by an admin, checks if session data exists
				// If yes, fetch the admin language, if no session data found,
				// Pdf is open by the client, so fetch his / her language
				$this->load->helper('file');
				if ( $this->session->userdata('user_id') >= 1)
				{
					$lang = get_option( 'user_language', 'users_options' );
					$lang_code = language_string_to_locale_notation( $lang );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
				}
				else
				{
					$lang = lang_code_to_string( client( $this->_quote['client_id'], 'client_language' ) );
					$lang_code = client( $this->_quote['client_id'], 'client_language' );
					$terms_lang = lang_code_to_notif_string( get_option( 'default_language' ) );
				}
				// Load system language file to handle dynamic localization
				$this->lang->load( 'application', $lang );
				// Get the right file and set the template
				$path_quote_terms 		= './notifications/' . $terms_lang . '/quotes/quote_terms.php';
				$path_quote_footer 		= './notifications/' . $terms_lang . '/quotes/quote_footer.php';
				$template 				= read_file( $path_quote_terms );
				$template_footer 		= read_file( $path_quote_footer );
				$tr 					= substr( $template, 0, null != get_option('terms_conditions_length') ? get_option('terms_conditions_length'): 1000 ); // if the terms and condition is very long, grab the first 1000 words.

				// START VIEW DATA
				// Now get all the items of the quote
				$data['invoiceitems'] 	= get_quoted_items($quote_number);
				$results 				= get_quote_tax( $quote_number );
				// Set a tax array if diffents tax applied and sum up the amount
				$tax 					= [];
				if( $results )
				{
					foreach ( $results as $key => $value ) {
						$tax[] = array(
							'tax_rate' 		=> $value->taxRate,
							'tax_sum' 		=> number_format( $value->taxAmount, 2 )
						);
					}
				}
				$data['tax_value'] 		= $tax;
				$data['non_formatted_quote_number'] = $this->_quote['quote_number'];
				$data['logo'] 			= get_option( 'logo' ); // Get the logo. Can be disable in settings
				$data['quote_footer'] 	= $this->parser->parse_string( $template_footer, array(), TRUE );
				$data['user_company'] 	= get_option( 'company' );
				$data['status'] 		= __( strtolower( $this->_quote['quote_status'] ) );
				$data['subject'] 		= $this->_quote['subject'];
				$data['quote_title'] 	= __( 'quote' ) . ' ' . get_option( 'quote_prefix' ).invoice_number_format() . sprintf( "%04s", $this->_quote['quote_number'] );
				$data['client_id'] 		= $this->_quote['client_id'];
				if ($this->_quote['discount_amount'] > 0 )
				{
					$data['discount'] 			= TRUE;
					$data['discount_amount'] 	= $this->_quote['discount_amount'];
					$data['discount_name'] 		= __( 'label_discount_amount' );
				}
				else
				{
					$data['discount'] 			= false;
				}

				$data['page_title'] 	= __( 'quote' ) . ' ' . get_option( 'quote_prefix' ).invoice_number_format() . sprintf( "%04s", $this->_quote['quote_number'] );
				$data['quote_number'] 	= get_option( 'quote_prefix' ).invoice_number_format() . sprintf( "%04s", $this->_quote['quote_number'] );
				// Pdf name when downloaded.
				$data['quote_numb'] 	= __( 'quote' ) . ' ' . get_option( 'quote_prefix' ).invoice_number_format() . sprintf( "%04s", $this->_quote['quote_number'] ) . '.pdf';
				$date = _fdate( $lang_code, $this->_quote['date'] );
				$due_date = _fdate( $lang_code, $this->_quote['due_date'] );

				$data['subtotal'] = $this->_quote['subtotal'];
				$data['tax_amount'] = $this->_quote['tax_amount'];
				if ($data['tax_amount'] <= 0)
				{
					$data['taxname'] = false;
				}
				else
				{
					$data['taxname'] = __( 'label_tax' );
					$data['taxname'] = TRUE;
				}
				$data['total'] = $this->_quote['total'];
				$data['balance'] = $this->_quote['amount_due'];
				$data['date'] = $date;
				$data['due_date'] = $due_date;
				$data['current_date'] = _fdate( $lang_code, date('Y-m-d') );

				$data['notes'] = $this->_quote['notes'];
				$data['terms'] = $this->parser->parse_string($tr, array(), TRUE);
				$data['client'] = array(
						'name_company' => $this->_client['name_company'],
						'billing_name_company' => "" != $this->_client['billing_name_company'] ? $this->_client['billing_name_company'] : $this->_client['name_company'],
						'shipping_name_company' => "" != $this->_client['shipping_name_company'] ? $this->_client['shipping_name_company'] : $this->_client['name_company'],
						'address1' => $this->_client['client_address1'],
						'billing_address1' => "" != $this->_client['billing_address1'] ? $this->_client['billing_address1']: $this->_client['client_address1'],
						'shipping_address1' => "" != $this->_client['shipping_address1'] ? $this->_client['shipping_address1'] : $this->_client['client_address1'],
						'address2' => $this->_client['client_address2'],
						'billing_address2' => "" != $this->_client['billing_address2'] ? $this->_client['billing_address2'] : $this->_client['client_address2'],
						'shipping_address2' => "" != $this->_client['shipping_address2'] ? $this->_client['shipping_address2'] : $this->_client['client_address2'],
						'postcode' => $this->_client['client_postcode'],
						'billing_postcode' => "" != $this->_client['billing_postcode'] ? $this->_client['billing_postcode'] : $this->_client['client_postcode'],
						'shipping_postcode' => "" != $this->_client['shipping_postcode'] ? $this->_client['shipping_postcode'] : $this->_client['client_postcode'],
						'city' => $this->_client['client_city'],
						'billing_city' => "" != $this->_client['billing_city'] ? $this->_client['billing_city'] : $this->_client['client_city'],
						'shipping_city' => "" != $this->_client['shipping_city'] ? $this->_client['shipping_city'] : $this->_client['client_city'],
						'state' => $this->_client['client_state'],
						'billing_state' => "" != $this->_client['billing_state'] ? $this->_client['billing_state'] : $this->_client['client_state'],
						'shipping_state' => "" != $this->_client['shipping_state'] ? $this->_client['shipping_state'] : $this->_client['client_state'],
						'country' => $this->_client['client_country'],
						'billing_country' => "" != $this->_client['billing_country'] ? $this->_client['billing_country'] : $this->_client['client_country'],
						'shipping_country' => "" != $this->_client['shipping_country'] ? $this->_client['shipping_country'] : $this->_client['client_country'],
						'client_tax_number' => $this->_client['client_tax_number'],
						'client_chamber_com' => $this->_client['client_chamber_com'],
						'client_bank_name' => $this->_client['client_bank_name'],
						'client_bank_number' => $this->_client['client_bank_number'],
						'client_phone' => $this->_client['client_phone'],
						'billing_phone' => "" != $this->_client['billing_phone'] ? $this->_client['billing_phone'] : $this->_client['client_phone'],
						'shipping_phone' => "" != $this->_client['shipping_phone'] ? $this->_client['shipping_phone'] : $this->_client['client_phone']
						);
				$data['user_address'] = array(
					'user_address1' 			=> get_option('address1'),
					'user_address2' 			=> get_option('address2'),
					'user_city' 				=> get_option('city'),
					'user_postcode' 			=> get_option('postcode'),
					'user_state' 				=> get_option('state'),
					'user_country' 				=> 'None' == get_countries(get_option('country')) ? '' : get_countries(get_option('country'))
					);
				$data['transactions'] = false;
				$data['balance'] = false;
				$data['tax_id'] 				= null !== get_option('tax_id') ? get_option('tax_id') : "";
				$data['chamber_commerce_id'] 	= null !== get_option('chamber_commerce_id') ? get_option('chamber_commerce_id') : "";
				$data['bank_name'] 				= null !== get_option('bank_name') ? get_option('bank_name') : "";
				$data['bank_number'] 			= null !== get_option('bank_number') ? get_option('bank_number') : "";
				$data['change_rate'] 			= $this->_quote['change_rate'];
				$data['phone'] = null !== get_option('phone') ? get_option('phone') : "";
				$data['mobile'] = null !== get_option('mobile') ? get_option('mobile') : "";
				
				$layout 						= null !== get_option('quote_layout') ? get_option('quote_layout') : 1; //Load the quote layout. Default is 1
				$this->Template->render('quotes', 'quote_tpl_'.$layout, $data);
			}
		}
	}
	public function view_accepted()
	{
		$quote_number 			= _dID( $_REQUEST['id'] );
		// Get the client id to set the language in frontend
		$data['client_id'] 		= get_quote_vars( $quote_number, 'client_id' );

		if ( ! is_approved( $quote_number ) )
		{
			// Set Quote to accepted
			update_quote_status( $quote_number, 'Accepted' );
			$this->m_manager->from_quote_to_invoice( $quote_number );
			$data['quote_url'] 				= base_url( 'index.php/viewquote/view?id=' ) . $_REQUEST['id'];
			$view_data['quote_response'] 	= $this->Template->render('quotes', 'quote_accepted.phtml', $data, TRUE );
		}
		else
		{
			$data['quote_url']				= base_url( 'index.php/viewquote/view?id=' ) . $_REQUEST['id'];
			$view_data['quote_response'] 	= $this->Template->render('quotes', 'quote_already_accepted.phtml', $data, TRUE );
		}
		$this->Template->render('quotes', 'quote_response.phtml', $view_data);
	}
	public function view_declined()
	{
		$quote_number 			= _dID( $_REQUEST['id'] );
		// Get the client id to set the language in frontend
		$data['client_id'] 		= get_quote_vars( $quote_number, 'client_id' );
		// Check if quote was already approved
		if ( is_approved( $quote_number ) )
		{
			$data['quote_url'] 					= base_url( 'index.php/viewquote/view?id=' ) . $_REQUEST['id'];
			$data['email'] 						= get_option( 'notifications_email' );
			$data['phone'] 						= get_option( 'phone' );
			$view_data['quote_response'] 		= $this->Template->render('quotes', 'change_mind.phtml', $data, TRUE );
			$this->Template->render('quotes', 'quote_response.phtml', $view_data );
		}
		else
		{
			// Set Quote to declined
			update_quote_status( $quote_number, 'Declined' );

			$data['quote_url'] 					= base_url('index.php/viewquote/view?id=') . $_REQUEST['id'];
			$view_data['quote_response'] 		= $this->Template->render('quotes', 'quote_declined.phtml', $data, TRUE);
			$this->Template->render('quotes', 'quote_response.phtml', $view_data);
		}
	}
	/**
	 * set_quote_vars 
	 * @param type $quote_number 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_quote_vars( $quote_number )
	{
		$results = get_quote_by_number( $quote_number );
		if ($results) {
			foreach ($results as $value) 
			{
				if ($value->client_id == 0)
				{
					$currency = get_option('user_currency');
				}
				else
				{
					$currency = client($value->client_id, 'client_currency');
				}
				if ( _has_option( 'change_currency' ) )
				{
					$change_rate = get_change_rate( $currency );
				}
				else
				{
					$change_rate = 1;
				}
				$this->_quote = array(
					'id'				=> $value->id,
					'client_id' 		=> $value->client_id,
					'quote_number' 	    => $value->quote_number,
					'subject' 			=> $value->subject,
					'date' 				=> $value->date,
					'due_date' 			=> $value->due_date,
					'next_duedate' 		=> $value->next_duedate,
					'date_paid' 		=> $value->date_paid,
					'subtotal' 			=> $value->subtotal,
					'tax_amount' 		=> $value->tax_amount,
					'discount_amount' 	=> $value->discount_amount,
					'total' 			=> $value->total,
					'amount_due' 		=> $value->amount_due,
					'quote_status' 	    => $value->quote_status,
					'notes' 			=> $value->notes,
					'change_rate'		=> $change_rate
				);
			}
			return true;
		} else {
			show_custom404();
		}
	}
	/**
	 * Set_client_var($quote_number)
	 * @param type $quote_number 
	 * @return type array
	 * @since 1.0.6
	 */
	public function set_client_vars($quote_number=null)
	{
		if (!$quote_number)
		{
			$this->client_id = 0;
			$this->_client = [
				'client_id'        => 0,
				'name_company'     => __('label_guest'),
				'billing_name_company' => __('label_guest'),
				'shipping_name_company' => __('label_guest'),
				'client_address1'  => '',
				'billing_address1'  => '',
				'shipping_address1'  => '',
				'client_address2'  => '',
				'billing_address2'  => '',
				'shipping_address2'  => '',
				'client_postcode'  => '',
				'billing_postcode'  => '',
				'shipping_postcode'  => '',
				'client_city'      => '',
				'billing_city'      => '',
				'shipping_city'      => '',
				'client_state'     => '',
				'billing_state'     => '',
				'shipping_state'     => '',
				'client_tax_number' => '',
				'client_country'   => '',
				'billing_country'   => '',
				'shipping_country'   => '',
				'client_tax_number' => '',
				'client_chamber_com' => '',
				'client_bank_name' => '',
				'client_bank_number' => '',
				'client_phone' => '',
				'billing_phone' => '',
				'shipping_phone' => ''
			];
		}
		else
		{
			$results = client($quote_number);
			foreach ($results as $client) {
				$this->client_id = $client->client_id;
				$this->_client = [
					'client_id'        => $client->client_id,
					'name_company'     => $client->name_company,
					'billing_name_company'     => $client->billing_name_company,
					'shipping_name_company'     => $client->shipping_name_company,
					'client_address1'  => $client->client_address1,
					'billing_address1'  => $client->billing_address1,
					'shipping_address1'  => $client->shipping_address1,
					'client_address2'  => $client->client_address2,
					'billing_address2'  => $client->billing_address2,
					'shipping_address2'  => $client->shipping_address2,
					'client_postcode'  => $client->client_postcode,
					'billing_postcode'  => $client->billing_postcode,
					'shipping_postcode'  => $client->shipping_postcode,
					'client_city'      => $client->client_city,
					'billing_city'      => $client->billing_city,
					'shipping_city'      => $client->shipping_city,
					'client_state'     => $client->client_state,
					'billing_state'     => $client->billing_state,
					'shipping_state'     => $client->shipping_state,
					'client_tax_number' => $client->client_tax_number,
					'client_chamber_com' => $client->client_chamber_com,
					'client_bank_name' => $client->client_bank_name,
					'client_bank_number' => $client->client_bank_number,
					'client_phone'		=> isset($client->client_phone) ? $client->client_phone : "",
					'billing_phone'		=> isset($client->billing_phone) ? $client->billing_phone : "",
					'shipping_phone'		=> isset($client->shipping_phone) ? $client->shipping_phone : "",
					'client_country'   => 'None' == get_countries($client->client_country) ? '': get_countries($client->client_country),
					'billing_country'   => null == $client->billing_country ? '': get_countries($client->billing_country),
					'shipping_country'   => null == $client->shipping_country ? '': get_countries($client->shipping_country)
				];
			}
		}
	}
}