<?php 
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class MY_Model extends CI_Model {
	/**
	 * @var type $_table
	 */
	protected $_table;
	/**
	 * @var type $_tables
	 */
	protected $_tables;
	/**
	 * @var type
	 */
	protected $_primary_key;
	/**
	 * @var type
	 */
	protected $_db_data = [];
	/**
	 * @var type
	 */
	protected $_select = '*';
	protected $_where = '';
	protected $salt;
	protected $_db;
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->library('EzSQL_codeigniter');
		$this->oneric = new EzSQL_codeigniter;

		$this->config->load('db_tables');
		$this->salt = $this->config->item('salt');
		$this->tables = $this->config->item('tables');

		// Connect mysqli database class
		$dbvars = get_db_vars();

		$dbhost = $dbvars['hostname']; // usually localhost
		$dbuser = $dbvars['username']; //enter your database username here
		$dbpass = $dbvars['password']; //enter your database password here
		$dbname = $dbvars['database']; // enter your database name here

		$this->_db = new \MysqliDb($dbhost, $dbuser, $dbpass, $dbname);
	}
	/**
	 * Description
	 * @param type $primary_value 
	 * @return type
	 */
	public function get($primary_value)
	{
		$query = "SELECT * FROM {$this->tables[$this->_table]} WHERE {$this->_primary_key} = {$primary_value}";
		return $this->oneric->get_row($query);
	}
	/**
	 * Get all value from a table
	 * @return type object
	 */
	public function get_all()
	{
		$query = "SELECT * FROM {$this->tables[$this->_table]}";
		return $this->oneric->get_results($query);
	}
	public function get_selection($selection)
	{
		$selection = is_array($selection) ? implode(',', $selection) : $selection;
		$query = "SELECT {$selection} FROM {$this->tables[$this->_table]}";
		return $this->oneric->get_results($query);
	}

	/**
	 * Get a single row
	 * @param type $id 
	 * @param type|null $select 
	 * @return type
	 */
	public function get_row($id, $select = NULL)
	{
		$select = (is_string($select) && $select !== NULL) ? $select : $this->_select;
		$query = "SELECT {$select} FROM {$this->tables[$this->_table]} WHERE {$this->_primary_key} = {$id}";
		return $this->oneric->get_row($query);
	}

	/**
	 * Get with a where clause
	 * @param type $where 
	 * @param type|null $select 
	 * @return type
	 */
	public function get_where($where, $select = NULL)
	{
		$select = (is_string($select) && $select !== NULL) ? $select : $this->_select;
		$query = "SELECT {$select} FROM {$this->tables[$this->_table]} WHERE {$where}";
		return $this->oneric->get_results($query);
	}

	/**
	 * Insert or update a record
	 * @param type $db_data 
	 * @param type|null $id 
	 * @return type
	 */
	public function save($db_data, $id = NULL)
	{
		$this->_db_data = $db_data;
		if (!$id)
		{
			$query = "INSERT INTO {$this->tables[$this->_table]} SET ". $this->oneric->get_set($this->_db_data);
			return $this->oneric->query($query);
		}
		else
		{
			$query = "UPDATE {$this->tables[$this->_table]}
							SET " . $this->oneric->get_set($this->_db_data) . 
							" WHERE {$this->_primary_key} = {$id}";
			return $this->oneric->query($query);
		}
	}
	/**
	 * Set a table
	 * @param type $table 
	 * @return type
	 */
	public function set_table($table)
	{
		$this->_table = $table;
		return $this;
	}

	/**
	 * Set tables
	 * @param type $tables 
	 * @return type
	 */
	public function set_tables($tables)
	{
		$this->_tables = $tables;
		return $this;
	}

	/**
	 * Set a primary key
	 * @param type $key 
	 * @return type
	 */
	public function set_primary_key($key)
	{
		$this->_primary_key = $key;
		return $this;
	}

	/**
	 * Get the next ID from any table
	 * @return type
	 */
	public function get_next_id()
    {
    	return (int) $this->db->select('AUTO_INCREMENT')
            ->from('information_schema.TABLES')
            ->where('TABLE_NAME', $this->tables[$this->_table])
            ->where('TABLE_SCHEMA', $this->db->database)->get()->row()->AUTO_INCREMENT;
    }
    public function truncate($table)
    {
    	return $this->db->truncate($this->tables[$table]);
    }
    public function before_delete($id)
    {
    	if (isset($this->_tables) && is_array($this->_tables))
    	{
    		foreach ($this->_tables as $table) 
    		{
    			if ($this->oneric->get_results("SELECT 1 FROM {$this->tables[$table]} WHERE {$this->_primary_key}={$id}") > 0)
    			{
    				return true;
    			}
    		}
    		return false;
    	}
    }
    public function encodeID($id)
    {
    	// Strings don't currently have a secure
    	// method, so simple base64 encoding will work for now.
    	if (! is_numeric($id))
    	{
            return '=_'.base64_encode($id);
    	}

    	$id = (int)$id;
    	if ($id < 1)
    	{
    		return false;
    	}
    	if ($id > pow(2,31))
    	{
    		return false;
    	}

    	$segment1 = $this->getHash($id,16);
    	$segment2 = $this->getHash($segment1,8);
    	$dec      = (int)base_convert($segment2,16,10);
    	$dec      = ($dec>$id)?$dec-$id:$dec+$id;
    	$segment2 = base_convert($dec,10,16);
    	$segment2 = str_pad($segment2,8,'0',STR_PAD_LEFT);
    	$segment3 = $this->getHash($segment1.$segment2,8);
    	$hex      = $segment1.$segment2.$segment3;
    	$bin      = pack('H*',$hex);
    	$oid      = base64_encode($bin);
    	$oid      = str_replace(array('+','/','='),array('$',':',''),$oid);

    	return $oid;
    }

    public function decodeID($hash)
    {
    	// Was it a simple string we encoded?
    	if (substr($hash, 0, 2) == '=_')
    	{
    		$hash = substr($hash, 2);
    		return base64_decode($hash);
    	}

    	if (! preg_match('/^[A-Z0-9\:\$]{21,23}$/i',$hash)) {
    		return 0;
    	}
    	$hash     = str_replace(array('$',':'),array('+','/'),$hash);
    	$bin      = base64_decode($hash);
    	$hex      = unpack('H*',$bin); $hex = $hex[1];
    	if (! preg_match('/^[0-9a-f]{32}$/',$hex))
    	{
    		return 0;
    	}
    	$segment1 = substr($hex,0,16);
    	$segment2 = substr($hex,16,8);
    	$segment3 = substr($hex,24,8);
    	$exp2     = $this->getHash($segment1,8);
    	$exp3     = $this->getHash($segment1.$segment2,8);
    	if ($segment3 != $exp3)
    	{
    		return 0;
    	}
    	$v1       = (int)base_convert($segment2,16,10);
    	$v2       = (int)base_convert($exp2,16,10);
    	$id       = abs($v1-$v2);

    	return $id;
    }
    public function findByHashedID($hashedID)
    {
    	return $this->find($this->decodeID($hashedID));
    }

    protected function getHash($str, $len)
    {
    	return substr(sha1($str.$this->salt),0,$len);
    }
    public function is_empty($table)
    {
    	$table = $this->tables[$table];
    	return $db->getValue($table, "count(*)");
    }
    /**
     * Count
     * @param type|null $status 
     * @return type
     */
    public function count_rows($table, $status = null, $context = null) {
    	$db = MysqliDb::getInstance();
    	switch ($table) {
    		case 'invoices':
    			if (!$status || $status == 'All') {
    				$db->where('invoice_status', 'Refunded', '<>');
    			} else {
    				$db->where('invoice_status', $status, '=');
    			}
    			break;
    		case 'quotes':
    			if ($status != 'All') {
    				$db->where('quote_status', $status, '=');
    			}
    			break;
    		case 'purchases':
    			if ($status != 'All') {
    				$db->where('purchase_status', $status, '=');
    			}
    			break;
    		case 'transactions':
    			if ($status != 'All') {
    				if ($context == 'charges') {
    					$db->where('charges_category', $status, '=');
    				} else {
    					$db->where('incomes_category', $status, '=');
    				}
    			}
    			break;
    	}
		return $db->getValue($this->tables[$table], "count(*)");
    }
}