<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function next_invoice_number()
{
	return get_next_id('invoices');
}
// ------------------------------------------------------------------------
function is_invoiced($id)
{
	global $db;
	$protected = [];
	$id = intval($id);
	$invoiced = $db->get_results("SELECT DISTINCT item_id FROM {$db->tables['invoices_items']}");
	if (!empty($invoiced))
	{
		foreach ($invoiced as $i) {
			array_push($protected, intval($i->item_id));
		}
	}
	if (in_array($id, $protected))
	{
		return true;
	}
	return FALSE;
}
// ------------------------------------------------------------------------
function has_invoice($id)
{
	global $db;
	$protected = [];
	$id = intval($id);
	$invoice = $db->get_results("SELECT DISTINCT client_id FROM {$db->tables['invoices']}");
	if (!empty($invoice))
	{
		foreach ($invoice as $i) {
			array_push($protected, intval($i->client_id));
		}
	}
	if (in_array($id, $protected))
	{
		return true;
	}
	return FALSE;
}
/**
 * Set invoices overdue
 * @return type mixec
 */
function set_overdue()
{
	global $db;
	$query = "SELECT * 
		FROM {$db->tables['invoices']} 
		WHERE invoice_status = 'Unpaid'
		";
	$invoices = $db->get_results($query);
	if (!empty($invoices))
	{
		foreach ($invoices as $invoice) 
		{
			$date = date("Y-m-d H:i:s");
			$due_date = $invoice->due_date;
			if ($date > $due_date)
			{
				$db_data = array('invoice_status' => 'Overdue');
				$db->query("UPDATE {$db->tables['invoices']} SET ".$db->get_set($db_data) . " WHERE id = {$invoice->id}");
			}
		}
	}
	return FALSE;
}
/**
 * Compute total due by client
 * @param type $id 
 * @param type|null $interval 
 * @return type
 */
function unpaid_invoice_by_client($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id}
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'";
			return $db->get_row($query)->TotalDue;
			break;
		case 'last_month':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND client_id={$id}
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'";
			return $db->get_row($query)->TotalDue;
			break;
		case 'latest_three_months':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE date >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH
				AND client_id={$id}
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'";
			return $db->get_row($query)->TotalDue;
			break;
		case 'this_year':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id}
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'";
			return $db->get_row($query)->TotalDue;
			break;
		case 'last_year':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE YEAR(date) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR))
				AND client_id={$id}
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'";
			return $db->get_row($query)->TotalDue;
			break;
		case 'all_dates':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE YEAR(date) IS NOT NULL
				AND client_id={$id}
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'";
			return $db->get_row($query)->TotalDue;
			break;
		default:
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id}
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'";
			return $db->get_row($query)->TotalDue;
			break;
	}
}
// ------------------------------------------------------------------------
/**
 * Get all unpaid invoices by client
 * @param type $id 
 * @param type|null $interval 
 * @return type
 */
function client_unpaid_invoices($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']} I 
				LEFT JOIN {$db->tables['clients']} C 
				ON I.client_id = C.client_id
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
		case 'last_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']} I 
				LEFT JOIN {$db->tables['clients']} C 
				ON I.client_id = C.client_id
				WHERE MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
		default:
			$query = "SELECT * 
				FROM {$db->tables['invoices']} I 
				LEFT JOIN {$db->tables['clients']} C 
				ON I.client_id = C.client_id
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
	}
}
// ------------------------------------------------------------------------
/**
 * Get all invoices for a given client
 * @param type $id 
 * @param type|null $interval 
 * @return type
 */
function client_invoices($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']} I 
				LEFT JOIN {$db->tables['clients']} C 
				ON I.client_id = C.client_id
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
		case 'last_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']} I 
				LEFT JOIN {$db->tables['clients']} C 
				ON I.client_id = C.client_id
				WHERE MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
		default:
			$query = "SELECT * 
				FROM {$db->tables['invoices']} I 
				LEFT JOIN {$db->tables['clients']} C 
				ON I.client_id = C.client_id
				WHERE I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
	}
}
// ------------------------------------------------------------------------
function get_invoice_charges($invoice_number)
{
	global $db;
	$res = new \stdClass();
	$res->charges_value = 0;

	if (!$db->query("SELECT EXISTS(SELECT 1 FROM {$db->tables['transactions']} WHERE invoice_number={$invoice_number})"))
	{
		return $res->charges_value;
	}
	else
	{
		$result = $db->get_results("SELECT charges_value FROM {$db->tables['transactions']} WHERE invoice_number={$invoice_number}");
		if ($result)
		{
			foreach ($result as $res) {
				return $res->charges_value;
			}
		}
		return $res->charges_value;
	}
}
// ------------------------------------------------------------------------
function get_invoices_amount($status)
{
	global $db;
	$query = "SELECT SUM(amount_due) AS value 
			FROM {$db->tables['invoices']} WHERE invoice_status='$status'";
	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $value) {
			return floatval($value->value);
		}
	}
}
// ------------------------------------------------------------------------
function count_invoices($status)
{
	global $db;
	$query = "SELECT COUNT(amount_due) AS value 
			FROM {$db->tables['invoices']} 
			WHERE invoice_status='$status'";
	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $value) {
			return floatval($value->value);
		}
	}
}
// ------------------------------------------------------------------------
function invoice_number_format()
{
	$format = get_option('invoice_numbering');
	switch ($format) {
		case '1':
			return '';
			break;
		case '2':
			return date('Y').'#';
			break;
		case '3':
			return date('Y/m').'#';
			break;
		default:
			return '';
			break;
	}
}
// ------------------------------------------------------------------------
function invoiced_to_guest($invoice_number)
{
	global $db;
	return $db->get_row("SELECT client_id FROM {$db->tables['invoices']} WHERE invoice_number={$invoice_number}")->client_id;
}
// ------------------------------------------------------------------------
function update_invoice_status($invoice_number, $status, $id=null)
{
	$invoice = get_invoice_by_number($invoice_number);
	$invoice_id = 0;
	if ($invoice)
	{
		foreach ($invoice as $k => $v) {
			$invoice_id = $v->id;
		}
	}
	global $db;
	$query = "UPDATE {$db->tables['invoices']}
		SET " . $db->get_set(array('invoice_status' => $status, 'payment_id' => $id)) . 
		" WHERE id = {$invoice_id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function get_invoice_tax($invoice_number)
{
	global $db;
	return $db->get_results("SELECT item_tax_rate AS taxRate, 
		SUM(item_subtotal) * item_tax_rate / 100 AS taxAmount
		FROM {$db->tables['invoices_items']}
		WHERE invoice_number = {$invoice_number}
		AND item_tax_rate > 0
		GROUP BY taxRate
		ORDER BY taxRate ASC");
}
// ------------------------------------------------------------------------
function get_invoice_vars($invoice_number, $var = null)
{
	global $db;
	if ($invoice_number && !$var)
	{
		return get_invoice_by_number($invoice_number);
	}
	elseif ($invoice_number && $var && $var !== 'invoiced_items')
	{
		return $db->get_row("SELECT {$var} FROM {$db->tables['invoices']} WHERE invoice_number={$invoice_number} LIMIT 1") ?
		$db->get_row("SELECT {$var} FROM {$db->tables['invoices']} WHERE invoice_number={$invoice_number} LIMIT 1")->{$var} : FALSE;
	}
	else
	{
		return get_invoiced_items($invoice_number);
	}
}
function get_invoice_by_id($id) {
	global $db;
	$query = "SELECT * FROM {$db->tables['invoices']} I 
	LEFT JOIN {$db->tables['clients']} C ON I.client_id = C.client_id 
	WHERE id = {$id}";
	return $db->get_results($query);
}
function refunded_invoice($invoice_number) {
	global $db;
	$refunded = [];
	$results = $db->get_results("SELECT initial_invoice_number FROM oc_invoices WHERE initial_invoice_number IS NOT NULL");
	if ($results) {
		foreach ($results as $r) {
			array_push($refunded, $r->initial_invoice_number);
		}
	}
	if (in_array($invoice_number, $refunded)) {
		return 1;
	}
	return 0;
}