<?php
// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

function mm_send_mail($to, $message, $subject=null, $from=null, $cc=null, $attachment=null, $name=null) {
    $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
    //Server settings
    $mail->SMTPDebug = 0;                                 

    // Get smtp settings if defined protocol
    if( get_option('email_settings') === "smtp")
    {
        $mail->isSMTP();
        $settings = json_decode(get_option('smtp_settings'), true);
        $mail->Host = $settings['smtp_host'];  // Specify main and backup SMTP servers
        $mail->SMTPAuth = true;                               // Enable SMTP authentication
        $mail->Username = $settings['smtp_user'];                 // SMTP username
        $mail->Password = $settings['smtp_pass'];                           // SMTP password
        $mail->SMTPSecure = $settings['smtp_crypto'];                            // Enable TLS encryption, `ssl` also accepted
        $mail->Port = $settings['smtp_port'];                                    // TCP port to connect to

        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );   
    } else {
        $mail->isSendmail();
    }

    try {
        //Recipients
        $mail->setFrom(isset($from) ? $from : get_option('email'), null == get_option('company') ? get_option('email') : get_option('company'));
        $mail->addAddress($to);     // Add a recipient
        $mail->addReplyTo(isset($from) ? $from : get_option('email'), null == get_option('company') ? get_option('email') : get_option('company'));

        if(isset($cc) && is_array($cc))
        {
            foreach ($cc as $cc_email) {
                $mail->addBCC($cc_email);
            }
        }
        if(isset($cc) && ! is_array($cc))
        {
            $mail->addCC(isset($cc) ? $cc : get_option('notifications_email'));
            if (null != get_option('notifications_email2')) {
                $mail->addCC(get_option('notifications_email2'));
            } 
        }

        //Attachments
        if($attachment) {
            is_array($attachment) OR $attachment = array($attachment);
            for ($i=0; $i < count($attachment); $i++) { 
                $mail->addAttachment($attachment[$i]); 
            }
        }
        //Content
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = isset($subject) ? $subject : __('no_subject');
        $mail->Body    = $message;
        $mail->AltBody = $message;

        $mail->send();
        return true;
    } catch (Exception $e) {
        log_message('error', 'Message could not be sent. Mailer Error: ', $mail->ErrorInfo);
    }
}
