<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use Mmanager\Adapter\Zend\BarcodeAdapter as Barcode;
use Mmanager\SmsService;
use PhpRbac\Rbac;
use Mmanager\Utils\UserAgent;
use Mmanager\Template as Template;

if ( ! function_exists('logged_in'))
{
	/**
	 * Check if user has active session
	 * @return bool
	 */
	function logged_in()
	{
		$CI = & get_instance();
		$CI->ion_auth_model->trigger_events('logged_in');
		$_SESSION['url'] = $_SERVER['REQUEST_URI'];
		return (bool) $CI->session->userdata('identity');
	}
}
if ( ! function_exists('client_logged_in'))
{
	/**
	 * Check if client has active session
	 * @return bool
	 */
	function client_logged_in()
	{
		$CI = & get_instance();
		$_SESSION['client_url'] = $_SERVER['REQUEST_URI'];
		return (bool) $CI->session->userdata('client_logged_in');
	}
}

// ------------------------------------------------------------------------

if ( ! function_exists('is_admin'))
{
	function is_admin($id = false)
	{
		$CI = & get_instance();
		$CI->ion_auth_model->trigger_events('is_admin');
		$admin_group = $CI->config->item('admin_group', 'ion_auth');
		return $CI->ion_auth->in_group($admin_group, $id);
	}
}

// ------------------------------------------------------------------------

if ( ! function_exists('user'))
{
	function user($key, $default = NULL)
	{
		$CI = & get_instance();
		if ( ! $CI->session->userdata('user_id'))
		{
			$user = $CI->ion_auth->user(1)->row();
		}
		else
		{
			$user = $CI->ion_auth->user()->row();
		}
		if ($user && $key !== 'address')
		{
			$return = null !== $user->{$key} ? $user->{$key}: $default;
		}
		else
		{
			$return  = array(
				'user_address1' => $user->user_address1,
				'user_address2' => $user->user_address2,
				'user_city' => $user->user_city,
				'user_postcode' => $user->user_postcode,
				'user_state' => $user->user_state,
				'user_country' => $user->user_country
				);
		}
		return $return;
	}
}

// ------------------------------------------------------------------------

if ( ! function_exists('delete'))
{
	function delete($table, $primary_key, $ids)
	{
		global $db;

		$CI = & get_instance();

		is_array($ids) OR $ids = array($ids);

		foreach ($ids as $id) 
		{
			if ($table !== 'invoices_items' || 
				$table !== 'purchases_items' || 
				$table !== 'quotes_items' || 
				$table !== 'payment_methods' || 
				$table !== 'orders_items')
			{
				$event = array(
					'action' 					=> 'delete',
					'referrer' 					=> $table,
					'referrer_id' 				=> $id,
					'referrer_value' 			=> get_name_var($table, $id),
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
			}
			$query = "DELETE FROM {$db->tables[$table]} WHERE {$primary_key} = {$id}";
			$db->query($query);
		}
		return $CI->db->affected_rows();
	}
}

// ------------------------------------------------------------------------
if ( ! function_exists('mass_approved')) {
	function mass_approved($ids, $context=null)
	{
		global $db;
		$CI = & get_instance();

		is_array($ids) OR $ids = array($ids);
		if ($ids) {
			foreach ($ids as $id) {
				update_quote_status($id, 'Accepted');
				$CI->m_manager->send_quote_email($id, $context);
				$CI->m_manager->from_quote_to_invoice($id, $context);
			}
		}
		return $CI->db->affected_rows();
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('mass_generate_invoices')) {
	function mass_generate_invoices($ids)
	{
		global $db;
		$CI = & get_instance();

		is_array($ids) OR $ids = array($ids);
		if ($ids) {
			foreach ($ids as $id) {
				update_order_status($id, 'Billed');
				$CI->m_manager->send_invoice_email($id);
				$CI->m_manager->from_order_to_invoice($id);
			}
		}
		return $CI->db->affected_rows();
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('mass_approved_purchases')) {
	function mass_approved_purchases($ids)
	{
		global $db;
		$CI = & get_instance();

		is_array($ids) OR $ids = array($ids);

		if ($ids)
		{
			foreach ($ids as $id) {
				update_purchase_status($id, 'Accepted');
			}
		}
		return $CI->db->affected_rows();
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('client')) {
	function client($id = false, $var = false)
	{
		global $db;
		if ($id && !$var)
		{
			return $db->get_results("SELECT * FROM {$db->tables['clients']} WHERE client_id={$id} LIMIT 1");
		}
		elseif ($id && $var && $var !== 'address')
		{
			return $db->get_row("SELECT {$var} FROM {$db->tables['clients']} WHERE client_id={$id} LIMIT 1") ?
			$db->get_row("SELECT {$var} FROM {$db->tables['clients']} WHERE client_id={$id} LIMIT 1")->{$var} : false;
		}
		elseif ( $id && $var === 'address') 
		{
			$user = $db->get_row("SELECT client_address1, client_address2, client_city, client_state, client_postcode, client_country FROM {$db->tables['clients']} WHERE client_id={$id} LIMIT 1");
			return $user;
		}
		elseif ( $id && $var === 'client_currency') 
		{
			$currency = $db->get_row("SELECT client_currency FROM {$db->tables['clients']} WHERE client_id={$id} LIMIT 1");
			return null != $currency ? $currency: get_option('user_currency');
		}
		elseif( !$id && $var == 'client_language')
		{
			return get_option('default_language');
		}
		else
		{
			return array(
				'client_id'       => 0,
				'name_company'    => __('guest'),
				'client_address1' => '',
				'client_address2' => '',
				'client_postcode' => '',
				'client_city'     => '',
				'client_state'    => '',
				'client_country'  => ''
			);
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('provider')) {
	function provider($id = false, $var = false)
	{
		global $db;
		if ($id && !$var)
		{
			return $db->get_results("SELECT * FROM {$db->tables['providers']} WHERE provider_id={$id} LIMIT 1");
		}
		elseif ($id && $var && $var !== 'address' && $var !== 'contact')
		{
			return $db->get_row("SELECT {$var} FROM {$db->tables['providers']} WHERE provider_id={$id} LIMIT 1") ?
			$db->get_row("SELECT {$var} FROM {$db->tables['providers']} WHERE provider_id={$id} LIMIT 1")->{$var} : false;
		}
		elseif ( $id && $var === 'address') 
		{
			$results = $db->get_row("SELECT provider_address1, provider_address2, provider_city, provider_state, provider_postcode, provider_country FROM {$db->tables['providers']} WHERE provider_id={$id} LIMIT 1");
			return $results;
		}
		elseif ( $id && $var === 'contact') 
		{
			$results = $db->get_row("SELECT provider_id, provider_contact1 FROM {$db->tables['providers']} WHERE provider_id={$id} LIMIT 1");
			return $results;
		}
		else
		{
			return array(
				'provider_id'       => 0,
				'name_company'    	=> __('provider'),
				'provider_address1' => '',
				'provider_address2' => '',
				'provider_postcode' => '',
				'provider_city'     => '',
				'provider_state'    => '',
				'provider_country'  => ''
			);
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('clients')) {
	function clients($status = false)
	{
		global $db;

		$rbac = new Rbac;
		if ( $rbac->check('customer_owner', USERID) AND ! $rbac->check('customer_access_any', USERID)) {
			$where = ' WHERE user_id = '. USERID;
			$additional_where = ' AND user_id = '. USERID;
		} else {
			$where = '';
			$additional_where = '';
		}

		if (!$status)
		{
			return $db->get_results("SELECT * FROM {$db->tables['clients']} ORDER BY client_id DESC {$where} {$additional_where}");
		}
		else
		{
			return $db->get_results("SELECT * FROM {$db->tables['clients']} WHERE client_status={$status} {$additional_where} ORDER BY client_id");
		}
	}
}
if ( ! function_exists('get_clients')) {
	function get_clients($status, $order, $sort, $offset, $limit, $search = null)
	{
		global $db;

		$rbac = new Rbac;
		if ( $rbac->check('customer_owner', USERID) AND ! $rbac->check('customer_access_any', USERID)) {
			$where = ' WHERE user_id = '. USERID;
			$additional_where = ' AND user_id = '. USERID;
		} else {
			$where = '';
			$additional_where = '';
		}

		if (!$status && !$search)
		{
			return $db->get_results("SELECT * FROM {$db->tables['clients']} ORDER BY {$sort} {$order} LIMIT {$offset},{$limit} {$where} {$additional_where}");
		} elseif ($search && ! $status) {
			return $db->get_results("SELECT * FROM {$db->tables['clients']} WHERE name_company LIKE '%{$search}%' OR client_email LIKE '%{$search}%' OR client_phone LIKE '%{$search}%'");
		}
		else
		{
			return $db->get_results("SELECT * FROM {$db->tables['clients']} ORDER BY {$sort} {$order} LIMIT {$offset},{$limit} WHERE client_status={$status} {$additional_where}");
		}
	}
}
function count_clients_table()
{
	global $db;
	$query = "SELECT COUNT('client_id') AS total FROM oc_items";
	return intval($db->get_row($query)->total);
}
// ------------------------------------------------------------------------
if ( ! function_exists('providers')) {
	function providers($status = false)
	{
		global $db;
		if (!$status)
		{
			return $db->get_results("SELECT DISTINCT provider_id, name_company FROM {$db->tables['providers']}");
		}
		else
		{
			return $db->get_results("SELECT DISTINCT provider_id, name_company FROM {$db->tables['providers']} WHERE provider_status={$status}");
		}
	}
}
// ------------------------------------------------------------------------

function get_providers($status=false)
{
	global $db;
	if ( ! $status) {
		return $db->get_results("SELECT DISTINCT * FROM {$db->tables['providers']}");
	} else {
		return $db->get_results("SELECT DISTINCT * FROM {$db->tables['providers']} WHERE provider_status=1");
	}
}
// ------------------------------------------------------------------------
function get_notes($referrer_id = false)
{
	global $db;
	if (!$referrer_id)
	{
		return $db->get_results("SELECT * FROM {$db->tables['notes']} ORDER BY note_id DESC");
	}
	else
	{
		return $db->get_results("SELECT * FROM {$db->tables['notes']} WHERE note_referrer_id={$referrer_id} ORDER BY note_id DESC");
	}
}
// ------------------------------------------------------------------------
function get_option($option_name, $table_name = false)
{
	if (!$table_name)
	{
		global $db;
		$options = get_options();
		foreach ($options as $option) {
			if ($option->option_name === $option_name)
			{
				return $option->option_value;
			}
		}
	}
	else if ($table_name && $table_name !== 'users')
	{
		global $db;
		$user_id = user('user_id');
		$options = $db->get_results("SELECT * FROM {$db->tables[$table_name]} WHERE user_id={$user_id}");
		if ($options)
		{
			foreach ($options as $option) {
				if ($option->option_key === $option_name)
				{
					return $option->option_value;
				}
			}
		}
	}
	else
	{
		return false;
	}
}
// ------------------------------------------------------------------------
/**
 * is_ajax_request()
 * Check if the request is an ajax request
 * @return type
 */
function is_ajax_request()
{
	$CI = & get_instance();
	if (!$CI->input->is_ajax_request())
	{
		return show_error(__('not_ajax_request'));
	}
	else
	{
		return true;
	}
}
// ------------------------------------------------------------------------
function get_next_id($table_key)
{
	global $db;
	$CI = & get_instance();
    return (int) $CI->db->select('AUTO_INCREMENT')
        ->from('information_schema.TABLES')
        ->where('TABLE_NAME', $db->tables[$table_key])
        ->where('TABLE_SCHEMA', $CI->db->database)->get()->row()->AUTO_INCREMENT;
}
// ------------------------------------------------------------------------
function get_last_id($table_key)
{
	$next_id = get_next_id($table_key);
	return $next_id - 1;
}
// ------------------------------------------------------------------------
function next_purchase_order_number()
{
	return get_next_id('purchases');
}
// ------------------------------------------------------------------------
function next_sale_order_number()
{
	return get_next_id('orders');
}
// ------------------------------------------------------------------------
function next_quote_number()
{
	return get_next_id('quotes');
}
// ------------------------------------------------------------------------
function is_up_to_date()
{
	return (version_compare(get_option('stable_version'), user('app_version'), '>')) ? false : TRUE;
}
// ------------------------------------------------------------------------
function language_meta()
{
	$lang_meta = [];
	$lang = get_option('user_language', 'users_options');
	switch ($lang) {
		case 'french':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/fr.gif');
			$lang_meta['lang_name'] = 'FR';
			break;
		case 'dutch':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/nl.gif');
			$lang_meta['lang_name'] = 'DU';
			break;
		case 'english':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/us.gif');
			$lang_meta['lang_name'] = 'US';
			break;
		case 'swedish':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/se.gif');
			$lang_meta['lang_name'] = 'SV';
			break;
		case 'english-gb':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/gb.gif');
			$lang_meta['lang_name'] = 'EN-GB';
			break;
		case 'italian':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/it.gif');
			$lang_meta['lang_name'] = 'IT';
			break;
		case 'spanish':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/es.gif');
			$lang_meta['lang_name'] = 'ES';
			break;
		case 'german':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/de.gif');
			$lang_meta['lang_name'] = 'DE';
			break;
		case 'romanian':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/ro.gif');
			$lang_meta['lang_name'] = 'RO';
			break;
		case 'russian':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/ru.gif');
			$lang_meta['lang_name'] = 'RU';
			break;
		case 'greek':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/gr.gif');
			$lang_meta['lang_name'] = 'EL';
			break;
		case 'arabic':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/sa.gif');
			$lang_meta['lang_name'] = 'AR';
			break;
		default:
			$lang_meta['flag_url'] = __common('assets/global/img/flags/us.gif');
			$lang_meta['lang_name'] = 'US';
			break;
	}
	return $lang_meta;
}
// ------------------------------------------------------------------------
function client_language_meta($client_id)
{
	$lang_meta = [];
	$lang = client($client_id, 'client_language');
	switch ($lang) {
		case 'fr_FR':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/fr.gif');
			$lang_meta['lang_name'] = 'FR';
			break;
		case 'nl_NL':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/nl.gif');
			$lang_meta['lang_name'] = 'DU';
			break;
		case 'en_US':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/us.gif');
			$lang_meta['lang_name'] = 'US';
			break;
		case 'sv_SE':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/se.gif');
			$lang_meta['lang_name'] = 'SV';
			break;
		case 'en_GB':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/gb.gif');
			$lang_meta['lang_name'] = 'EN-GB';
			break;
		case 'it_IT':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/it.gif');
			$lang_meta['lang_name'] = 'IT';
			break;
		case 'es_ES':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/es.gif');
			$lang_meta['lang_name'] = 'ES';
			break;
		case 'de_DE':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/de.gif');
			$lang_meta['lang_name'] = 'DE';
			break;
		case 'ro':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/ro.gif');
			$lang_meta['lang_name'] = 'RO';
			break;
		case 'ru_RU':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/ru.gif');
			$lang_meta['lang_name'] = 'RU';
			break;
		case 'ar_AR':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/sa.gif');
			$lang_meta['lang_name'] = 'AR';
			break;
		case 'el_EL':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/gr.gif');
			$lang_meta['lang_name'] = 'EL';
			break;
		default:
			$lang_meta['flag_url'] = __common('assets/global/img/flags/us.gif');
			$lang_meta['lang_name'] = 'US';
			break;
	}
	return $lang_meta;
}
// ------------------------------------------------------------------------
function provider_language_meta($provider_id)
{
	$lang_meta = [];
	$lang = provider($provider_id, 'provider_language');
	switch ($lang) {
		case 'fr_FR':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/fr.gif');
			$lang_meta['lang_name'] = 'FR';
			break;
		case 'nl_NL':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/nl.gif');
			$lang_meta['lang_name'] = 'DU';
			break;
		case 'en_US':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/us.gif');
			$lang_meta['lang_name'] = 'US';
			break;
		case 'sv_SE':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/se.gif');
			$lang_meta['lang_name'] = 'SV';
			break;
		case 'en_GB':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/gb.gif');
			$lang_meta['lang_name'] = 'EN-GB';
			break;
		case 'it_IT':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/it.gif');
			$lang_meta['lang_name'] = 'IT';
			break;
		case 'es_ES':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/es.gif');
			$lang_meta['lang_name'] = 'ES';
			break;
		case 'de_DE':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/de.gif');
			$lang_meta['lang_name'] = 'DE';
			break;
		case 'ro':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/ro.gif');
			$lang_meta['lang_name'] = 'RO';
			break;
		case 'ru_RU':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/ru.gif');
			$lang_meta['lang_name'] = 'RU';
			break;
		case 'ar_AR':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/sa.gif');
			$lang_meta['lang_name'] = 'AR';
			break;
		case 'el_EL':
			$lang_meta['flag_url'] = __common('assets/global/img/flags/gr.gif');
			$lang_meta['lang_name'] = 'EL';
			break;
		default:
			$lang_meta['flag_url'] = __common('assets/global/img/flags/us.gif');
			$lang_meta['lang_name'] = 'US';
			break;
	}
	return $lang_meta;
}
// ------------------------------------------------------------------------
function get_invoice_by_number($invoice_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['invoices']}
	WHERE invoice_number = {$invoice_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_order_by_number($order_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['orders']}
	WHERE order_number = {$order_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_order_var($order_number, $var)
{
	global $db;
	return $db->get_row("SELECT {$var} FROM {$db->tables['orders']} WHERE order_number={$order_number}") ?
	$db->get_row("SELECT {$var} FROM {$db->tables['orders']} WHERE order_number={$order_number}")->$var : "";
}
// ------------------------------------------------------------------------
function get_purchase_by_number($purchase_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['purchases']} I 
	LEFT JOIN {$db->tables['providers']} C ON I.provider_id = C.provider_id 
	WHERE purchase_number = {$purchase_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_quote_by_number($quote_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['quotes']} WHERE quote_number = {$quote_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_invoiced_items($invoice_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['invoices_items']} WHERE invoice_number = {$invoice_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_sale_items($order_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['orders_items']} WHERE order_number = {$order_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_sale_picked_items($order_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['orders_items']} WHERE picked = 1 AND order_number = {$order_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_purchased_items($purchase_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['purchases_items']} WHERE purchase_number = {$purchase_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_quoted_items($quote_number)
{
	global $db;
	$query = "SELECT * FROM {$db->tables['quotes_items']} WHERE quote_number = {$quote_number}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function count_total_rows($table) {
	global $db;
	return $db->get_row("SELECT COUNT(*) as row FROM {$table}")->row;
}
function get_invoices($status = false)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	global $db;
	$status = !isset($status) ? 'All' : $status;
	switch ($status) {
		case 'Paid':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE invoice_status = 'Paid'
				{$additional_where}
				OR amount_paid > 0
				AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				ORDER BY id DESC";
			break;
		case 'Unpaid':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE invoice_status = 'Unpaid'
				{$additional_where}
				ORDER BY id DESC";
			break;
		case 'Overdue':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE invoice_status = 'Overdue'
				{$additional_where}
				ORDER BY id DESC";
			break;
		case 'Cancelled':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE invoice_status = 'Cancelled'
				{$additional_where}
				ORDER BY id DESC";
			break;
		case 'Refunded':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE invoice_status = 'Refunded'
				{$additional_where}
				ORDER BY id DESC";
			break;
		
		default:
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE invoice_status <> 'Refunded'
				{$additional_where}
				ORDER BY id DESC";
			break;
	}
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_sales($status = false)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	global $db;
	$status = !isset($status) ? 'All' : $status;
	switch ($status) {
		case 'Paid':
			$query = "SELECT * 
				FROM {$db->tables['orders']}
				WHERE order_status = 'Paid'
				{$additional_where}
				OR amount_paid > 0
				AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				ORDER BY id DESC";
			break;
		case 'Unpaid':
			$query = "SELECT * 
				FROM {$db->tables['orders']}
				WHERE order_status = 'Unpaid'
				{$additional_where}
				ORDER BY id DESC";
			break;
		case 'Overdue':
			$query = "SELECT * 
				FROM {$db->tables['orders']}
				WHERE order_status = 'Overdue'
				{$additional_where}
				ORDER BY id DESC";
			break;
		case 'Cancelled':
			$query = "SELECT * 
				FROM {$db->tables['orders']}
				WHERE order_status = 'Cancelled'
				{$additional_where}
				ORDER BY id DESC";
			break;
		case 'Refunded':
			$query = "SELECT * 
				FROM {$db->tables['orders']}
				WHERE order_status = 'Refunded'
				{$additional_where}
				ORDER BY id DESC";
			break;
		
		default:
			$query = "SELECT * 
				FROM {$db->tables['orders']}
				WHERE order_status <> 'Refunded'
				{$additional_where}
				ORDER BY id DESC";
			break;
	}
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_purchase_orders($status = false)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
		$additional_unique_where = ' WHERE user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$status = !isset($status) ? 'All' : $status;
	switch ($status) {
		case 'Paid':
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE I.purchase_status = 'Paid'
				OR I.amount_paid > 0
				AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP) {$additional_where}
				ORDER BY I.id DESC";
			break;
		case 'Unpaid':
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE I.purchase_status = 'Unpaid' {$additional_where}
				ORDER BY I.id DESC";
			break;
		case 'Overdue':
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE I.purchase_status = 'Overdue' {$additional_where}
				ORDER BY I.id DESC";
			break;
		case 'Cancelled':
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE I.purchase_status = 'Cancelled' {$additional_where}
				ORDER BY I.id DESC";
			break;
		case 'Refunded':
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE I.purchase_status = 'Refunded' {$additional_where}
				ORDER BY I.id DESC";
			break;
		
		default:
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id {$additional_where}
				ORDER BY I.id DESC";
			break;
	}
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_quotes($status = false, $id = null)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$where = ' WHERE user_id = '. USERID;
		$additional_where = ' AND user_id = '. USERID;
		$client_where = isset($id) ? ' AND client_id = '.$id : '';
	} else {
		$where = '';
		$additional_where = '';
		$client_where = isset($id) ? ' WHERE client_id = '.$id : '';
	}
	$status = !isset($status) ? 'All' : $status;
	switch ($status) {
		case 'Accepted':
			$query = "SELECT * 
				FROM {$db->tables['quotes']}
				WHERE quote_status = 'Accepted'
				AND MONTH(accepted_on) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(accepted_on) = YEAR(CURRENT_TIMESTAMP) {$additional_where} {$client_where}
				ORDER BY id DESC";
			break;
		case 'Declined':
			$query = "SELECT * 
				FROM {$db->tables['quotes']}
				WHERE quote_status = 'Declined' {$additional_where} {$client_where}
				ORDER BY id DESC";
			break;
		case 'Pending':
			$query = "SELECT * 
				FROM {$db->tables['quotes']}
				WHERE quote_status = 'Pending' {$additional_where} {$client_where}
				ORDER BY id DESC";
			break;
		case 'Cancelled':
			$query = "SELECT * 
				FROM {$db->tables['quotes']}
				WHERE quote_status = 'Cancelled' {$additional_where} {$client_where}
				ORDER BY id DESC";
			break;
		default:
			$query = "SELECT * 
				FROM {$db->tables['quotes']}
				{$where} {$client_where}
				ORDER BY id DESC";
			break;
	}
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function invoice_status($invoice_number)
{
	global $db;
	$result= $db->get_row("SELECT invoice_status FROM {$db->tables['invoices']} WHERE invoice_number={$invoice_number}")->invoice_status;
	$status = ucfirst($result);
	switch ($status) {
		case 'Paid':
			return 'is_paid';
			break;
		case 'Unpaid':
			return 'is_unpaid';
			break;
		case 'Cancelled':
			return 'is_cancelled';
			break;
		case 'Overdue':
			return 'is_overdue';
			break;
		case 'Draft':
			return 'is_draft';
			break;
		case 'Refunded':
			return 'is_refunded';
			break;
		case 'Open':
			return 'is_opened';
			break;
		case 'Pending':
			return 'is_pending';
			break;
		case 'Failed':
			return 'is_failed';
			break;
		case 'Expired':
			return 'is_expired';
			break;
		case 'Paidout':
			return 'is_paidout';
			break;
		case 'Charged_back':
			return 'is_chargeback';
			break;
	}
}
// ------------------------------------------------------------------------
function order_status($order_number)
{
	global $db;
	$result= $db->get_row("SELECT order_status FROM {$db->tables['orders']} WHERE order_number={$order_number}")->order_status;
	$status = ucfirst($result);
	switch ($status) {
		case 'Pending':
			return 'is_pending';
			break;
		case 'Progress':
			return 'is_inprogress';
			break;
		case 'Awaiting Payment':
			return 'is_awaiting_payment';
			break;
		case 'Awaiting Fulfillment':
			return 'is_awaiting_fulfillment';
			break;
		case 'Awaiting Shipment':
			return 'is_awaiting_shipment';
			break;
		case 'Awaiting Pickup':
			return 'is_awaiting_pickup';
			break;
		case 'Partially Shipped':
			return 'is_partially_shipped';
			break;
		case 'Completed':
			return 'is_completed';
			break;
		case 'Shipped':
			return 'is_shipped';
			break;
		case 'Billed':
			return 'is_billed';
			break;
		case 'Refunded':
			return 'is_refunded';
			break;
		case 'Cancelled':
			return 'is_cancelled';
			break;
		case 'Declined':
			return 'is_declined';
			break;
		case 'Disputed':
			return 'is_disputed';
			break;
		case 'Manual Verification Required':
			return 'manual_verification_required';
			break;
		case 'Partially Refunded':
			return 'is_partially_refunded';
			break;
		default:
			return 'is_pending';
	}
}
// ------------------------------------------------------------------------
function purchase_status($purchase_number)
{
	global $db;
	$result= $db->get_row("SELECT purchase_status FROM {$db->tables['purchases']} WHERE purchase_number={$purchase_number}")->purchase_status;
	$status = ucfirst($result);
	switch ($status) {
		case 'Accepted':
			return 'is_accepted';
			break;
		case 'Paid':
			return 'is_paid';
			break;
		case 'Declined':
			return 'is_declined';
			break;
		case 'Cancelled':
			return 'is_cancelled';
			break;
		case 'Pending':
			return 'is_pending';
			break;
		case 'In Progress':
			return 'is_in_progress';
			break;
		case 'Is sent':
			return 'is_sent';
			break;
		case 'Draft':
			return 'is_draft';
			break;
		default:
			return 'is_draft';
			break;
	}
}
// ------------------------------------------------------------------------
function quote_status($quote_number)
{
	global $db;
	$status = $db->get_row("SELECT quote_status FROM {$db->tables['quotes']} WHERE quote_number={$quote_number}") ?
	$db->get_row("SELECT quote_status FROM {$db->tables['quotes']} WHERE quote_number={$quote_number}")->quote_status : 'Draft';
	switch ($status) {
		case 'Accepted':
			return 'is_accepted';
			break;
		case 'Declined':
			return 'is_declined';
			break;
		case 'Cancelled':
			return 'is_cancelled';
			break;
		case 'Pending':
			return 'is_pending';
			break;
		case 'Draft':
			return 'is_draft';
			break;
	}
}
// ------------------------------------------------------------------------
function can_delete_charges($id)
{
	global $db;
	return null !== $db->get_row("SELECT invoice_number FROM {$db->tables['transactions']} WHERE transaction_id={$id}")->invoice_number;
}
// ------------------------------------------------------------------------
function format_number($number)
{
    $number_format = get_option('number_format');
    
    switch ($number_format) {
        case 1:
            return number_format($number, 2, '.', ',');
            break; 
        case 2:
            return number_format($number, 2, ',', '.');
            break; 
        case 3:
            return number_format($number, 2, '.', ' ');
            break; 
        case 4:
            return number_format($number, 2, ',', ' ');
            break;
        case 5:
            return number_format($number, 0, '', '.');
            break;
        case 6:
            return number_format($number, 0, '', ' ');
            break;
        default:
            return number_format($number, 2, ',', ' ');
            break;
    }
}
// ------------------------------------------------------------------------
function is_empty_table($table_index)
{
	global $db;
	return $db->get_row("SELECT COUNT(*) AS rows FROM {$db->tables[$table_index]}")->rows == 0;
}
// ------------------------------------------------------------------------
function add_credit($client_id, $value)
{
	global $db;
	$query = "UPDATE {$db->tables['clients']}
					SET " . $db->get_set(array('client_credit' => $value)) . 
					" WHERE client_id = {$client_id}";
	return $db->query($query);
}
// ------------------------------------------------------------------------
function refund($client_id, $value)
{
	global $db;
	$credit = get_credit($client_id);
	$new_credit = $credit + $value;
	$query = "UPDATE {$db->tables['clients']}
					SET " . $db->get_set(array('client_credit' => $new_credit)) . 
					" WHERE client_id = {$client_id}";
	return $db->query($query);
}
// ------------------------------------------------------------------------
function remove_credit($client_id, $value)
{
	if($client_id > 0)
	{
		$client_credit = floatval(get_credit($client_id));
		if ($client_credit > 0 )
		{
			$client_credit -= floatval($value);
			return add_credit($client_id, $client_credit);
		}
		else
		{
			return 0;
		}
	}
}
// ------------------------------------------------------------------------
function get_credit($client_id)
{
	global $db;
	$query = "SELECT client_credit FROM {$db->tables['clients']} WHERE client_id = '{$client_id}'";
	return $db->get_row($query) ? $db->get_row($query)->client_credit : '0';
}
// ------------------------------------------------------------------------
function get_support($client_id)
{
	global $db;
	$query = "SELECT support_contract FROM {$db->tables['clients']} WHERE client_id = '{$client_id}'";
	return $db->get_row($query) ? $db->get_row($query)->support_contract : '0';
}
// ------------------------------------------------------------------------
function get_testers()
{
	global $db;
	return $db->get_results("SELECT first_name, email FROM {$db->tables['users']}");
}
// ------------------------------------------------------------------------
function __short_month_year($date_string)
{
	$month = date('M', strtotime($date_string));
	return __($month) . ' ' . date('Y');
}
// ------------------------------------------------------------------------
function app_unstable_version()
{
	global $db;
	return $db->get_row("SELECT option_value FROM {$db->tables['options']} WHERE option_name = 'unstable_version'") ?
	$db->get_row("SELECT option_value FROM {$db->tables['options']} WHERE option_name = 'unstable_version'")->option_value : false;
}
// ------------------------------------------------------------------------
function app_stable_version()
{
	global $db;
	return $db->get_row("SELECT option_value FROM {$db->tables['options']} WHERE option_name = 'stable_version'") ?
	$db->get_row("SELECT option_value FROM {$db->tables['options']} WHERE option_name = 'stable_version'")->option_value : "";
}
// ------------------------------------------------------------------------
function user_app_version()
{
	$CI = & get_instance();
	$user_id = $CI->session->userdata('user_id');
	global $db;
	if ($user_id)
		return $db->get_row("SELECT app_version FROM {$db->tables['users']} WHERE id = {$user_id}")->app_version;
	return app_stable_version();
}
// ------------------------------------------------------------------------
function batch_user_app_version_update()
{
	global $db;
	$stable_version = app_stable_version();
	$users = $db->get_results("SELECT id, app_version FROM {$db->tables['users']}");
	foreach ($users as $user) {
		if ($user->app_version !== $stable_version)
		{
			$query = "UPDATE {$db->tables['users']}
								SET " . $db->get_set(array('app_version' => $stable_version)) . 
								" WHERE id = " .$user->id;
			$db->query($query);
		}
	}
}
// ------------------------------------------------------------------------
/**
 * A short function to display css file link
 * @param type $file 
 * @return type
 */
function __css($file)
{
	$theme = null == get_option('theme') ? 'default' : get_option('theme'); 
	return base_url('themes/').$theme.$file;
}
// ------------------------------------------------------------------------
/**
 * A short function to display css file link
 * @param type $file 
 * @return type
 */
function __img($file)
{
	$theme = null == get_option('theme') ? 'default' : get_option('theme'); 
	return base_url('themes/').$theme.$file;
}
// ------------------------------------------------------------------------
/**
 * A short function to display js file link
 * @param type $file 
 * @return type
 */
function __js($file)
{
	$theme = null == get_option('theme') ? 'default' : get_option('theme');
	return base_url('themes/').$theme.$file;
}
function __common($file)
{
	$theme_name = null == get_option('theme_name') ? 'darkblue' : get_option('theme_name'); 
	return base_url('themes/').$theme_name.'/common/'.$file;
}
// ------------------------------------------------------------------------
/**
 * Deprecated Used to truncate tables.
 * @return type void
 */
function reset_app()
{
	return array(
		'clients' => truncate("clients"),
		'items' => truncate("items"),
		'items groups' => truncate("items_groups"),
		'taxes' => truncate("taxes"),
		'transactions' => truncate("transactions"),
		'invoices' => truncate("invoices"),
		'quotes' => truncate("quotes"),
		'user options' => truncate("users_options"),		
		'quoted items' => truncate("quotes_items")
	);
}
// ------------------------------------------------------------------------
/**
 * Truncate a table without constraint
 * @param type $table 
 * @return type void
 */
function truncate($table)
{
	global $db;
	$CI = & get_instance();
	return $CI->db->truncate($db->tables[$table]);
}
// ------------------------------------------------------------------------
/**
 * Print a formated string
 * @param type $format 
 * @param type $arr 
 * @return type
 */
function printf_array($format, $arr) 
{ 
    return call_user_func_array('printf', array_merge((array)$format, $arr)); 
}
// ------------------------------------------------------------------------
/**
 * Display copyright
 * @return type string
 */
function copyright_info()
{
	$link = '<a href="https://www.onericcomputing.com">';
	$link .= " by On'Eric Computing</a>";

	return "<em> 2015 - " . date('Y') . " &copy; m'Manager v." . ONERIC_VERSION . $link . "</em>";
}
// ------------------------------------------------------------------------
/**
 * Try to get the browser language
 * @return type string
 */
function get_browser_language()
{
	if (!isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
	{
		$browser_lang = "fr";
	}
	else
	{
		$browser_lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
	}
	switch ($browser_lang)
	{
		case "fr":
			$lang = "french";
			break;
		case "us":
			$lang = "english";
			break;
		case "en-GB":
			$lang = "english-gb";
			break;
		case "de":
			$lang = "german";
			break;
		case "es":
			$lang = "spanish";
			break;
		case "ro":
			$lang = "romanian";
			break;
		case "ru":
			$lang = "russian";
			break;
		case "nl":
			$lang = "dutch";
			break;
		case "ar":
			$lang = "arabic";
			break;
		case "el":
			$lang = "greek";
			break;
		case "it":
			$lang = "italian";
			break;
		default:
			$lang = "english";
	}
	return $lang;
}
// ------------------------------------------------------------------------
/**
 * Get the timezone
 * @return type array
 */
function get_timezone()
{
	$zones = timezone_identifiers_list();
	foreach ($zones as $zone){
		$zone = explode('/', $zone); // 0 => Continent, 1 => City
	
		// Only use "friendly" continent names
		if ($zone[0] == 'Africa' || $zone[0] == 'America' || $zone[0] == 'Antarctica' || $zone[0] == 'Arctic' || $zone[0] == 'Asia' || $zone[0] == 'Atlantic' || $zone[0] == 'Australia' || $zone[0] == 'Europe' || $zone[0] == 'Indian' || $zone[0] == 'Pacific')
		{
			if (isset($zone[1]) != '')
			{
				$locations[$zone[0]][$zone[0]. '/' . $zone[1]] = str_replace('_', ' ', $zone[1]); // Creates array(DateTimeZone => 'Friendly name')
			}
		}
		return $zones;
	}
}
// ------------------------------------------------------------------------
/**
 * Get the currencies list
 * @param type|null $k 
 * @param type|null $field 
 * @return type mixed
 */
function get_currencies($k=null, $field=null)
{
	$currencies = array(
		'AED'=>array('key' => 'AED', 'name' => 'United Arab Emirates Dirham', 'symbol'=>'د.إ', 'hex'=>'&#x62f;&#x2e;&#x625;'),
		'ANG'=>array('key' => 'ANG', 'name' => 'NL Antillian Guilder', 'symbol'=>'ƒ', 'hex'=>'&#x192;'),
		'AUD'=>array('key' => 'AUD', 'name' => 'Australian Dollar', 'symbol'=>'A$', 'hex'=>'&#x41;&#x24;'),
		'BRL'=>array('key' => 'BRL', 'name' => 'Brazilian Real', 'symbol'=>'R$', 'hex'=>'&#x52;&#x24;'),
		'BSD'=>array('key' => 'BSD', 'name' => 'Bahamian Dollar', 'symbol'=>'B$', 'hex'=>'&#x42;&#x24;'),
		'CAD'=>array('key' => 'CAD', 'name' => 'Canadian Dollar', 'symbol'=>'$', 'hex'=>'&#x24;'),
		'CHF'=>array('key' => 'CHF', 'name' => 'Swiss Franc', 'symbol'=>'CHF', 'hex'=>'&#x43;&#x48;&#x46;'),
		'CNY'=>array('key' => 'CNY', 'name' => 'Chinese Yuan Renminbi', 'symbol'=>'¥', 'hex'=>'&#xa5;'),
		'COP'=>array('key' => 'COP', 'name' => 'Colombian Peso', 'symbol'=>'$', 'hex'=>'&#x24;'),
		'CZK'=>array('key' => 'CZK', 'name' => 'Czech Koruna', 'symbol'=>'Kč', 'hex'=>'&#x4b;&#x10d;'),
		'DKK'=>array('key' => 'DKK', 'name' => 'Danish Krone', 'symbol'=>'kr', 'hex'=>'&#x6b;&#x72;'),
		'DOP'=>array('key' => 'DOP', 'name' => 'Dominican Peso', 'symbol'=>'RD$', 'hex'=>'RD&#x24;'),
		'EUR'=>array('key' => 'EUR', 'name' => 'Euro', 'symbol'=>'€', 'hex'=>'&#x20ac;'),
		'FJD'=>array('key' => 'FJD', 'name' => 'Fiji Dollar', 'symbol'=>'FJ$', 'hex'=>'&#x46;&#x4a;&#x24;'),
		'GBP'=>array('key' => 'GBP', 'name' => 'British Pound', 'symbol'=>'£', 'hex'=>'&#xa3;'),
		'GHS'=>array('key' => 'GHS', 'name' => 'Ghanaian New Cedi', 'symbol'=>'GH₵', 'hex'=>'&#x47;&#x48;&#x20b5;'),
		'GTQ'=>array('key' => 'GTQ', 'name' => 'Guatemalan Quetzal', 'symbol'=>'Q', 'hex'=>'&#x51;'),
		'HNL'=>array('key' => 'HNL', 'name' => 'Honduran Lempira', 'symbol'=>'L', 'hex'=>'&#x4c;'),
		'HRK'=>array('key' => 'HRK', 'name' => 'Croatian Kuna', 'symbol'=>'kn', 'hex'=>'&#x6b;&#x6e;'),
		'HUF'=>array('key' => 'HUF', 'name' => 'Hungarian Forint', 'symbol'=>'Ft', 'hex'=>'&#x46;&#x74;'),
		'IDR'=>array('key' => 'IDR', 'name' => 'Indonesian Rupiah', 'symbol'=>'Rp', 'hex'=>'&#x52;&#x70;'),
		'ILS'=>array('key' => 'ILS', 'name' => 'Israeli New Shekel', 'symbol'=>'₪', 'hex'=>'&#x20aa;'),
		'INR'=>array('key' => 'INR', 'name' => 'Indian Rupee', 'symbol'=>'₹', 'hex'=>'&#x20b9;'),
		'IQD'=>array('key' => 'IQD', 'name' => 'Iraqi Dinar', 'symbol'=>'د.ع', 'hex'=>''),
		'ISK'=>array('key' => 'ISK', 'name' => 'Iceland Krona', 'symbol'=>'kr', 'hex'=>'&#x6b;&#x72;'),
		'JMD'=>array('key' => 'JMD', 'name' => 'Jamaican Dollar', 'symbol'=>'J$', 'hex'=>'&#x4a;&#x24;'),
		'JPY'=>array('key' => 'JPY', 'name' => 'Japanese Yen', 'symbol'=>'¥', 'hex'=>'&#xa5;'),
		'KRW'=>array('key' => 'KRW', 'name' => 'South-Korean Won', 'symbol'=>'₩', 'hex'=>'&#x20a9;'),
		'LKR'=>array('key' => 'LKR', 'name' => 'Sri Lanka Rupee', 'symbol'=>'₨', 'hex'=>'&#x20a8;'),
		'MAD'=>array('key' => 'MAD', 'name' => 'Moroccan Dirham', 'symbol'=>'.د.م', 'hex'=>'&#x2e;&#x62f;&#x2e;&#x645;'),
		'MMK'=>array('key' => 'MMK', 'name' => 'Myanmar Kyat', 'symbol'=>'K', 'hex'=>'&#x4b;'),
		'MYR'=>array('key' => 'MYR', 'name' => 'Malaysian Ringgit', 'symbol'=>'RM', 'hex'=>'&#x52;&#x4d;'),
		'NOK'=>array('key' => 'NOK', 'name' => 'Norwegian Kroner', 'symbol'=>'kr', 'hex'=>'&#x6b;&#x72;'),
		'PAB'=>array('key' => 'PAB', 'name' => 'Panamanian Balboa', 'symbol'=>'B/.', 'hex'=>'&#x42;&#x2f;&#x2e;'),
		'PEN'=>array('key' => 'PEN', 'name' => 'Peruvian Nuevo Sol', 'symbol'=>'S/.', 'hex'=>'&#x53;&#x2f;&#x2e;'),
		'PHP'=>array('key' => 'PHP', 'name' => 'Philippine Peso', 'symbol'=>'₱', 'hex'=>'&#x20b1;'),
		'PKR'=>array('key' => 'PKR', 'name' => 'Pakistan Rupee', 'symbol'=>'₨', 'hex'=>'&#x20a8;'),
		'PLN'=>array('key' => 'PLN', 'name' => 'Polish Zloty', 'symbol'=>'zł', 'hex'=>'&#x7a;&#x142;'),
		'RON'=>array('key' => 'RON', 'name' => 'Romanian New Lei', 'symbol'=>'lei', 'hex'=>'&#x6c;&#x65;&#x69;'),
		'RSD'=>array('key' => 'RSD', 'name' => 'Serbian Dinar', 'symbol'=>'RSD', 'hex'=>'&#x52;&#x53;&#x44;'),
		'RUB'=>array('key' => 'RUB', 'name' => 'Russian Rouble', 'symbol'=>'руб', 'hex'=>'&#x440;&#x443;&#x431;'),
		'SEK'=>array('key' => 'SEK', 'name' => 'Swedish Krona', 'symbol'=>'kr', 'hex'=>'&#x6b;&#x72;'),
		'SGD'=>array('key' => 'SGD', 'name' => 'Singapore Dollar', 'symbol'=>'S$', 'hex'=>'&#x53;&#x24;'),
		'THB'=>array('key' => 'THB', 'name' => 'Thai Baht', 'symbol'=>'฿', 'hex'=>'&#xe3f;'),
		'TND'=>array('key' => 'TND', 'name' => 'Tunisian Dinar', 'symbol'=>'DT', 'hex'=>'&#x44;&#x54;'),
		'TRY'=>array('key' => 'TRY', 'name' => 'Turkish Lira', 'symbol'=>'TL', 'hex'=>'&#x54;&#x4c;'),
		'TWD'=>array('key' => 'TWD', 'name' => 'Taiwan Dollar', 'symbol'=>'NT$', 'hex'=>'&#x4e;&#x54;&#x24;'),
		'USD'=>array('key' => 'USD', 'name' => 'US Dollar', 'symbol'=>'$', 'hex'=>'&#x24;'),
		'VEF'=>array('key' => 'VEF', 'name' => 'Venezuelan Bolivar Fuerte', 'symbol'=>'Bs', 'hex'=>'&#x42;&#x73;'),
		'VND'=>array('key' => 'VND', 'name' => 'Vietnamese Dong', 'symbol'=>'₫', 'hex'=>'&#x20ab;'),
		'XAF'=>array('key' => 'XAF', 'name' => 'CFA Franc BEAC', 'symbol'=>'FCFA', 'hex'=>'&#x46;&#x43;&#x46;&#x41;'),
		'XOF'=>array('key' => 'XOF', 'name' => 'CFA Franc BCEAO', 'symbol'=>'FCFA', 'hex'=>'&#x46;&#x43;&#x46;&#x41;'),
		'XPF'=>array('key' => 'XPF', 'name' => 'CFP Franc', 'symbol'=>'F', 'hex'=>'&#x46;'),
		'ZAR'=>array('key' => 'ZAR', 'name' => 'South African Rand', 'symbol'=>'R', 'hex'=>'&#x52;')
	);
	if (!$k)
	{
		return $currencies;
	}
	else
	{
		foreach ($currencies as $key => $value) {
			if ($k == $key)
			{
				return $value[$field];
			}
		}
	}
}
// ------------------------------------------------------------------------
/**
 * Get country list
 * @param type|null $code 
 * @return type
 */
function get_countries($code=null)
{
	$return = array(
		array('code' => 'None', 'name' => 'None', 'coordinate' => ''),
		array('code' => 'AF', 'name' => 'Afghanistan', 'coordinate' => '16.63'),
		array('code' => 'AX', 'name' => 'Aland Islands', 'coordinate' => ''),
		array('code' => 'AL', 'name' => 'Albania', 'coordinate' => '11.58'),
		array('code' => 'DZ', 'name' => 'Algeria', 'coordinate' => '158.97'),
		array('code' => 'AS', 'name' => 'American Samoa', 'coordinate' => ''),
		array('code' => 'AD', 'name' => 'Andorra', 'coordinate' => ''),
		array('code' => 'AO', 'name' => 'Angola', 'coordinate' => '85.81'),
		array('code' => 'AI', 'name' => 'Anguilla', 'coordinate' => ''),
		array('code' => 'AQ', 'name' => 'Antarctica', 'coordinate' => ''),
		array('code' => 'AG', 'name' => 'Antigua And Barbuda', 'coordinate' => '1.1'),
		array('code' => 'AR', 'name' => 'Argentina', 'coordinate' => '351.02'),
		array('code' => 'AM', 'name' => 'Armenia', 'coordinate' => '8.83'),
		array('code' => 'AW', 'name' => 'Aruba', 'coordinate' => ''),
		array('code' => 'AU', 'name' => 'Australia', 'coordinate' => '1219.72'),
		array('code' => 'AT', 'name' => 'Austria', 'coordinate' => '366.26'),
		array('code' => 'AZ', 'name' => 'Azerbaijan', 'coordinate' => '52.17'),
		array('code' => 'BS', 'name' => 'Bahamas', 'coordinate' => '7.54'),
		array('code' => 'BH', 'name' => 'Bahrain', 'coordinate' => '21.73'),
		array('code' => 'BD', 'name' => 'Bangladesh', 'coordinate' => '105.4'),
		array('code' => 'BB', 'name' => 'Barbados', 'coordinate' => '3.96'),
		array('code' => 'BY', 'name' => 'Belarus', 'coordinate' => '52.89'),
		array('code' => 'BE', 'name' => 'Belgium', 'coordinate' => '461.33'),
		array('code' => 'BZ', 'name' => 'Belize', 'coordinate' => '1.43'),
		array('code' => 'BJ', 'name' => 'Benin', 'coordinate' => '6.49'),
		array('code' => 'BM', 'name' => 'Bermuda', 'coordinate' => ''),
		array('code' => 'BT', 'name' => 'Bhutan', 'coordinate' => '1.4'),
		array('code' => 'BO', 'name' => 'Bolivia', 'coordinate' => '19.18'),
		array('code' => 'BA', 'name' => 'Bosnia And Herzegovina', 'coordinate' => '16.2'),
		array('code' => 'BW', 'name' => 'Botswana', 'coordinate' => '12.5'),
		array('code' => 'BV', 'name' => 'Bouvet Island', 'coordinate' => ''),
		array('code' => 'BR', 'name' => 'Brazil', 'coordinate' => '2023.53'),
		array('code' => 'IO', 'name' => 'British Indian Ocean Territory', 'coordinate' => ''),
		array('code' => 'BN', 'name' => 'Brunei Darussalam', 'coordinate' => '11.96'),
		array('code' => 'BG', 'name' => 'Bulgaria', 'coordinate' => '44.84'),
		array('code' => 'BF', 'name' => 'Burkina Faso', 'coordinate' => '8.67'),
		array('code' => 'BI', 'name' => 'Burundi', 'coordinate' => '1.47'),
		array('code' => 'KH', 'name' => 'Cambodia', 'coordinate' => '11.36'),
		array('code' => 'CM', 'name' => 'Cameroon', 'coordinate' => '21.88'),
		array('code' => 'CA', 'name' => 'Canada', 'coordinate' => '1563.66'),
		array('code' => 'CV', 'name' => 'Cape Verde', 'coordinate' => '1.57'),
		array('code' => 'KY', 'name' => 'Cayman Islands', 'coordinate' => ''),
		array('code' => 'CF', 'name' => 'Central African Republic', 'coordinate' => '2.11'),
		array('code' => 'TD', 'name' => 'Chad', 'coordinate' => '7.59'),
		array('code' => 'CL', 'name' => 'Chile', 'coordinate' => '199.18'),
		array('code' => 'CN', 'name' => 'China', 'coordinate' => '5745.13'),
		array('code' => 'CX', 'name' => 'Christmas Island', 'coordinate' => ''),
		array('code' => 'CC', 'name' => 'Cocos (Keeling) Islands', 'coordinate' => ''),
		array('code' => 'CO', 'name' => 'Colombia', 'coordinate' => '283.11'),
		array('code' => 'KM', 'name' => 'Comoros', 'coordinate' => '0.56'),
		array('code' => 'CG', 'name' => 'Congo', 'coordinate' => '11.88'),
		array('code' => 'CD', 'name' => 'Congo, Democratic Republic', 'coordinate' => '12.6'),
		array('code' => 'CK', 'name' => 'Cook Islands', 'coordinate' => ''),
		array('code' => 'CR', 'name' => 'Costa Rica', 'coordinate' => '35.02'),
		array('code' => 'CI', 'name' => 'Cote D\'Ivoire', 'coordinate' => '22.38'),
		array('code' => 'HR', 'name' => 'Croatia', 'coordinate' => '59.92'),
		array('code' => 'CU', 'name' => 'Cuba', 'coordinate' => ''),
		array('code' => 'CY', 'name' => 'Cyprus', 'coordinate' => '22.75'),
		array('code' => 'CZ', 'name' => 'Czech Republic', 'coordinate' => '195.23'),
		array('code' => 'DK', 'name' => 'Denmark', 'coordinate' => '304.56'),
		array('code' => 'DJ', 'name' => 'Djibouti', 'coordinate' => '1.14'),
		array('code' => 'DM', 'name' => 'Dominica', 'coordinate' => '0.38'),
		array('code' => 'DO', 'name' => 'Dominican Republic', 'coordinate' => '50.87'),
		array('code' => 'EC', 'name' => 'Ecuador', 'coordinate' => '61.49'),
		array('code' => 'EG', 'name' => 'Egypt', 'coordinate' => '216.83'),
		array('code' => 'SV', 'name' => 'El Salvador', 'coordinate' => '21.8'),
		array('code' => 'GQ', 'name' => 'Equatorial Guinea', 'coordinate' => '14.55'),
		array('code' => 'ER', 'name' => 'Eritrea', 'coordinate' => '2.25'),
		array('code' => 'EE', 'name' => 'Estonia', 'coordinate' => '19.22'),
		array('code' => 'ET', 'name' => 'Ethiopia', 'coordinate' => '30.94'),
		array('code' => 'FK', 'name' => 'Falkland Islands (Malvinas)', 'coordinate' => ''),
		array('code' => 'FO', 'name' => 'Faroe Islands', 'coordinate' => ''),
		array('code' => 'FJ', 'name' => 'Fiji', 'coordinate' => '3.15'),
		array('code' => 'FI', 'name' => 'Finland', 'coordinate' => '231.98'),
		array('code' => 'FR', 'name' => 'France', 'coordinate' => '2555.44'),
		array('code' => 'GF', 'name' => 'French Guiana', 'coordinate' => ''),
		array('code' => 'PF', 'name' => 'French Polynesia', 'coordinate' => ''),
		array('code' => 'TF', 'name' => 'French Southern Territories', 'coordinate' => ''),
		array('code' => 'GA', 'name' => 'Gabon', 'coordinate' => '12.56'),
		array('code' => 'GM', 'name' => 'Gambia', 'coordinate' => '1.04'),
		array('code' => 'GE', 'name' => 'Georgia', 'coordinate' => '11.23'),
		array('code' => 'DE', 'name' => 'Germany', 'coordinate' => '3305.9'),
		array('code' => 'GH', 'name' => 'Ghana', 'coordinate' => '18.06'),
		array('code' => 'GI', 'name' => 'Gibraltar', 'coordinate' => ''),
		array('code' => 'GR', 'name' => 'Greece', 'coordinate' => '305.01'),
		array('code' => 'GL', 'name' => 'Greenland', 'coordinate' => ''),
		array('code' => 'GD', 'name' => 'Grenada', 'coordinate' => '0.65'),
		array('code' => 'GP', 'name' => 'Guadeloupe', 'coordinate' => ''),
		array('code' => 'GU', 'name' => 'Guam', 'coordinate' => ''),
		array('code' => 'GT', 'name' => 'Guatemala', 'coordinate' => '40.77'),
		array('code' => 'GG', 'name' => 'Guernsey', 'coordinate' => ''),
		array('code' => 'GN', 'name' => 'Guinea', 'coordinate' => '4.34'),
		array('code' => 'GW', 'name' => 'Guinea-Bissau', 'coordinate' => '0.83'),
		array('code' => 'GY', 'name' => 'Guyana', 'coordinate' => '2.2'),
		array('code' => 'HT', 'name' => 'Haiti', 'coordinate' => '6.5'),
		array('code' => 'HM', 'name' => 'Heard Island & Mcdonald Islands', 'coordinate' => ''),
		array('code' => 'VA', 'name' => 'Holy See (Vatican City State)', 'coordinate' => ''),
		array('code' => 'HN', 'name' => 'Honduras', 'coordinate' => '15.34'),
		array('code' => 'HK', 'name' => 'Hong Kong', 'coordinate' => '226.49'),
		array('code' => 'HU', 'name' => 'Hungary', 'coordinate' => '132.28'),
		array('code' => 'IS', 'name' => 'Iceland', 'coordinate' => '12.77'),
		array('code' => 'IN', 'name' => 'India', 'coordinate' => '1430.02'),
		array('code' => 'ID', 'name' => 'Indonesia', 'coordinate' => '695.06'),
		array('code' => 'IR', 'name' => 'Iran, Islamic Republic Of', 'coordinate' => '337.9'),
		array('code' => 'IQ', 'name' => 'Iraq', 'coordinate' => '84.14'),
		array('code' => 'IE', 'name' => 'Ireland', 'coordinate' => '204.14'),
		array('code' => 'IM', 'name' => 'Isle Of Man', 'coordinate' => ''),
		array('code' => 'IL', 'name' => 'Israel', 'coordinate' => '201.25'),
		array('code' => 'IT', 'name' => 'Italy', 'coordinate' => '2036.69'),
		array('code' => 'JM', 'name' => 'Jamaica', 'coordinate' => '13.74'),
		array('code' => 'JP', 'name' => 'Japan', 'coordinate' => '5390.9'),
		array('code' => 'JE', 'name' => 'Jersey', 'coordinate' => ''),
		array('code' => 'JO', 'name' => 'Jordan', 'coordinate' => '27.13'),
		array('code' => 'KZ', 'name' => 'Kazakhstan', 'coordinate' => '129.76'),
		array('code' => 'KE', 'name' => 'Kenya', 'coordinate' => '32.42'),
		array('code' => 'KI', 'name' => 'Kiribati', 'coordinate' => '0.15'),
		array('code' => 'KR', 'name' => 'Korea', 'coordinate' => '986.26'),
		array('code' => 'KW', 'name' => 'Kuwait', 'coordinate' => '117.32'),
		array('code' => 'KG', 'name' => 'Kyrgyzstan', 'coordinate' => '4.44'),
		array('code' => 'LA', 'name' => 'Lao People\'s Democratic Republic', 'coordinate' => '6.34'),
		array('code' => 'LV', 'name' => 'Latvia', 'coordinate' => '23.39'),
		array('code' => 'LB', 'name' => 'Lebanon', 'coordinate' => '39.15'),
		array('code' => 'LS', 'name' => 'Lesotho', 'coordinate' => '1.8'),
		array('code' => 'LR', 'name' => 'Liberia', 'coordinate' => '0.98'),
		array('code' => 'LY', 'name' => 'Libyan Arab Jamahiriya', 'coordinate' => '77.91'),
		array('code' => 'LI', 'name' => 'Liechtenstein', 'coordinate' => ''),
		array('code' => 'LT', 'name' => 'Lithuania', 'coordinate' => '35.73'),
		array('code' => 'LU', 'name' => 'Luxembourg', 'coordinate' => '52.43'),
		array('code' => 'MO', 'name' => 'Macao', 'coordinate' => ''),
		array('code' => 'MK', 'name' => 'Macedonia', 'coordinate' => '9.58'),
		array('code' => 'MG', 'name' => 'Madagascar', 'coordinate' => '8.33'),
		array('code' => 'MW', 'name' => 'Malawi', 'coordinate' => '5.04'),
		array('code' => 'MY', 'name' => 'Malaysia', 'coordinate' => '218.95'),
		array('code' => 'MV', 'name' => 'Maldives', 'coordinate' => '1.43'),
		array('code' => 'ML', 'name' => 'Mali', 'coordinate' => '9.08'),
		array('code' => 'MT', 'name' => 'Malta', 'coordinate' => '7.8'),
		array('code' => 'MH', 'name' => 'Marshall Islands', 'coordinate' => ''),
		array('code' => 'MQ', 'name' => 'Martinique', 'coordinate' => ''),
		array('code' => 'MR', 'name' => 'Mauritania', 'coordinate' => '3.49'),
		array('code' => 'MU', 'name' => 'Mauritius', 'coordinate' => '9.43'),
		array('code' => 'YT', 'name' => 'Mayotte', 'coordinate' => ''),
		array('code' => 'MX', 'name' => 'Mexico', 'coordinate' => '1004.04'),
		array('code' => 'FM', 'name' => 'Micronesia, Federated States Of', 'coordinate' => ''),
		array('code' => 'MD', 'name' => 'Moldova', 'coordinate' => '5.36'),
		array('code' => 'MC', 'name' => 'Monaco', 'coordinate' => ''),
		array('code' => 'MN', 'name' => 'Mongolia', 'coordinate' => '5.81'),
		array('code' => 'ME', 'name' => 'Montenegro', 'coordinate' => '3.88'),
		array('code' => 'MS', 'name' => 'Montserrat', 'coordinate' => ''),
		array('code' => 'MA', 'name' => 'Morocco', 'coordinate' => '91.7'),
		array('code' => 'MZ', 'name' => 'Mozambique', 'coordinate' => '10.21'),
		array('code' => 'MM', 'name' => 'Myanmar', 'coordinate' => '35.65'),
		array('code' => 'NA', 'name' => 'Namibia', 'coordinate' => '11.45'),
		array('code' => 'NR', 'name' => 'Nauru', 'coordinate' => ''),
		array('code' => 'NP', 'name' => 'Nepal', 'coordinate' => '15.11'),
		array('code' => 'NL', 'name' => 'Netherlands', 'coordinate' => '770.31'),
		array('code' => 'AN', 'name' => 'Netherlands Antilles', 'coordinate' => ''),
		array('code' => 'NC', 'name' => 'New Caledonia', 'coordinate' => ''),
		array('code' => 'NZ', 'name' => 'New Zealand', 'coordinate' => '138'),
		array('code' => 'NI', 'name' => 'Nicaragua', 'coordinate' => '6.38'),
		array('code' => 'NE', 'name' => 'Niger', 'coordinate' => '5.6'),
		array('code' => 'NG', 'name' => 'Nigeria', 'coordinate' => '206.66'),
		array('code' => 'NU', 'name' => 'Niue', 'coordinate' => ''),
		array('code' => 'NF', 'name' => 'Norfolk Island', 'coordinate' => ''),
		array('code' => 'MP', 'name' => 'Northern Mariana Islands', 'coordinate' => ''),
		array('code' => 'NO', 'name' => 'Norway', 'coordinate' => '413.51'),
		array('code' => 'OM', 'name' => 'Oman', 'coordinate' => '53.78'),
		array('code' => 'PK', 'name' => 'Pakistan', 'coordinate' => '174.79'),
		array('code' => 'PW', 'name' => 'Palau', 'coordinate' => ''),
		array('code' => 'PS', 'name' => 'Palestinian Territory, Occupied', 'coordinate' => ''),
		array('code' => 'PA', 'name' => 'Panama', 'coordinate' => '27.2'),
		array('code' => 'PG', 'name' => 'Papua New Guinea', 'coordinate' => '8.81'),
		array('code' => 'PY', 'name' => 'Paraguay', 'coordinate' => '17.17'),
		array('code' => 'PE', 'name' => 'Peru', 'coordinate' => '153.55'),
		array('code' => 'PH', 'name' => 'Philippines', 'coordinate' => '189.06'),
		array('code' => 'PN', 'name' => 'Pitcairn', 'coordinate' => ''),
		array('code' => 'PL', 'name' => 'Poland', 'coordinate' => '438.88'),
		array('code' => 'PT', 'name' => 'Portugal', 'coordinate' => '223.7'),
		array('code' => 'PR', 'name' => 'Puerto Rico', 'coordinate' => ''),
		array('code' => 'QA', 'name' => 'Qatar', 'coordinate' => '126.52'),
		array('code' => 'RE', 'name' => 'Reunion', 'coordinate' => ''),
		array('code' => 'RO', 'name' => 'Romania', 'coordinate' => '158.39'),
		array('code' => 'RU', 'name' => 'Russian Federation', 'coordinate' => '1476.91'),
		array('code' => 'RW', 'name' => 'Rwanda', 'coordinate' => '5.69'),
		array('code' => 'BL', 'name' => 'Saint Barthelemy', 'coordinate' => ''),
		array('code' => 'SH', 'name' => 'Saint Helena', 'coordinate' => ''),
		array('code' => 'KN', 'name' => 'Saint Kitts And Nevis', 'coordinate' => '0.56'),
		array('code' => 'LC', 'name' => 'Saint Lucia', 'coordinate' => '1'),
		array('code' => 'MF', 'name' => 'Saint Martin', 'coordinate' => ''),
		array('code' => 'PM', 'name' => 'Saint Pierre And Miquelon', 'coordinate' => ''),
		array('code' => 'VC', 'name' => 'Saint Vincent And Grenadines', 'coordinate' => '0.58'),
		array('code' => 'WS', 'name' => 'Samoa', 'coordinate' => '0.55'),
		array('code' => 'SM', 'name' => 'San Marino', 'coordinate' => ''),
		array('code' => 'ST', 'name' => 'Sao Tome And Principe', 'coordinate' => '0.19'),
		array('code' => 'SA', 'name' => 'Saudi Arabia', 'coordinate' => '434.44'),
		array('code' => 'SN', 'name' => 'Senegal', 'coordinate' => '12.66'),
		array('code' => 'RS', 'name' => 'Serbia', 'coordinate' => '38.92'),
		array('code' => 'SC', 'name' => 'Seychelles', 'coordinate' => '0.92'),
		array('code' => 'SL', 'name' => 'Sierra Leone', 'coordinate' => '1.9'),
		array('code' => 'SG', 'name' => 'Singapore', 'coordinate' => '217.38'),
		array('code' => 'SK', 'name' => 'Slovakia', 'coordinate' => '86.26'),
		array('code' => 'SI', 'name' => 'Slovenia', 'coordinate' => '46.44'),
		array('code' => 'SB', 'name' => 'Solomon Islands', 'coordinate' => '0.67'),
		array('code' => 'SO', 'name' => 'Somalia', 'coordinate' => ''),
		array('code' => 'ZA', 'name' => 'South Africa', 'coordinate' => '354.41'),
		array('code' => 'GS', 'name' => 'South Georgia And Sandwich Isl.', 'coordinate' => ''),
		array('code' => 'ES', 'name' => 'Spain', 'coordinate' => '1374.78'),
		array('code' => 'LK', 'name' => 'Sri Lanka', 'coordinate' => '48.24'),
		array('code' => 'SD', 'name' => 'Sudan', 'coordinate' => '65.93'),
		array('code' => 'SR', 'name' => 'Suriname', 'coordinate' => '3.3'),
		array('code' => 'SJ', 'name' => 'Svalbard And Jan Mayen', 'coordinate' => ''),
		array('code' => 'SZ', 'name' => 'Swaziland', 'coordinate' => '3.17'),
		array('code' => 'SE', 'name' => 'Sweden', 'coordinate' => '444.59'),
		array('code' => 'CH', 'name' => 'Switzerland', 'coordinate' => '522.44'),
		array('code' => 'SY', 'name' => 'Syrian Arab Republic', 'coordinate' => '59.63'),
		array('code' => 'TW', 'name' => 'Taiwan', 'coordinate' => '426.98'),
		array('code' => 'TJ', 'name' => 'Tajikistan', 'coordinate' => '5.58'),
		array('code' => 'TZ', 'name' => 'Tanzania', 'coordinate' => '22.43'),
		array('code' => 'TH', 'name' => 'Thailand', 'coordinate' => '312.61'),
		array('code' => 'TL', 'name' => 'Timor-Leste', 'coordinate' => '0.62'),
		array('code' => 'TG', 'name' => 'Togo', 'coordinate' => '3.07'),
		array('code' => 'TK', 'name' => 'Tokelau', 'coordinate' => ''),
		array('code' => 'TO', 'name' => 'Tonga', 'coordinate' => '0.3'),
		array('code' => 'TT', 'name' => 'Trinidad And Tobago', 'coordinate' => '21.2'),
		array('code' => 'TN', 'name' => 'Tunisia', 'coordinate' => '43.86'),
		array('code' => 'TR', 'name' => 'Turkey', 'coordinate' => '729.05'),
		array('code' => 'TM', 'name' => 'Turkmenistan', 'coordinate' => '0'),
		array('code' => 'TC', 'name' => 'Turks And Caicos Islands', 'coordinate' => ''),
		array('code' => 'TV', 'name' => 'Tuvalu', 'coordinate' => ''),
		array('code' => 'UG', 'name' => 'Uganda', 'coordinate' => '17.12'),
		array('code' => 'UA', 'name' => 'Ukraine', 'coordinate' => '136.56'),
		array('code' => 'AE', 'name' => 'United Arab Emirates', 'coordinate' => '239.65'),
		array('code' => 'GB', 'name' => 'United Kingdom', 'coordinate' => '2258.57'),
		array('code' => 'US', 'name' => 'United States', 'coordinate' => '14624.18'),
		array('code' => 'UM', 'name' => 'United States Outlying Islands', 'coordinate' => ''),
		array('code' => 'UY', 'name' => 'Uruguay', 'coordinate' => '40.71'),
		array('code' => 'UZ', 'name' => 'Uzbekistan', 'coordinate' => '37.72'),
		array('code' => 'VU', 'name' => 'Vanuatu', 'coordinate' => '0.72'),
		array('code' => 'VE', 'name' => 'Venezuela', 'coordinate' => '285.21'),
		array('code' => 'VN', 'name' => 'Viet Nam', 'coordinate' => '101.99'),
		array('code' => 'VG', 'name' => 'Virgin Islands, British', 'coordinate' => ''),
		array('code' => 'VI', 'name' => 'Virgin Islands, U.S.', 'coordinate' => ''),
		array('code' => 'WF', 'name' => 'Wallis And Futuna', 'coordinate' => ''),
		array('code' => 'EH', 'name' => 'Western Sahara', 'coordinate' => ''),
		array('code' => 'YE', 'name' => 'Yemen', 'coordinate' => '30.02'),
		array('code' => 'ZM', 'name' => 'Zambia', 'coordinate' => '15.69'),
		array('code' => 'ZW', 'name' => 'Zimbabwe', 'coordinate' => '5.57')
	);
	if (!$code)
	{
		return $return;
	}
	else
	{
		if ($code == -1) {
			return "";
		} else {
			foreach ($return as $key => $value) {
				if($value['code'] == $code)
				{
					return $value['name'];
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
/**
 * Custom function to format date
 * @param type $format 
 * @param type $date 
 * @return type string
 */
function _fdate($locale=null, $date) 
{
	if(!$date)
	{
		return false;
	}
	else
	{
		$locale_str = isset($locale) ? $locale: language_string_to_locale_notation( get_option('user_language', 'users_options') );
		$locale_str .= '.UTF8';
		setlocale(LC_ALL, $locale_str);
		$formattedDate = strftime( __toftime(get_option('user_date_format')), strtotime($date) );
		if (get_option('user_date_format') === 'j F Y' || 
			get_option('user_date_format') === 'F j, Y') {
			$months = [
				'January', 
				'February', 
				'March', 
				'April', 
				'May', 
				'June', 
				'July', 
				'August', 
				'September', 
				'October', 
				'November', 
				'December'
			];
			$monthsTranslations = [
				_monthLocale('label_january'), 
				_monthLocale('label_february'), 
				_monthLocale('label_march'), 
				_monthLocale('label_april'), 
				_monthLocale('label_may'), 
				_monthLocale('label_june'), 
				_monthLocale('label_july'), 
				_monthLocale('label_august'), 
				_monthLocale('label_september'), 
				_monthLocale('label_october'), 
				_monthLocale('label_november'), 
				_monthLocale('label_december')
			];
			return str_ireplace($months, $monthsTranslations, $formattedDate);
		}
		return $formattedDate;
	}
}
function _monthLocale($month) {
	return ucfirst(__($month));
}
// ------------------------------------------------------------------------
/**
 * Helper function to return strftime format
 * @param type $format 
 * @return type str
 * @since 1.5
 */
function __toftime($format)
{
	switch ($format) {
		case 'j F Y':
			return '%d %B %Y';
			break;
		case 'F j, Y':
			return '%B %d, %Y';
			break;
		case 'Y-m-d':
			return '%Y-%m-%d';
			break;
		case 'm/d/Y':
			return '%m/%d/%Y';
			break;
		case 'd/m/Y':
			return '%d/%m/%Y';
			break;
		default:
			return '%Y-%m-%d';
			break;
	}
}
// /**
//  * Custom function to format due date
//  * @param type $format 
//  * @param type $date 
//  * @return type
//  */
// function _fduedate($format, $date) {
// 	if ( empty( $date ) )
// 		return false;
// 	if ( 'english' == $format )
// 		return date('m/d', strtotime($date) );
// 	if ( 'french' == $format OR 'spanish' == $format )
// 		return date('d/m', strtotime($date));
// 	if ( 'german' == $format OR 'russian' == $format )
// 		return date('d.m', strtotime($date));
// 	else
// 		return date('m/d', strtotime($date) );
// }
// ------------------------------------------------------------------------
/**
 * A custom function to format date before saving in database
 * @param type $format 
 * @param type $date 
 * @return type
 */
function mysqlDate($format, $date) {
	if ( empty( $date ) )
		return false;
	if ( 'english' == $format )
		return date("Y-m-d H:i:s", strtotime( str_replace('/', '-', $date) ));
	if ( 'french' == $format OR 'spanish' == $format )
		return date("Y-m-d H:i:s", strtotime( str_replace('/', '-', $date) ));
	if ( 'german' == $format OR 'russian' == $format )
		return date("Y-m-d H:i:s", strtotime( str_replace('.', '-', $date) ));
	else
		return date("Y-m-d H:i:s", strtotime( str_replace('/', '-', $date) ));
}
// ------------------------------------------------------------------------
/**
 * A custom function to encrypt IDs
 * @param type $id 
 * @return type hash
 */
function _eID($id)
{
	return encodeID($id);
}
// ------------------------------------------------------------------------
/**
 * A custom function to decrypt hash
 * @param type $hash 
 * @return type int
 */
function _dID($hash)
{
	$d = [];
	if (is_array($hash))
	{
		foreach ($hash as $h) {
			array_push($d, decodeID($h));
		}
		return $d;
	}
	return decodeID($hash);
}
// ------------------------------------------------------------------------
/**
 * Helper function to encrypt
 * @param type $id 
 * @return type
 */
function encodeID($id)
{
	// Strings don't currently have a secure
	// method, so simple base64 encoding will work for now.
	if (! is_numeric($id))
	{
        return '=_'.base64_encode($id);
	}

	$id = (int)$id;
	if ($id < 1)
	{
		return false;
	}
	if ($id > pow(2,31))
	{
		return false;
	}

	$segment1 = getHash($id,16);
	$segment2 = getHash($segment1,8);
	$dec      = (int)base_convert($segment2,16,10);
	$dec      = ($dec>$id)?$dec-$id:$dec+$id;
	$segment2 = base_convert($dec,10,16);
	$segment2 = str_pad($segment2,8,'0',STR_PAD_LEFT);
	$segment3 = getHash($segment1.$segment2,8);
	$hex      = $segment1.$segment2.$segment3;
	$bin      = pack('H*',$hex);
	$oid      = base64_encode($bin);
	$oid      = str_replace(array('+', '/', '='),array('$', ':', ''),$oid);

	return $oid;
}
// ------------------------------------------------------------------------
/**
 * Helper function to decode ID
 * @param type $hash 
 * @return type
 */
function decodeID($hash)
{
	// Was it a simple string we encoded?
	if (substr($hash, 0, 2) == '=_')
	{
		$hash = substr($hash, 2);
		return base64_decode($hash);
	}

	if (! preg_match('/^[A-Z0-9\:\$]{21,23}$/i',$hash)) {
		return 0;
	}
	$hash     = str_replace(array('$', ':'),array('+', '/'),$hash);
	$bin      = base64_decode($hash);
	$hex      = unpack('H*',$bin); $hex = $hex[1];
	if (! preg_match('/^[0-9a-f]{32}$/',$hex))
	{
		return 0;
	}
	$segment1 = substr($hex,0,16);
	$segment2 = substr($hex,16,8);
	$segment3 = substr($hex,24,8);
	$exp2     = getHash($segment1,8);
	$exp3     = getHash($segment1.$segment2,8);
	if ($segment3 != $exp3)
	{
		return 0;
	}
	$v1       = (int)base_convert($segment2,16,10);
	$v2       = (int)base_convert($exp2,16,10);
	$id       = abs($v1-$v2);

	return $id;
}
// ------------------------------------------------------------------------
/**
 * Find by hash
 * @param type $hashedID 
 * @return type
 */
function findByHashedID($hashedID)
{
	return find(decodeID($hashedID));
}
// ------------------------------------------------------------------------
/**
 * Get the hash
 * @param type $str 
 * @param type $len 
 * @return type
 */
function getHash($str, $len)
{
	$salt = '583f19d104962fd083a29794facb4f640d23b9eb';
	return substr(sha1($str.$salt),0,$len);
}
// ------------------------------------------------------------------------
/**
 * Initialize tcpdf
 * @return type
 */
function tcpdf()
{
	require_once(APPPATH. 'helpers/tcpdf/config/lang/eng.php');
	require_once(APPPATH. 'helpers/tcpdf/tcpdf.php');
}
// ------------------------------------------------------------------------
/**
 * Custom function to return a language string
 * @param type $key 
 * @param type|null $context 
 * @return type
 */
function __($key, $context=null)
{
	$CI = & get_instance();
	if(!$context)
	{
		return !lang($key) ? $key : lang($key);
	}
	else
	{
		$idiom = lang_code_to_string(client($context, 'client_language'));
		$CI->lang->load('application', $idiom);
		return $CI->lang->line($key);
	}
}
// ------------------------------------------------------------------------
/**
 * Return system default language translation
 * for notification message
 * @param type $key 
 * @param type|null $context 
 * @return type
 */
function __s($key)
{
	$CI = & get_instance();
	$idiom = lang_code_to_string(get_option('default_language'));
	$CI->lang->load('application', $idiom);
	return $CI->lang->line($key);
}
// ------------------------------------------------------------------------
/**
 * Custom function for displaying a language string
 * @param type $key 
 * @return type
 */
function _e($key)
{
	echo !lang($key) ? $key : lang($key);
}
// ------------------------------------------------------------------------
/**
 * Reports - Get income by client id in a specified interval
 * @param type $id 
 * @param type|null $interval 
 * @return type
 */
function income_by_client($id, $interval=null)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	switch ($interval) {
		case 'this_month':
			$query = "SELECT client_id AS clientID,
				SUM(CASE WHEN invoice_status = 'Paid'
					THEN amount_paid ELSE 0 End) - 
				SUM(CASE WHEN invoice_status = 'Refunded'
					THEN amount_due ELSE 0 End) AS TotalPaid
				FROM {$db->tables['invoices']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id} {$additional_where}";
			return $db->get_row($query)->TotalPaid;
			break;
		case 'last_month':
			$query = "SELECT client_id AS clientID,
				SUM(CASE WHEN invoice_status = 'Paid'
					THEN amount_paid ELSE 0 End) - 
				SUM(CASE WHEN invoice_status = 'Refunded'
					THEN amount_due ELSE 0 End) AS TotalPaid
				FROM {$db->tables['invoices']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND client_id={$id} {$additional_where}";
			return $db->get_row($query)->TotalPaid;
			break;
		case 'latest_three_months':
			$query = "SELECT client_id AS clientID,
				SUM(CASE WHEN invoice_status = 'Paid'
					THEN amount_paid ELSE 0 End) - 
				SUM(CASE WHEN invoice_status = 'Refunded'
					THEN amount_due ELSE 0 End) AS TotalPaid
				FROM {$db->tables['invoices']}
				WHERE date_paid >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH
				AND client_id={$id} {$additional_where}";
			return $db->get_row($query)->TotalPaid;
			break;
		case 'this_year':
			$query = "SELECT client_id AS clientID,
				SUM(CASE WHEN invoice_status = 'Paid'
					THEN amount_paid ELSE 0 End) - 
				SUM(CASE WHEN invoice_status = 'Refunded'
					THEN amount_due ELSE 0 End) AS TotalPaid
				FROM {$db->tables['invoices']}
				WHERE YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id} {$additional_where}";
			return $db->get_row($query)->TotalPaid;
			break;
		case 'last_year':
			$query = "SELECT client_id AS clientID,
				SUM(CASE WHEN invoice_status = 'Paid'
					THEN amount_paid ELSE 0 End) - 
				SUM(CASE WHEN invoice_status = 'Refunded'
					THEN amount_due ELSE 0 End) AS TotalPaid
				FROM {$db->tables['invoices']}
				WHERE YEAR(date_paid) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR))
				AND client_id={$id} {$additional_where}";
			return $db->get_row($query)->TotalPaid;
			break;
		case 'all_dates':
			$query = "SELECT client_id AS clientID,
				SUM(CASE WHEN invoice_status = 'Paid'
					THEN amount_paid ELSE 0 End) - 
				SUM(CASE WHEN invoice_status = 'Refunded'
					THEN amount_due ELSE 0 End) AS TotalPaid
				FROM {$db->tables['invoices']}
				WHERE YEAR(date_paid) IS NOT NULL
				AND client_id={$id} {$additional_where}";
			return $db->get_row($query)->TotalPaid;
			break;
		default:
			$query = "SELECT client_id AS clientID,
				SUM(CASE WHEN invoice_status = 'Paid'
					THEN amount_paid ELSE 0 End) - 
				SUM(CASE WHEN invoice_status = 'Refunded'
					THEN amount_due ELSE 0 End) AS TotalPaid
				FROM {$db->tables['invoices']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id} {$additional_where}";
			return $db->get_row($query)->TotalPaid;
			break;
	}
}
function report_income_by_client($id, $start, $end) {
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$query = "SELECT client_id AS clientID,
		SUM(CASE WHEN invoice_status = 'Paid'
			THEN amount_paid ELSE 0 End) - 
		SUM(CASE WHEN invoice_status = 'Refunded'
			THEN amount_due ELSE 0 End) AS TotalPaid
		FROM {$db->tables['invoices']}
		WHERE date_paid BETWEEN '{$start}' AND '{$end}'
		AND client_id={$id} {$additional_where}";
	return $db->get_row($query)->TotalPaid;
}
function report_income_by_user($id, $start, $end) {
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$query = "SELECT user_id AS UserID,
		SUM(CASE WHEN invoice_status = 'Paid'
			THEN amount_paid ELSE 0 End) - 
		SUM(CASE WHEN invoice_status = 'Refunded'
			THEN amount_due ELSE 0 End) AS TotalPaid,
		SUM(CASE WHEN commission_status = 'Paid'
			THEN user_commission ELSE 0 End) AS PaidCommission,
		SUM(CASE WHEN commission_status = 'Unpaid'
			THEN user_commission ELSE 0 End) AS UnPaidCommission
		FROM {$db->tables['invoices']}
		WHERE date_paid BETWEEN '{$start}' AND '{$end}'
		AND user_id={$id} {$additional_where}";
	return $db->get_results($query);
}
function has_unpaid_commission() {
	global $db;
	$query = "SELECT id FROM {$db->tables['invoices']} WHERE commission_status = 'Unpaid' LIMIT 1";
	$result = null != $db->get_row($query) ? $db->get_row($query)->id : 0;

	return $result;
}
function commissions_total_by_user($id, $start = null, $end = null) {
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$query = "SELECT user_id AS UserID,
		SUM(CASE WHEN invoice_status = 'Paid'
			THEN amount_paid ELSE 0 End) - 
		SUM(CASE WHEN invoice_status = 'Refunded'
			THEN amount_due ELSE 0 End) AS TotalPaid,
		SUM(CASE WHEN commission_status = 'Paid'
			THEN user_commission ELSE 0 End) AS PaidCommission,
		SUM(CASE WHEN commission_status = 'Unpaid'
			THEN user_commission ELSE 0 End) AS UnPaidCommission
		FROM {$db->tables['invoices']}
		WHERE user_id={$id} {$additional_where}";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function purchases_by_provider($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_paid) AS TotalPaid
				FROM {$db->tables['purchases']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				AND provider_id={$id}";
			return $db->get_row($query)->TotalPaid;
		case 'last_month':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_paid) AS TotalPaid
				FROM {$db->tables['purchases']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND provider_id={$id}";
			return $db->get_row($query)->TotalPaid;
		case 'latest_three_months':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_paid) AS TotalPaid
				FROM {$db->tables['purchases']}
				WHERE date_paid >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH
				AND provider_id={$id}";
			return $db->get_row($query)->TotalPaid;
		case 'this_year':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_paid) AS TotalPaid
				FROM {$db->tables['purchases']}
				WHERE YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				AND provider_id={$id}";
			return $db->get_row($query)->TotalPaid;
		case 'last_year':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_paid) AS TotalPaid
				FROM {$db->tables['purchases']}
				WHERE YEAR(date_paid) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR))
				AND provider_id={$id}";
			return $db->get_row($query)->TotalPaid;
		case 'all_dates':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_paid) AS TotalPaid
				FROM {$db->tables['purchases']}
				WHERE YEAR(date_paid) IS NOT NULL
				AND provider_id={$id}";
			return $db->get_row($query)->TotalPaid;
		default:
			$query = "SELECT provider_id AS providerID,
				SUM(amount_paid) AS TotalPaid
				FROM {$db->tables['purchases']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				AND provider_id={$id}";
			return $db->get_row($query)->TotalPaid;
	}
}
// ------------------------------------------------------------------------
function unpaid_purchase_by_provider($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['purchases']}
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND provider_id={$id}";
			return $db->get_row($query)->TotalDue;
		case 'last_month':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['purchases']}
				WHERE MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND provider_id={$id}";
			return $db->get_row($query)->TotalDue;
		case 'latest_three_months':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['purchases']}
				WHERE date >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH
				AND provider_id={$id}";
			return $db->get_row($query)->TotalDue;
		case 'this_year':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['purchases']}
				WHERE YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND provider_id={$id}";
			return $db->get_row($query)->TotalDue;
		case 'last_year':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['purchases']}
				WHERE YEAR(date) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR))
				AND provider_id={$id}";
			return $db->get_row($query)->TotalDue;
		case 'all_dates':
			$query = "SELECT provider_id AS providerID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['purchases']}
				WHERE YEAR(date) IS NOT NULL
				AND provider_id={$id}";
			return $db->get_row($query)->TotalDue;
		default:
			$query = "SELECT provider_id AS providerID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['purchases']}
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND provider_id={$id}";
			return $db->get_row($query)->TotalDue;
	}
}

// ------------------------------------------------------------------------
function provider_purchases($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND I.provider_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
		case 'last_month':
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND I.provider_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
		default:
			$query = "SELECT * 
				FROM {$db->tables['purchases']} I 
				LEFT JOIN {$db->tables['providers']} C 
				ON I.provider_id = C.provider_id
				WHERE I.provider_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
	}
}
// ------------------------------------------------------------------------
function client_products_services($id)
{
	global $db;
	$query = "SELECT DISTINCT item_name AS name, item_price AS price,
	SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_quantity ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_quantity ELSE 0 End) AS value
	FROM {$db->tables['invoices_items']}
	WHERE client_id={$id} 
	GROUP BY item_name
	ORDER BY item_name";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function provider_products_services($id)
{
	global $db;
	$query = "SELECT DISTINCT item_name AS name, 
	item_price AS price,
	SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_quantity ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_quantity ELSE 0 End) AS value
	FROM {$db->tables['purchases_items']}
	WHERE provider_id={$id} 
	GROUP BY item_name
	ORDER BY item_name";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function status_str($status)
{
	switch ($status) {
		case '1':
			return __('label_active');
			break;
		case '0':
			return __('label_inactive');
			break;
	}
}
// ------------------------------------------------------------------------
function income_by_category($interval)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	switch ($interval) {
		case 'this_month':
			$range = 1;
			break;
		case 'latest_three_months':
			$range = 3;
			break;
		case 'this_year':
			$query = "SELECT item_group AS name,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_subtotal ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_subtotal ELSE 0 End) AS value
				FROM {$db->tables['invoices_items']}
				WHERE YEAR(date_paid) = YEAR(CURDATE()) {$additional_where}
				GROUP BY item_group
				ORDER BY item_group ASC";
			return $db->get_results($query);
			break;
		case 'last_month':
			$query = "SELECT item_group AS name,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_subtotal ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_subtotal ELSE 0 End) AS value
				FROM {$db->tables['invoices_items']}
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}
				GROUP BY item_group
				ORDER BY item_group ASC";
			return $db->get_results($query);
			break;
		case 'last_year':
			$query = "SELECT item_group AS name,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_subtotal ELSE 0 End) AS value
			FROM {$db->tables['invoices_items']}
			WHERE YEAR(date_paid) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) {$additional_where}
			GROUP BY item_group
			ORDER BY item_group ASC";
			return $db->get_results($query);
			break;
		case 'all_dates':
			$query = "SELECT item_group AS name,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_subtotal ELSE 0 End) AS value
			FROM {$db->tables['invoices_items']}
			WHERE YEAR(date_paid) IS NOT NULL {$additional_where}
			GROUP BY item_group
			ORDER BY item_group ASC";
			return $db->get_results($query);
			break;
		default:
			$range = 3;
			break;
	}
	$query = "SELECT item_group AS name,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_subtotal ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_subtotal ELSE 0 End) AS value
		FROM {$db->tables['invoices_items']}
		WHERE date_paid >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL {$range} MONTH {$additional_where}
		GROUP BY item_group
		ORDER BY item_group ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
// REPORTS AND CHARTS
function record_charges($post_array, $primary_key=null, $id=null)
{
	global $db;
	$db_data = array(
		'charges_name'			=> isset($post_array['charges_name']) ? $post_array['charges_name'] : null, 
		'charges_sku'			=> isset($post_array['charges_sku']) ? $post_array['charges_sku'] : generate_sku(), 
		'charges_category'		=> isset($post_array['charges_category']) ? $post_array['charges_category'] : null,
		'charges_value'			=> isset($post_array['charges_value']) ? $post_array['charges_value'] : null,
		'charges_notes'			=> isset($post_array['charges_notes']) ? $post_array['charges_notes'] : null,
		'incomes_name'		    => isset($post_array['incomes_value']) ? $post_array['incomes_name'] : null, 
		'incomes_sku'		    => isset($post_array['incomes_value']) ? $post_array['incomes_sku'] : generate_sku(), 
		'incomes_category'		=> isset($post_array['incomes_value']) ? $post_array['incomes_category'] : null, 
		'incomes_value'			=> isset($post_array['incomes_value']) ? $post_array['incomes_value'] : null, 
		'incomes_notes'			=> isset($post_array['incomes_notes']) ? $post_array['incomes_notes'] : null, 
		'payment_method'		=> isset($post_array['incomes_value']) ? $post_array['payment_method'] : get_option('default_payment_method'), 
		'turnover_included'		=> isset($post_array['turnover_included']) ? $post_array['turnover_included'] : 0, 
		'taxes'					=> isset($post_array['taxes']) ? $post_array['taxes'] : null, 
		'created_on'    		=> isset($post_array['created_on']) ? $post_array['created_on'] : 'NOW()', 
		'item_sku' 				=> isset($post_array['item_sku']) ? $post_array['item_sku'] : null,
		'invoice_number' 		=> isset($post_array['invoice_number']) ? $post_array['invoice_number'] : 'NULL',
		'purchase_number' 		=> isset($post_array['purchase_number']) ? $post_array['purchase_number'] : 'NULL',
		'unique_id' 			=> isset($post_array['unique_id']) ? $post_array['unique_id'] : 'NULL',
		'user_id' 				=> isset($post_array['user_id']) ? $post_array['user_id'] : USERID
	);
	if (!$id)
	{
		$db->query("INSERT INTO {$db->tables['transactions']} SET ".$db->get_set($db_data));
	}
	else
	{
		if ($db->get_results("SELECT {$primary_key} FROM {$db->tables['transactions']} WHERE {$primary_key}={$id}"))
		{
			$db->query("UPDATE {$db->tables['transactions']} SET ".$db->get_set($db_data)." WHERE {$primary_key} = {$id}");
		}
		else
		{
			$db->query("INSERT INTO {$db->tables['transactions']} SET ".$db->get_set($db_data));
		}
	}
}
// ------------------------------------------------------------------------
function get_charges_sku($invoice_number)
{
	global $db;
	$res = new \stdClass();
	$res->charges_sku = NULL;

	if (!$db->query("SELECT EXISTS(SELECT 1 FROM {$db->tables['transactions']} WHERE invoice_number={$invoice_number})"))
	{
		return $res->charges_sku;
	}
	else
	{
		$result = $db->get_results("SELECT charges_sku FROM {$db->tables['transactions']} WHERE invoice_number={$invoice_number}");
		if ($result)
		{
			foreach ($result as $res) {
				return $res->charges_sku;
			}
		}
		return $res->charges_sku;
	}
}
// ------------------------------------------------------------------------
function get_incomes_sku($invoice_number)
{
	global $db;
	return $db->get_row("SELECT incomes_sku FROM {$db->tables['transactions']} WHERE invoice_number={$invoice_number}")->incomes_sku;
}
// ------------------------------------------------------------------------
function get_item_charges($item_sku)
{
	global $db;
	return $db->get_row("SELECT charges_value FROM {$db->tables['transactions']} WHERE item_sku='$item_sku'")->charges_value;
}
// ------------------------------------------------------------------------
function get_charges_list($filter=null)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	if (!$filter)
	{
		$filter = 'all';
	}
	switch ($filter) {
		case 'all':
			$query = "SELECT charges_name, charges_category,
						SUM(charges_value) AS charges_value
						FROM {$db->tables['transactions']} 
						WHERE charges_value > 0 {$additional_where}
						GROUP BY charges_category
						ORDER BY charges_category";
			return $db->get_results($query);
			break;
		default:
			$query = "SELECT charges_name, charges_category,
						SUM(charges_value) AS charges_value
						FROM {$db->tables['transactions']} 
						WHERE charges_value > 0 {$additional_where}
						GROUP BY charges_category
						ORDER BY charges_category";
			return $db->get_results($query);
			break;
	}
}
// ------------------------------------------------------------------------
function get_incomes_list($filter=null)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	if (!$filter)
	{
		$filter = 'all';
	}
	switch ($filter) {
		case 'all':
			$query = "SELECT incomes_category,
						SUM(incomes_value) AS incomes_value
						FROM {$db->tables['transactions']} 
						WHERE incomes_value > 0 {$additional_where}
						GROUP BY incomes_category
						ORDER BY incomes_category";
			return $db->get_results($query);
			break;
		default:
			$query = "SELECT incomes_category,
						SUM(incomes_value) AS incomes_value
						FROM {$db->tables['transactions']} 
						WHERE incomes_value > 0 {$additional_where}
						GROUP BY incomes_category
						ORDER BY incomes_category";
			return $db->get_results($query);
			break;
	}
}
// ------------------------------------------------------------------------
function get_charges($id)
{
	global $db;
	return $db->get_results("SELECT * FROM {$db->tables['transactions']} WHERE transaction_id={$id}");
}
// ------------------------------------------------------------------------
function get_charges_by_category($category)
{
	global $db;
	return $db->get_results("SELECT * FROM {$db->tables['transactions']} WHERE charges_category='$category'");
}
// ------------------------------------------------------------------------
function get_charges_category($key)
{
	global $db;
	$result = $db->get_row("SELECT group_name FROM {$db->tables['charges_categories']} WHERE group_id={$key}")->group_name;
	if ($result && $result === "charges_purchases" || 
		$result === "charges_external_services" ||
		$result === "charges_other_external_services" ||
		$result === "charges_taxes_assimilated_payments" ||
		$result === "charges_staff_costs" ||
		$result === "charges_other_day_to_day_management_charges" ||
		$result === "charges_financial_charges" ||
		$result === "charges_depreciation_provisions" ||
		$result === "charges_employee_participation_income_taxes" ||
		$result === "charges_exceptional_costs"
		)
	{
		return __($result);
	}
	else
	{
		return $result;
	}
}
// ------------------------------------------------------------------------
function get_incomes_category($key)
{
	global $db;
	$result = $db->get_row("SELECT group_name FROM {$db->tables['incomes_categories']} WHERE group_id={$key}")->group_name;
	if ($result && $result === "incomes_sales_services_goods" || 
		$result === "incomes_operating_subsidies" ||
		$result === "incomes_day_day_other_incomes" ||
		$result === "incomes_financial_product" ||
		$result === "extraordinary_income"
		)
	{
		return __($result);
	}
	else
	{
		return $result;
	}
}
// ------------------------------------------------------------------------
function get_incomes_by_category($category)
{
	global $db;
	return $db->get_results("SELECT * FROM {$db->tables['transactions']} WHERE incomes_category='$category'");
}
// ------------------------------------------------------------------------
function get_charges_categories()
{
	global $db;
	return $db->get_results("SELECT * FROM {$db->tables['charges_categories']}");
}
// ------------------------------------------------------------------------
function get_incomes_categories()
{
	global $db;
	return $db->get_results("SELECT * FROM {$db->tables['incomes_categories']}");
}
// ------------------------------------------------------------------------
// Daily transaction report
if ( ! function_exists('get_transactions')) {
    function get_transactions($start=null, $end=null)
	{
		$rbac = new Rbac;
		if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
			$additional_where = ' AND user_id = '. USERID;
			$additional_single_where = ' user_id = '. USERID;
		} else {
			$additional_where = '';
			$additional_single_where = '';
		}

		global $db;
		if ($start && $end) {
			$query = "SELECT * FROM oc_transactions WHERE created_on BETWEEN '{$start}' AND '{$end}' {$additional_where} ORDER BY created_on DESC";
		} else {
			$query = "SELECT * FROM oc_transactions {$additional_single_where}";
		}
		return $db->get_results($query);
	}
}
function get_transaction_id($key, $value)
{
	global $db;
	return $db->get_row("SELECT transaction_id FROM {$db->tables['transactions']} WHERE {$key}='$value'") ? $db->get_row("SELECT transaction_id FROM {$db->tables['transactions']} WHERE {$key}='$value'")->transaction_id : null;
}
// ------------------------------------------------------------------------
function financial_accounting($interval=null, $filter=null)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}
	global $db;
	$data = [];
	$accounting = [];
	$incomes = 0;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT YEAR(created_on) AS SalesYear,
				MONTH(created_on) AS SalesMonth,
				SUM(incomes_value) AS TotalSales,
				SUM(taxes) AS TotalTax,
				SUM(charges_value) AS TotalCharges
				FROM {$db->tables['transactions']}
				WHERE created_on >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 1 MONTH AND turnover_included = 1
				{$additional_where}
				GROUP BY YEAR(created_on), MONTH(created_on)
				ORDER BY YEAR(created_on), MONTH(created_on)";
			$data  = $db->get_results($query);
			break;
		case 'today':
			$query = "SELECT YEAR(created_on) AS SalesYear,
				MONTH(created_on) AS SalesMonth,
				SUM(incomes_value) AS TotalSales,
				SUM(taxes) AS TotalTax,
				SUM(charges_value) AS TotalCharges
				FROM {$db->tables['transactions']}
				WHERE DATE(created_on) = DATE(NOW())
				{$additional_where}";
			$data  = $db->get_results($query);
			break;
		case 'latest_three_months':
			$query = "SELECT YEAR(created_on) AS SalesYear,
				MONTH(created_on) AS SalesMonth,
				SUM(incomes_value) AS TotalSales,
				SUM(taxes) AS TotalTax,
				SUM(charges_value) AS TotalCharges
				FROM {$db->tables['transactions']}
				WHERE created_on >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH AND turnover_included = 1
				{$additional_where}
				GROUP BY YEAR(created_on), MONTH(created_on)
				ORDER BY YEAR(created_on), MONTH(created_on)";
			$data  = $db->get_results($query);
			break;
		case 'this_year':
			$query = "SELECT YEAR(created_on) AS SalesYear,
				MONTH(created_on) AS SalesMonth,
				SUM(incomes_value) AS TotalSales,
				SUM(taxes) AS TotalTax,
				SUM(charges_value) AS TotalCharges
				FROM {$db->tables['transactions']}
				WHERE YEAR(created_on) = YEAR(CURDATE()) AND turnover_included = 1
				{$additional_where}
				GROUP BY YEAR(created_on), MONTH(created_on)
				ORDER BY YEAR(created_on), MONTH(created_on)";
			$data = $db->get_results($query);
			break;
		case 'this_year_total':
			$query = "SELECT YEAR(created_on) AS SalesYear,
				'~' AS SalesMonth,
				SUM(incomes_value) AS TotalSales,
				SUM(taxes) AS TotalTax,
				SUM(charges_value) AS TotalCharges
				FROM {$db->tables['transactions']}
				WHERE YEAR(created_on) = YEAR(CURDATE()) AND turnover_included = 1
				{$additional_where}
				GROUP BY YEAR(created_on)";
			$data = $db->get_results($query);
			break;
		case 'last_year':
			$query = "SELECT YEAR(created_on) AS SalesYear,
			MONTH(created_on) AS SalesMonth,
			SUM(incomes_value) AS TotalSales,
			SUM(taxes) AS TotalTax,
			SUM(charges_value) AS TotalCharges
			FROM {$db->tables['transactions']}
			WHERE YEAR(created_on) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) AND turnover_included = 1
			{$additional_where}
			GROUP BY YEAR(created_on), MONTH(created_on)
			ORDER BY YEAR(created_on), MONTH(created_on)";
			$data = $db->get_results($query);
			break;
		case 'last_year_total':
			$query = "SELECT YEAR(created_on) AS SalesYear,
			'~' AS SalesMonth,
			SUM(incomes_value) AS TotalSales,
			SUM(taxes) AS TotalTax,
			SUM(charges_value) AS TotalCharges
			FROM {$db->tables['transactions']}
			WHERE YEAR(created_on) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) AND turnover_included = 1
			{$additional_where}
			GROUP BY YEAR(created_on)";
			$data = $db->get_results($query);
			break;
		case 'all_dates':
			$query = "SELECT YEAR(created_on) AS SalesYear,
			MONTH(created_on) AS SalesMonth,
			SUM(incomes_value) AS TotalSales,
			SUM(taxes) AS TotalTax,
			SUM(charges_value) AS TotalCharges
			FROM {$db->tables['transactions']}
			WHERE YEAR(created_on) IS NOT NULL AND turnover_included = 1
			{$additional_where}
			GROUP BY YEAR(created_on), MONTH(created_on)
			ORDER BY YEAR(created_on), MONTH(created_on)";
			$data = $db->get_results($query);
			break;
		default:
			$query = "SELECT YEAR(created_on) AS SalesYear,
				MONTH(created_on) AS SalesMonth,
				SUM(incomes_value) AS TotalSales,
				SUM(taxes) AS TotalTax,
				SUM(charges_value) AS TotalCharges
				FROM {$db->tables['transactions']}
				WHERE created_on >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH AND turnover_included = 1
				{$additional_where}
				GROUP BY YEAR(created_on), MONTH(created_on)
				ORDER BY YEAR(created_on), MONTH(created_on)";
			$data  = $db->get_results($query);;
			break;
	}
	if ($data && !$filter)
	{
		foreach ($data as $value) 
		{
			$accounting[] = array(
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'incomes' => floatval($value->TotalSales),
				'taxes' => floatval($value->TotalTax),			
				'charges' => floatval($value->TotalCharges)			
			);
		}
		return $accounting;
	}
	elseif ($data && $filter == 'incomes')
	{
		foreach ($data as $value) 
		{
			$incomes += floatval($value->TotalSales);
		}
		return $incomes;
	}
	else
	{
		return false;
	}
}
// ------------------------------------------------------------------------
/**
 * Homepage quick stats. Uses fixed date range
 * This month and previous month
 * @param type|bool $interval 
 * @return type|array
 */
function home_chart_invoiced_items_count($interval = false)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}
	switch ($interval) {
		case 'last_month':
			$query = "SELECT I.item_sku AS sku,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_quantity ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_quantity ELSE 0 End) AS quantity,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_subtotal ELSE 0 End) AS value
			FROM {$db->tables['invoices_items']} I
			WHERE MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}
			GROUP BY item_sku 
			ORDER BY quantity DESC";
			return $db->get_results($query);
		case 'this_month':
			$query = "SELECT I.item_sku AS sku,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_quantity ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_quantity ELSE 0 End) AS quantity,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_subtotal ELSE 0 End) AS value
			FROM {$db->tables['invoices_items']} I
			WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
			AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP) {$additional_where}
			GROUP BY item_sku
			ORDER BY quantity DESC";
			return $db->get_results($query);
		default:
			$query = "SELECT I.item_sku AS sku,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_quantity ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_quantity ELSE 0 End) AS quantity,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_subtotal ELSE 0 End) AS value
			FROM {$db->tables['invoices_items']} I
			WHERE MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}
			GROUP BY item_sku 
			ORDER BY quantity DESC";
			return $db->get_results($query);
	}
}
/**
 * Function to count invoiced items
 * Uses dynamic date range
 * @param date $start 
 * @param date $end 
 * @return type|array
 */
function invoiced_items_count($start, $end)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$query = "SELECT I.item_sku AS sku,
	SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_quantity ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_quantity ELSE 0 End) AS quantity,
	SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_subtotal ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
		THEN item_subtotal ELSE 0 End) AS value
	FROM {$db->tables['invoices_items']} I
	WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
	GROUP BY item_sku 
	ORDER BY quantity DESC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_income($interval = false)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}
	global $db;
	$results = [];
	switch ($interval) {
		case 'last_year':
			$query = "SELECT SUM(amount_paid) - SUM(tax_amount) AS Incomes
							FROM {$db->tables['invoices']}
							WHERE YEAR(date_paid) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) {$additional_where}";
			$results = $db->get_results($query);
			break;
		case 'this_year':
			$query = "SELECT SUM(amount_paid) - SUM(tax_amount) AS Incomes 
						FROM {$db->tables['invoices']} 
						WHERE YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP) {$additional_where}";
			$results = $db->get_results($query);
			break;
		case 'last_month':
			$query = "SELECT SUM(amount_paid) - SUM(tax_amount) AS Incomes 
						FROM {$db->tables['invoices']}
						WHERE MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}";
			$results = $db->get_results($query);
			break;
		case 'this_month':
			$query = "SELECT SUM(amount_paid) - SUM(tax_amount) AS Incomes
							FROM {$db->tables['invoices']}
							WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
							AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP) {$additional_where}";
			$results = $db->get_results($query);
			break;
		
		default:
			$query = "SELECT SUM(amount_paid) - SUM(tax_amount) AS Incomes 
						FROM {$db->tables['invoices']}
						WHERE YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP) {$additional_where}";
			$results = $db->get_results($query);
			break;
	}
	if ($results)
	{
		foreach ($results as $value) {
			return floatval($value->Incomes);
		}
	}
}

// ------------------------------------------------------------------------
function annual_incomes_progression()
{
	if (get_income('this_year') == 0)
	{
		$progression = 0;
	}
	else
	{
		if (get_income('last_year') != 0)
		{
			$progression = 100 * ( floatval(get_income('this_year')) - floatval(get_income('last_year') )) / floatval(get_income('last_year') );
		}
		else
		{
			$progression = 0;
		}
	}
	return number_format($progression, 2);
}
// ------------------------------------------------------------------------
function incomes_progession($start)
{
	if (!get_income($start))
	{
		$progression = 0;
	}
	else
	{
		$progression = 100 * ( floatval(get_income('this_month')) - floatval(get_income($start) )) / floatval(get_income($start) );
	}
	return number_format($progression, 2);
}
// ------------------------------------------------------------------------
function money_preferences($key=null)
{
	$results = array(
			'user_currency' => (!get_option('user_currency')) ? 'EUR' : get_option('user_currency'),
			'currency_symbol' => (!get_currencies(get_option('user_currency'), 'symbol') ? '€' : get_currencies(get_option('user_currency'), 'symbol')),
			'number_format' => (!get_option('number_format')) ? '4' : get_option('number_format'),
			'currency_placement' => (!get_option('currency_placement')) ? 'after' : get_option('currency_placement')
		);

	if(!$key)
	{
		return $results;
	}
	else
	{
		foreach ($results as $k => $v) {
			if($k === $key)
			{
				return $v;
			}
		}
	}
}
// ------------------------------------------------------------------------
function get_base_currency()
{
	return get_option('user_currency');
}
// ------------------------------------------------------------------------
function get_all_items($status=null)
{
	global $db;
	if (!$status)
	{
		$query = "SELECT * 
						FROM {$db->tables['items']} AS I 
						LEFT JOIN {$db->tables['items_groups']} AS G 
						ON I.group_id = G.group_id 
						LEFT JOIN {$db->tables['taxes']} AS T 
						ON I.tax_id = T.id
						LEFT JOIN {$db->tables['uom']} AS U 
						ON I.uom_id = U.id
						LEFT JOIN {$db->tables['hsn_sac']} AS N 
						ON I.hsn_sac_id = N.id
						LEFT JOIN {$db->tables['cgst']} AS C
						ON I.cgst_id = C.id
						LEFT JOIN {$db->tables['sgst']} AS S
						ON I.sgst_id = S.id
						LEFT JOIN {$db->tables['igst']} AS H
						ON I.igst_id = H.id
						LEFT JOIN {$db->tables['cess']} AS M
						ON I.cess_id = M.id";
		return $db->get_results($query);
	}
	else
	{
		$query = "SELECT * 
						FROM {$db->tables['items']} AS I 
						LEFT JOIN {$db->tables['items_groups']} AS G 
						ON I.group_id = G.group_id 
						LEFT JOIN {$db->tables['taxes']} AS T 
						ON I.tax_id = T.id
						LEFT JOIN {$db->tables['uom']} AS U 
						ON I.uom_id = U.id
						LEFT JOIN {$db->tables['hsn_sac']} AS N 
						ON I.hsn_sac_id = N.id
						LEFT JOIN {$db->tables['cgst']} AS C
						ON I.cgst_id = C.id
						LEFT JOIN {$db->tables['sgst']} AS S
						ON I.sgst_id = S.id
						LEFT JOIN {$db->tables['igst']} AS H
						ON I.igst_id = H.id
						LEFT JOIN {$db->tables['cess']} AS M
						ON I.cess_id = M.id
						WHERE I.item_status = {$status}";
		return $db->get_results($query);
	}
}
// ------------------------------------------------------------------------
/**
 * Description
 * @return type
 */
function generate_sku()
{
	$CI = & get_instance();
	$CI->load->helper('string');
	$sku = random_string('alpha', 3);
	$sku .= '-';
	$sku .= random_string('alnum', 3);
	$sku .= '-';
	$sku .= random_string('alpha', 1);
	$sku .= random_string('numeric', 2);

	return strtoupper($sku);
}
// ------------------------------------------------------------------------
function get_due_date()
{
	global $db;
	$query = "SELECT due_date AS dueDate,
	SUM(total) AS value
	FROM {$db->tables['invoices']}
	WHERE due_date IS NOT NULL
	GROUP BY due_date 
	ORDER BY due_date ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_options()
{
	$return = [];
	if ( db_table_exists('oc_options')) {
		global $db;
		db_reconnect();
		
		$query = "SELECT * FROM {$db->tables['options']}";
		$return = $db->get_results($query);
	}
	return $return;
}
// ------------------------------------------------------------------------
function get_option_id($option_name, $table=null)
{
	$options_ids = [];
	if ( !$table)
	{
		$options = get_options();
		if ($options)
		{
			foreach ($options as $option) 
			{
				$options_ids[$option->option_name] = $option->option_id;
			}
		}
	}
	return array_key_exists($option_name, $options_ids) ? $options_ids[$option_name] : false;
}
// ------------------------------------------------------------------------
function set_option($db_data, $table=null)
{
	global $db;
	$table = isset($table) ? $table : 'options';
	$option_name = isset($db_data['option_name']) ? $db_data['option_name'] : false;
	$primary_key = 'option_id';
	$option_id = get_option_id($option_name);
	
	if ( !$option_id )
	{
		$query = "INSERT INTO {$db->tables[$table]} SET ". $db->get_set($db_data);
		return $db->query($query);
	}
	else
	{
		$query = "UPDATE {$db->tables[$table]}
						SET " . $db->get_set($db_data) . 
						" WHERE {$primary_key} = {$option_id}";
		return $db->query($query);
	}
}
// ------------------------------------------------------------------------
function option_value($options, $key)
{
	foreach ($options as $value) {
	   if ($value->option_name === $key)
	   {
	   		return $value->option_value;
	   }
	}
	return '';
}
// ------------------------------------------------------------------------
function get_users()
{
	global $db;
	$query = "SELECT id, email, created_on, last_login, active, first_name, last_name FROM {$db->tables['users']}";
	return $db->get_results($query);
}
// Ci email
// ------------------------------------------------------------------------
// function send_email($to, $message, $subject=null, $from=null, $cc=null, $attachment=null)
// {
// 	if (1 != get_option('turn_off_notifications')) {
// 		$CI =& get_instance();
// 		$CI->load->library('email');

// 		// Get smtp settings if defined protocol
// 		if( get_option('email_settings') === "smtp")
// 		{
// 			$config['protocol'] = 'smtp';
// 			$settings = json_decode(get_option('smtp_settings'));
// 			foreach ($settings as $key => $conf) {
// 				$config[$key] = $conf;
// 			}
// 		}
// 		else
// 		{
// 			$config['protocol'] = 'mail';
// 		}
// 		$config['mailpath'] = '/usr/sbin/sendmail';
// 		$config['charset'] = 'utf-8';
// 		$config['wordwrap'] = TRUE;
// 		$config['mailtype'] = 'html';
// 		$config['validate'] = 'true';

// 		$CI->email->initialize($config);
// 		$CI->email->from(isset($from) ? $from : get_option('email'), null == get_option('company') ? get_option('email') : get_option('company'));
// 		$CI->email->to($to);
// 		if(isset($cc))
// 		{
// 			$CI->email->cc($cc);
// 		}
// 		if(isset($attachment))
// 		{
// 			$CI->email->cc($cc);
// 			$CI->email->attach($attachment, 'inline');
// 		}
// 		$CI->email->subject(isset($subject) ? $subject : __('no_subject'));
// 		$CI->email->message($message);
// 		$CI->email->send();
// 	}
// }
// ------------------------------------------------------------------------
function send_email($to, $message, $subject=null, $from=null, $cc=null, $attachment=null, $name=null)
{
	if (1 != get_option('turn_off_notifications')) {
		mm_send_mail($to, $message, $subject, $from, $cc, $attachment, $name);
	}
}
// ------------------------------------------------------------------------
function get_clients_address()
{
	global $db;
	$query = "SELECT name_company, client_address1, client_city, client_postcode, client_country FROM {$db->tables['clients']}";
	return $db->get_results($query);
}

// ------------------------------------------------------------------------
function purchased_from_guest($purchase_number)
{
	global $db;
	return $db->get_row("SELECT provider_id FROM {$db->tables['purchases']} WHERE purchase_number={$purchase_number}")->provider_id;
}
// ------------------------------------------------------------------------
function quoted_to_guest($quote_number)
{
	global $db;
	return $db->get_row("SELECT client_id FROM {$db->tables['quotes']} WHERE quote_number={$quote_number}")->client_id;
}
// ------------------------------------------------------------------------
function is_active_client($id)
{
	global $db;
	return null === $db->get_row("SELECT client_status FROM {$db->tables['clients']} WHERE client_status={$id}")->client_status;
}
// ------------------------------------------------------------------------
function activate($table, $col, $primary_key, $id)
{
	global $db;
	$query = "UPDATE {$db->tables[$table]}
		SET " . $db->get_set(array($col => 1)) . 
		" WHERE $primary_key = {$id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function desactivate($table, $col, $primary_key, $id)
{
	global $db;
	$query = "UPDATE {$db->tables[$table]}
		SET " . $db->get_set(array($col => 0)) . 
		" WHERE $primary_key = {$id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function update_quote_status($quote_number, $status)
{
	$quote = get_quote_by_number($quote_number);
	$quote_id = 0;
	if ($quote)
	{
		foreach ($quote as $k => $v) {
			$quote_id = $v->id;
		}
	}
	global $db;
	$query = "UPDATE {$db->tables['quotes']}
		SET " . $db->get_set(array('quote_status' => $status)) . 
		" WHERE id = {$quote_id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function update_purchase_status($purchase_number, $status)
{
	$purchase = get_purchase_by_number($purchase_number);
	$purchase_id = 0;
	if ($purchase)
	{
		foreach ($purchase as $k => $v) {
			$purchase_id = $v->id;
		}
	}
	global $db;
	$query = "UPDATE {$db->tables['purchases']}
		SET " . $db->get_set(array('purchase_status' => $status)) . 
		" WHERE id = {$purchase_id}";
	$db->query($query);
}

// ------------------------------------------------------------------------
function update_payment_id($invoice_number, $payment_id)
{
	$invoice = get_invoice_by_number($invoice_number);
	$invoice_id = 0;
	if ($invoice)
	{
		foreach ($invoice as $k => $v) {
			$invoice_id = $v->id;
		}
	}
	global $db;
	$query = "UPDATE {$db->tables['invoices']}
		SET " . $db->get_set(array('payment_id' => $payment_id)) . 
		" WHERE id = {$invoice_id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function import_quoted_items($quote_number)
{
	global $db;
	return $db->get_results("SELECT * FROM {$db->tables['quotes_items']} WHERE quote_number = {$quote_number}");
}
// ------------------------------------------------------------------------
function is_approved($quote_number)
{
	global $db;
	return 'Accepted' === $db->get_row("SELECT quote_status FROM {$db->tables['quotes']} WHERE quote_number = {$quote_number}")->quote_status;
}
// ------------------------------------------------------------------------
/**
 * Add Currency and money format
 * @param type $number 
 * @param type|null $client_id 
 * @return type mixed
 * @since 1.5
 */
function add_currency($number, $client_id=null, $context='')
{
	if ( ! $client_id || null == client( $client_id, 'client_currency') )
	{
		$currency = get_currencies( get_option('user_currency'), 'symbol' );
	}
	else
	{
		$currency_str = client($client_id, 'client_currency');
		$currency = get_currencies($currency_str, 'symbol');
	}

	$position = get_option('currency_placement');
	switch ($position) {
		case 'after':
			return htmlentities($context.$number . ' ' . $currency);
			break;
		case 'before':
			return htmlentities($currency. ' '.$context.$number);
			break;
		case 'none':
			return htmlentities($context.$number);
			break;
		
		default:
			return htmlentities($currency. ' ' .$context. $number);
			break;
	}
}
// ------------------------------------------------------------------------
function add_provider_currency($number, $provider_id=null)
{
	if ( ! $provider_id || null == provider( $provider_id, 'provider_currency') )
	{
		$currency = get_currencies( get_option('user_currency'), 'symbol' );
	}
	else
	{
		$currency_str = provider($provider_id, 'provider_currency');
		$currency = get_currencies($currency_str, 'symbol');
	}

	$position = get_option('currency_placement');
	switch ($position) {
		case 'after':
			return $number . ' ' . $currency;
			break;
		case 'before':
			return $currency. ' '.$number;
			break;
		case 'none':
			return $number;
			break;
		
		default:
			return $currency. ' ' . $number;
			break;
	}
}
// ------------------------------------------------------------------------
function language_code_to_string($language_code)
{
	switch ($language_code) {
		case 'fr-FR':
			return 'french';
			break;
		case 'du-DU':
			return 'dutch';
			break;
		case 'en-US':
			return 'english';
			break;
		case 'sv-SE':
			return 'swedish';
			break;
		case 'en-GB':
			return 'english-gb';
			break;
		case 'ru-RU':
			return 'russian';
			break;
		case 'ro':
			return 'romanian';
			break;
		case 'de-DE':
			return 'german';
			break;
		case 'es-ES':
			return 'spanish';
			break;
		case 'it-IT':
			return 'italian';
			break;
		case 'ar-AR':
			return 'arabic';
			break;
		case 'el-EL':
			return 'greek';
			break;
		default:
			return 'english';
			break;
	}
}
// ------------------------------------------------------------------------
function language_string_to_code($language_string)
{
	switch ($language_string) {
		case 'french':
			return 'fr-FR';
			break;
		case 'english':
			return 'en-US';
			break;
		case 'swedish':
			return 'sv-SE';
			break;
		case 'english-gb':
			return 'en-GB';
			break;
		case 'russian':
			return 'ru-RU';
			break;
		case 'romanian':
			return 'ro';
			break;
		case 'german':
			return 'de-DE';
			break;
		case 'spanish':
			return 'es-ES';
			break;
		case 'arabic':
			return 'ar-AR';
			break;
		case 'greek':
			return 'el-EL';
			break;
		case 'italian':
			return 'it-IT';
			break;
		case 'dutch':
			return 'nl-NL';
			break;
		default:
			return 'en-US';
			break;
	}
}
// ------------------------------------------------------------------------
function language_string_to_locale_notation($language_string)
{
	switch ($language_string) {
		case 'french':
			return 'fr_FR';
			break;
		case 'english':
			return 'en_US';
			break;
		case 'english-gb':
			return 'en_GB';
			break;
		case 'russian':
			return 'ru_RU';
			break;
		case 'german':
			return 'de_DE';
			break;
		case 'spanish':
			return 'es_ES';
			break;
		case 'italian':
			return 'it_IT';
			break;
		case 'arabic':
			return 'ar_AR';
			break;
		case 'dutch':
			return 'nl_NL';
			break;
		case 'greek':
			return 'el_EL';
			break;
		case 'romanian':
			return 'ro';
			break;
		default:
			return 'en_US';
			break;
	}
}
// ------------------------------------------------------------------------
function cron_command()
{
	return base_url('index.php/cron');
}
// ------------------------------------------------------------------------
function sku_to_name($sku)
{
	global $db;
	return $db->get_row("SELECT name FROM {$db->tables['items']} WHERE sku='{$sku}'") ?
	$db->get_row("SELECT name FROM {$db->tables['items']} WHERE sku='{$sku}'")->name : "";
}
// ------------------------------------------------------------------------
function get_user_avatar($id = false)
{
	if (!$id)
	{
		$id = 1;
	}
	global $db;
	return $db->get_row("SELECT user_avatar FROM {$db->tables['users']} WHERE id = {$id}")->user_avatar;
}
// ------------------------------------------------------------------------
function col_exists($table, $fieldname)
{
	global $db;

	return boolval($db->query("SHOW COLUMNS FROM {$db->tables[$table]} LIKE '{$fieldname}'"));

}
// ------------------------------------------------------------------------
function db_table_exists($table)
{
	global $db;

	return boolval($db->query("SHOW TABLES LIKE '{$table}'"));

}
// ------------------------------------------------------------------------
function get_payment_methods()
{
	global $db;
	return $db->get_results("SELECT DISTINCT payment_method_name, payment_method_id FROM oc_payment_methods");
}
// ------------------------------------------------------------------------
function get_additional_taxes()
{
	global $db;
	return $db->get_results("SELECT DISTINCT additional_tax_name, id, additional_tax_rate, additional_tax_criteria FROM oc_additional_taxes");
}
// ------------------------------------------------------------------------
function get_purchase_tax($purchase_number)
{
	global $db;
	return $db->get_results("SELECT item_tax_rate AS taxRate, 
		SUM(item_subtotal) * item_tax_rate / 100 AS taxAmount
		FROM {$db->tables['purchases_items']}
		WHERE purchase_number = {$purchase_number}
		AND item_tax_rate > 0
		GROUP BY taxRate
		ORDER BY taxRate ASC");
}
// ------------------------------------------------------------------------
function get_quote_tax($quote_number)
{
	global $db;
	return $db->get_results("SELECT item_tax_rate AS taxRate, 
		SUM(item_subtotal) * item_tax_rate / 100 AS taxAmount
		FROM {$db->tables['quotes_items']}
		WHERE quote_number = {$quote_number}
		AND item_tax_rate > 0
		GROUP BY taxRate
		ORDER BY taxRate ASC");
}
// ------------------------------------------------------------------------
function get_client($invoice_number)
{
	global $db;
	return $db->get_row("SELECT client_id FROM {$db->tables['invoices']} WHERE invoice_number = {$invoice_number}")->client_id;
}
// ------------------------------------------------------------------------
function payment_method_str($id)
{
	$payment_methods = get_payment_methods();
	if ($payment_methods)
	{
		foreach ($payment_methods as $value) {
			if($value->payment_method_id == $id)
			{
				return $value->payment_method_name;
			}
		}
	}
}
// ------------------------------------------------------------------------
function get_item_description($item_id = null, $item_name = null)
{
	global $db;

	$key = isset($item_id) ? 'item_id' : 'name';
	$search = isset($item_id) ? $item_id : $item_name;
	$description = "";
	if ($key == 'item_id') {
		$result = $db->get_row("SELECT description FROM {$db->tables['items']} WHERE item_id='{$item_id}'");
	} else {
		$result = $db->get_row("SELECT description FROM {$db->tables['items']} WHERE name LIKE '{$item_name}'");
	}
	if ($result) {
		$description = $result->description;
	}
	return $description;
}
// ------------------------------------------------------------------------
function count_clients($status, $period=null)
{
	global $db;

	$rbac = new Rbac;
	if ( $rbac->check('customer_owner', USERID) AND ! $rbac->check('customer_access_any', USERID)) {
		$where = ' WHERE user_id = '. USERID;
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$where = '';
		$additional_where = '';
	}

	$status = trim($status);
	if($status == 'all')
	{
		switch ($period) {
			case 'last_year':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE YEAR(client_date_created) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) {$additional_where}";
				$results = $db->get_results($query);
				break;
			case 'this_year':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE YEAR(client_date_created) = YEAR(CURRENT_TIMESTAMP) {$additional_where}";
				$results = $db->get_results($query);
				break;
			case 'last_month':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE MONTH(client_date_created) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(client_date_created) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}";
				$results = $db->get_results($query);
				break;
			case 'this_month':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE MONTH(client_date_created) = MONTH(CURRENT_TIMESTAMP) 
						AND YEAR(client_date_created) = YEAR(CURRENT_TIMESTAMP) {$additional_where}";
				$results = $db->get_results($query);
				break;
			default:
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} {$where}";
				$results = $db->get_results($query);
				break;
		}
	}
	else
	{
		if($status == 'active')
		{
			$status = 1;
		}
		elseif($status == 'inactive')
		{
			$status = 0;
		}
		switch ($period) {
			case 'last_year':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE client_status='$status' AND YEAR(client_date_created) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) {$additional_where}";
				$results = $db->get_results($query);
				break;
			case 'this_year':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE client_status='$status' AND YEAR(client_date_created) = YEAR(CURRENT_TIMESTAMP) {$additional_where}";
				$results = $db->get_results($query);
				break;
			case 'last_month':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE client_status='$status' AND MONTH(client_date_created) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(client_date_created) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}";
				$results = $db->get_results($query);
				break;
			case 'this_month':
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']} 
						WHERE client_status='$status' AND MONTH(client_date_created) = MONTH(CURRENT_TIMESTAMP) 
						AND YEAR(client_date_created) = YEAR(CURRENT_TIMESTAMP) {$additional_where}";
				$results = $db->get_results($query);
				break;
			
			default:
				$query = "SELECT COUNT(client_status) AS value 
						FROM {$db->tables['clients']}
						WHERE client_status='$status' {$additional_where}";
				$results = $db->get_results($query);
				break;
		}
	}
	if ($results)
	{
		foreach ($results as $value) {
			return intval($value->value);
		}
	}
	return false;
}
// ------------------------------------------------------------------------
function has_password($client_id)
{
	global $db;
	return null != $db->get_row("SELECT client_password FROM {$db->tables['clients']} WHERE client_id={$client_id}")->client_password;
}
// ------------------------------------------------------------------------
function provider_has_password($provider_id)
{
	global $db;
	return null != $db->get_row("SELECT provider_password FROM {$db->tables['providers']} WHERE provider_id={$provider_id}")->provider_password;
}
// ------------------------------------------------------------------------
function generate_password()
{
	$CI = & get_instance();
	$CI->load->helper('string');
	$pwd = random_string('alnum', 6);
	return $pwd;
}
// ------------------------------------------------------------------------
/**
 * Get change rate for a given client
 */
function get_change_rate($currency_str)
{
	$CI = & get_instance();
	$CI->load->library('m_manager');
	return $CI->m_manager->get_change_rate($currency_str);
}
// ------------------------------------------------------------------------
function lang_code_to_string($code)
{
	switch ($code) {
		case 'en_US':
			return 'english';
			break;
		case 'sv_SE':
			return 'swedish';
			break;
		case 'en_GB':
			return 'english-gb';
			break;
		case 'fr_FR':
			return 'french';
			break;
		case 'nl_NL':
			return 'dutch';
			break;
		case 'de_DE':
			return 'german';
			break;
		case 'ru_RU':
			return 'russian';
			break;
		case 'es_ES':
			return 'spanish';
			break;
		case 'ar_AR':
			return 'arabic';
			break;
		case 'el_EL':
			return 'greek';
			break;
		case 'ro':
			return 'romanian';
			break;
		case 'it_IT':
			return 'italian';
			break;
		default:
			return 'english';
			break;
	}
}
// ------------------------------------------------------------------------
/**
 * There was a typo in the notification language code
 * en-US instead of en_US ...
 */
function lang_code_to_notif_string($code)
{
	switch ($code) {
		case 'en_US':
			return 'en-US';
			break;
		case 'sv_SE':
			return 'sv-SE';
			break;
		case 'en_GB':
			return 'en-GB';
			break;
		case 'fr_FR':
			return 'fr-FR';
			break;
		case 'nl_NL':
			return 'nl-NL';
			break;
		case 'de_DE':
			return 'de-DE';
			break;
		case 'ru_RU':
			return 'ru-RU';
			break;
		case 'ro':
			return 'ro';
			break;
		case 'es_ES':
			return 'es-ES';
			break;
		case 'ar_AR':
			return 'ar-AR';
			break;
		case 'el_EL':
			return 'el-EL';
			break;
		case 'it_IT':
			return 'it-IT';
			break;
		default:
			return 'en-US';
			break;
	}
}
// ------------------------------------------------------------------------
function get_tax($tax_id=null, $field=null)
{
	global $db;
	$results = $db->get_results("SELECT * FROM oc_taxes");
	if(!$tax_id)
	{
		return $results;
	}
	else
	{
		if($tax_id && !$field)
		{
			foreach ($results as $value) {
				if ($tax_id == $value->id)
				{
					return $value;
				}
			}
		}
		else
		{
			foreach ($results as $value) {
				if ($tax_id == $value->id)
				{
					return $value->{$field};
				}
			}
		}
	}
}
function get_tax_id($value)
{
	global $db;
	return $db->get_row("SELECT id FROM oc_taxes WHERE tax_percent = '{$value}'")->id;
}
// ------------------------------------------------------------------------
function record_notes($post_array, $primary_key=null, $id=null)
{
	global $db;
	$db_data = array(
		'note_title'			=> isset($post_array['note_title']) ? $post_array['note_title']: "", 
		'note_message'			=> isset($post_array['note_message']) ? $post_array['note_message'] : "", 
		'note_referrer_key'		=> isset($post_array['note_referrer_key']) ? $post_array['note_referrer_key']: "",
		'note_referrer_id'	    => isset($post_array['note_referrer_id']) ? $post_array['note_referrer_id']: "",
		'note_referrer_value'	=> isset($post_array['note_referrer_value']) ? $post_array['note_referrer_value']: "",
		'user_id'		    	=> isset($post_array['user_id']) ? $post_array['user_id']: user('id'), 
		'updated_by'		    => isset($post_array['updated_by']) ? $post_array['updated_by']: user('id'), 
		'note_created_on'		=> isset($post_array['note_created_on']) ? $post_array['note_created_on']: date('Y-m-d')
	);
	if (!$id)
	{
		$db->query("INSERT INTO {$db->tables['notes']} SET ".$db->get_set($db_data));
	}
	else
	{
		if ($db->get_results("SELECT {$primary_key} FROM {$db->tables['notes']} WHERE {$primary_key}={$id}"))
		{
			$db->query("UPDATE {$db->tables['notes']} SET ".$db->get_set($db_data)." WHERE {$primary_key} = {$id}");
		}
		else
		{
			$db->query("INSERT INTO {$db->tables['notes']} SET ".$db->get_set($db_data));
		}
	}
}
// ------------------------------------------------------------------------
function get_user_var($id, $var=null)
{
	global $db;
	if ( !$id) {
		return (object)[];
	}
	if(!$var)
	{
		return $db->get_results("SELECT * FROM users where id={$id}");
	}
	else
	{
		return $db->get_row("SELECT {$var} FROM users where id={$id}")->$var;
	}
}
function get_user_var_by_name($key, $name, $var=null)
{
	global $db;
	$name = addslashes($name);

	if ( !$key) {
		return (object)[];
	}
	if(!$var)
	{
		return $db->get_results("SELECT * FROM users where $key LIKE '{$name}'");
	}
	else
	{
		return $db->get_row("SELECT {$var} FROM users where $key LIKE '{$name}'")->$var;
	}
}
// ------------------------------------------------------------------------
function record_event($event)
{
	$db_data = array(
		'action' 					=> $event['action'],
		'referrer' 					=> $event['referrer'],
		'referrer_id' 				=> $event['referrer_id'],
		'referrer_value' 			=> $event['referrer_value'],
		'user_id' 					=> isset($event['user_id']) ? intval($event['user_id']) : intval(0),
		'client_id' 				=> isset($event['client_id']) ? intval($event['client_id']) : intval(0),
		'status' 					=> $event['status']
	);
	global $db;
	if ( $event['referrer'] !== 'invoices_items' || $event['referrer'] !== 'payment_methods' || $event['referrer'] !== 'purchases_items' )
	{
		$db->query("INSERT INTO {$db->tables['timeline']} SET ".$db->get_set($db_data));
	}
}
// ------------------------------------------------------------------------
function get_events($start, $end)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}
	global $db;
	$query = "SELECT * FROM {$db->tables['timeline']}
				WHERE referrer not LIKE '%invoices_items%'
				AND referrer not LIKE '%quotes_items%'
				AND referrer not LIKE '%orders_items%'
				AND created_on BETWEEN '{$start}' AND '{$end}'
				{$additional_where}
				ORDER BY id DESC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function client_exists($client_id)
{
	global $db;
	return !null == $db->query("SELECT client_id FROM {$db->tables['clients']} WHERE client_id={$client_id}");
}
// ------------------------------------------------------------------------
/**
 * Get the name var for timeline
 */
function get_name_var($table, $id)
{
	global $db;
	switch ($table) {
		case 'options':
			return $db->get_row("SELECT option_name FROM {$db->tables['options']} WHERE option_id={$id}")->option_name;
			break;
		case 'users_options':
			return $db->get_row("SELECT option_key FROM {$db->tables['users_options']} WHERE option_id={$id}")->option_key;
			break;
		case 'users':
			return $db->get_row("SELECT first_name FROM {$db->tables['users']} WHERE $id={$id}")->first_name;
			break;
		case 'clients':
			return $db->get_row("SELECT name_company FROM {$db->tables['clients']} WHERE client_id={$id}")->name_company;
			break;
		case 'providers':
			return $db->get_row("SELECT name_company FROM {$db->tables['providers']} WHERE provider_id={$id}")->name_company;
			break;
		case 'invoices':
			return $db->get_row("SELECT invoice_number FROM {$db->tables['invoices']} WHERE id={$id}")->invoice_number;
			break;
		case 'quotes':
			return $db->get_row("SELECT quote_number FROM {$db->tables['quotes']} WHERE id={$id}")->quote_number;
			break;
		case 'items':
			return $db->get_row("SELECT name FROM {$db->tables['items']} WHERE item_id={$id}")->name;
			break;
		case 'items_groups':
			return $db->get_row("SELECT group_name FROM {$db->tables['items_groups']} WHERE group_id={$id}")->group_name;
			break;
		case 'taxes':
			return $db->get_row("SELECT tax_name FROM {$db->tables['taxes']} WHERE id={$id}")->tax_name;
			break;
		case 'charges_categories':
			return $db->get_row("SELECT group_name FROM {$db->tables['charges_categories']} WHERE group_id={$id}")->group_name;
			break;
		case 'incomes_categories':
			return $db->get_row("SELECT group_name FROM {$db->tables['incomes_categories']} WHERE group_id={$id}")->group_name;
			break;
		case 'notes':
			return $db->get_row("SELECT note_title FROM {$db->tables['notes']} WHERE note_id={$id}")->note_title;
			break;
		case 'transactions':
			return $db->get_row("SELECT transaction_id FROM {$db->tables['transactions']} WHERE transaction_id={$id}")->transaction_id;
			break;
	}
}
// ------------------------------------------------------------------------
function update_change_rates()
{
	global $db;
	$currencies = [];
	$base = get_option('user_currency');
	$results = $db->get_results("SELECT DISTINCT client_currency FROM {$db->tables['clients']}");
	if ($results)
	{
		foreach ($results as $cur) {
			array_push($currencies, $cur->client_currency);
		}
	}
	if ($currencies)
	{
		foreach ($currencies as $v) {
			$rate = get_change_rate($v);
			$db->query("UPDATE {$db->tables['clients']} SET ".$db->get_set(array('client_change_rate' => $rate))." WHERE client_currency = '{$v}'");
		 }
	}
}
// ------------------------------------------------------------------------
function tax_report($start, $end)
{
	global $db;

	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	if (! _has_option( 'is_indian' ) )
	{
		$query = "SELECT YEAR(date_paid) AS SalesYear,
			MONTH(date_paid) AS SalesMonth,
			item_tax_rate AS taxRate,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_subtotal ELSE 0 End) AS itemSubtotal,
			(SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_subtotal ELSE 0 End)) * item_tax_rate / 100 AS taxValue
			FROM {$db->tables['invoices_items']}
			WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
			GROUP BY item_tax_rate
			ORDER BY item_tax_rate ASC";
		$data = $db->get_results($query);
		if ($data)
		{
			foreach ($data as $value) 
			{
				$accounting[] = array(
					'year' => $value->SalesYear,
					'month' => $value->SalesMonth,
					'item_subtotal' => floatval($value->itemSubtotal),
					'tax_rate' => floatval($value->taxRate),			
					'tax_value' => floatval($value->taxValue)			
				);
			}
			return $accounting;
		}
	}
	else
	{
		$query = "SELECT YEAR(date_paid) AS SalesYear,
		MONTH(date_paid) AS SalesMonth,
		item_cgst_rate AS cGstTaxRate, 
		item_sgst_rate AS sGstTaxRate, 
		item_igst_rate AS iGstTaxRate,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_subtotal ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_subtotal ELSE 0 End) AS itemSubtotal,
		(SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_subtotal ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_subtotal ELSE 0 End)) * item_cgst_rate / 100 AS cGstTaxValue,
		(SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_subtotal ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_subtotal ELSE 0 End)) * item_sgst_rate / 100 AS sGstTaxValue,
		(SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_subtotal ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_subtotal ELSE 0 End)) * item_igst_rate / 100 AS iGstTaxValue
		FROM {$db->tables['invoices_items']}
		WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
		GROUP BY item_cgst_rate, item_sgst_rate, item_igst_rate
		ORDER BY item_cgst_rate, item_sgst_rate, item_igst_rate ASC";
		$data = $db->get_results($query);
		if ($data)
		{
			foreach ($data as $value) 
			{
				$accounting[] = array(
					'year' => $value->SalesYear,
					'month' => $value->SalesMonth,
					'item_subtotal' => floatval($value->itemSubtotal),
					'cgst_tax_rate' => floatval($value->cGstTaxRate),			
					'sgst_tax_rate' => floatval($value->sGstTaxRate),			
					'igst_tax_rate' => floatval($value->iGstTaxRate),			
					'cgst_tax_value' => floatval($value->cGstTaxValue),			
					'sgst_tax_value' => floatval($value->sGstTaxValue),			
					'igst_tax_value' => floatval($value->iGstTaxValue)			
				);
			}
			return $accounting;
		}
	}
	return $accounting;
}
// ------------------------------------------------------------------------
function additional_taxes_report($start, $end)
{
	global $db;

	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	
	$query = "SELECT YEAR(date_paid) AS SalesYear,
		MONTH(date_paid) AS SalesMonth,
		additional_tax_rate AS taxRate,
		additional_tax_id AS ID,
		invoice_number AS invoice_number,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN invoice_subtotal ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN invoice_subtotal ELSE 0 End) AS itemSubtotal,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN invoice_tax_amount ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
			THEN invoice_tax_amount ELSE 0 End) AS invoiceTaxAmount,
		(SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN invoice_surcharge_amount ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
			THEN invoice_surcharge_amount ELSE 0 End)) AS surchargetaxValue,
		(SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN invoice_deduct_amount ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
			THEN invoice_deduct_amount ELSE 0 End)) AS deductTaxValue
		FROM {$db->tables['additional_taxes_meta']}
		WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
		GROUP BY additional_tax_rate
		ORDER BY additional_tax_rate ASC";
	$data = $db->get_results($query);
	if ($data)
	{
		foreach ($data as $value) 
		{
			$tax_value = 0 != $value->deductTaxValue ?  $value->deductTaxValue : $value->surchargetaxValue;
			if (get_additional_tax($value->ID, 'additional_tax_criteria') == 'add_after_all_taxes') {
				$subtotal = floatval($value->itemSubtotal + $value->invoiceTaxAmount);
			}
			if (get_additional_tax($value->ID, 'additional_tax_criteria') == 'deduct_after_all_taxes') {
				$subtotal = floatval($value->itemSubtotal + $value->invoiceTaxAmount + get_invoice_surcharge($value->invoice_number));
			}
			$accounting[] = array(
				'name' => get_additional_tax($value->ID, 'additional_tax_name'),
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'item_subtotal' => $subtotal,
				'tax_amount' => floatval($value->itemSubtotal),
				'tax_rate' => floatval($value->taxRate),
				'tax_value' => floatval($tax_value)			
			);
		}
		return $accounting;
	}
	return $accounting;
}

// ------------------------------------------------------------------------
function tax_report_cgst($start, $end)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	$query = "SELECT YEAR(date_paid) AS SalesYear,
	MONTH(date_paid) AS SalesMonth,
	item_cgst_rate AS cGstTaxRate,
	SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_subtotal ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_subtotal ELSE 0 End) AS itemSubtotal,
	(SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_subtotal ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
		THEN item_subtotal ELSE 0 End)) * item_cgst_rate / 100 AS cGstTaxValue
  	FROM {$db->tables['invoices_items']}
	WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
	GROUP BY item_cgst_rate
	ORDER BY item_cgst_rate ASC";
	$data = $db->get_results($query);
	if ($data)
	{
		foreach ($data as $value) 
		{
			$accounting[] = array(
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'item_subtotal' => floatval($value->itemSubtotal),
				'cgst_tax_rate' => floatval($value->cGstTaxRate),			
 				'cgst_tax_value' => floatval($value->cGstTaxValue)		
 			);
		}
		return $accounting;
	}
	return $accounting;
}
// ------------------------------------------------------------------------
function tax_report_sgst($start, $end)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	$query = "SELECT YEAR(date_paid) AS SalesYear,
	MONTH(date_paid) AS SalesMonth,
	item_sgst_rate AS sGstTaxRate,
	SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_subtotal ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_subtotal ELSE 0 End) AS itemSubtotal,
	(SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_subtotal ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
		THEN item_subtotal ELSE 0 End)) * item_sgst_rate / 100 AS sGstTaxValue
  	FROM {$db->tables['invoices_items']}
	WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
	GROUP BY item_sgst_rate
	ORDER BY item_sgst_rate ASC";
	$data = $db->get_results($query);
	if ($data)
	{
		foreach ($data as $value) 
		{
			$accounting[] = array(
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'item_subtotal' => floatval($value->itemSubtotal),
				'sgst_tax_rate' => floatval($value->sGstTaxRate),			
 				'sgst_tax_value' => floatval($value->sGstTaxValue)		
 			);
		}
		return $accounting;
	}
	return $accounting;
}
// ------------------------------------------------------------------------
function tax_report_igst($start, $end)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	$query = "SELECT YEAR(date_paid) AS SalesYear,
	MONTH(date_paid) AS SalesMonth,
	item_igst_rate AS iGstTaxRate,
	SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_subtotal ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
			THEN item_subtotal ELSE 0 End) AS itemSubtotal,
	(SUM(CASE WHEN invoice_is_cancelled = 0 
		THEN item_subtotal ELSE 0 End) - 
	SUM(CASE WHEN invoice_is_cancelled = 1
		THEN item_subtotal ELSE 0 End)) * item_igst_rate / 100 AS iGstTaxValue
  	FROM {$db->tables['invoices_items']}
	WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
	GROUP BY item_igst_rate
	ORDER BY item_igst_rate ASC";
	$data = $db->get_results($query);
	if ($data)
	{
		foreach ($data as $value) 
		{
			$accounting[] = array(
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'item_subtotal' => floatval($value->itemSubtotal),
				'igst_tax_rate' => floatval($value->iGstTaxRate),			
 				'igst_tax_value' => floatval($value->iGstTaxValue)		
 			);
		}
		return $accounting;
	}
	return $accounting;
}
// ------------------------------------------------------------------------
function monthly_orders_report($start, $end)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	$query = "SELECT YEAR(created_on) AS SalesYear,
		MONTH(created_on) AS SalesMonth,
		SUM(incomes_value) AS itemSubtotal,
		SUM(taxes) AS taxValue,
		SUM(charges_value) AS TotalCharges,
		SUM(incomes_value + taxes) AS TotalWithTax
		FROM {$db->tables['transactions']}
		WHERE created_on BETWEEN '{$start}' AND '{$end}' AND turnover_included = 1 {$additional_where} 
		GROUP BY YEAR(created_on), MONTH(created_on)
		ORDER BY YEAR(created_on), MONTH(created_on)";
	$data = $db->get_results($query);
	if ($data)
	{
		foreach ($data as $value) 
		{
			$accounting[] = array(
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'item_subtotal' => floatval($value->itemSubtotal),
				'tax_value' => floatval($value->taxValue),
				'total_with_tax' => floatval($value->TotalWithTax)
			);
		}
	}
	return $accounting;
}
// ------------------------------------------------------------------------
function get_tax_totals($start, $end, $var=null)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$totals = [];
	$query = "SELECT YEAR(created_on) AS SalesYear,
		MONTH(created_on) AS SalesMonth,
		SUM(incomes_value) AS itemSubtotal,
		SUM(taxes) AS taxValue,
		SUM(charges_value) AS TotalCharges,
		SUM(incomes_value + taxes) AS TotalWithTax
		FROM {$db->tables['transactions']}
		WHERE created_on BETWEEN '{$start}' AND '{$end}' AND turnover_included = 1 {$additional_where}
		GROUP BY YEAR(created_on), MONTH(created_on)
		ORDER BY YEAR(created_on), MONTH(created_on)";
	$data = $db->get_results($query);
	if ($data) {
		$invoice_total = 0;
		$tax_total = 0;
		$charges_total = 0;
		$total_with_tax = 0;
		foreach ($data as $v) {
			$invoice_total += $v->itemSubtotal;
			$tax_total += $v->taxValue;
			$total_with_tax = $invoice_total + $tax_total;
			$charges_total += $v->TotalCharges;
		}
		$totals = array(
			'invoice_total' => $invoice_total,
			'tax_total' => $tax_total,
			'total_with_tax' => $total_with_tax,
			'charges_total' => $charges_total
		);
	}
	if (!$var)
	{
		return $totals;
	}
	else
	{
		return $totals[$var];
	}
}
// ------------------------------------------------------------------------
function is_rtl($client_id=null)
{
	if (!$client_id)
	{
		return get_option('default_language') == 'ar-AR';
	}
	else
	{
		return client($client_id, 'client_language') == 'ar_AR';
	}
}
// ------------------------------------------------------------------------
function provider_is_rtl($provider_id=null)
{
	if (!$provider_id)
	{
		return get_option('default_language') == 'ar-AR';
	}
	else
	{
		return provider($provider_id, 'provider_language') == 'ar_AR';
	}
}
// ------------------------------------------------------------------------
function record_cal_event($event, $id=null)
{
	global $db;
	if (!$id)
	{
		$db->query("INSERT INTO {$db->tables['calendar']} SET ".$db->get_set($event));
	}
	else
	{
		if ($db->get_results("SELECT id FROM {$db->tables['calendar']} WHERE id={$id}"))
		{
			$db->query("UPDATE {$db->tables['calendar']} SET ".$db->get_set($event)." WHERE id = {$id}");
		}
		else
		{
			$db->query("INSERT INTO {$db->tables['calendar']} SET ".$db->get_set($event));
		}
	}
}
// ------------------------------------------------------------------------
function get_cal_events($filter=null)
{
	global $db;
	if (!$filter)
	{
		return $db->get_results("SELECT * FROM oc_calendar");
	}
}
// ------------------------------------------------------------------------
function _has_option($option)
{
	return get_option($option);
}
// ------------------------------------------------------------------------
function count_active_payment_gateway()
{
	$count = 0;
	if ( _has_option('has_paypal') )
	{
		$count += 1;
	}
	if ( _has_option('has_stripe') )
	{
		$count += 1;
	}
	if ( _has_option('has_mollie') )
	{
		$count += 1;
	}
	if ( _has_option('has_ingenico') )
	{
		$count += 1;
	}
	return $count;
}
// ------------------------------------------------------------------------
function bootstrap_btn_width()
{
	$count = count_active_payment_gateway();
	switch ($count) {
		case '1':
			return "col-md-12";
			break;
		case '2':
			return "col-md-6";
			break;
		case '3':
			return "col-md-4";
			break;
		case '4':
			return "col-md-3";
			break;
		default:
			return "col-md-4";
			break;
	}
}
// ------------------------------------------------------------------------
function get_items_services($filter=null)
{
	global $db;
	if (!$filter)
	{
		$query = "SELECT item_id, sku, name, price, purchase_price, item_status
			FROM {$db->tables['items']} AS I 
			LEFT JOIN {$db->tables['items_groups']} AS G 
			ON I.group_id = G.group_id 
			LEFT JOIN {$db->tables['taxes']} AS T 
			ON I.tax_id = T.id ORDER BY name ASC";
		return $db->get_results($query);
	}
}
// ------------------------------------------------------------------------
/**
 * Get all ordered items
 * @param type $invoice_number 
 * @return type array
 */
function get_ordered_items($update_bd = false)
{
	global $db;
	$query = "SELECT item_id AS id,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_quantity ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_quantity ELSE 0 End) AS quantity
		FROM {$db->tables['invoices_items']}
		WHERE invoice_is_cancelled = 0
		AND date_paid > '0000-00-00'
		GROUP BY item_id 
		ORDER BY item_id DESC";
	$results = $db->get_results($query);
	if ($results)
	{
		if(!$update_bd)
		{
			return $results;
		}
		else
		{
			foreach ($results as $r) {
				$query = "UPDATE {$db->tables['items']}
					SET " . $db->get_set(array('ordered' => $r->quantity)). 
					" WHERE item_id = " .$r->id;
				$db->query($query);
			}
		}
	}
}
// ------------------------------------------------------------------------
/**
 * Get all ordered items
 * @param type $invoice_number 
 * @return type array
 */
function get_committed_items($update_bd = false)
{
	global $db;
	$query = "SELECT item_id AS id,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_quantity ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_quantity ELSE 0 End) AS quantity
		FROM {$db->tables['invoices_items']}
		WHERE invoice_is_cancelled = 0
		AND date_paid = '0000-00-00'
		OR date_paid IS NULL
		GROUP BY item_id 
		ORDER BY item_id DESC";
	$results = $db->get_results($query);
	if ( $results )
	{
		if(!$update_bd)
		{
			return $results;
		}
		else
		{
			foreach ($results as $r) {
				$query = "UPDATE {$db->tables['items']}
					SET " . $db->get_set(array('committed' => $r->quantity)). 
					" WHERE item_id = " .$r->id;
				$db->query($query);
			}
		}
	}
}
// ------------------------------------------------------------------------
/**
 * Get ordered items by invoice number
 * @param type $invoice_number 
 * @return type array
 */
function get_ordered_items_by_invoice($invoice_number)
{
	global $db;
	$query = "SELECT item_id AS id,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_quantity ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_quantity ELSE 0 End) AS quantity
		FROM {$db->tables['invoices_items']}
		WHERE invoice_number = {$invoice_number}
		AND date_paid > '0000-00-00'
		GROUP BY item_id 
		ORDER BY item_id DESC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
/**
 * Fetch all committed items
 */
function get_committed_items_by_invoice($invoice_number)
{
	global $db;
	$query = "SELECT item_id AS id,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_quantity ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_quantity ELSE 0 End) AS quantity
		FROM {$db->tables['invoices_items']}
		WHERE invoice_number = {$invoice_number}
		GROUP BY item_id 
		ORDER BY item_id ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
/**
 * Fetch the database current state for ordered items
 */
function get_ordered_db_state($item_id)
{
	global $db;
	$result = $db->get_row("SELECT ordered FROM oc_items WHERE item_id = {$item_id}");
	return $result ? $result->ordered: 0;
}
// ------------------------------------------------------------------------
/**
 * Fetch the database current state for the committed items
 */
function get_committed_db_state($item_id)
{
	global $db;
	$result = $db->get_row("SELECT committed FROM oc_items WHERE item_id = {$item_id}");
	return $result ? $result->committed: 0;
}
// ------------------------------------------------------------------------
/**
 * Set ordered items. These items have been paid
 */
function set_ordered_items($invoice_number)
{
	global $db;
	$ordered = get_ordered_items_by_invoice($invoice_number);
	if ($ordered)
	{
		foreach ($ordered as $or) {
			$db_state = get_ordered_db_state($or->id);
			$query = "UPDATE {$db->tables['items']}
				SET " . $db->get_set(array('ordered' => floatval($db_state) + floatval($or->quantity)) ). 
				" WHERE item_id = " .$or->id;
			$db->query($query);
			available_stock($or->id);
		}
	}
}
// ------------------------------------------------------------------------
/**
 * Set ordered items. These items have been paid
 */
function set_committed_items($invoice_number)
{
	global $db;
	$committed = get_committed_items_by_invoice($invoice_number);
	if ($committed)
	{
		foreach ($committed as $com) {
			$db_state = get_committed_db_state($com->id);
			$query = "UPDATE {$db->tables['items']}
				SET " . $db->get_set(array('committed' => floatval($db_state) + floatval($com->quantity)) ). 
				" WHERE item_id = " .$com->id;
			$db->query($query);
			available_stock($com->id);
		}
	}
}
// ------------------------------------------------------------------------
/**
 * As the create invoice ajax method delete all data and recreate them, let's remove committed items
 * THEN add them back
 */
function remove_committed_items($invoice_number)
{
	global $db;
	$committed = get_committed_items_by_invoice($invoice_number);
	if ($committed)
	{
		foreach ($committed as $com) {
			$db_state = get_committed_db_state($com->id);
			if($db_state > 0)
			{
				$query = "UPDATE {$db->tables['items']}
					SET " . $db->get_set(array('committed' => floatval($db_state) - floatval($com->quantity)) ). 
					" WHERE item_id = " .$com->id;
				$db->query($query);
				available_stock($com->id);
			}
		}
	}
}
// ------------------------------------------------------------------------
/**
 * As the create invoice ajax method delete all data and recreate them, let's remove committed items
 * THEN add them back
 */
function remove_ordered_items($invoice_number)
{
	global $db;
	$ordered = get_ordered_items_by_invoice($invoice_number);
	if ($ordered)
	{
		foreach ($ordered as $or) {
			$db_state = get_ordered_db_state($or->id);
			$query = "UPDATE {$db->tables['items']}
				SET " . $db->get_set(array('ordered' => floatval($db_state) - floatval($or->quantity)) ). 
				" WHERE item_id = " .$or->id;
			$db->query($query);
			available_stock($or->id);
		}
	}
}
// ------------------------------------------------------------------------
/**
 * Get data for view file
 */
function get_items_stocks($filter=null)
{
	global $db;
	get_ordered_items(true);
	get_committed_items(true);
	update_stock();
	stock_valuation();
	if (!$filter)
	{
		$query = "SELECT item_id, sku, name, reorder_point, on_hand_stock, available, committed, ordered, valuation
			FROM {$db->tables['items']} AS I 
			LEFT JOIN {$db->tables['items_groups']} AS G 
			ON I.group_id = G.group_id 
			LEFT JOIN {$db->tables['taxes']} AS T 
			ON I.tax_id = T.id 
			WHERE I.is_service = 0
			AND track_inventory = 1
			ORDER BY name ASC";
		return $db->get_results($query);
	}
}
// ------------------------------------------------------------------------
function available_stock($item_id)
{
	global $db;
	$query = "SELECT on_hand_stock, committed, ordered FROM oc_items WHERE item_id = {$item_id}";
	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $r) {
			$available_stock = floatval($r->on_hand_stock) - floatval($r->committed) - floatval($r->ordered);
			$query = "UPDATE {$db->tables['items']}
				SET " . $db->get_set(array('available' => $available_stock)). 
				" WHERE item_id = " .$item_id;
			$db->query($query);
		}
	}
}
// ------------------------------------------------------------------------
function update_stock()
{
	global $db;
	$query = "SELECT item_id, on_hand_stock, committed, ordered FROM oc_items";
	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $r) {
			$available_stock = floatval($r->on_hand_stock) - floatval($r->committed) - floatval($r->ordered);
			$query = "UPDATE {$db->tables['items']}
				SET " . $db->get_set(array('available' => $available_stock)). 
				" WHERE item_id = " .$r->item_id;
			$db->query($query);
		}
	}
}
// ------------------------------------------------------------------------
function update_on_hand($item_name, $item_quantity)
{
	global $db;
	
	$query = "SELECT item_id, on_hand_stock FROM oc_items WHERE name = '{$item_name}'";
	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $r) {
			$current_on_hand_stock = floatval($r->on_hand_stock);
			$new_on_hand = floatval($current_on_hand_stock) + floatval($item_quantity);
			$query = "UPDATE {$db->tables['items']}
				SET " . $db->get_set(array('on_hand_stock' => $new_on_hand)). 
				" WHERE item_id = " .$r->item_id;
			$db->query($query);
		}
	}
}
// ------------------------------------------------------------------------
function stock_valuation()
{
	global $db;
	$results = $db->get_results("SELECT item_id, purchase_price, on_hand_stock FROM {$db->tables['items']}");
	if($results)
	{
		foreach ($results as $r) {
			$id = $r->item_id;
			if ($r->purchase_price)
			{
				$valuation = floatval($r->purchase_price) * floatval($r->on_hand_stock);
				$query = "UPDATE {$db->tables['items']}
				 	SET " . $db->get_set(array('valuation' => $valuation)). 
					" WHERE item_id = " .$id;
				 $db->query($query);
			}
		}
	}
}

// ------------------------------------------------------------------------
/**
 * Alert Admin on stocks level
 * If a CC email address is set,
 * The 2nd address will also be notified.
 * @since 1.5
 * @return type void
 */
function alert_low_stock()
{
	if (_has_option('items_stocks') && ! _has_option('turn_off_items_low_stock_email')) {
		global $db;
		$query = "SELECT item_id, sku, name, available, reorder_point FROM oc_items WHERE available <= reorder_point AND date(next_stock_warning) = DATE(NOW()) OR date(next_stock_warning) IS NULL AND is_service = 0";
		$results = $db->get_results($query);
		if($results)
		{
			$next_warning = date('Y-m-d', strtotime('+3 day', now()));
			$html = __s('message_low_stock') . $next_warning. '<br />---------------------';
			$html .= '<!DOCTYPE html><html><head><style>table {border-collapse: collapse;width: 100%;}th, td {text-align: left;padding: 8px;}tr:nth-child(even){background-color: #f2f2f2}th {background-color: #4CAF50;color: white;}</style></head><body><table style="width:90%"><tr><th>' . __s('th_sku') . '</th><th>' . __s('th_item') . '</th><th>' . __s('label_available'). '</th><th>' . __s('label_reorder_point_short'). '</th></tr>';
			foreach ($results as $r) {
				$query = "UPDATE {$db->tables['items']}
					SET " . $db->get_set(array('next_stock_warning' => $next_warning)) . 
					" WHERE item_id = " .$r->item_id;
				$html .= '<tr><td>' . $r->sku . '</td><td>'. $r->name . '</td><td>'. $r->available . '</td><td>'. $r->reorder_point. '</td>';
				$db->query($query);
			}
			$html .= '</table><p style="text-align:center;">' . __s('message_generated_with') . '<a href="https://codecanyon.net/item/mmanager-invoices-management-system/19866435?s_rank=1">m\'Manager</a></p></body></html>';
			$email_cc = null !== get_option('notifications_email_2') ? get_option('notifications_email_2'): null;
			send_email( get_option('notifications_email'), $html, __s('label_low_stock_subject'), null, $email_cc );
		}
	}
}
function alert_connection()
{
	$userAgent = new UserAgent();
	$ip = $userAgent->getUserIP();
	
	if ( ! is_authorized_ip($ip)) {
		$title = __s('label_connection_to_app');
		$firstname = get_option('first_name');
		$lastname = get_option('last_name');
		$message1 = __s('message_connection_to_app_1');
		$message2 = __s('message_connection_to_app_2');
		$message3 = __s('message_connection_to_app_3');

		if ( $firstname && $lastname) {
			$name = $firstname. ' '. $lastname;
		} else if ($firstname) {
			$name = $firstname;
		} else if ($lastname) {
			$name = $lastname;
		} else {
			$name = 'Admin';
		}
		$html = '<!DOCTYPE html><html><head>
		<style> 
			h2 {text-align: center;}
			p {
				text-align: justify;
				font-size: 14px;
			}
			.button {
			    background-color: #4CAF50; /* Green */
			    border: none;
			    color: white;
			    padding: 15px 32px;
			    text-align: center;
			    text-decoration: none;
			    display: inline-block;
			    font-size: 12px;
			    margin: 4px 2px;
			    cursor: pointer;
			}
			.button2 {background-color: #008CBA;} /* Blue */
			.button3 {background-color: #f44336;} /* Red */ 
			.button4 {background-color: #e7e7e7; color: black;} /* Gray */ 
			.button5 {background-color: #555555;} /* Black */
		</style>
		</head><body><h2>'.$title.'</h2><br /><p>'.sprintf(__('label_greetings_with_name'), $name).'<br /><br />'. $message1.'<br /><br />------------------------------------------<br /><br />'.__s('label_account').': '. user('email').'<br />'.__s('label_ip_address'). ': ' .$userAgent->getUserIP().'<br />'.__s('label_browser'). ' : '. $userAgent->getUserAgent().'<br /><br />------------------------------------------ <br /><br />'.$message2.'<br /><br /> '. anchor('/user/index?a=registerIp&ip='.$userAgent->getUserIP(), '<button class="button button2">Yes, this is a trusted IP Address</button>').'<br />'.$message3.'&#x2614;<br /></p>';
		$html .= '<p style="text-align:center;">' . __s('message_generated_with') . '<a href="https://codecanyon.net/item/mmanager-invoices-management-system/19866435?s_rank=1">m\'Manager</a></p></body></html>';
		$email_cc = null !== get_option('notifications_email_2') ? get_option('notifications_email_2'): null;
		send_email( get_option('notifications_email'), $html, __s('label_connection_subject'), null, $email_cc );
	}
}
// ------------------------------------------------------------------------
function dashboard_alert_low_stock()
{
	if (_has_option('items_stocks')) {
		global $db;
		$query = "SELECT item_id FROM oc_items WHERE available <= reorder_point";
		$results = $db->get_row($query)->item_id;
		if($results && can_access('stocks'))
		{
			return true;
		}
	}
}
function dashboard_warning_unpaid_commission()
{
	if(has_unpaid_commission() && can_user_manage_access() && _has_option('user_commissions'))
	{
		return true;
	}
}
function clear_timeline()
{
	global $db;
	$period = date('Y-m-d', strtotime(date('Y-m-d') .' -60 day'));
	return $db->query("DELETE FROM oc_timeline WHERE created_on <= '{$period}'");
}
// ------------------------------------------------------------------------
function update_clients_currency()
{
	global $db;
	$db_data = array(
		'client_updated_at' => date('Y-m-d'),
		'client_currency'  => get_option('user_currency'),
		'client_change_rate'  => 1
		);
	$query = "UPDATE {$db->tables['clients']}
				SET " . $db->get_set($db_data);
			$db->query($query);
}
// ------------------------------------------------------------------------
function update_client_password($client_id, $db_data)
{
	global $db;
	$query = "UPDATE {$db->tables['clients']}
				SET " . $db->get_set($db_data). "WHERE client_id = {$client_id}";
			$db->query($query);
}
// ------------------------------------------------------------------------
function update_providers_currency()
{
	global $db;
	$db_data = array(
		'provider_currency'  => get_option('user_currency')
		);
	$query = "UPDATE {$db->tables['providers']}
				SET " . $db->get_set($db_data);
			$db->query($query);
}
// ------------------------------------------------------------------------
function is_method_in_use($id)
{
	global $db;
	$method = $db->get_row("SELECT payment_method_name FROM oc_payment_methods WHERE payment_method_id = {$id}")->payment_method_name;
	if($method)
	{
		$result = $db->get_row("SELECT payment_method FROM {$db->tables['invoices']} WHERE payment_method = '{$method}'");
		if($result)
		{
			return null !== $result->payment_method;
		}
		else
		{
			return false;
		}
	}
}
// ------------------------------------------------------------------------
function is_tax_in_use($id)
{
	global $db;
	$tax = $db->get_row("SELECT additional_tax_name FROM oc_additional_taxes WHERE id = {$id}")->additional_tax_name;
	if($tax)
	{
		$result = $db->get_row("SELECT additional_tax_name FROM {$db->tables['invoices']} WHERE additional_tax_name = '{$tax}'");
		if($result)
		{
			return null !== $result->additional_tax_name;
		}
		else
		{
			return false;
		}
	}
}
// ------------------------------------------------------------------------

function get_items($status = null)
{
	global $db;
	$status = trim($status);
	if (!$status)
	{
		$query = "SELECT * 
			FROM {$db->tables['items']} AS I 
			LEFT JOIN {$db->tables['items_groups']} AS G 
			ON I.group_id = G.group_id 
			LEFT JOIN {$db->tables['taxes']} AS T 
			ON I.tax_id = T.id
			WHERE I.is_service = 0 ORDER BY item_id DESC";
		return $db->get_results($query);
	}
	elseif ($status == 'inactive')
	{
		$query = "SELECT * 
			FROM {$db->tables['items']} AS I 
			LEFT JOIN {$db->tables['items_groups']} AS G 
			ON I.group_id = G.group_id 
			LEFT JOIN {$db->tables['taxes']} AS T 
			ON I.tax_id = T.id
			WHERE I.is_service = 0 AND item_status = 0 ORDER BY item_id DESC";
		return $db->get_results($query);
	}
}
if ( ! function_exists('get_items_sp')) {
	function get_items_sp($status, $order, $sort, $offset, $limit, $search = null)
	{
		global $db;

		if (!$status && !$search)
		{
			$query = "SELECT * 
				FROM {$db->tables['items']} AS I  
				LEFT JOIN {$db->tables['items_groups']} AS G 
				ON I.group_id = G.group_id 
				LEFT JOIN {$db->tables['taxes']} AS T 
				ON I.tax_id = T.id
				WHERE I.is_service = 0 ORDER BY {$sort} {$order} LIMIT {$offset},{$limit}";
			return $db->get_results($query);
		} elseif ($search && ! $status) {
			$query = "SELECT * 
				FROM {$db->tables['items']} AS I 
				LEFT JOIN {$db->tables['items_groups']} AS G 
				ON I.group_id = G.group_id 
				LEFT JOIN {$db->tables['taxes']} AS T 
				ON I.tax_id = T.id
				WHERE item_id LIKE '%{$sku}%' OR name LIKE '%{$search}%' OR group_name LIKE '%{$search}%' OR price LIKE '%{$search}%' OR item_status LIKE '%{$search}%' OR tax_percent LIKE '%{$search}%'";
			return $db->get_results($query);
		}
		else
		{
			$query = "SELECT * 
				FROM {$db->tables['items']} AS I  
				LEFT JOIN {$db->tables['items_groups']} AS G 
				ON I.group_id = G.group_id 
				LEFT JOIN {$db->tables['taxes']} AS T 
				ON I.tax_id = T.id
				WHERE I.is_service = 0 AND item_status = {$status} ORDER BY {$sort} {$order} LIMIT {$offset},{$limit}";
			return $db->get_results($query);
		}
	}
}
function count_items_table()
{
	global $db;
	$query = "SELECT COUNT('item_id') AS total FROM oc_items WHERE is_service = 0";
	return intval($db->get_row($query)->total);
}
// ------------------------------------------------------------------------
function get_services($status = null)
{
	global $db;
	$status = trim($status);
	if (!$status)
	{
		$query = "SELECT * 
			FROM {$db->tables['items']} AS I 
			LEFT JOIN {$db->tables['items_groups']} AS G 
			ON I.group_id = G.group_id 
			LEFT JOIN {$db->tables['taxes']} AS T 
			ON I.tax_id = T.id
			WHERE I.is_service = 1 ORDER BY item_id DESC";
		return $db->get_results($query);
	}
	elseif ($status == 'inactive')
	{
		$query = "SELECT * 
			FROM {$db->tables['items']} AS I 
			LEFT JOIN {$db->tables['items_groups']} AS G 
			ON I.group_id = G.group_id 
			LEFT JOIN {$db->tables['taxes']} AS T 
			ON I.tax_id = T.id
			WHERE I.is_service = 1 AND item_status = 0 ORDER BY item_id DESC";
		return $db->get_results($query);
	}
}
// ------------------------------------------------------------------------
function get_items_services_name($filter=null)
{
	global $db;
	if (!$filter)
	{
		$query = "SELECT name
			FROM {$db->tables['items']}";
		return $db->get_results($query);
	}
}

// ------------------------------------------------------------------------
/**
 * Check if item or service exists
 * @param type $item_name 
 * @return type bool
 * @since 1.5
 */
function item_exists($item_name)
{
	global $db;
	return null !== $db->get_row("SELECT name FROM oc_items WHERE name = '{$item_name}'");
}
// ------------------------------------------------------------------------
function item_status_str($status)
{
	switch ($status) {
		case '1':
			return __('label_available');
			break;
		case '0':
			return __('label_out_of_stock');
			break;
	}
}
// ------------------------------------------------------------------------
function item_is_available($quantity)
{
	return $quantity > 0 ? __('label_available'): __('label_out_of_stock'); 
}
// ------------------------------------------------------------------------
function get_purchase_vars($purchase_number, $var = null)
{
	global $db;
	if ($purchase_number && !$var)
	{
		return get_purchase_by_number($purchase_number);
	}
	elseif ($purchase_number && $var && $var !== 'purchased_items')
	{
		return $db->get_row("SELECT {$var} FROM {$db->tables['purchases']} WHERE purchase_number={$purchase_number} LIMIT 1") ?
		$db->get_row("SELECT {$var} FROM {$db->tables['purchases']} WHERE purchase_number={$purchase_number} LIMIT 1")->{$var} : false;
	}
	else
	{
		return get_purchased_items($purchase_number);
	}
}
// ------------------------------------------------------------------------
/**
 * Get quote vars for view files
 * @param type $quote_number 
 * @param type|null $var 
 * @return type mixed
 */
function get_quote_vars( $quote_number, $var = null )
{
	global $db;
	if ( $quote_number && !$var )
	{
		return get_quote_by_number( $quote_number );
	}
	elseif ( $quote_number && $var && $var !== 'quote_items')
	{
		return $db->get_row("SELECT {$var} FROM {$db->tables['quotes']} WHERE quote_number = {$quote_number} LIMIT 1") ?
		$db->get_row("SELECT {$var} FROM {$db->tables['quotes']} WHERE quote_number = {$quote_number} LIMIT 1")->{$var} : false;
	}
	else
	{
		return get_quoted_items($quote_number);
	}
}
// ------------------------------------------------------------------------
function record_hsn_sac($db_data)
{
	global $db;
	$db->query("INSERT INTO {$db->tables['hsn_sac']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function record_uom($db_data)
{
	global $db;
	$db->query("INSERT INTO {$db->tables['uom']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function record_cgst($db_data)
{
	global $db;
	$db->query("INSERT INTO {$db->tables['cgst']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function record_sgst($db_data)
{
	global $db;
	$db->query("INSERT INTO {$db->tables['sgst']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function record_igst($db_data)
{
	global $db;
	$db->query("INSERT INTO {$db->tables['igst']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function record_cess($db_data)
{
	global $db;
	$db->query("INSERT INTO {$db->tables['cess']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function get_hsn_sac()
{
	global $db;
	$query = "SELECT id, hsn_sac_value
		FROM oc_hsn_sac
		GROUP BY hsn_sac_value
		ORDER BY hsn_sac_value ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_uom()
{
	global $db;
	$query = "SELECT id, uom_value
		FROM oc_uom
		GROUP BY uom_value
		ORDER BY uom_value ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_cgst()
{
	global $db;
	$query = "SELECT id, cgst_rate
		FROM oc_cgst
		GROUP BY cgst_rate
		ORDER BY cgst_rate ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_sgst()
{
	global $db;
	$query = "SELECT id, sgst_rate
		FROM oc_sgst
		GROUP BY sgst_rate
		ORDER BY sgst_rate ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_igst()
{
	global $db;
	$query = "SELECT id, igst_rate
		FROM oc_igst
		GROUP BY igst_rate
		ORDER BY igst_rate ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function get_cess()
{
	global $db;
	$query = "SELECT id, cess_rate
		FROM oc_cess
		GROUP BY cess_rate
		ORDER BY cess_rate ASC";
	return $db->get_results($query);
}
// ------------------------------------------------------------------------
function generateQrcode($item_id, $data, $level = 'H', $size = 2) {
	// Require the Phpqrcode file
	require_once('vendor/myeric/mmanager/src/Adapter/Qrcode/PhpQrCode.php');
	// Where to save images
	$PNG_TEMP_DIR = dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR.'uploads/qrcode'.DIRECTORY_SEPARATOR;
	//html PNG location prefix
	$PNG_WEB_DIR = 'qrcode/';
	// Create folder if it does not exist
	if (!file_exists($PNG_TEMP_DIR))
	    mkdir($PNG_TEMP_DIR);
	// Set filename
	$filename = $item_id.'.png';
	// File path
	$filepath = $PNG_TEMP_DIR.$filename;
	// Generate QR Code
	return QRcode::png($data, $filepath, $level, $size);
}
// ------------------------------------------------------------------------
function formatBarCodeOutput($data) {
	if (strlen($data) > 20) {
		return '*'.substr(preg_replace('/\s+/', '-', $data), 0, 20).'...*';
	}
	return '*'.preg_replace('/\s+/', '-', $data).'*';
}
function generateBarcode($id, $text, $ean13 = false) {
	// Where to save images
	$PNG_TEMP_DIR = dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR.'uploads/barcode'.DIRECTORY_SEPARATOR;
	//html PNG location prefix
	$PNG_WEB_DIR = 'barcode/';
	// Create folder if it does not exist
	if (!file_exists($PNG_TEMP_DIR))
	    mkdir($PNG_TEMP_DIR);
	// Set filename
	$filename = $id.'.png';
	// File path
	$filepath = $PNG_TEMP_DIR.$filename;
	//Only the text to draw is required
	$barcodeOptions = [
		'text' => $text,
		'font'	=> 3
	];

	// No required options
	$rendererOptions = [];

	if ( ! $ean13) {
		// Draw the barcode, // send the headers, and emit the image:
		$imageResource = Barcode::draw(
		    'code128',
		    'image',
		    $barcodeOptions,
		    $rendererOptions
		);
		imagepng($imageResource, $filepath);
	} else {
		// Draw the barcode, // send the headers, and emit the image:
		$imageResource = Barcode::draw(
		    'ean13',
		    'image',
		    $barcodeOptions,
		    $rendererOptions
		);
		imagepng($imageResource, $filepath);
	}
}
// Barcode use time function to avoid serving cached files
// This causes the system to save lot of files
// This function collects garbage and delete unused files
function clearTempBarcode()
{
	$CI = & get_instance();
	$PNG_TEMP_DIR = dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR.'uploads/barcode'.DIRECTORY_SEPARATOR;
	$CI->load->helper('file');

	global $db;
	$barCode = [];
	$inUseBarCode = $db->get_results("SELECT barcode FROM oc_items");
	if ( ! empty($inUseBarCode)) {
		foreach ($inUseBarCode as $key => $value) {
			array_push($barCode, $value->barcode);
		}
	}
	$tempBarCode = get_filenames($PNG_TEMP_DIR);
	foreach ($tempBarCode as $key => $value) {
		if ( ! in_array($value, $barCode)) {
			unlink($PNG_TEMP_DIR.$value);
		}
	}
}
// QR Code use time function to avoid serving cached files
// This causes the system to save lot of files
// This function collects garbage and delete unused files
function clearTempQRcode()
{
	$CI = & get_instance();
	$PNG_TEMP_DIR = dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR.'uploads/qrcode'.DIRECTORY_SEPARATOR;
	$CI->load->helper('file');

	global $db;
	$qrCode = [];
	$inUseqrCode = $db->get_results("SELECT qrcode FROM oc_items");
	if ( ! empty($inUseqrCode)) {
		foreach ($inUseqrCode as $key => $value) {
			array_push($qrCode, $value->qrcode);
		}
	}
	$tempQrCode = get_filenames($PNG_TEMP_DIR);
	foreach ($tempQrCode as $key => $value) {
		if ( ! in_array($value, $qrCode)) {
			unlink($PNG_TEMP_DIR.$value);
		}
	}
}
function loadLang($id, $context) {
	$CI = & get_instance();
	if (isset($_SESSION['user_id'])) {
	    $CI->lang->load('application', lang_code_to_string(get_option('user_language', 'users_options')));
	} else {
		switch ($context) {
			case 'client':
				$CI->lang->load('application', lang_code_to_string(client($id, 'client_language')));
				break;
			case 'provider':
				$CI->lang->load('application', lang_code_to_string(provider($id, 'provider_language')));
				break;
			default:
				$CI->lang->load('application', lang_code_to_string(get_option('user_language', 'users_options')));
				break;
		}
	}
}
function _importFromCsv($table, $db_array) {
	global $db;
	$db->query("INSERT INTO {$table} SET ".$db->get_set($db_array));
}
function get_entity_by($entity, $var) {
	$return = [];
	$results = [];
	switch ($entity) {
		case 'customer':
			$results = clients();
			break;
		case 'provider':
			$results = providers();
			break;
		case 'product':
			$results = get_items();
			break;
		case 'service':
			$results = get_services();
			break;
		case 'invoice':
			$results = get_invoices();
			break;
		default:
			return $return;
			break;
	}
	if ($results) {
		foreach ($results as $value) {
			array_push($return, $value->$var);
		}
	}
	return $return;
}
function db_add_credit_note()
{
	global $db;

	if ( ! col_exists('invoices', 'is_credit_note'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `is_credit_note` tinyint(1) DEFAULT 0");
		$db->query("ALTER TABLE `oc_invoices` ADD `initial_invoice_number` int(11) DEFAULT NULL");
		$db->query("ALTER TABLE `oc_invoices` ADD `credit_is_added` tinyint(1) DEFAULT 0");
		$db->query("ALTER TABLE `oc_items` ADD `product_ean13` VARCHAR(20) DEFAULT NULL");
	}
}
function getAccountEntityNextId($entity, $account_id = null) {
	global $db;
	return $db->get_row("SELECT counter_value FROM oc_accounts_counters WHERE counter_key = '{$entity}'") ? intval($db->get_row("SELECT counter_value FROM oc_accounts_counters WHERE counter_key = '{$entity}'")->counter_value) + 1 : 1;
}
function __e($string) {
	return !lang($string) ? $string : lang($string);
}
function db_add_accounts_counters() {
	global $db;
	if ( ! db_table_exists('oc_accounts_counters'))
	{
		$db->query("CREATE TABLE IF NOT EXISTS `oc_accounts_counters` (`id` int(11) NOT NULL AUTO_INCREMENT, `counter_key` varchar(225) NOT NULL, `counter_value` int(11) NOT NULL, `account_id` int(11) NOT NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
		$db->query("ALTER TABLE `oc_invoices` ADD `invoice_key` INT(11)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `invoice_key` INT(11)");
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('setAccountEntityId')) {
	function setAccountEntityId($entity, $id = null, $account_id = null)
	{
		global $db;

		$primary_key = 'id';
		$counter_id = get_counters_id($entity);
		
		if ( !$counter_id )
		{
			$query = "INSERT INTO oc_accounts_counters SET ". $db->get_set(array('counter_key' => $entity, 'counter_value' => $id));
			return $db->query($query);
		}
		else
		{
			$query = "UPDATE oc_accounts_counters
							SET " . $db->get_set(array('counter_key' => $entity, 'counter_value' => $id)) . 
							" WHERE {$primary_key} = {$counter_id}";
			return $db->query($query);
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('get_counters')) {
	function get_counters($account_id = null)
	{
		global $db;
		$query = "SELECT * FROM oc_accounts_counters";
		return $db->get_results($query);
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('get_counters_id')) {
	function get_counters_id($counter_key, $account_id = null)
	{
		$options_ids = [];
		$options = get_counters();
		if ($options)
		{
			foreach ($options as $option) 
			{
				$options_ids[$option->counter_key] = $option->id;
			}
		}
		return array_key_exists($counter_key, $options_ids) ? $options_ids[$counter_key] : false;
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('get_client_id')) {
	function get_client_id($client_name = null, $client_email = null)
	{
		global $db;
		$client_name = isset($client_name) ? addslashes($client_name) : null;

		if (!$client_name && !$client_email)
		{
			return intval(0);
		}
		else
		{
			if (!$client_email) {
				return null !== $db->get_row("SELECT client_id FROM {$db->tables['clients']} WHERE name_company LIKE '{$client_name}'") ?
				$db->get_row("SELECT client_id FROM {$db->tables['clients']} WHERE name_company LIKE '{$client_name}'")->client_id : '';
			} else {
				return null !== $db->get_row("SELECT client_id FROM {$db->tables['clients']} WHERE client_email LIKE '{$client_email}'") ?
				$db->get_row("SELECT client_id FROM {$db->tables['clients']} WHERE client_email LIKE '{$client_email}'")->client_id : '';
			}
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('setUserData')) {
	function setUserData($key, $value) {
		$CI = & get_instance();
		$CI->session->set_userdata($key, $value);
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('getUserData')) {
	function getUserData($key = null) {
		$CI = & get_instance();
		return isset($key) ? $CI->session->userdata($key) : $CI->session->userdata();
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('get_item_barcode_data')) {
	function get_item_barcode_data($id) {
		global $db;
		return $db->get_results("SELECT item_id, sku, name, price, barcode FROM oc_items WHERE item_id = '{$id}'");
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('upgrade_to_messaging')) {
	function upgrade_to_messaging() {
		global $db;
		if ( ! db_table_exists('oc_messaging'))
		{
			$db->query("CREATE TABLE IF NOT EXISTS `oc_messaging` (`id` int(11) NOT NULL AUTO_INCREMENT, `message_from` int(11) DEFAULT NULL, `message_to` int(11) DEFAULT NULL, `message` text, `account_id` int(11) NULL, `user_id` int(11) NULL, `is_read` tinyint(1) NULL DEFAULT 0, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('upgrade_to_additional_taxes')) {
	function upgrade_to_additional_taxes() {
		global $db;
		if ( ! db_table_exists('oc_additional_taxes'))
		{
			$db->query("CREATE TABLE IF NOT EXISTS `oc_additional_taxes` (`id` int(11) NOT NULL AUTO_INCREMENT, `additional_tax_name` VARCHAR(25) NOT NULL, `additional_tax_rate` decimal(5,2) NOT NULL, `additional_tax_criteria` VARCHAR(25) NOT NULL, `account_id` int(11) NULL, `user_id` int(11) NULL, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
			$db->query("CREATE TABLE IF NOT EXISTS `oc_additional_taxes_meta` (`id` int(11) NOT NULL AUTO_INCREMENT, `additional_tax_id` INT(11) NOT NULL, `additional_tax_rate` decimal(5,2) NOT NULL, `additional_tax_criteria` VARCHAR(25) NOT NULL, `invoice_number` int(11) NOT NULL, `invoice_subtotal` decimal(10,2) NOT NULL, `invoice_tax_amount` decimal(10,2) NOT NULL DEFAULT 0, `invoice_surcharge_amount` decimal(10,2) NOT NULL DEFAULT 0, `invoice_deduct_amount` decimal(10,2) NOT NULL DEFAULT 0, `account_id` int(11) NULL, `invoice_is_cancelled` tinyint(1) NOT NULL DEFAULT 0, `user_id` int(11) NULL, `date_paid` DATETIME NOT NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('save_message')) {
	function save_message($db_array) {
		global $db;
		$db->query("INSERT INTO oc_messaging SET ".$db->get_set($db_array));
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('get_messages')) {
	function get_messages($from, $to) {
		global $db;
		return $db->get_results("SELECT * FROM oc_messaging WHERE message_from = '{$from}' AND message_to = '{$to}' OR message_from = '{$to}' AND message_to = '{$from}' ORDER BY id ASC");
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('mark_read')) {
	function mark_read($message_id) {
		global $db;
		$db->query("UPDATE oc_messaging SET ".$db->get_set(array('is_read' => 1)) . " WHERE id = {$message_id}");
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('count_unread_messages')) {
	function count_unread_messages($message_from) {
		global $db;
		$user_id = USERID;

		return $db->get_row("SELECT COUNT(is_read) AS value FROM oc_messaging WHERE message_from = '{$message_from}' AND message_to = {$user_id} AND is_read = 0")->value;
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('count_user_unread_messages')) {
	function count_user_unread_messages($user_id) {
		global $db;
		return $db->get_row("SELECT COUNT(is_read) AS value FROM oc_messaging WHERE message_to = '{$user_id}' AND is_read = 0")->value;
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('_dateInterval')) {
	function _dateInterval($date, $format = null) {
		$currentDate = new DateTime(date('Y-m-d H:i:s'));
		$date = new DateTime($date);
		$interval = $currentDate->diff($date);

		if ( ! $format) {
			return $interval->days;
		}
		else if ($format == 'Y-m-d') {
			return $interval->y . ' '. __('label_year'). ' '. $interval->m .' '. __('label_month'). ' '. $interval->d.' '.__('label_day');
		}
		else
		{
			return $interval->days;
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('_dateDiff')) {
	function _dateDiff($date) {
		switch (_dateInterval($date)) {
			case '0':
				return DateTime::createFromFormat('Y-m-d H:i:s', $date)->format('H:i:s');
			case '1':
				return __e('label_yesterday').' '. DateTime::createFromFormat('Y-m-d H:i:s', $date)->format('H:i:s');
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
				return __(DateTime::createFromFormat('Y-m-d H:i:s', $date)->format('D')). ' '.DateTime::createFromFormat('Y-m-d H:i:s', $date)->format('H:i:s');		
			default:
				return $date;
		}
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('_durationToHour')) {
	function _durationToHour($time) {
		$time = explode(':', $time);
		return ($time[0]) + ($time[1] / 60) + ($time[2]/3600);
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('is_service')) {
	function is_service($name) {
		global $db;

		return $db->get_row("SELECT is_service FROM oc_items WHERE name LIKE '{$name}'") ? $db->get_row("SELECT is_service FROM oc_items WHERE name LIKE '{$name}'")->is_service : false;
	}
}

function next_invoice_number()
{
	return get_next_id('invoices');
}

function next_annual_number($entity)
{
	global $db;
	return null != $db->get_row("SELECT value FROM oc_annual_sequencing WHERE entity = '{$entity}'") ? $db->get_row("SELECT value FROM oc_annual_sequencing WHERE entity = '{$entity}'")->value: '1';
}
if ( ! function_exists('next_order_number')) {
	function next_order_number()
	{
		return get_next_id('orders');
	}
}
// ------------------------------------------------------------------------
function is_invoiced($id)
{
	global $db;
	$protected = [];
	$id = intval($id);
	$invoiced = $db->get_results("SELECT DISTINCT item_id FROM {$db->tables['invoices_items']}");
	if (!empty($invoiced))
	{
		foreach ($invoiced as $i) {
			array_push($protected, intval($i->item_id));
		}
	}
	if (in_array($id, $protected))
	{
		return true;
	}
	return FALSE;
}
// ------------------------------------------------------------------------
function has_invoice($id)
{
	global $db;
	$protected = [];
	$id = intval($id);
	$invoice = $db->get_results("SELECT DISTINCT client_id FROM {$db->tables['invoices']}");
	if (!empty($invoice))
	{
		foreach ($invoice as $i) {
			array_push($protected, intval($i->client_id));
		}
	}
	if (in_array($id, $protected))
	{
		return true;
	}
	return FALSE;
}
/**
 * Set invoices overdue
 * @return type mixec
 */
function set_overdue()
{
	global $db;
	$CI = &get_instance();
	$apply_late_fees = _has_option('apply_late_fees') ?? 0; 
	$apply_late_fees_when = _has_option('apply_late_fees_when') ?? "immediately"; 

	$query = "SELECT * 
		FROM {$db->tables['invoices']} 
		WHERE invoice_status = 'Unpaid'
		";
	$invoices = $db->get_results($query);
	
	if (!empty($invoices))
	{
		foreach ($invoices as $invoice) 
		{
			$date = date("Y-m-d H:i:s");
			$due_date = $invoice->due_date;

			if ($date > $due_date)
			{
				$db_data = array('invoice_status' => 'Overdue', 'next_overdue_reminder' => date('Y-m-d'));
				$db->query("UPDATE {$db->tables['invoices']} SET ".$db->get_set($db_data) . " WHERE id = {$invoice->id}");

				if ($apply_late_fees && "immediately" == $apply_late_fees_when) {
					$CI->m_manager->apply_late_fees($invoice->id);
				}
			}
		}
	}
	return false;
}

function in_notify($id) {
	return (bool)client($id, 'send_overdue_reminder');
}
/**
 * Compute total due by client
 * @param type $id 
 * @param type|null $interval 
 * @return type
 */
function unpaid_invoice_by_client($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE (invoice_status = 'Unpaid' OR invoice_status = 'Overdue')
				AND MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id}";
			return $db->get_row($query)->TotalDue;
			break;
		case 'last_month':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE (invoice_status = 'Unpaid' OR invoice_status = 'Overdue')
				AND MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND client_id={$id}";
			return $db->get_row($query)->TotalDue;
			break;
		case 'latest_three_months':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE (invoice_status = 'Unpaid' OR invoice_status = 'Overdue')
				AND date >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL 3 MONTH
				AND client_id={$id}";
			return $db->get_row($query)->TotalDue;
			break;
		case 'this_year':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE (invoice_status = 'Unpaid' OR invoice_status = 'Overdue')
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id}";
			return $db->get_row($query)->TotalDue;
			break;
		case 'last_year':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE (invoice_status = 'Unpaid' OR invoice_status = 'Overdue')
				AND YEAR(date) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR))
				AND client_id={$id}";
			return $db->get_row($query)->TotalDue;
			break;
		case 'all_dates':
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE (invoice_status = 'Unpaid' OR invoice_status = 'Overdue')
				AND YEAR(date) IS NOT NULL
				AND client_id={$id}";
			return $db->get_row($query)->TotalDue;
			break;
		default:
			$query = "SELECT client_id AS clientID,
				SUM(amount_due) AS TotalDue
				FROM {$db->tables['invoices']}
				WHERE (invoice_status = 'Unpaid' OR invoice_status = 'Overdue')
				AND MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id}";
			return $db->get_row($query)->TotalDue;
			break;
	}
}
// ------------------------------------------------------------------------
/**
 * Get all unpaid invoices by client
 * @param type $id 
 * @param type|null $interval 
 * @return type
 */
function client_unpaid_invoices($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
		case 'last_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
		default:
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND invoice_status = 'Unpaid'
				OR invoice_status = 'Overdue'
				AND I.client_id={$id}
				ORDER BY I.id DESC";
			return $db->get_results($query);
			break;
	}
}
// ------------------------------------------------------------------------
/**
 * Get all invoices for a given client
 * @param type $id 
 * @param type|null $interval 
 * @return type
 */
function client_invoices($id, $interval=null)
{
	global $db;
	switch ($interval) {
		case 'this_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date) = YEAR(CURRENT_TIMESTAMP)
				AND client_id={$id}
				ORDER BY id DESC";
			return $db->get_results($query);
			break;
		case 'last_month':
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE MONTH(date) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) 
				AND YEAR(date) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				AND client_id={$id}
				ORDER BY id DESC";
			return $db->get_results($query);
			break;
		default:
			$query = "SELECT * 
				FROM {$db->tables['invoices']}
				WHERE client_id={$id}
				ORDER BY id DESC";
			return $db->get_results($query);
			break;
	}
}
// ------------------------------------------------------------------------
function get_invoice_charges($invoice_number)
{
	global $db;
	$res = new \stdClass();
	$res->charges_value = 0;

	if (!$db->query("SELECT EXISTS(SELECT 1 FROM {$db->tables['transactions']} WHERE invoice_number={$invoice_number})"))
	{
		return $res->charges_value;
	}
	else
	{
		$result = $db->get_results("SELECT charges_value FROM {$db->tables['transactions']} WHERE invoice_number={$invoice_number}");
		if ($result)
		{
			foreach ($result as $res) {
				return $res->charges_value;
			}
		}
		return $res->charges_value;
	}
}
// ------------------------------------------------------------------------
function get_invoices_amount($status)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	global $db;
	$query = "SELECT SUM(amount_due) AS value 
			FROM {$db->tables['invoices']} WHERE invoice_status='$status' {$additional_where}";
	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $value) {
			return floatval($value->value);
		}
	}
}
// ------------------------------------------------------------------------
function count_invoices($status)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	global $db;
	$query = "SELECT COUNT(amount_due) AS value 
			FROM {$db->tables['invoices']} 
			WHERE invoice_status='$status' {$additional_where}";
	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $value) {
			return floatval($value->value);
		}
	}
}
// ------------------------------------------------------------------------
function count_sale_orders($status = null)
{
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	global $db;
	if ( ! $status) {
		$query = "SELECT COUNT(id) AS value 
				FROM {$db->tables['orders']} 
				WHERE order_status != 'Shipped' AND order_status != 'Completed' {$additional_where}";
	} else {
		$query = "SELECT COUNT(id) AS value 
				FROM {$db->tables['orders']} 
				WHERE order_status='$status' {$additional_where}";
	}

	$results = $db->get_results($query);
	if ($results)
	{
		foreach ($results as $value) {
			return floatval($value->value);
		}
	}
}
// ------------------------------------------------------------------------
function invoice_number_format()
{
	$format = get_option('invoice_numbering');
	switch ($format) {
		case '1':
			return '';
			break;
		case '2':
			return date('Y').'#';
			break;
		case '3':
			return date('Y/m').'#';
			break;
		case '4':
			return date('y').'';
			break;
		default:
			return '';
			break;
	}
}
// ------------------------------------------------------------------------
function invoiced_to_guest($invoice_number)
{
	global $db;
	return $db->get_row("SELECT client_id FROM {$db->tables['invoices']} WHERE invoice_number={$invoice_number}")->client_id;
}
// ------------------------------------------------------------------------
function ordered_by_guest($order_number)
{
	global $db;
	return $db->get_row("SELECT client_id FROM {$db->tables['orders']} WHERE order_number={$order_number}")->client_id;
}
// ------------------------------------------------------------------------
function update_invoice_status($invoice_number, $status, $id=null)
{
	$invoice = get_invoice_by_number($invoice_number);
	$invoice_id = 0;
	if ($invoice)
	{
		foreach ($invoice as $k => $v) {
			$invoice_id = $v->id;
		}
	}
	global $db;
	$query = "UPDATE {$db->tables['invoices']}
		SET " . $db->get_set(array('invoice_status' => $status, 'payment_id' => $id)) . 
		" WHERE id = {$invoice_id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function update_order_status($order_number, $status, $id=null)
{
	$invoice = get_order_by_number($order_number);
	$order_id = 0;
	if ($invoice)
	{
		foreach ($invoice as $k => $v) {
			$order_id = $v->id;
		}
	}
	global $db;
	$query = "UPDATE {$db->tables['orders']}
		SET " . $db->get_set(array('order_status' => $status, 'payment_id' => $id)) . 
		" WHERE id = {$order_id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function update_order($order_number, $db_data)
{
	$invoice = get_order_by_number($order_number);
	$order_id = 0;
	if ($invoice)
	{
		foreach ($invoice as $k => $v) {
			$order_id = $v->id;
		}
	}
	global $db;
	$query = "UPDATE {$db->tables['orders']}
		SET " . $db->get_set($db_data) . 
		" WHERE id = {$order_id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function update_ordered_items($id, $db_data)
{
	global $db;
	$query = "UPDATE {$db->tables['orders_items']}
		SET " . $db->get_set($db_data) . 
		" WHERE id = {$id}";
	$db->query($query);
}
// ------------------------------------------------------------------------
function get_invoice_tax($invoice_number)
{
	global $db;
	return $db->get_results("SELECT item_tax_rate AS taxRate, 
		SUM(item_subtotal) * item_tax_rate / 100 AS taxAmount
		FROM {$db->tables['invoices_items']}
		WHERE invoice_number = {$invoice_number}
		AND item_tax_rate > 0
		GROUP BY taxRate
		ORDER BY taxRate ASC");
}
// ------------------------------------------------------------------------
function get_order_tax($order_number)
{
	global $db;
	return $db->get_results("SELECT item_tax_rate AS taxRate, 
		SUM(item_subtotal) * item_tax_rate / 100 AS taxAmount
		FROM {$db->tables['orders_items']}
		WHERE order_number = {$order_number}
		AND item_tax_rate > 0
		GROUP BY taxRate
		ORDER BY taxRate ASC");
}
// ------------------------------------------------------------------------
function get_invoice_vars($invoice_number, $var = null)
{
	global $db;
	if ($invoice_number && !$var)
	{
		return get_invoice_by_number($invoice_number);
	}
	elseif ($invoice_number && $var && $var !== 'invoiced_items')
	{
		return $db->get_row("SELECT {$var} FROM {$db->tables['invoices']} WHERE invoice_number={$invoice_number} LIMIT 1") ?
		$db->get_row("SELECT {$var} FROM {$db->tables['invoices']} WHERE invoice_number={$invoice_number} LIMIT 1")->{$var} : FALSE;
	}
	else
	{
		return get_invoiced_items($invoice_number);
	}
}
function get_invoice_by_id($id) {
	global $db;
	$query = "SELECT * FROM {$db->tables['invoices']} I 
	LEFT JOIN {$db->tables['clients']} C ON I.client_id = C.client_id 
	WHERE id = {$id}";
	return $db->get_results($query);
}
function refunded_invoice($invoice_number) {
	global $db;
	$refunded = [];
	$results = $db->get_results("SELECT initial_invoice_number FROM oc_invoices WHERE initial_invoice_number IS NOT NULL");
	if ($results) {
		foreach ($results as $r) {
			array_push($refunded, $r->initial_invoice_number);
		}
	}
	if (in_array($invoice_number, $refunded)) {
		return 1;
	}
	return 0;
}

function purchase_mass_payment($table, $primary_key, $ids)
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_purchase_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total + $value->shipping_amount + $value->other_expenses;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
				}
			}
			$db_data = array(
				'date_paid' => date('Y-m-d'),
				'amount_paid' => $total,
				'amount_due' => 0,
				'purchase_status' => 'Paid',
				'payment_method' => get_option('default_payment_method'),
				'sent' => 'yes'
				);
			// Record transaction
			// Check if any payment done before 
			$last_amount_paid = get_purchase_vars($id, 'amount_paid');
			if ( $last_amount_paid && $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'purchase_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'purchase_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			$query = "UPDATE {$db->tables['purchases']}
				SET " . $db->get_set($db_data) . 
				" WHERE purchase_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['purchases_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE purchase_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_purchase_email($id);

			$charges_data = array(
				'charges_name' 		=> __('charges_purchases'),
				'charges_category' 	=> 1,
				'charges_value'	    => $total,
				'incomes_name'		=> null,
				'incomes_category'	=> null,
				'incomes_value'	    => null,
				'incomes_sku'	    => null,
				'payment_method'	=> get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => null,
				'created_on' 	    => $date
				);
			record_charges($charges_data, 'purchase_number', isset($id) ? $id: null);
		}
	}
	else
	{
		$total = 0;
		$id = $ids;
		$results = get_purchase_by_number($id);
		if ($results)
		{
			foreach ($results as $key => $value) {
				$total = $value->total + $value->shipping_amount + $value->other_expenses;
				$subtotal = $value->subtotal;
				$tax_amount = $value->tax_amount;
				$date = $value->date;
			}
		}
		$db_data = array(
			'date_paid' => date('Y-m-d'),
			'amount_paid' => $total,
			'amount_due' => 0,
			'purchase_status' => 'Paid',
			'payment_method' => get_option('default_payment_method'),
			'sent' => 'yes'
			);
		// Record transaction
		// Check if any payment done before 
		$last_amount_paid = get_purchase_vars($id, 'amount_paid');
		if ( $last_amount_paid && $last_amount_paid > 0 )
		{
			$trans_data = array(
				'payment_method'		=> get_option('default_payment_method'), 
				'payment_reference'		=> time(),
				'payment_amount'		=> $total - $last_amount_paid,
				'date_paid'				=> date('Y-m-d'),
				'purchase_number'		=> $id, 
				'payment_note'		    => ""
			);
			record_transaction($trans_data);
		}
		else
		{
			$trans_data = array(
				'payment_method'		=> get_option('default_payment_method'), 
				'payment_reference'		=> time(),
				'payment_amount'		=> $total,
				'date_paid'				=> date('Y-m-d'),
				'purchase_number'		=> $id, 
				'payment_note'		    => ""
			);
			record_transaction($trans_data);
		}
		$db_data2 = array(
			'date_paid' => date('Y-m-d')
			);
		$query = "UPDATE {$db->tables['purchases']}
			SET " . $db->get_set($db_data) . 
			" WHERE purchase_number = " .$id;
		$db->query($query);
		$query2 = "UPDATE {$db->tables['purchases_items']}
			SET " . $db->get_set($db_data2) . 
			" WHERE purchase_number = " .$id;
		$db->query($query2);
		$CI->m_manager->send_purchase_email($id);

		$charges_data = array(
			'charges_name' 		=> __('charges_purchases'),
			'charges_category' 	=> 1,
			'charges_value'	    => $total,
			'incomes_name'		=> null,
			'incomes_category'	=> null,
			'incomes_value'	    => null,
			'incomes_sku'	    => null,
			'payment_method'	=> get_option('default_payment_method'),
			'turnover_included'	=> 1,
			'taxes'             => null,
			'created_on' 	    => $date
			);
		record_charges($charges_data, 'purchase_number', isset($id) ? $id: null);
	}
	return $CI->db->affected_rows();
}
// ------------------------------------------------------------------------
if ( ! function_exists('mass_payment'))
{
	/**
	 * Mass payment function when many invoices are selected to be marked paid
	 * @param type $table 
	 * @param type $primary_key 
	 * @param array $ids 
	 * @return int
	 */
	function mass_payment($table, $primary_key, array $ids)
	{
		global $db;

		$CI = & get_instance();
		$sms = new SmsService(get_option('sms_platform'), get_option('plateform_api_key'));
		is_array($ids) OR $ids = array($ids);
		$context = [];
		
		// See if you need to send SMS
		if (null != get_option( 'notify_when_invoice_is' )) {
			$context = json_decode(get_option( 'notify_when_invoice_is' ), true);
		}
		foreach ($ids as $id) 
		{
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;

					if (in_array($value->invoice_status, $context)) {
						$sms->sendMessage(client($value->client_id, 'client_phone'), get_option('sms_invoice_paid'). " ".__('invoices_invoice'). ' #'. $id. " ". get_option('company'));
					}
				}
			}
			$db_data = array(
				'date_paid' => date('Y-m-d'),
				'amount_paid' => $total,
				'amount_due' => 0,
				'invoice_status' => 'Paid',
				'payment_method' => get_option('default_payment_method'),
				'sent' => 'yes'
				);
			// Record transaction
			// Check if any payment done before 
			$last_amount_paid = get_invoice_vars($id, 'amount_paid');
			if ( $last_amount_paid && $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> 7,
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'incomes_sku'	    => generate_sku(),
				'payment_method'	=> get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
			record_additional_taxes_meta($id);
		}
		return $CI->db->affected_rows();
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('create_credit_note'))
{
	/**
	 * Mass credit note function when many invoices are selected to be refunded
	 * @param type $table 
	 * @param type $primary_key 
	 * @param array $ids 
	 * @return int
	 */
	function create_credit_note($table, $primary_key, array $ids)
	{
		global $db;

		$CI = & get_instance();
		is_array($ids) OR $ids = array($ids);

		foreach ($ids as $id)
		{
		}
		return $CI->db->affected_rows();
	}
}
// ------------------------------------------------------------------------

function mollie_payment( $ids, $transaction_id )
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$user_id = $value->user_id;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
				}
			}
			$db_data = array(
				'date_paid' 		=> date('Y-m-d'),
				'amount_paid' 		=> $total,
				'amount_due' 		=> 0,
				'invoice_status' 	=> 'Paid',
				'payment_method' 	=> get_option('default_payment_method'),
				'sent' 				=> 'yes',
				'transaction_id' 	=> isset($transaction_id) ? $transaction_id : time(),
				'payment_gateway' 	=> 'Mollie',
				'user_id'			=> $user_id
				);
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);

			$last_amount_paid = floatval( get_invoice_vars( $id, 'amount_paid' ) );
			if ( $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
					'user_id'				=> $user_id
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
					'user_id'				=> $user_id
				);
				record_transaction($trans_data);
			}
			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> __('charges_financial_charges'),
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_sku'		=> 	generate_sku(),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'payment_method'    => get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id,
				'user_id'			=> $user_id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
	}
	return $CI->db->affected_rows();
}

// ------------------------------------------------------------------------
function stripe_payment( $ids, $transaction_id )
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
					$user_id = $value->user_id;
				}
			}
			$db_data = array(
				'date_paid' 		=> date('Y-m-d'),
				'amount_paid' 		=> $total,
				'amount_due' 		=> 0,
				'invoice_status' 	=> 'Paid',
				'payment_method' 	=> get_option('default_payment_method'),
				'sent' 				=> 'yes',
				'transaction_id' 	=> isset($transaction_id) ? $transaction_id : time(),
				'payment_gateway' 	=> 'Stripe',
				'user_id'			=> $user_id
				);
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			// Check if a payment has already be done
			$last_amount_paid = floatval( get_invoice_vars( $id, 'amount_paid' ) );
			if ( $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
					'user_id'				=> $user_id
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
					'user_id'				=> $user_id
				);
				record_transaction($trans_data);
			}

			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> __('charges_financial_charges'),
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_sku'		=> 	generate_sku(),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'payment_method'    => get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id,
				'user_id'			=> $user_id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
	}
	return $CI->db->affected_rows();
}

// ------------------------------------------------------------------------

function ingenico_payment( $ids, $transaction_id )
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
					$user_id = $value->user_id;
				}
			}
			$db_data = array(
				'date_paid' => date('Y-m-d'),
				'amount_paid' => $total,
				'amount_due' => 0,
				'invoice_status' => 'Paid',
				'payment_method' => get_option('default_payment_method'),
				'sent' => 'yes',
				'transaction_id' => isset($transaction_id) ? $transaction_id : time(),
				'payment_gateway' 	=> 'Ingenico',
				'user_id'				=> $user_id
				);
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);

			$last_amount_paid = floatval ( get_invoice_vars( $id, 'amount_paid' ) );
			if ( $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
					'user_id'				=> $user_id
				);
				record_transaction( $trans_data );
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
					'user_id'				=> $user_id
				);
				record_transaction( $trans_data );
			}
			
			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> __('charges_financial_charges'),
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_sku'		=> 	generate_sku(),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'payment_method' 	=> get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id,
				'user_id'			=> $user_id
				);
			record_charges( $charges_data, 'invoice_number', isset($id) ? $id: null );
		}
	}
	return $CI->db->affected_rows();
}

// ------------------------------------------------------------------------

function mark_refunded($id, $amount)
{
	$invoice = get_invoice_by_number($id);
	$invoice_id = 0;
	$total_refund = 0;
	$update_invoice = [];
	if ($invoice)
	{
		foreach ($invoice as $v) {
			$invoice_id = $v->id;
			$payment_id = $v->payment_id;

			if(!$payment_id)
			{
				$total_refund = $v->amount_refunded + $amount;
			}
			else
			{
				$total_refund = $amount;
			}
			$update_invoice = array(
				'payment_method' => $v->payment_method,
				'transaction_id' => time(),
				'subtotal' => $v->subtotal,
				'global_discount' => $v->global_discount,
				'tax_amount' => $v->tax_amount,
				'discount_amount' => $v->discount_amount,
				'total' => $v->total,
				'amount_paid' => $v->total - $total_refund,
				'credit_used' => $v->credit_used,
				'amount_due' => 0,
				'invoice_status' => 'Refunded',
				'sent' => 'yes',
				'notes' => $v->notes,
				'payment_id' => $v->payment_id,
				'amount_refunded' => $total_refund
				);
		}
		if ($update_invoice['amount_paid'] == 0)
		{
			$db_data2 = array(
				'date_paid' => NULL
				);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> 7,
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_category'	=> 1,
				'incomes_sku'	    => null,
				'payment_method'	=> $update_invoice['payment_method'],
				'incomes_value'	    => 0,
				'turnover_included'	=> 0,
				'taxes'             => 0,
				'created_on' 	    => date('Y-m-d'),
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
		else
		{
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			$update_invoice['invoice_status'] = "Refunded";
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> 7,
				'charges_value'	    => get_invoice_charges($id),
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_category'	=> 1,
				'incomes_sku'	    => null,
				'payment_method'	=> $update_invoice['payment_method'],
				'incomes_value'	    => $v->subtotal - $total_refund,
				'turnover_included'	=> 1,
				'taxes'             => $update_invoice['tax_amount'],
				'created_on' 	    => date('Y-m-d'),
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
		global $db;
		$query = "UPDATE {$db->tables['invoices']}
			SET " . $db->get_set($update_invoice) . 
			" WHERE id = {$invoice_id}";
		$db->query($query);
		$query2 = "UPDATE {$db->tables['invoices_items']}
					SET " . $db->get_set($db_data2) . 
					" WHERE invoice_number = " .$id;
		$db->query($query2);
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('mass_refund'))
{
	/**
	 * Mass refund function when many invoices are selected to be marked refunded
	 * @param type $table 
	 * @param type $primary_key 
	 * @param array $ids 
	 * @return int
	 */
	function mass_refund($table, $primary_key, array $ids)
	{
		global $db;

		$CI = & get_instance();
		is_array($ids) OR $ids = array($ids);
		foreach ($ids as $id) 
		{
			$results = get_invoice_by_id($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$CI->m_manager->credit_note_invoice($value->invoice_number);
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
function record_transaction($post_array)
{
	global $db;
	$db_data = array(
		'payment_method'		=> isset($post_array['payment_method']) ? $post_array['payment_method'] : get_option('default_payment_method'), 
		'payment_reference'		=> isset($post_array['payment_reference']) ? $post_array['payment_reference'] : now(), 
		'payment_amount'		=> isset($post_array['payment_amount']) ? $post_array['payment_amount'] : null,
		'date_paid'				=> isset($post_array['date_paid']) ? $post_array['date_paid'] : date('Y-m-d'),
		'invoice_number'		=> isset($post_array['invoice_number']) ? $post_array['invoice_number'] : null, 
		'purchase_number'		=> isset($post_array['purchase_number']) ? $post_array['purchase_number'] : null, 
		'payment_note'		    => isset($post_array['payment_note']) ? $post_array['payment_note'] : null,
		'user_id'		    	=> isset($post_array['user_id']) ? $post_array['user_id'] : USERID
	);
	$db->query("INSERT INTO {$db->tables['payment_history']} SET ".$db->get_set($db_data));
}

// ------------------------------------------------------------------------
function record_purchase_transaction($post_array)
{
	global $db;
	$db_data = array(
		'payment_method'		=> isset($post_array['payment_method']) ? $post_array['payment_method'] : get_option('default_payment_method'), 
		'payment_reference'		=> isset($post_array['payment_reference']) ? $post_array['payment_reference'] : now(), 
		'payment_amount'		=> isset($post_array['payment_amount']) ? $post_array['payment_amount'] : null,
		'date_paid'				=> isset($post_array['date_paid']) ? $post_array['date_paid'] : date('Y-m-d'),
		'purchase_number'		=> $post_array['purchase_number'], 
		'payment_note'		    => isset($post_array['payment_note']) ? $post_array['payment_note'] : null,
		'user_id'		    	=> isset($post_array['user_id']) ? $post_array['user_id'] : USERID
	);
	$db->query("INSERT INTO {$db->tables['payment_history']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function get_payment_history($invoice_number)
{
	global $db;
	$results = $db->get_results("SELECT * FROM oc_payment_history WHERE invoice_number = {$invoice_number}");
	if(!empty($results))
	{
		return $results;
	}
	return [];
}
// ------------------------------------------------------------------------
function get_purchase_payment_history($purchase_number)
{
	global $db;
	$results = $db->get_results("SELECT * FROM oc_payment_history WHERE purchase_number = {$purchase_number}");
	if(!empty($results))
	{
		return $results;
	}
	return [];
}
// ------------------------------------------------------------------------
function convert_payment_gateway_status($status)
{
	switch ($status) {
		case 'Paid':
		case 'Paidout':
			return 'Paid';
			break;
		case 'Unpaid':
		case 'Open':
		case 'Pending':
		case 'Failed':
		case 'Expired':
			return 'Unpaid';
			break;
		case 'Cancelled':
			return 'Cancelled';
			break;
		case 'Overdue':
			return 'Overdue';
			break;
		case 'Draft':
			return 'Draft';
			break;
		case 'Refunded':
		case 'Charged_back':
			return 'Refunded';
			break;
	}
}
function update_transaction($invoice_number, $amount, $tax_amount) {
	global $db;
	$incomes_value = 0;
	$taxes = 0;
	$transaction_id = 0;
	$invoice_number = get_invoice_vars($invoice_number, 'initial_invoice_number');
	$transaction = $db->get_results("SELECT transaction_id, incomes_value, taxes FROM oc_transactions WHERE invoice_number = '{$invoice_number}'");
	if ($transaction) {
		foreach ($transaction as $tran) {
			$transaction_id = $tran->transaction_id;
			$incomes_value = $tran->incomes_value;
			$taxes = $tran->taxes;
		}
	}
	$db_data = array(
		'incomes_value' => 0 < $incomes_value ? $incomes_value -= $amount : 0,
		'taxes'			=> 0 < $taxes ? $taxes -= $tax_amount: 0
	);	
	$query = "UPDATE {$db->tables['transactions']}
		SET " . $db->get_set($db_data) . 
		" WHERE transaction_id = {$transaction_id}";
	$db->query($query);
}
function report_annual_income($filter = null)
{
	global $db;
	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	$incomes = 0;
	$query = "SELECT YEAR(created_on) AS SalesYear,
	'~' AS SalesMonth,
	SUM(incomes_value) AS TotalSales,
	SUM(taxes) AS TotalTax,
	SUM(charges_value) AS TotalCharges
	FROM {$db->tables['transactions']}
	WHERE turnover_included = 1 {$additional_where}
	GROUP BY YEAR(created_on) DESC";
	$data = $db->get_results($query);
	if ($data && !$filter)
	{
		foreach ($data as $value) 
		{
			$accounting[] = array(
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'incomes' => floatval($value->TotalSales),
				'taxes' => floatval($value->TotalTax),			
				'charges' => floatval($value->TotalCharges)			
			);
		}
		return $accounting;
	}
	elseif ($data && $filter == 'incomes')
	{
		foreach ($data as $value) 
		{
			$incomes += floatval($value->TotalSales);
		}
		return $incomes;
	}
	else
	{
		return false;
	}
}
function report_forecast_income($filter = null) {
	global $db;

	$rbac = new Rbac;
	if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
		$additional_where = ' AND user_id = '. USERID;
		$additional_unique_where = ' WHERE user_id = '. USERID;
	} else {
		$additional_where = '';
	}

	$data = [];
	$accounting = [];
	$incomes = 0;
	$taxes = 0;

	$query = "SELECT YEAR(due_date) AS SalesYear,
		MONTH(due_date) AS SalesMonth,
		SUM(CASE WHEN invoice_status = 'Paid' OR invoice_status = 'Unpaid' OR invoice_status = 'Overdue'
			THEN subtotal ELSE 0 End) - 
		SUM(CASE WHEN invoice_status = 'Refunded'
			THEN subtotal ELSE 0 End) AS TotalSales,
		SUM(CASE WHEN invoice_status = 'Paid' OR invoice_status = 'Unpaid' OR invoice_status = 'Overdue'
			THEN tax_amount ELSE 0 End) - 
		SUM(CASE WHEN invoice_status = 'Refunded'
			THEN tax_amount ELSE 0 End) AS TotalTax
		FROM {$db->tables['invoices']} {$additional_unique_where}
		GROUP BY YEAR(due_date), MONTH(due_date)
		ORDER BY YEAR(due_date), MONTH(due_date)";
	$data = $db->get_results($query);
	if ($data && !$filter)
	{
		foreach ($data as $value) 
		{
			$incomes += floatval($value->TotalSales);
			$taxes += floatval($value->TotalTax);
			$accounting[] = array(
				'year' => $value->SalesYear,
				'month' => $value->SalesMonth,
				'incomes' => $incomes,
				'taxes' => $taxes,			
				'incomeswithtax' => $incomes + $taxes,			
				'charges' => 0			
			);
		}
		return $accounting;
	}
	elseif ($data && $filter == 'incomes')
	{
		foreach ($data as $value) 
		{
			$incomes += floatval($value->TotalSales);
		}
		return $incomes;
	}
	else
	{
		return false;
	}
}
if ( ! function_exists('get_db_vars')) {
	function get_db_vars($var = null) {
		$CI =& get_instance();
		$CI->load->database();
		if ( ! $var) {
			return array(
				'hostname' => $CI->db->hostname,
				'username' => $CI->db->username,
				'password' => $CI->db->password,
				'database' => $CI->db->database,
				'dbdriver' => $CI->db->dbdriver
			);
		} 
	}
}
if ( ! function_exists('get_user_id')) {
	function get_user_id() {
		return user('user_id');
	} 
}
function hasPermission($role, $permission) {
	$rbac = new Rbac;
	$role_id  = $rbac->Roles->returnId($role);
	$perm_id  = $rbac->Permissions->returnId($permission);

	return $rbac->Roles->hasPermission($role_id, $perm_id);
}
function can_add_edit_items_services($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('items_services_add_edit', $user_id) || $rbac->check('items_services_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_delete_items_services($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('items_services_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_access($entity, $user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	switch ($entity) {
		case 'homepage':
			if ($rbac->check('homepage_access_any', $user_id) || 
				$rbac->check('homepage_owner', $user_id)) {
				return true;
			} else {
				return false;
			}
		case 'customers':
			if ($rbac->check('customer_add_edit', $user_id) || 
				$rbac->check('customer_add_edit_delete', $user_id) ||
				$rbac->check('customer_owner', $user_id) || 
				$rbac->check('customer_access_any', $user_id)) {
				return true;
			} else {
				return false;
			}
		case 'items':
			if ($rbac->check('items_services_add_edit', $user_id) || 
				$rbac->check('items_services_add_edit_delete', $user_id)) {
				return true;
			} else {
				return false;
			}
		case 'update_price':
			if ($rbac->check('items_services_batch_update_price', $user_id)) {
				return true;
			} else {
				return false;
			}
		case 'time_tracking':
			if ($rbac->check('user_run_time_tracking', $user_id)) {
				return true;
			} else {
				return false;
			}
		case 'providers':
			if ($rbac->check('provider_add_edit', $user_id) || 
				$rbac->check('provider_add_edit_delete', $user_id)) {
				return true;
			} else {
				return false;
			}
		case 'stocks':
			if ($rbac->check('items_services_edit_stocks', $user_id)) { 
				return true;
			} else {
				return false;
			}
		case 'invoices':
			if ($rbac->check('invoice_add_edit', $user_id) || 
				$rbac->check('invoice_add_edit_delete', $user_id) || 
				$rbac->check('invoice_access_any', $user_id) || 
				$rbac->check('invoice_owner', $user_id) || 
				$rbac->check('invoice_create_credit_note', $user_id)) { 
				return true;
			} else {
				return false;
			}
		case 'purchases':
			if ($rbac->check('purchase_add_edit', $user_id) || 
				$rbac->check('purchase_add_edit_delete', $user_id)) { 
				return true;
			} else {
				return false;
			}
		case 'incomes_charges':
			if ($rbac->check('charge_income_add_edit', $user_id) || 
				$rbac->check('charge_income_access_any', $user_id) || 
				$rbac->check('charge_income_owner', $user_id) || 
				$rbac->check('charge_income_add_edit_delete', $user_id)
			) { 
				return true;
			} else {
				return false;
			}
		case 'reports':
			if (
				$rbac->check('report_access_any', $user_id) ||
				$rbac->check('report_owner', $user_id)
			) { 
				return true;
			} else {
				return false;
			}
		case 'settings':
			if (
				$rbac->check('setting_readonly', $user_id) ||
				$rbac->check('setting_read_write', $user_id)
			) { 
				return true;
			} else {
				return false;
			}
		case 'edit_commissions':
			if ($rbac->check('user_manage_commissions', $user_id)) { 
				return true;
			} else {
				return false;
			}
		case 'reset_password':
			if ($rbac->check('user_reset_password', $user_id)) { 
				return true;
			} else {
				return false;
			}
		default:
			return false;
	}
}
function can_add_edit_customers($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('customer_add_edit', $user_id) || $rbac->check('customer_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_delete_customers($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('customer_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_providers($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('provider_add_edit', $user_id) || $rbac->check('provider_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_delete_providers($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('provider_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_invoices($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('invoice_add_edit', $user_id) || $rbac->check('invoice_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_delete_invoices($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('invoice_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_purchases($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('purchase_add_edit', $user_id) || $rbac->check('purchase_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_delete_purchases($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('purchase_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_charges_incomes($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('charge_income_add_edit', $user_id) || $rbac->check('charge_income_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_add_edit_delete_charges_incomes($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('charge_income_add_edit_delete', $user_id)) {
		return true;
	}
	return false;
}
function can_create_credit_note($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('invoice_create_credit_note', $user_id)) {
		return true;
	}
	return false;
}
function can_batch_update_prices($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('items_services_batch_update_price', $user_id)) {
		return true;
	}
	return false;
}
function can_edit_items_services_stocks($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('items_services_edit_stocks', $user_id)) {
		return true;
	}
	return false;
}
function can_user_manage_access($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('user_manage_access', $user_id)) {
		return true;
	}
	return false;
}
function can_edit_settings($user_id = null) {
	$user_id = isset($user_id) ? $user_id : USERID;
	$rbac = new Rbac;
	if ($rbac->check('setting_read_write', $user_id)) {
		return true;
	}
	return false;
}
function hasRole($user_id, $locale = true) {
	$rbac = new Rbac;
	$roles = $rbac->Users->allRoles($user_id);
	if ($roles) {
	    foreach ($roles as $key => $value) {
	        if($rbac->Users->hasRole($value['Title'], $user_id)) {
	        	if ($locale) {
	        		return __($value['Title']);
	        	} else {
	        		return $value['Title'];
	        	}
	        }
	    }
	} 
}
function get_roles()
{
	global $db;
	$query = "SELECT ID, Title, Description FROM oc_roles";
	return $db->get_results($query);
}
function update_user_commissions_settings($type, $value, $id = null) {
	global $db;
	if ( ! $id) {
		$users = get_users();
	} else {
		$users = get_user_var($id);
	}
	if ($users) {
		foreach ($users as $user) {
			$query = "UPDATE {$db->tables['users']}
				SET " . $db->get_set(array('commission_type' => $type, 'commission_type_value' => $value)) . 
				" WHERE id = " .$user->id;
			$db->query($query);
		}
	}
}
function batch_pay_commissions($pay = null) {
	if ( _has_option('user_commissions') ) {
		global $db;
		$user_id = 0;
		$commission_type = '';
		$commission_value = 0;
		$invoice_subtotal = 0;

		$user_commission = 0;

		$query = "SELECT * FROM oc_invoices WHERE commission_status = 'Unpaid'";
		$results = $db->get_results($query);

		if ($results) {
			foreach ($results as $invoice) {
				$user_id = $invoice->user_id;
				$commission_settings = get_user_commission_settings($user_id);
				if ($commission_settings) {
					foreach ($commission_settings as $commission) {
						$commission_type = $commission->commission_type;
						$commission_value = $commission->commission_type_value;
					}
				}
				$invoice_subtotal = $invoice->subtotal;
				if ($commission_type == "fixed") {
					$user_commission = $commission_value;
				} else {
					$com = ($invoice_subtotal * $commission_value ) / 100;
					$user_commission = $com;
				}
				$query = "UPDATE oc_invoices
						SET " . $db->get_set(array('user_commission' => $user_commission, 'updated_on' => date('Y-m-d H:i:s'))) . 
						" WHERE id = " .$invoice->id;
				$db->query($query);
				if ($pay) {
					$query = "UPDATE oc_invoices
						SET " . $db->get_set(array('commission_status' => 'Paid', 'updated_on' => date('Y-m-d H:i:s'))) . 
						" WHERE id = " .$invoice->id;
						$db->query($query);
					// Record commissions
					if(get_option('commission_in_charges') == 1) {
						$charges_category = get_option('commission_charges_cat');
						$charges_name = get_charges_category($charges_category);
						$charges_value = $user_commission;
						$payment_method = get_user_payment_method($user_id);

						$post_array = array(
							'charges_name'					=> $charges_name,
							'charges_category'				=> $charges_category,
							'charges_value'					=> $charges_value,
							'payment_method'				=> $payment_method,
							'turnover_included'				=> 1,
							'invoice_number'				=> $invoice->invoice_number,
							'user_id'						=> $user_id,
							'update_on'						=> date('Y-m-d H:i:s')
							);
						record_charges($post_array);
					}
				}
			}
			return true;
		}
	}
	return true;
}
function batch_pay_users_commissions($ids, $pay = null) {
	if ( _has_option('user_commissions') ) {
		global $db;
		$user_id = 0;

		is_array($ids) OR $ids = array($ids);
		foreach ($ids as $id) {
			$commission_type = '';
			$commission_value = 0;
			$invoice_subtotal = 0;

			$user_commission = 0;
			$user_id = _dID($id);


			$query = "SELECT * FROM oc_invoices WHERE commission_status = 'Unpaid' AND user_id = {$user_id}";
			$results = $db->get_results($query);

			if ($results) {
				foreach ($results as $invoice) {
					$commission_settings = get_user_commission_settings($user_id);
					if ($commission_settings) {
						foreach ($commission_settings as $commission) {
							$commission_type = $commission->commission_type;
							$commission_value = $commission->commission_type_value;
						}
					}
					$invoice_subtotal = $invoice->subtotal;
					if ($commission_type == "fixed") {
						$user_commission = $commission_value;
					} else {
						$com = ($invoice_subtotal * $commission_value ) / 100;
						$user_commission = $com;
					}
					$query = "UPDATE oc_invoices
							SET " . $db->get_set(array('user_commission' => $user_commission, 'updated_on' => date('Y-m-d H:i:s'))) . 
							" WHERE id = " .$invoice->id;
					$db->query($query);
					if ($pay) {
						$query = "UPDATE oc_invoices
							SET " . $db->get_set(array('commission_status' => 'Paid', 'updated_on' => date('Y-m-d H:i:s'))) . 
							" WHERE id = " .$invoice->id;
							$db->query($query);
						// Record commissions
						if(get_option('commission_in_charges') == 1) {
							$charges_category = get_option('commission_charges_cat');
							$charges_name = get_charges_category($charges_category);
							$charges_value = $user_commission;
							$payment_method = get_user_payment_method($user_id);

							$post_array = array(
								'charges_name'					=> $charges_name,
								'charges_category'				=> $charges_category,
								'charges_value'					=> $charges_value,
								'payment_method'				=> $payment_method,
								'turnover_included'				=> 1,
								'invoice_number'				=> $invoice->invoice_number,
								'user_id'						=> $user_id,
								'update_on'						=> date('Y-m-d H:i:s')
								);
							record_charges($post_array);
						}
					}
				}
			}
		}
	}
	return true;
}
function get_user_commission_settings($user_id) {
	global $db;
	$eligible_roles = json_decode( null !== get_option( 'eligible_roles' ) ? get_option( 'eligible_roles' ): json_encode([]));
	if (in_array( strtolower(hasRole($user_id)), $eligible_roles)) {
		$query = "SELECT id, commission_type, commission_type_value FROM users WHERE id = {$user_id}";
		return $db->get_results($query);
	} else {
		return [];
	}
}
function get_user_commissions($user_id) {
	$user_id = isset($user_id) ? $user_id : USERID;
	global $db;
	$query = "SELECT invoice_number, subtotal, user_commission, commission_status, updated_on FROM oc_invoices WHERE user_id = '{$user_id}'";
	return $db->get_results($query);
}
function cron_generate_commissions() {
	if ( get_option('apply_commission_on_paid_order') == 'auto' && _has_option('user_commissions')) {
		batch_pay_commissions();
	}
}
function get_user_payment_method($user_id) {
	global $db;
	$query = "SELECT user_own_paypal, user_own_skrill, user_own_bank_number FROM users WHERE id = '{$user_id}'";
	$results = $db->get_results($query);
	if ($results) {
		foreach ($results as $method) {
			if ($method->user_own_paypal) {
				return __('option_paypal');
			} elseif ($method->user_own_skrill) {
				return __('option_skrill');
			} elseif ($method->user_own_bank_number) {
				return __('option_bank_transfer');
			} else {
				return __('cash');
			}
		}
	}
}
function get_item_service_vars_by_name($name, $var) {
	global $db;

	$query = "SELECT {$var} FROM oc_items WHERE name LIKE '{$name}'";
	return $db->get_row($query)->{$var};
}
function billing_address($id, $var) {
	global $db;
	switch ($var) {
		case 'billing_phone':
			$default_var = "client_phone";
			break;
		case 'billing_address1':
			$default_var = "client_address1";
			break;
		case 'billing_address2':
			$default_var = "client_address2";
			break;
		case 'billing_city':
			$default_var = "client_city";
			break;
		case 'billing_country':
			$default_var = "client_country";
			break;
		case 'billing_name_company':
			$default_var = "name_company";
			break;
	}
	$query = "SELECT {$var} FROM oc_clients WHERE client_id = '{$id}'";
	return null == $db->get_row("SELECT {$var} FROM oc_clients WHERE client_id = '{$id}'") ? client($id, $default_var) : $db->get_row($query)->{$var};
}
function shipping_address($id, $var) {
	global $db;
	switch ($var) {
		case 'shipping_phone':
			$default_var = "client_phone";
			break;
		case 'shipping_address1':
			$default_var = "client_address1";
			break;
		case 'shipping_address2':
			$default_var = "client_address2";
			break;
		case 'shipping_city':
			$default_var = "client_city";
			break;
		case 'shipping_country':
			$default_var = "client_country";
			break;
		case 'shipping_name_company':
			$default_var = "name_company";
			break;
	}
	$query = "SELECT {$var} FROM oc_clients WHERE client_id = '{$id}'";
	return null == $db->get_row("SELECT {$var} FROM oc_clients WHERE client_id = '{$id}'") ? client($id, $default_var) : $db->get_row($query)->{$var};
}
function get_gdpr_link($client_id) {
	$lang = client($client_id, 'client_language');
	switch ($lang) {
		case 'fr_FR':
			return 'https://fr.wikipedia.org/wiki/R%C3%A8glement_g%C3%A9n%C3%A9ral_sur_la_protection_des_donn%C3%A9es';
		case 'en_US':
			return 'https://en.wikipedia.org/wiki/General_Data_Protection_Regulation';
		default:
			return 'https://en.wikipedia.org/wiki/General_Data_Protection_Regulation';
	}
}
function is_valid_license($code) {
	switch ($code) {
		case '0':
			return '<span style="color:red; font-weight:bold;">'. strtoupper(__('label_invalid')).'</span>';
		case '1':
			return '<span style="color:green; font-weight:bold;">'. strtoupper(__('label_valid')).'</span>';
	};
}
function __parse_url($url) {
	$url = rtrim($url,"/").'/';
	$parse = parse_url($url);
	return rtrim(preg_replace('#^www\.(.+\.)#i', '$1', $parse['host']) . $parse['path'], "/");
}
function mysql_backup_db() {
	$dbvars = get_db_vars();

	$dbhost =$dbvars['hostname']; // usually localhost
	$dbuser = $dbvars['username']; //enter your database username here
	$dbpass = $dbvars['password']; //enter your database password here
	$dbname = $dbvars['database']; // enter your database name here
	$sendto = get_option('notifications_email');
	$sendfrom = get_option('email');
	$cc = get_option('notifications_email_2');
	$sendsubject = __('subject_database_backup');
	$bodyofemail = __('message_database_backup_notification'). '<br /><br />'.__('backup_email_message_signature'). '<br /><br />';
	// don't need to edit below this section

	$backupfile = $dbname . date("Y-m-d") . '.sql.gz';
	system("mysqldump -h $dbhost -u $dbuser --password=$dbpass $dbname | gzip > $backupfile");

	// Mail the file
	send_email($sendto, $bodyofemail, $sendsubject, $sendfrom, $cc, $backupfile, $backupfile);

	// Delete the file from your server
	unlink($backupfile);
}
function __render($module, $view_file, $data = null, $return = false) {
	$CI =& get_instance();
	$theme = null == get_option('theme') ? 'default' : get_option('theme'); 
	$theme_name = null == get_option('theme_name') ? 'darkblue' : get_option('theme_name');
	$file_path = $theme_name.'/'.$theme.'/modules/'.$module.'/views/'.$view_file;
	if (file_exists(getcwd().'/themes/'.$file_path)) {
		return $CI->load->view($file_path, $data, $return);
	} else {
		$file_path = $theme_name.'/default/modules/'.$module.'/views/'.$view_file;
		return $CI->load->view($file_path, $data, $return);
	}
}
/**
 * Interpolates context values into the message placeholders.
 */
function interpolate($message, array $context = array())
{
    // build a replacement array with braces around the context keys
    $replace = array();
    foreach ($context as $key => $val) {
        // check that the value can be casted to string
        if (!is_array($val) && (!is_object($val) || method_exists($val, '__toString'))) {
            $replace['{' . $key . '}'] = $val;
        }
    }

    // interpolate replacement values into the message and return
    return strtr($message, $replace);
}
if ( ! function_exists('boolval')) {
	function boolval($var) {
		return !! $var;
	} 
}
if ( ! function_exists('add_ip')) {
	function add_ip($ip) {
		global $db;

		$ips = null == get_option('authorized_ips') ? [] : json_decode(get_option('authorized_ips'), true);
		if ( !in_array($ip, $ips)) {
			array_push($ips, $ip);
			set_option(array(
			    'option_name' => "authorized_ips",
			    'option_value' => json_encode($ips)
			    )
			);
			return true;
		}
		return false;
	} 
}
if ( ! function_exists('order_status_str')) {
	function order_status_str($status) {
		switch ($status) {
			case 'Billed':
				return __('label_billed');
			case 'Draft':
				return __('option_draft');
			case 'Pending':
				return __('label_pending');
			case 'Progress':
				return __('label_progress');
			case 'Awaiting Payment':
				return __('label_awaiting_payment');
			case 'Awaiting Fulfillment':
				return __('label_awaiting_fulfillment');
			case 'Awaiting Shipment':
				return __('label_awaiting_shipment');
			case 'Awaiting Pickup':
				return __('label_awaiting_pickup');
			case 'Partially Shipped':
				return __('label_partially_shipped');
			case 'Completed':
				return __('label_completed');
			case 'Shipped':
				return __('label_shipped');
			case 'Cancelled':
				return __('option_cancelled');
			case 'Declined':
				return __('label_declined');
			case 'Refunded':
				return __('label_refunded');
			case 'Disputed':
				return __('label_disputed');
			case 'Manual Verification Required':
				return __('label_manual_verification_required');
			case 'Partially Refunded':
				return __('option_partially_refunded');	
			default:
				return __('label_progress');
		}
	} 
}
if ( ! function_exists('is_authorized_ip')) {
	function is_authorized_ip($ip) {
		global $db;

		$ips = null == get_option('authorized_ips') ? [] : json_decode(get_option('authorized_ips'), true);
		if ( in_array($ip, $ips)) {
			return true;
		}
		return false;
	} 
}
if ( ! function_exists('create_ticket')) {
	function create_ticket() {
		global $db;
		return (object) array(
			'id'	=> get_next_id('support'),
			'created_on'	=> _fdate(get_option('user_language'), date('Y-m-d'))
		);
	} 
}
if ( ! function_exists('record_additional_taxes_meta')) {
	function record_additional_taxes_meta($invoice_number) {
		global $db;
		$tax_meta = [];
		$additional_taxes_array = json_decode(get_invoice_vars($invoice_number, 'additional_taxes'), true);
		$subtotal = get_invoice_vars($invoice_number, 'subtotal');
		$tax_amount = get_invoice_vars($invoice_number, 'tax_amount');
		
		$ids = $db->get_results("SELECT id FROM oc_additional_taxes_meta WHERE invoice_number = {$invoice_number}");
		$to_del = [];
		if ($ids) {
			foreach ($ids as $id) {
				array_push($to_del, $id->id);
			}
			foreach ($to_del as $value) {
				delete('additional_taxes_meta', 'id', $value);
			}
		}
		foreach ($additional_taxes_array as $key => $t) {
			$invoice_surcharge_amount = 0;
			$invoice_deduct_amount = 0;
			foreach ($t as $tax) {
				if (get_additional_tax($tax['id'], 'additional_tax_criteria') == 'add_after_all_taxes') {
					$invoice_surcharge_amount = $tax['value'];
				}
				if (get_additional_tax($tax['id'], 'additional_tax_criteria') == 'deduct_after_all_taxes') {
					$invoice_deduct_amount = $tax['value'];
				}
				$tax_meta[] = [
					'additional_tax_id' => $tax['id'],
					'additional_tax_rate' => $tax['rate'],
					'additional_tax_criteria' => get_additional_tax($tax['id'], 'additional_tax_criteria'),
					'invoice_number' => $invoice_number,
					'invoice_subtotal' => $subtotal,
					'invoice_tax_amount' => $tax_amount,
					'invoice_surcharge_amount' => $invoice_surcharge_amount,
					'invoice_deduct_amount' => $invoice_deduct_amount,
					'date_paid' => date('Y-m-d')
				];
			}
		}
		foreach ($tax_meta as $value) {
			$db->query("INSERT INTO {$db->tables['additional_taxes_meta']} SET ".$db->get_set($value));
		}
	} 
}
function get_tickets($start = null, $end = null) {
	global $db;
	return $db->get_results("SELECT * FROM oc_support ORDER BY id DESC");
}
function get_ticket_messages($id) {
	global $db;
	return $db->get_results("SELECT * FROM oc_support_details WHERE ticket_id = {$id} ORDER BY id DESC");
}
function get_ticket($id) {
	global $db;
	return $db->get_row("SELECT * FROM oc_support WHERE id = '{$id}'");
}
function get_support_total_duration($id, $duration) {
	global $db;
	$current_duration = null == $db->get_row("SELECT total_duration FROM oc_support WHERE id = '{$id}'") ? 0 : $db->get_row("SELECT total_duration FROM oc_support WHERE id = '{$id}'")->total_duration;
	$total = floatval($current_duration) + floatval($duration);

	return $total;
}
function get_support_vars($id, $var) {
	global $db;
	return $db->get_row("SELECT {$var} FROM oc_support WHERE id = '{$id}'")->$var;

}
function set_support_vars($id, $args) {
	global $db;
	if ($id) {
		$query = "UPDATE {$db->tables['support']}
			SET " . $db->get_set($args) . 
			" WHERE id = {$id}";
		$db->query($query);
	}
}
function update_client_support_contract($id, $duration, $context) {
	global $db;
	$current = get_support($id);

	switch ($context) {
		case '-':
			$new = floatval($current) - floatval($duration);
			if ($new > 0) {
				$new_support = $new;
			} else {
				$new_support = 0;
			}
			$query = "UPDATE {$db->tables['clients']}
				SET " . $db->get_set(array('support_contract' => $new_support)) . 
				" WHERE client_id = {$id}";
			$db->query($query);
			break;
		case '+':
			$new = floatval($current) + floatval($duration);

			$query = "UPDATE {$db->tables['clients']}
				SET " . $db->get_set(array('support_contract' => $new)) . 
				" WHERE client_id = {$id}";
			$db->query($query);
			break;
	}
}
function get_support_extra_time($ticket_id, $extra_time_to_bill, $context) {
	global $db;
	$current = get_support_vars($ticket_id, 'extra_time_to_bill');

	switch ($context) {
		case '-':
			return floatval($current) - floatval($extra_time_to_bill);
		case '+':
			return floatval($current) + floatval($extra_time_to_bill);
	}
}
function set_support_extra_time($ticket_id, $duration, $context) {
	global $db;
	$current = get_support_vars($ticket_id, 'extra_time_to_bill');
	switch ($context) {
		case '-':
			$new = floatval($current) - floatval($duration);
			break;
		case '+':
			$new = floatval($current) + floatval($duration);
			break;
	}
	$query = "UPDATE {$db->tables['support']}
		SET " . $db->get_set(array('extra_time_to_bill' => $new)) . 
		" WHERE id = {$ticket_id}";
	$db->query($query);
}
function convertToHoursMins($time, $format = '%02d:%02d:%02d') {
    if ($time < 1) {
        return;
    }
    $hours = floor($time / 60);
    $minutes = ($time % 60);
    $seconds = ($time / 3600);
    return sprintf($format, $hours, $minutes, $seconds);
}
function getInvoiceTaxVars($invoice_number, $tax_rate, $context) {
	$items = get_invoiced_items($invoice_number);
	$subtotal = 0;
	$tax_amount = 0;

	switch ($context) {
		case 'subtotal':
			if ($items) {
				foreach ($items as $item) {
					if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
						$subtotal += $item->item_subtotal;
					}
				}
				return $subtotal;
			}
		case 'tax_amount':
			if ($items) {
				foreach ($items as $item) {
					if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
						$subtotal += $item->item_subtotal;
						$tax_amount = floatval($subtotal * $tax_rate / 100);
					}
				}
				return $tax_amount;
			}
	}
}
function getQuoteTaxVars($quote_number, $tax_rate, $context) {
	$items = get_quoted_items($quote_number);
	$subtotal = 0;
	$tax_amount = 0;

	switch ($context) {
		case 'subtotal':
			if ($items) {
				foreach ($items as $item) {
					if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
						$subtotal += $item->item_subtotal;
					}
				}
				return $subtotal;
			}
		case 'tax_amount':
			if ($items) {
				foreach ($items as $item) {
					if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
						$subtotal += $item->item_subtotal;
						$tax_amount = floatval($subtotal * $tax_rate / 100);
					}
				}
				return $tax_amount;
			}
	}
}
function isValidDate($date, $format = 'Y-m-d H:i:s')
{
    $d = DateTime::createFromFormat($format, $date);
    // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
    return $d && $d->format($format) === $date;
}
function getUrlContent($url){
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
	curl_setopt($ch, CURLOPT_TIMEOUT, 5);
	$data = curl_exec($ch);
	$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);
	return ($httpcode>=200 && $httpcode<300) ? $data : false;
}
function getOrderTaxVars($order_number, $tax_rate, $context) {
	$items = get_sale_items($order_number);
	$subtotal = 0;
	$tax_amount = 0;

	switch ($context) {
		case 'subtotal':
			if ($items) {
				foreach ($items as $item) {
					if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
						$subtotal += $item->item_subtotal;
					}
				}
				return $subtotal;
			}
		case 'tax_amount':
			if ($items) {
				foreach ($items as $item) {
					if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
						$subtotal += $item->item_subtotal;
						$tax_amount = floatval($subtotal * $tax_rate / 100);
					}
				}
				return $tax_amount;
			}
	}
}
function upgrade_dbs_for_additional_taxes() {
	if ( ! col_exists('invoices', 'additional_taxes')) {
		global $db;
		$db->query("ALTER TABLE `oc_invoices` ADD `additional_taxes` text NULL");
		$db->query("ALTER TABLE `oc_quotes` ADD `additional_taxes` text NULL");

		if ( db_table_exists('oc_orders')) {
			$db->query("ALTER TABLE `oc_orders` ADD `additional_taxes` text NULL");
		}
	}
}
function upgrade_db_add_mpn() {
	if ( ! col_exists('items', 'product_mpn')) {
		global $db;
		$db->query("ALTER TABLE `oc_items` ADD `product_mpn` VARCHAR(20) NULL");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `product_mpn` VARCHAR(20) NULL");
		$db->query("ALTER TABLE `oc_purchaseitems` ADD `product_mpn` VARCHAR(20) NULL");
		$db->query("ALTER TABLE `oc_orderitems` ADD `product_mpn` VARCHAR(20) NULL");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `product_mpn` VARCHAR(20) NULL");
	}
}
function is_italian_company() {
	return get_option('country') == 'IT' ? true: false;
}
function add_italian_fields() {
	if (is_italian_company()) {
		if ( ! col_exists('clients', 'client_fiscal_code')) {
			global $db;
			$db->query("ALTER TABLE `oc_clients` ADD `client_fiscal_code` VARCHAR(20) NULL");
		}
	}
}
function addAnnualNumbering() {
	if ( ! col_exists('invoices', 'annual_number_key')) {
		global $db;
		$db->query("ALTER TABLE `oc_invoices` ADD `annual_number_key` VARCHAR(20) NULL");
		$db->query("ALTER TABLE `oc_quotes` ADD `annual_number_key` VARCHAR(20) NULL");
		$db->query("ALTER TABLE `oc_orders` ADD `annual_number_key` VARCHAR(20) NULL");
		$db->query("ALTER TABLE `oc_purchases` ADD `annual_number_key` VARCHAR(20) NULL");
		$db->query("CREATE TABLE IF NOT EXISTS `oc_annual_sequencing` (`id` int(11) NOT NULL AUTO_INCREMENT, `entity` VARCHAR(225) NOT NULL, `value` INT(11) NOT NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
		set_invoices_annual_number_key();
	}
}
function set_invoices_annual_number_key($year = null) {
	global $db;
	$years = [];
	$yearData = [];
	$last_key = 0;
	if ( ! $year) {
		$query = "SELECT DISTINCT YEAR(updated_on) as Year 
			FROM {$db->tables['invoices']}
			ORDER BY YEAR(updated_on) ASC";
	}
	$results = $db->get_results($query);
	if ($results) {
		foreach ($results as $year) {
			array_push($years, $year->Year);
		}
	}
	if ($years) {
		foreach ($years as $year) {
			$yearData[$year] = $db->get_results("SELECT id FROM oc_invoices WHERE updated_on LIKE '{$year}%'");
		}
	}
	if ($yearData) {
		foreach ($yearData as $key => $value) {
			$year = $key;
			foreach ($value as $key => $id) {
				$db_data = array('annual_number_key' => ++$key);
				$last_key = ++$key;
				$query = "UPDATE {$db->tables['invoices']}
					SET " . $db->get_set($db_data) . 
					" WHERE id =".$id->id;
				$db->query($query);
			}
		}
		update_annual_sequencing('invoice', $last_key);
	}
}
function update_annual_sequencing($entity, $value) {
	global $db;
	$id = null != $db->get_row("SELECT id FROM oc_annual_sequencing WHERE entity = '{$entity}'") ? $db->get_row("SELECT id FROM oc_annual_sequencing WHERE entity = '{$entity}'")->id: false;
	if ($id) {
		$query = "UPDATE oc_annual_sequencing
			SET " . $db->get_set(array('entity' => 'invoice', 'value' => $value)) . 
			" WHERE id =".$id;
		$db->query($query);
	} else {
		$db->query("INSERT INTO oc_annual_sequencing SET ".$db->get_set(array('entity' => 'invoice', 'value' => $value)));
	}
}
function get_additional_tax($id, $var) {
	$taxes = get_additional_taxes();
	if ($taxes) {
		foreach ($taxes as $tax) {
			if ($tax->id == $id) {
				return $tax->{$var};
			}
		}
	}
}
function get_invoice_surcharge($invoice_number) {
	global $db;
	$query = "SELECT invoice_surcharge_amount FROM oc_additional_taxes_meta WHERE invoice_number = {$invoice_number} AND invoice_is_cancelled = 0";
	$results = $db->get_results($query);

	$total = 0;
	if ($results) {
		foreach ($results as $value) {
			$total += floatval($value->invoice_surcharge_amount);
		}
	}
	return $total;
}
if ( ! function_exists('db_reconnect')) {
	function db_reconnect() {
		$CI =& get_instance();
		$CI->db->reconnect();
	}
}
function db_add_overdue_invoice_reminder()
{
	global $db;

	if ( ! col_exists('invoices', 'next_overdue_reminder'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `next_overdue_reminder` datetime DEFAULT NULL");
		$db->query("ALTER TABLE `oc_clients` ADD `send_overdue_reminder` tinyint(1) DEFAULT 1");
	}
}

function send_overdue_invoices_reminder() {

	if (!_has_option('turn_off_customer_invoice_emails')) {
		$reminder_type = null != get_option('reminder_type') ? get_option('reminder_type') : 2;
		$CI =& get_instance();
		global $db;

		switch ($reminder_type) {
			case '1':
				$invoices = $db->get_results("SELECT DISTINCT invoice_number FROM oc_invoices WHERE invoice_status = 'Overdue' AND date(next_overdue_reminder) <= DATE(NOW())");
				if ($invoices) {
					foreach ($invoices as $value) {
						$invoice_number = $value->invoice_number;
						$results = get_invoice_by_number($invoice_number);
						if ($results) {
							foreach ($results as $invoice) {
								if ($invoice->client_id && in_notify($invoice->client_id)) {
									$currency = $invoice->client_id == 0 ? get_option('user_currency') : client( $invoice->client_id, 'client_currency' );
									$change_rate = _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;

									$data = array(
										'invoice_url'				=> base_url( 'index.php/viewinvoice/view?id=' ) . _eID( $invoice_number ),
										'to_name'            		=> html_entity_decode(client( $invoice->client_id, 'name_company' )),
										'date'		    			=> _fdate( client( $invoice->client_id, 'client_language' ), $invoice->due_date ),
										'invoice_status'			=> __( strtolower( $invoice->invoice_status ) ),
										'invoice_number' 			=> get_option( 'invoice_prefix' ).invoice_number_format() . sprintf( "%04s", $invoice_number ),
										'invoicesubject'			=> $invoice->subject
										);
									$data['invoice_amount'] 		= add_currency( format_number( $invoice->total * $change_rate ), $invoice->client_id );
									$data['amount_paid'] 			= add_currency( format_number( $invoice->amount_paid * $change_rate ), $invoice->client_id );
									$data['amount_due'] 			= add_currency( format_number( $invoice->amount_due * $change_rate ), $invoice->client_id );
									$data['amount_refunded'] 		= add_currency( format_number( $invoice->amount_refunded * $change_rate ), $invoice->client_id );
									$data['client_account'] 		= base_url( 'index.php/client/index?id=' ) . _eID( $invoice->client_id );
									$data['logo_url'] 				= base_url( 'uploads/admin/img/' ). get_option( 'logo' );
									$data['btn_client_account'] 	= __( 'btn_client_account', $invoice->client_id );

									$CI->load->helper('file');

									$lang = lang_code_to_notif_string( client( $invoice->client_id, 'client_language' ) );
									$path_overdue_reminder = './notifications/' . $lang . '/invoices/overdue_invoice_reminder.php';

									$to = client( $invoice->client_id, 'client_email' );
									$template = read_file( $path_overdue_reminder );
									$subject = __( 'label_overdue_invoice_reminder', $invoice->client_id );
									$message = $CI->parser->parse_string( $template, $data, true );

									send_email( $to, $message, $subject );
									set_next_overdue_invoice_reminder($invoice->client_id);
								}
							}
						}
					}
				} else {
					return false;
				}
				break;
			case '2':
				$ids = $db->get_results("SELECT DISTINCT client_id FROM oc_invoices WHERE invoice_status = 'Overdue' AND date(next_overdue_reminder) <= DATE(NOW())");
				if ($ids) {
					foreach ($ids as $value) {
						$client_id = $value->client_id;
						if ($client_id && in_notify($client_id)) {
							$results = $db->get_row("SELECT COUNT(id) AS TotalOverdueInvoices FROM oc_invoices WHERE invoice_status = 'Overdue' AND client_id = {$client_id}")->TotalOverdueInvoices;

							if ($results) {
								$data = array(
									'to_name'            		=> html_entity_decode(client( $client_id, 'name_company' )),
									'count_overdue'		    	=> intval($results)
									);
								$data['client_account'] 		= base_url( 'index.php/client/index?id=' ) . _eID( $client_id );
								$data['logo_url'] 				= base_url( 'uploads/admin/img/' ). get_option( 'logo' );
								$data['btn_client_account'] 	= __( 'btn_client_account', $client_id );

								$CI->load->helper('file');

								$lang = lang_code_to_notif_string( client( $client_id, 'client_language' ) );
								$path_overdue_reminder = './notifications/' . $lang . '/invoices/overdue_invoice_single_reminder.php';

								$to = client( $client_id, 'client_email' );
								$template = read_file( $path_overdue_reminder );
								$subject = __( 'label_overdue_invoice_reminder', $client_id );
								$message = $CI->parser->parse_string( $template, $data, true );

								send_email( $to, $message, $subject );
								set_next_overdue_invoice_reminder($client_id);
							}
						}
					}
				} else {
					return false;
				}
				break;
			default:
				$ids = $db->get_results("SELECT DISTINCT client_id FROM oc_invoices WHERE invoice_status = 'Overdue' AND date(next_overdue_reminder) <= DATE(NOW())");
				if ($ids) {
					foreach ($ids as $value) {
						$client_id = $value->client_id;
						$results = $db->get_row("SELECT COUNT(id) AS TotalOverdueInvoices FROM oc_invoices WHERE invoice_status = 'Overdue' AND client_id = {$client_id}")->TotalOverdueInvoices;

						if ($results) {
							$data = array(
								'to_name'            		=> html_entity_decode(client( $client_id, 'name_company' )),
								'count_overdue'		    	=> $results
								);
							$data['client_account'] 		= base_url( 'index.php/client/index?id=' ) . _eID( $client_id );
							$data['logo_url'] 				= base_url( 'uploads/admin/img/' ). get_option( 'logo' );
							$data['btn_client_account'] 	= __( 'btn_client_account', $client_id );

							$CI->load->helper('file');

							$lang = lang_code_to_notif_string( client( $client_id, 'client_language' ) );
							$path_overdue_reminder = './notifications/' . $lang . '/invoices/overdue_invoice_single_reminder.php';

							$to = client( $client_id, 'client_email' );
							$template = read_file( $path_overdue_reminder );
							$subject = __( 'label_overdue_invoice_reminder', $client_id );
							$message = $CI->parser->parse_string( $template, $data, true );

							send_email( $to, $message, $subject );
							set_next_overdue_invoice_reminder($client_id);
						}
					}
				} else {
					return false;
				}
			break;
		}
		$apply_late_fees = _has_option('apply_late_fees') ?? 0;
		if ($apply_late_fees && "after_reminder" == get_option('apply_late_fees_when')) {
			$invoices = $db->get_results("SELECT DISTINCT invoice_number FROM oc_invoices WHERE invoice_status = 'Overdue' AND date(next_overdue_reminder) <= DATE(NOW())");
			if ($invoices) {
				foreach ($invoices as $value) {
					$invoice_number = $value->invoice_number;
					$CI->m_manager->apply_late_fees($invoice_number);
				}
			}
		}
	}
}

function set_next_overdue_invoice_reminder($client_id) {
	global $db;
	$interval = null != get_option('reminder_interval') ? '+'.intval(get_option('reminder_interval')).' day': '+3 day';
	$next_warning = date('Y-m-d', strtotime($interval, now()));
	
	$invoices = $db->get_results("SELECT id from oc_invoices WHERE invoice_status = 'Overdue' AND client_id = '{$client_id}'");
	if ($invoices) {
		foreach ($invoices as $value) {
			$invoice_id = $value->id;
			$db_data = array('next_overdue_reminder' => $next_warning);
			$db->query("UPDATE {$db->tables['invoices']} SET ".$db->get_set($db_data) . " WHERE id = {$invoice_id}");
		}
	}
}
function db_add_item_serial_number()
{
	global $db;

	if ( ! col_exists('items', 'serial_number'))
	{
		$db->query("ALTER TABLE `oc_items` ADD `serial_number` VARCHAR(225)");
	}
}
function db_add_time_tracker() {
	global $db;
	if ( ! db_table_exists('oc_time_tracker'))
	{
		$db->query("CREATE TABLE IF NOT EXISTS `oc_time_tracker` (`id` int(11) NOT NULL AUTO_INCREMENT, `client_id` INT(11),`user_id` INT(11), `item_id` INT(11), `item_sku` VARCHAR(225),`item_name` VARCHAR(225),`item_price` DECIMAL(10,2),`item_quantity` DECIMAL(10,3),`item_non_formatted_quantity` INT(11),`item_subtotal` DECIMAL(10,2),`item_non_formatted_subtotal` VARCHAR(225), `item_description` TEXT, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
}
if ( ! function_exists('get_user_id_by_name')) {
	function get_user_id_by_name($user_name = null)
	{
		global $db;
		$user_name = addslashes($user_name);

		if (!$user_name)
		{
			return intval(0);
		}
		else
		{
			return $db->get_row("SELECT id FROM {$db->tables['users']} WHERE first_name LIKE '{$user_name}'")->id;
		}
	}
}
if ( ! function_exists('get_item_vars_by_name')) {
	function get_item_vars_by_name($item_name, $var)
	{
		global $db;
		$item_name = addslashes($item_name);

		if (!$item_name)
		{
			return intval(0);
		}
		else
		{
			return $db->get_row("SELECT {$var} FROM {$db->tables['items']} WHERE name LIKE '{$item_name}'")->$var;
		}
	}
}
if ( ! function_exists('save_timers')) {
	function save_timers($db_data)
	{
		global $db;

		if (!$db_data)
		{
			return false;
		}
		else
		{
			$db->query("TRUNCATE oc_time_tracker");

			foreach ($db_data as $key => $value) {
				$db->query("INSERT INTO oc_time_tracker SET ".$db->get_set($value));
			}
		}
	}
}
if ( ! function_exists('get_timers')) {
	function get_timers()
	{
		global $db;
		return $db->get_results("SELECT * FROM oc_time_tracker");
	}
}
if ( ! function_exists('get_tracker_item')) {
	function get_tracker_item($id)
	{
		global $db;
		return $db->get_results("SELECT * FROM oc_time_tracker WHERE id = {$id}");
	}
}
if ( ! function_exists('set_repair_vars')) {
	function set_repair_vars($repair_number, $data)
	{
		global $db;
		$db->query("UPDATE oc_tickets SET ".$db->get_set($data) . " WHERE id = {$repair_number}");
	}
}
if ( ! function_exists('has_repair_module')) {
	function has_repair_module()
	{
		return (bool)db_table_exists('oc_tickets');
	}
}
if ( ! function_exists('get_plugings')) {
	function get_plugings()
	{
		global $db;
		$plugin = get_option('premium_plugins');
		if ($plugin) {
			return json_decode($plugin, true);
		} else {
			return false;
		}
	}
}
if ( ! function_exists('set_plugings')) {
	function set_plugings($menu)
	{
		global $db;
		$list = [];

		$plugins = get_plugings();
		if ($plugins) {
			array_push($plugins, $menu);
			set_option(array(
				'option_name' => "premium_plugins",
				'option_value' => json_encode($plugins)
			));
		} else {
			set_option(array(
				'option_name' => "premium_plugins",
				'option_value' => json_encode($menu)
			));
		}
	}
}
if ( ! function_exists('timerFormat')) {
	function timerFormat($start_time, $end_time, $std_format = false)
	{       
		$total_time = $end_time - $start_time;
		$days       = floor($total_time /86400);        
		$hours      = floor($total_time /3600);     
		$minutes    = intval(($total_time/60) % 60);        
		$seconds    = intval($total_time % 60);     
		$results = "";
		
		if($std_format == false)
		{
		  if($days > 0) $results .= $days . (($days > 1)? " ". __('label_days'). " ": " ". __('label_day'). " ");     
		  if($hours > 0) $results .= $hours . (($hours > 1)?" ". __('label_hours'). " ": " ". __('label_hour'). " ");        
		  if($minutes > 0) $results .= $minutes . (($minutes > 1)?" ". __('label_minutes'). " ": " ". __('label_minute'). " "); 
		  if($seconds > 0) $results .= $seconds . (($seconds > 1)?" ". __('label_seconds'). " ": " ". __('label_second'). " "); 
		}
		else
		{
		  if($days > 0) $results = $days . (($days > 1)? " ". __('label_days'). " ": " ". __('label_day'). " ");
		  $results = sprintf("%s%02d:%02d:%02d",$results,$hours,$minutes,$seconds);
		}
		return $results;
	}
}
if ( ! function_exists('show_custom404')) {
	function show_custom404()
	{       
		$template = new Template();
		$template->render('users', 'custom_404.phtml', []);
	}
}
if ( ! function_exists('replcSpecChar')) {
	function replcSpecChar($string){
		$string = str_replace("æ", "&aelig;", $string);
		$string = str_replace("ø", "&oslash;", $string);
		$string = str_replace("å", "&aring;", $string);
		$string = str_replace("Æ", "&AElig;", $string);
		$string = str_replace("Ø", "&Oslash;", $string);
		$string = str_replace("Å", "&Aring;", $string);
		
		return $string;
	}
}
function db_add_client_cc()
{
	global $db;

	if ( ! col_exists('clients', 'client_cc'))
	{
		$db->query("ALTER TABLE `oc_clients` ADD `client_cc` TEXT");
	}
}
function db_add_edit_item_serial_number_col_type()
{
	global $db;
	$query = "SELECT DATA_TYPE as type FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = 'oc_items' AND COLUMN_NAME = 'serial_number'";
	$type = $db->get_row($query)->type;

	if ($type == 'varchar') {

		$db->query("ALTER TABLE oc_items MODIFY serial_number TEXT");
		$db->query("ALTER TABLE oc_invoiceitems ADD specific_serial_number TEXT");
		$db->query("ALTER TABLE oc_quoteitems ADD specific_serial_number TEXT");
		$db->query("ALTER TABLE oc_orderitems ADD specific_serial_number TEXT");
		$db->query("ALTER TABLE oc_proformaitems ADD specific_serial_number TEXT");
		$db->query("ALTER TABLE oc_purchaseitems ADD specific_serial_number TEXT");
		$items = get_items();
		if ($items) {
			foreach ($items as $item) {
				if ($item->serial_number) {
					$id = $item->item_id;
					$serial_number = $item->serial_number;
					$db->query("UPDATE {$db->tables['items']} SET " . $db->get_set(array('serial_number' => json_encode(array($serial_number)))) . " WHERE item_id = {$id}");
				}
			}
		}
	}
}
function generate_pdf_file($entity, $document_number)
{
	switch ($entity) {
		case 'invoices':
			$document_number = _eID($document_number);
			$invoicePdfUrl = base_url('index.php/viewinvoice/view?id=').$document_number;
			return \Mmanager\Mmanager::getUrl($invoicePdfUrl);
		case 'quotes':
			$document_number = _eID($document_number);
			$quotePdfUrl = base_url('index.php/viewquote/view?id=').$document_number;
			return \Mmanager\Mmanager::getUrl($quotePdfUrl);
		case 'proforma':
			$document_number = _eID($document_number);
			$proformaPdfUrl = base_url('index.php/viewproforma/view?id=').$document_number;
			return \Mmanager\Mmanager::getUrl($proformaPdfUrl);
		case 'orders':
			$document_number = _eID($document_number);
			$orderPdfUrl = base_url('index.php/vieworder/view?id=').$document_number;
			return \Mmanager\Mmanager::getUrl($orderPdfUrl);
		default:
			return false;
			break;
	}
}
function get_mime_type($filename) {
    $idx = explode( '.', $filename );
    $count_explode = count($idx);
    $idx = strtolower($idx[$count_explode-1]);

    $mimet = array( 
        'txt' => 'text/plain',
        'htm' => 'text/html',
        'html' => 'text/html',
        'php' => 'text/html',
        'css' => 'text/css',
        'js' => 'application/javascript',
        'json' => 'application/json',
        'xml' => 'application/xml',
        'swf' => 'application/x-shockwave-flash',
        'flv' => 'video/x-flv',

        // images
        'png' => 'image/png',
        'jpe' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'jpg' => 'image/jpeg',
        'gif' => 'image/gif',
        'bmp' => 'image/bmp',
        'ico' => 'image/vnd.microsoft.icon',
        'tiff' => 'image/tiff',
        'tif' => 'image/tiff',
        'svg' => 'image/svg+xml',
        'svgz' => 'image/svg+xml',

        // archives
        'zip' => 'application/zip',
        'rar' => 'application/x-rar-compressed',
        'exe' => 'application/x-msdownload',
        'msi' => 'application/x-msdownload',
        'cab' => 'application/vnd.ms-cab-compressed',

        // audio/video
        'mp3' => 'audio/mpeg',
        'qt' => 'video/quicktime',
        'mov' => 'video/quicktime',

        // adobe
        'pdf' => 'application/pdf',
        'psd' => 'image/vnd.adobe.photoshop',
        'ai' => 'application/postscript',
        'eps' => 'application/postscript',
        'ps' => 'application/postscript',

        // ms office
        'doc' => 'application/msword',
        'rtf' => 'application/rtf',
        'xls' => 'application/vnd.ms-excel',
        'ppt' => 'application/vnd.ms-powerpoint',
        'docx' => 'application/msword',
        'xlsx' => 'application/vnd.ms-excel',
        'pptx' => 'application/vnd.ms-powerpoint',


        // open office
        'odt' => 'application/vnd.oasis.opendocument.text',
        'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
    );
    if (isset( $mimet[$idx] )) {
    	return $mimet[$idx];
    } else {
    	return 'application/octet-stream';
    }
}
function is_404($url) {
    $handle = curl_init($url);
    curl_setopt($handle,  CURLOPT_RETURNTRANSFER, TRUE);

    /* Get the HTML or whatever is linked in $url. */
    $response = curl_exec($handle);

    /* Check for 404 (file not found). */
    $httpCode = curl_getinfo($handle, CURLINFO_HTTP_CODE);
    curl_close($handle);

    /* If the document has loaded successfully without any redirection or error */
    if ($httpCode >= 200 && $httpCode < 300) {
        return false;
    } else {
        return true;
    }
}
function db_add_notifications() {
	global $db;
	if ( ! db_table_exists('oc_notifications'))
	{
		$db->query("CREATE TABLE IF NOT EXISTS `oc_notifications` (`id` int(11) NOT NULL AUTO_INCREMENT, `category_id` int(11) NULL, `title` varchar(225) NULL, `message` TEXT, `active` tinyint(1) NOT NULL DEFAULT 0, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
	if ( ! db_table_exists('oc_notifications_categories'))
	{
		$db->query("CREATE TABLE IF NOT EXISTS `oc_notifications_categories` (`id` int(11) NOT NULL AUTO_INCREMENT, `category_name` varchar(225) NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
}
function get_notification_category_id($name) {
	$name = addslashes($name);
	global $db;
	return $db->get_row("SELECT id FROM oc_notifications_categories where category_name LIKE '{$name}'")->id;
}
function get_notification_messages() {
	global $db;
	return $db->get_results("SELECT * FROM oc_notifications ORDER BY id DESC");
}
function get_notification_categories() {
	global $db;
	return $db->get_results("SELECT * FROM oc_notifications_categories ORDER BY id DESC");
}
function set_client_portal_message($id) {
	global $db;
	if ($id) {
		$message = $db->get_results("SELECT * FROM oc_notifications WHERE id = '{$id}'");
		if ($message) {
			foreach ($message as $m) {
				$db_data = array(
					'option_name' => 'client_portal_message',
					'option_value' => $m->id
				);
			}
			set_option($db_data);
		}
	}
}
function get_client_portal_message($id, $var = null) {
	global $db;
	if ($id && ! $var) {
		return $db->get_results("SELECT * FROM oc_notifications WHERE id = '{$id}'");
	} else {
		return null != $db->get_row("SELECT $var FROM oc_notifications WHERE id = '{$id}'") ? $db->get_row("SELECT $var FROM oc_notifications WHERE id = '{$id}'")->{$var} : '';
	}
}
function unset_client_portal_message($id) {
	global $db;
	if ($id) {
		$message = $db->get_results("SELECT * FROM oc_notifications WHERE id = '{$id}'");
		if ($message) {
			foreach ($message as $m) {
				$db_data = array(
					'option_name' => 'client_portal_message',
					'option_value' => null
				);
			}
			set_option($db_data);
		}
	}
}
function db_upgrade_decimal_precision() {
	global $db;
	$db->query("ALTER TABLE oc_additional_taxes_meta MODIFY COLUMN invoice_subtotal decimal(19,4)");
	$db->query("ALTER TABLE oc_additional_taxes_meta MODIFY COLUMN invoice_tax_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_additional_taxes_meta MODIFY COLUMN invoice_surcharge_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_additional_taxes_meta MODIFY COLUMN invoice_deduct_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_clients MODIFY COLUMN client_credit decimal(19,4)");

	$db->query("ALTER TABLE oc_invoiceitems MODIFY COLUMN item_price decimal(19,4)");
	$db->query("ALTER TABLE oc_invoiceitems MODIFY COLUMN item_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_invoiceitems MODIFY COLUMN item_subtotal decimal(19,4)");

	$db->query("ALTER TABLE oc_quoteitems MODIFY COLUMN item_price decimal(19,4)");
	$db->query("ALTER TABLE oc_quoteitems MODIFY COLUMN item_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_quoteitems MODIFY COLUMN item_subtotal decimal(19,4)");

	$db->query("ALTER TABLE oc_proformaitems MODIFY COLUMN item_price decimal(19,4)");
	$db->query("ALTER TABLE oc_proformaitems MODIFY COLUMN item_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_proformaitems MODIFY COLUMN item_subtotal decimal(19,4)");

	$db->query("ALTER TABLE oc_purchaseitems MODIFY COLUMN item_price decimal(19,4)");
	$db->query("ALTER TABLE oc_purchaseitems MODIFY COLUMN item_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_purchaseitems MODIFY COLUMN item_subtotal decimal(19,4)");

	$db->query("ALTER TABLE oc_orderitems MODIFY COLUMN item_price decimal(19,4)");
	$db->query("ALTER TABLE oc_orderitems MODIFY COLUMN item_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_orderitems MODIFY COLUMN item_subtotal decimal(19,4)");

	$db->query("ALTER TABLE oc_time_tracker MODIFY COLUMN item_price decimal(19,4)");
	$db->query("ALTER TABLE oc_time_tracker MODIFY COLUMN item_subtotal decimal(19,4)");

	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN subtotal decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN global_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN tax_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN discount_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN total decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN amount_paid decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN credit_used decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN amount_due decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN amount_refunded decimal(19,4)");
	$db->query("ALTER TABLE oc_invoices MODIFY COLUMN user_commission decimal(19,4)");

	$db->query("ALTER TABLE oc_quotes MODIFY COLUMN subtotal decimal(19,4)");
	$db->query("ALTER TABLE oc_quotes MODIFY COLUMN global_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_quotes MODIFY COLUMN tax_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_quotes MODIFY COLUMN discount_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_quotes MODIFY COLUMN total decimal(19,4)");
	$db->query("ALTER TABLE oc_quotes MODIFY COLUMN amount_paid decimal(19,4)");
	$db->query("ALTER TABLE oc_quotes MODIFY COLUMN amount_due decimal(19,4)");

	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN subtotal decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN global_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN tax_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN discount_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN total decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN amount_paid decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN credit_used decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN amount_due decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN amount_refunded decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN shipping_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_purchases MODIFY COLUMN other_expenses decimal(19,4)");

	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN subtotal decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN global_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN tax_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN discount_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN total decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN amount_paid decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN credit_used decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN amount_due decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN amount_refunded decimal(19,4)");
	$db->query("ALTER TABLE oc_proforma MODIFY COLUMN user_commission decimal(19,4)");

	$db->query("ALTER TABLE oc_orders MODIFY COLUMN subtotal decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN global_discount decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN tax_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN discount_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN total decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN amount_paid decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN credit_used decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN amount_due decimal(19,4)");
	$db->query("ALTER TABLE oc_orders MODIFY COLUMN amount_refunded decimal(19,4)");

	$db->query("ALTER TABLE oc_items MODIFY COLUMN price decimal(19,4)");
	$db->query("ALTER TABLE oc_items MODIFY COLUMN purchase_price decimal(19,4)");
	$db->query("ALTER TABLE oc_items MODIFY COLUMN initial_cost decimal(19,4)");
	$db->query("ALTER TABLE oc_items MODIFY COLUMN valuation decimal(19,4)");

	$db->query("ALTER TABLE oc_payment_history MODIFY COLUMN payment_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_providers MODIFY COLUMN provider_credit decimal(19,4)");
	$db->query("ALTER TABLE users MODIFY COLUMN commission_type_value decimal(19,4)");

	$db->query("ALTER TABLE oc_transactions MODIFY COLUMN charges_value decimal(19,4)");
	$db->query("ALTER TABLE oc_transactions MODIFY COLUMN incomes_value decimal(19,4)");
	$db->query("ALTER TABLE oc_transactions MODIFY COLUMN taxes decimal(19,4)");
	$db->query("ALTER TABLE oc_transactions MODIFY COLUMN charges_value_without_tax decimal(19,4)");
	$db->query("ALTER TABLE oc_transactions MODIFY COLUMN charges_tax_amount decimal(19,4)");
	$db->query("ALTER TABLE oc_transactions MODIFY COLUMN incomes_value_without_tax	decimal(19,4)");
}

function db_add_invoice_late_fees()
{
	global $db;

	if ( ! col_exists('clients', 'exclude_late_fees'))
	{
		$late_fees_line = array(
			'item_id' => '-1',
			'sku' => 'LF-99',
			'name' => __('label_late_fees'),
			'description' => __('late_fees_description'),
			'price' => 0
		);
		$db->query("ALTER TABLE `oc_clients` ADD `exclude_late_fees` tinyint(1) NOT NULL DEFAULT 0");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `is_late_fees` tinyint(1) NOT NULL DEFAULT 0");
		$db->query("ALTER TABLE `oc_invoices` ADD `late_fees_subtotal` DECIMAL(19,4) NOT NULL DEFAULT 0");
		$db->query("ALTER TABLE `oc_invoices` ADD `late_fees_tax_amount` DECIMAL(19,4) NOT NULL DEFAULT 0");
		$db->query("ALTER TABLE `oc_invoices` ADD `late_fees_tax_rate` DECIMAL(5,2) NOT NULL DEFAULT 0");
		$db->query("INSERT INTO oc_items SET ".$db->get_set($late_fees_line));
	}
}
function _has_late_fees_item() {
	global $db;
	$query = "SELECT item_id FROM oc_items WHERE item_id = -1";
	$line = $db->get_row($query)->item_id;

	if (!$line) {
		$late_fees_line = array(
			'item_id' => '-1',
			'sku' => 'LF-99',
			'name' => __('label_late_fees'),
			'description' => __('late_fees_description'),
			'price' => 0
		);
		$db->query("INSERT INTO oc_items SET ".$db->get_set($late_fees_line));
	}
}
function _has_late_fees($invoice_number) {
	global $db;
	$query = "SELECT item_price FROM oc_invoiceitems WHERE invoice_number = '{$invoice_number}' AND is_late_fees = 1";
	return $db->get_row($query)->item_price ?? 0;
}
function db_add_invoices_attachments()
{
	global $db;

	if ( ! col_exists('invoices', 'attachments'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `attachments` Text");
		$db->query("ALTER TABLE `oc_quotes` ADD `attachments` Text");
		$db->query("ALTER TABLE `oc_purchases` ADD `attachments` Text");
		$db->query("ALTER TABLE `oc_proforma` ADD `attachments` Text");
	}
}

// Temp function
function count_paid_invoices()
{
	global $db;
	$query = "SELECT COUNT('id') AS total FROM oc_invoices WHERE invoice_status = 'Paid'";
	return intval($db->get_row($query)->total);
}
function count_unpaid_invoices()
{
	global $db;
	$query = "SELECT COUNT('id') AS total FROM oc_invoices WHERE invoice_status = 'Unpaid'";
	return intval($db->get_row($query)->total);
}
function count_overdue_invoices()
{
	global $db;
	$query = "SELECT COUNT('id') AS total FROM oc_invoices WHERE invoice_status = 'Overdue'";
	return intval($db->get_row($query)->total);
}
function count_quotes_table()
{
	global $db;
	$query = "SELECT COUNT('id') AS total FROM oc_quotes";
	return intval($db->get_row($query)->total);
}
function count_invoices_table()
{
	global $db;
	$query = "SELECT COUNT('id') AS total FROM oc_invoices WHERE is_credit_note = 0";
	return intval($db->get_row($query)->total);
}
function count_services_table()
{
	global $db;
	$query = "SELECT COUNT('item_id') AS total FROM oc_items WHERE is_service = 1";
	return intval($db->get_row($query)->total);
}

// Temp function