<?php
defined('BASEPATH') OR exit('No direct script access allowed');


function purchase_mass_payment($table, $primary_key, $ids)
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_purchase_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total + $value->shipping_amount + $value->other_expenses;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
				}
			}
			$db_data = array(
				'date_paid' => date('Y-m-d'),
				'amount_paid' => $total,
				'amount_due' => 0,
				'purchase_status' => 'Paid',
				'payment_method' => get_option('default_payment_method'),
				'sent' => 'yes'
				);
			// Record transaction
			// Check if any payment done before 
			$last_amount_paid = get_purchase_vars($id, 'amount_paid');
			if ( $last_amount_paid && $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'purchase_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'purchase_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			$query = "UPDATE {$db->tables['purchases']}
				SET " . $db->get_set($db_data) . 
				" WHERE purchase_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['purchases_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE purchase_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_purchase_email($id);

			$charges_data = array(
				'charges_name' 		=> __('charges_purchases'),
				'charges_category' 	=> 1,
				'charges_value'	    => $total,
				'incomes_name'		=> null,
				'incomes_category'	=> null,
				'incomes_value'	    => null,
				'incomes_sku'	    => null,
				'payment_method'	=> get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => null,
				'created_on' 	    => $date
				);
			record_charges($charges_data, 'purchase_number', isset($id) ? $id: null);
		}
	}
	else
	{
		$total = 0;
		$id = $ids;
		$results = get_purchase_by_number($id);
		if ($results)
		{
			foreach ($results as $key => $value) {
				$total = $value->total + $value->shipping_amount + $value->other_expenses;
				$subtotal = $value->subtotal;
				$tax_amount = $value->tax_amount;
				$date = $value->date;
			}
		}
		$db_data = array(
			'date_paid' => date('Y-m-d'),
			'amount_paid' => $total,
			'amount_due' => 0,
			'purchase_status' => 'Paid',
			'payment_method' => get_option('default_payment_method'),
			'sent' => 'yes'
			);
		// Record transaction
		// Check if any payment done before 
		$last_amount_paid = get_purchase_vars($id, 'amount_paid');
		if ( $last_amount_paid && $last_amount_paid > 0 )
		{
			$trans_data = array(
				'payment_method'		=> get_option('default_payment_method'), 
				'payment_reference'		=> time(),
				'payment_amount'		=> $total - $last_amount_paid,
				'date_paid'				=> date('Y-m-d'),
				'purchase_number'		=> $id, 
				'payment_note'		    => ""
			);
			record_transaction($trans_data);
		}
		else
		{
			$trans_data = array(
				'payment_method'		=> get_option('default_payment_method'), 
				'payment_reference'		=> time(),
				'payment_amount'		=> $total,
				'date_paid'				=> date('Y-m-d'),
				'purchase_number'		=> $id, 
				'payment_note'		    => ""
			);
			record_transaction($trans_data);
		}
		$db_data2 = array(
			'date_paid' => date('Y-m-d')
			);
		$query = "UPDATE {$db->tables['purchases']}
			SET " . $db->get_set($db_data) . 
			" WHERE purchase_number = " .$id;
		$db->query($query);
		$query2 = "UPDATE {$db->tables['purchases_items']}
			SET " . $db->get_set($db_data2) . 
			" WHERE purchase_number = " .$id;
		$db->query($query2);
		$CI->m_manager->send_purchase_email($id);

		$charges_data = array(
			'charges_name' 		=> __('charges_purchases'),
			'charges_category' 	=> 1,
			'charges_value'	    => $total,
			'incomes_name'		=> null,
			'incomes_category'	=> null,
			'incomes_value'	    => null,
			'incomes_sku'	    => null,
			'payment_method'	=> get_option('default_payment_method'),
			'turnover_included'	=> 1,
			'taxes'             => null,
			'created_on' 	    => $date
			);
		record_charges($charges_data, 'purchase_number', isset($id) ? $id: null);
	}
	return $CI->db->affected_rows();
}
// ------------------------------------------------------------------------
if ( ! function_exists('mass_payment'))
{
	/**
	 * Mass payment function when many invoices are selected to be marked paid
	 * @param type $table 
	 * @param type $primary_key 
	 * @param array $ids 
	 * @return int
	 */
	function mass_payment($table, $primary_key, array $ids)
	{
		global $db;

		$CI = & get_instance();
		is_array($ids) OR $ids = array($ids);

		foreach ($ids as $id) 
		{
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
				}
			}
			$db_data = array(
				'date_paid' => date('Y-m-d'),
				'amount_paid' => $total,
				'amount_due' => 0,
				'invoice_status' => 'Paid',
				'payment_method' => get_option('default_payment_method'),
				'sent' => 'yes'
				);
			// Record transaction
			// Check if any payment done before 
			$last_amount_paid = get_invoice_vars($id, 'amount_paid');
			if ( $last_amount_paid && $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => ""
				);
				record_transaction($trans_data);
			}
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> 7,
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'incomes_sku'	    => generate_sku(),
				'payment_method'	=> get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
		return $CI->db->affected_rows();
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('create_credit_note'))
{
	/**
	 * Mass credit note function when many invoices are selected to be refunded
	 * @param type $table 
	 * @param type $primary_key 
	 * @param array $ids 
	 * @return int
	 */
	function create_credit_note($table, $primary_key, array $ids)
	{
		global $db;

		$CI = & get_instance();
		is_array($ids) OR $ids = array($ids);

		foreach ($ids as $id)
		{
		}
		return $CI->db->affected_rows();
	}
}
// ------------------------------------------------------------------------

function mollie_payment( $ids, $transaction_id )
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
				}
			}
			$db_data = array(
				'date_paid' 		=> date('Y-m-d'),
				'amount_paid' 		=> $total,
				'amount_due' 		=> 0,
				'invoice_status' 	=> 'Paid',
				'payment_method' 	=> get_option('default_payment_method'),
				'sent' 				=> 'yes',
				'transaction_id' 	=> isset($transaction_id) ? $transaction_id : time(),
				'payment_gateway' 	=> 'Mollie'
				);
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);

			$last_amount_paid = floatval( get_invoice_vars( $id, 'amount_paid' ) );
			if ( $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
				);
				record_transaction($trans_data);
			}
			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> __('charges_financial_charges'),
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_sku'		=> 	generate_sku(),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'payment_method'    => get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
	}
	return $CI->db->affected_rows();
}

// ------------------------------------------------------------------------
function stripe_payment( $ids, $transaction_id )
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
				}
			}
			$db_data = array(
				'date_paid' 		=> date('Y-m-d'),
				'amount_paid' 		=> $total,
				'amount_due' 		=> 0,
				'invoice_status' 	=> 'Paid',
				'payment_method' 	=> get_option('default_payment_method'),
				'sent' 				=> 'yes',
				'transaction_id' 	=> isset($transaction_id) ? $transaction_id : time(),
				'payment_gateway' 	=> 'Stripe'
				);
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			// Check if a payment has already be done
			$last_amount_paid = floatval( get_invoice_vars( $id, 'amount_paid' ) );
			if ( $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
				);
				record_transaction($trans_data);
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
				);
				record_transaction($trans_data);
			}

			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> __('charges_financial_charges'),
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_sku'		=> 	generate_sku(),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'payment_method'    => get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
	}
	return $CI->db->affected_rows();
}

// ------------------------------------------------------------------------

function ingenico_payment( $ids, $transaction_id )
{
	global $db;
	$CI = & get_instance();
	if (is_array($ids))
	{
		foreach ($ids as $id) {
			$total = 0;
			$results = get_invoice_by_number($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$total = $value->total;
					$subtotal = $value->subtotal;
					$tax_amount = $value->tax_amount;
					$date = $value->date;
				}
			}
			$db_data = array(
				'date_paid' => date('Y-m-d'),
				'amount_paid' => $total,
				'amount_due' => 0,
				'invoice_status' => 'Paid',
				'payment_method' => get_option('default_payment_method'),
				'sent' => 'yes',
				'transaction_id' => isset($transaction_id) ? $transaction_id : time(),
				'payment_gateway' 	=> 'Ingenico'
				);
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);

			$last_amount_paid = floatval ( get_invoice_vars( $id, 'amount_paid' ) );
			if ( $last_amount_paid > 0 )
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
				);
				record_transaction( $trans_data );
			}
			else
			{
				$trans_data = array(
					'payment_method'		=> get_option('default_payment_method'), 
					'payment_reference'		=> isset($transaction_id) ? $transaction_id : time(),
					'payment_amount'		=> $total,
					'date_paid'				=> date('Y-m-d'),
					'invoice_number'		=> $id, 
					'payment_note'		    => "",
				);
				record_transaction( $trans_data );
			}
			
			$query = "UPDATE {$db->tables['invoices']}
				SET " . $db->get_set($db_data) . 
				" WHERE invoice_number = " .$id;
			$db->query($query);
			$query2 = "UPDATE {$db->tables['invoices_items']}
				SET " . $db->get_set($db_data2) . 
				" WHERE invoice_number = " .$id;
			$db->query($query2);
			$CI->m_manager->send_invoice_email($id);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> __('charges_financial_charges'),
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_sku'		=> 	generate_sku(),
				'incomes_category'	=> 1,
				'incomes_value'	    => $subtotal,
				'payment_method' 	=> get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => $tax_amount,
				'created_on' 	    => $date,
				'invoice_number'    => $id
				);
			record_charges( $charges_data, 'invoice_number', isset($id) ? $id: null );
		}
	}
	return $CI->db->affected_rows();
}

// ------------------------------------------------------------------------

function mark_refunded($id, $amount)
{
	$invoice = get_invoice_by_number($id);
	$invoice_id = 0;
	$total_refund = 0;
	$update_invoice = [];
	if ($invoice)
	{
		foreach ($invoice as $v) {
			$invoice_id = $v->id;
			$payment_id = $v->payment_id;

			if(!$payment_id)
			{
				$total_refund = $v->amount_refunded + $amount;
			}
			else
			{
				$total_refund = $amount;
			}
			$update_invoice = array(
				'payment_method' => $v->payment_method,
				'transaction_id' => time(),
				'subtotal' => $v->subtotal,
				'global_discount' => $v->global_discount,
				'tax_amount' => $v->tax_amount,
				'discount_amount' => $v->discount_amount,
				'total' => $v->total,
				'amount_paid' => $v->total - $total_refund,
				'credit_used' => $v->credit_used,
				'amount_due' => 0,
				'invoice_status' => 'Refunded',
				'sent' => 'yes',
				'notes' => $v->notes,
				'payment_id' => $v->payment_id,
				'amount_refunded' => $total_refund
				);
		}
		if ($update_invoice['amount_paid'] == 0)
		{
			$db_data2 = array(
				'date_paid' => NULL
				);
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> 7,
				'charges_value'	    => 0,
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_category'	=> 1,
				'incomes_sku'	    => null,
				'payment_method'	=> $update_invoice['payment_method'],
				'incomes_value'	    => 0,
				'turnover_included'	=> 0,
				'taxes'             => 0,
				'created_on' 	    => date('Y-m-d'),
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
		else
		{
			$db_data2 = array(
				'date_paid' => date('Y-m-d')
				);
			$update_invoice['invoice_status'] = "Refunded";
			$charges_data = array(
				'charges_name' 		=> __('label_payment_fees'),
				'charges_category' 	=> 7,
				'charges_value'	    => get_invoice_charges($id),
				'incomes_name'		=> 	__('incomes_sales_services_goods'),
				'incomes_category'	=> 1,
				'incomes_sku'	    => null,
				'payment_method'	=> $update_invoice['payment_method'],
				'incomes_value'	    => $update_invoice['amount_paid'],
				'turnover_included'	=> 1,
				'taxes'             => $update_invoice['tax_amount'],
				'created_on' 	    => date('Y-m-d'),
				'invoice_number'    => $id
				);
			record_charges($charges_data, 'invoice_number', isset($id) ? $id: null);
		}
		global $db;
		$query = "UPDATE {$db->tables['invoices']}
			SET " . $db->get_set($update_invoice) . 
			" WHERE id = {$invoice_id}";
		$db->query($query);
		$query2 = "UPDATE {$db->tables['invoices_items']}
					SET " . $db->get_set($db_data2) . 
					" WHERE invoice_number = " .$id;
		$db->query($query2);
	}
}
// ------------------------------------------------------------------------
if ( ! function_exists('mass_refund'))
{
	/**
	 * Mass refund function when many invoices are selected to be marked refunded
	 * @param type $table 
	 * @param type $primary_key 
	 * @param array $ids 
	 * @return int
	 */
	function mass_refund($table, $primary_key, array $ids)
	{
		global $db;

		$CI = & get_instance();
		is_array($ids) OR $ids = array($ids);
		foreach ($ids as $id) 
		{
			$results = get_invoice_by_id($id);
			if ($results)
			{
				foreach ($results as $key => $value) {
					$CI->m_manager->credit_note_invoice($value->invoice_number);
				}
			}
		}
	}
}
// ------------------------------------------------------------------------
function record_transaction($post_array)
{
	global $db;
	$db_data = array(
		'payment_method'		=> isset($post_array['payment_method']) ? $post_array['payment_method'] : get_option('default_payment_method'), 
		'payment_reference'		=> isset($post_array['payment_reference']) ? $post_array['payment_reference'] : now(), 
		'payment_amount'		=> isset($post_array['payment_amount']) ? $post_array['payment_amount'] : null,
		'date_paid'				=> isset($post_array['date_paid']) ? $post_array['date_paid'] : date('Y-m-d'),
		'invoice_number'		=> isset($post_array['invoice_number']) ? $post_array['invoice_number'] : null, 
		'purchase_number'		=> isset($post_array['purchase_number']) ? $post_array['purchase_number'] : null, 
		'payment_note'		    => isset($post_array['payment_note']) ? $post_array['payment_note'] : null
	);
	$db->query("INSERT INTO {$db->tables['payment_history']} SET ".$db->get_set($db_data));
}

// ------------------------------------------------------------------------
function record_purchase_transaction($post_array)
{
	global $db;
	$db_data = array(
		'payment_method'		=> isset($post_array['payment_method']) ? $post_array['payment_method'] : get_option('default_payment_method'), 
		'payment_reference'		=> isset($post_array['payment_reference']) ? $post_array['payment_reference'] : now(), 
		'payment_amount'		=> isset($post_array['payment_amount']) ? $post_array['payment_amount'] : null,
		'date_paid'				=> isset($post_array['date_paid']) ? $post_array['date_paid'] : date('Y-m-d'),
		'purchase_number'		=> $post_array['purchase_number'], 
		'payment_note'		    => isset($post_array['payment_note']) ? $post_array['payment_note'] : null,
	);
	$db->query("INSERT INTO {$db->tables['payment_history']} SET ".$db->get_set($db_data));
}
// ------------------------------------------------------------------------
function get_payment_history($invoice_number)
{
	global $db;
	$results = $db->get_results("SELECT * FROM oc_payment_history WHERE invoice_number = {$invoice_number}");
	if(!empty($results))
	{
		return $results;
	}
	return [];
}
// ------------------------------------------------------------------------
function get_purchase_payment_history($purchase_number)
{
	global $db;
	$results = $db->get_results("SELECT * FROM oc_payment_history WHERE purchase_number = {$purchase_number}");
	if(!empty($results))
	{
		return $results;
	}
	return [];
}
// ------------------------------------------------------------------------
function convert_payment_gateway_status($status)
{
	switch ($status) {
		case 'Paid':
		case 'Paidout':
			return 'Paid';
			break;
		case 'Unpaid':
		case 'Open':
		case 'Pending':
		case 'Failed':
		case 'Expired':
			return 'Unpaid';
			break;
		case 'Cancelled':
			return 'Cancelled';
			break;
		case 'Overdue':
			return 'Overdue';
			break;
		case 'Draft':
			return 'Draft';
			break;
		case 'Refunded':
		case 'Charged_back':
			return 'Refunded';
			break;
	}
}
function update_transaction($invoice_number, $amount, $tax_amount) {
	global $db;
	$incomes_value = 0;
	$taxes = 0;
	$transaction_id = 0;
	$invoice_number = get_invoice_vars($invoice_number, 'initial_invoice_number');
	$transaction = $db->get_results("SELECT transaction_id, incomes_value, taxes FROM oc_transactions WHERE invoice_number = '{$invoice_number}'");
	if ($transaction) {
		foreach ($transaction as $tran) {
			$transaction_id = $tran->transaction_id;
			$incomes_value = $tran->incomes_value;
			$taxes = $tran->taxes;
		}
	}
	$db_data = array(
		'incomes_value' => 0 < $incomes_value ? $incomes_value -= $amount : 0,
		'taxes'			=> 0 < $taxes ? $taxes -= $tax_amount: 0
	);	
	$query = "UPDATE {$db->tables['transactions']}
		SET " . $db->get_set($db_data) . 
		" WHERE transaction_id = {$transaction_id}";
	$db->query($query);
}