<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpRbac\Rbac;

function db_add_proforma() {
	global $db;
	if ( ! db_table_exists('oc_proforma')){
		$db->query("CREATE TABLE IF NOT EXISTS oc_proforma LIKE oc_invoices");
		$db->query("ALTER TABLE oc_proforma CHANGE COLUMN invoice_number proforma_number varchar(20)");
		$db->query("ALTER TABLE oc_proforma CHANGE COLUMN invoice_status proforma_status varchar(20)");
		$db->query("ALTER TABLE oc_proforma CHANGE COLUMN invoice_key proforma_key varchar(20)");
		$db->query("ALTER TABLE oc_proforma CHANGE COLUMN initial_invoice_number initial_proforma_number varchar(20)");
		$db->query("ALTER TABLE oc_proforma DROP INDEX `invoice_number`");
		$db->query("CREATE INDEX proforma_number ON oc_proforma (proforma_number)");
		$db->query("CREATE TABLE IF NOT EXISTS oc_proformaitems LIKE oc_invoiceitems");
		$db->query("ALTER TABLE oc_proformaitems CHANGE COLUMN invoice_number proforma_number varchar(20)");
		$db->query("ALTER TABLE oc_proformaitems CHANGE COLUMN invoice_key proforma_key varchar(20)");
		$db->query("ALTER TABLE oc_proformaitems CHANGE COLUMN invoice_is_cancelled proforma_is_cancelled tinyint(1)");
		$db->query("ALTER TABLE oc_proformaitems DROP INDEX `invoice_number`");
		$db->query("CREATE INDEX proforma_number ON oc_proformaitems (proforma_number)");
	
		$db->query("ALTER TABLE `oc_proformaitems` ADD CONSTRAINT  `fk_proforma` FOREIGN KEY (`proforma_number`) REFERENCES `oc_proforma` (`proforma_number`) ON DELETE CASCADE ON UPDATE NO ACTION");
	}
	if ( db_table_exists('oc_proforma') && ! db_table_exists('oc_proformaitems')){
		
		$db->query("CREATE TABLE IF NOT EXISTS oc_proformaitems LIKE oc_invoiceitems");
		$db->query("ALTER TABLE oc_proformaitems CHANGE COLUMN invoice_number proforma_number varchar(20)");
		$db->query("ALTER TABLE oc_proformaitems CHANGE COLUMN invoice_key proforma_key varchar(20)");
		$db->query("ALTER TABLE oc_proformaitems CHANGE COLUMN invoice_is_cancelled proforma_is_cancelled tinyint(1)");
		$db->query("ALTER TABLE oc_proformaitems DROP INDEX `invoice_number`");
		$db->query("CREATE INDEX proforma_number ON oc_proformaitems (proforma_number)");
	
		$db->query("ALTER TABLE `oc_proformaitems` ADD CONSTRAINT  `fk_proforma` FOREIGN KEY (`proforma_number`) REFERENCES `oc_proforma` (`proforma_number`) ON DELETE CASCADE ON UPDATE NO ACTION");
	}
	if ( ! col_exists('invoices', 'proforma_number'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `proforma_number` int(11) DEFAULT NULL");
	}
	if ( ! col_exists('proforma', 'proforma_key'))
	{
		$db->query("ALTER TABLE `oc_proforma` ADD `proforma_key` int(11) DEFAULT NULL");
	}
	if ( ! col_exists('proforma', 'proforma_status'))
	{
		$db->query("ALTER TABLE `oc_proforma` ADD `proforma_status` varchar(20) DEFAULT NULL");
	}
	if ( col_exists('proforma', 'initial_invoice_number'))
	{
		$db->query("ALTER TABLE oc_proforma CHANGE COLUMN initial_invoice_number initial_proforma_number varchar(20)");
	}
	if ( col_exists('proforma', 'invoice_number'))
	{
		$indexed = $db->query("SHOW INDEX FROM oc_proforma WHERE Key_name = 'invoice_number'");
		if ($indexed) {
			$db->query("ALTER TABLE oc_proforma DROP INDEX `invoice_number`");
		}
	}
}

if ( ! function_exists('get_proforma')) {
	function get_proforma($id=null) {

		$rbac = new Rbac;
		if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
			$where = ' WHERE user_id = '. USERID;
			$additional_where = ' AND user_id = '. USERID;
			if ($id) {
				$client_where = isset($id) ? ' AND client_id = '.$id : '';
			}
		} else {
			$where = '';
			$additional_where = '';
			if ($id) {
				$client_where = ' WHERE client_id = '.$id;
			} else {
				$client_where = '';
			}
		}

		global $db;
		$query = "SELECT * FROM oc_proforma {$where} {$additional_where} {$client_where} ORDER BY id DESC";

		return $db->get_results($query);
	}
}
if ( ! function_exists('get_proforma_by_number')) {
	function get_proforma_by_number($proforma_number)
	{
		global $db;
		$query = "SELECT * FROM {$db->tables['proforma']}
		WHERE proforma_number = {$proforma_number}";
		return $db->get_results($query);
	}
}
if ( ! function_exists('get_proforma_items')) {
	function get_proforma_items($proforma_number)
	{
		global $db;
		$query = "SELECT * FROM {$db->tables['proforma_items']} WHERE proforma_number = {$proforma_number}";
		return $db->get_results($query);
	}
}
if ( ! function_exists('get_proforma_tax')) {
	function get_proforma_tax($proforma_number)
	{
		global $db;
		return $db->get_results("SELECT item_tax_rate AS taxRate, 
			SUM(item_subtotal) * item_tax_rate / 100 AS taxAmount
			FROM {$db->tables['proforma_items']}
			WHERE proforma_number = {$proforma_number}
			AND item_tax_rate > 0
			GROUP BY taxRate
			ORDER BY taxRate ASC");
	}
}
if ( ! function_exists('proforma_for_guest')) {
	function proforma_for_guest($proforma_number)
	{
		global $db;
		return $db->get_row("SELECT client_id FROM {$db->tables['proforma']} WHERE proforma_number={$proforma_number}")->client_id;
	}
}
if ( ! function_exists('getProformaTaxVars')) {
	function getProformaTaxVars($proforma_number, $tax_rate, $context) {
		$items = get_proforma_items($proforma_number);
		$subtotal = 0;
		$tax_amount = 0;

		switch ($context) {
			case 'subtotal':
				if ($items) {
					foreach ($items as $item) {
						if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
							$subtotal += $item->item_subtotal;
						}
					}
					return $subtotal;
				}
			case 'tax_amount':
				if ($items) {
					foreach ($items as $item) {
						if (floatval($item->item_tax_rate) == floatval($tax_rate)) {
							$subtotal += $item->item_subtotal;
							$tax_amount = floatval($subtotal * $tax_rate / 100);
						}
					}
					return $tax_amount;
				}
		}
	}
}
if ( ! function_exists('merge_proforma')) {
	function merge_proforma($proforma_numbers) {
		global $db;

		$merged_items = [];
		$merged_attachments = [];

		$html = __s('proforma_merged_from') .'<br />---------------------<ul>';
		$client_id = get_proforma_vars($proforma_numbers[0], 'client_id');
		$next_proforma_id = get_next_id('proforma');

		// Get the change rate if multicurrency is enabled
		$currency = $client_id == 0 ? get_option('user_currency') : client($client_id, 'client_currency');
		$change_rate = _has_option('change_currency') ? get_change_rate( $currency ) : 1;

		$proformaTable 								= []; // All data that will be saved on oc_invoices
		$proformaTable['change_rate'] 				= $change_rate; // Save change_rate for reference
		$proformaTable['user_id'] 					= user('user_id');
		$proformaTable['proforma_number'] 			= $next_proforma_id;
		$proformaTable['annual_number_key'] 		= $next_proforma_id;
		$proformaTable['proforma_key'] 				= $next_proforma_id;
		$proformaTable['proforma_status'] 			= 'Draft';
		$proformaTable['client_id'] 				= $client_id;
		$proformaTable['date'] 						= date('Y-m-d');
		$proformaTable['due_date'] 					= date('Y-m-d');
	
		$proformaTable['subtotal'] 					= 0;
		$proformaTable['tax_amount'] 				= 0;
		$proformaTable['global_discount'] 			= 0;
		$proformaTable['discount_amount'] 			= 0;
		$proformaTable['total'] 					= 0;
		$proformaTable['amount_due']				= 0;
		$proformaTable['amount_paid']				= 0;
		$proformaTable['amount_refunded']			= 0;
		$proformaTable['credit_used']				= 0;
		$additional_taxes							= [];
		$mergedAdditionalTaxes						= [];

		is_array($proforma_numbers) OR $proforma_numbers = array($proforma_numbers);
		if ( ! empty($proforma_numbers)) {
			foreach ($proforma_numbers as $proforma_number) {
				$addTax = json_decode(get_proforma_vars($proforma_number, 'additional_taxes'), true);
				$attachments = json_decode(get_proforma_vars($proforma_number, 'attachments'), true);
				if ($addTax) {
					array_push($additional_taxes, $addTax);
				}
				if ($attachments) {
					foreach ($attachments as $attachment) {
						$merged_attachments[] = $attachment;
					}
				}
				$inv_f_number = null == get_option('proforma_prefix') ? __('proforma_prefix_short') . sprintf( "%04s", $proforma_number ) : get_option('proforma_prefix') . sprintf( "%04s", $proforma_number );

				$proformaTable['subtotal'] 					+= get_proforma_vars($proforma_number, 'subtotal');
				$proformaTable['tax_amount'] 				+= get_proforma_vars($proforma_number, 'tax_amount');
				$proformaTable['discount_amount'] 			+= get_proforma_vars($proforma_number, 'discount_amount');
				$proformaTable['discount_amount'] 			= get_proforma_vars($proforma_number, 'global_discount');
				$proformaTable['total'] 					+= get_proforma_vars($proforma_number, 'total');
				$proformaTable['amount_due']				+= get_proforma_vars($proforma_number, 'amount_due');
				$proformaTable['amount_paid']				+= get_proforma_vars($proforma_number, 'amount_paid');
				$proformaTable['credit_used']				+= get_proforma_vars($proforma_number, 'credit_used');
				$proformaTable['amount_refunded']			+= get_proforma_vars($proforma_number, 'amount_refunded');
				$proformaTable['additional_taxes']			 = json_encode($additional_taxes);
				$html 										.= '<li>'.$inv_f_number. ' Issue on: '. _fdate( client( $client_id, 'client_language' ), get_proforma_vars($proforma_number, 'date') ). ' - Amount: '. add_currency(format_number(get_proforma_vars($proforma_number, 'total') * $change_rate, $client_id)). '</li>';
			}
			$html .= '</ul>';
			$proformaTable['notes'] 					= $html;
			$proformaTable['attachments']			    = json_encode($merged_attachments);

			// Set status
			if($proformaTable['amount_paid'] > 0 && $proformaTable['amount_due'] > 0) {
				$proformaTable['proforma_status'] 			= 'Partially Paid';
			} 

			if($proformaTable['amount_due'] <= 0) {
				$proformaTable['proforma_status'] 			= 'Paid';
			}

			if($proformaTable['amount_refunded'] == $proformaTable['total']) {
				$proformaTable['proforma_status'] 			= 'Refunded';
			}
			if($proformaTable['amount_refunded'] > 0 && $proformaTable['amount_refunded'] != $proformaTable['total']) {
				$proformaTable['proforma_status'] 			= 'Partially Refunded';
			}
			if ($additional_taxes) {
				foreach($additional_taxes as $k=>$v) {
				    foreach ($v as $t) {
				    	$mergedAdditionalTaxes[] = $t;
				    }
				}
			}
			$proformaTable['additional_taxes']			 = json_encode($mergedAdditionalTaxes);
			$db->query("INSERT INTO {$db->tables['proforma']} SET ".$db->get_set($proformaTable));

			foreach ($proforma_numbers as $proforma_number) {

				$items = get_proforma_items($proforma_number);
				foreach ($items as $item) {
					$item_array = array(
						'proforma_number' => $next_proforma_id,
						'proforma_key' => $next_proforma_id,
						'client_id' => $client_id,
						'user_id' => user('user_id'),
						'item_sku' => $item->item_sku,
						'item_id' => $item->item_id,
						'item_group' => category_id($item->item_id),
						'item_name' => addslashes($item->item_name),
						'item_uom' => $item->item_uom,
						'item_price' => $item->item_price,
						'item_discount' => $item->item_discount,
						'specific_serial_number' => $item->specific_serial_number,
						'item_quantity' => $item->item_quantity,
						'item_subtotal' => $item->item_subtotal,
						'item_tax_rate' => $item->item_tax_rate,
						'item_recurring' => 1,
						'proforma_is_cancelled' => ''
						);
					$db->query("INSERT INTO {$db->tables['proforma_items']} SET ".$db->get_set($item_array));
				}
				if (get_option('delete_once_merged') == 1) {
					delete('proforma', 'proforma_number', $proforma_number);
				}
			}
		}
	}
}
if ( ! function_exists('get_proforma_vars')) {
	function get_proforma_vars($proforma_number, $var = null)
	{
		global $db;
		if ($proforma_number && !$var)
		{
			return get_proforma_by_number($proforma_number);
		}
		elseif ($proforma_number && $var && $var !== 'invoiced_items')
		{
			return $db->get_row("SELECT {$var} FROM {$db->tables['proforma']} WHERE proforma_number={$proforma_number} LIMIT 1") ?
			$db->get_row("SELECT {$var} FROM {$db->tables['proforma']} WHERE proforma_number={$proforma_number} LIMIT 1")->{$var} : FALSE;
		}
		else
		{
			return get_proforma_by_number($proforma_number);
		}
	}
}
if ( ! function_exists('category_id')) {
	function category_id($item_id=null)
	{
		if(!$item_id)
		{
			return 0;
		}
		else
		{
			$CI =& get_instance();

			$CI->load->model('products/products_model', 'products');
			$groups = $CI->products->category_id($item_id);
			if ($groups)
			{
				foreach ($groups as $v) {
					return $v->group_id;
				}
			}
		}
	}
}
if ( ! function_exists('next_proforma_number')) {
	function next_proforma_number()
	{
		return get_next_id('proforma');
	}
}
if ( ! function_exists('from_proforma_to_invoice')) {
	function from_proforma_to_invoice( $proforma_number, $context=null)
	{
		$CI =& get_instance();

		$CI->load->model('invoices/invoices_model', 'invoices');
		$invoices = get_proforma_by_number( $proforma_number );
		$attachments = [];

		if ( ! empty( $invoices ) )
		{
			foreach ( $invoices as $key => $invoice ) 
			{
				$client_id = $invoice->client_id;
				// Get the change rate if multicurrency is enabled
				$currency = $invoice->client_id == 0 ? get_option('user_currency') : client( $invoice->client_id, 'client_currency' );
				$change_rate = _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
				$invoice_number = next_invoice_number();
				// Current date
				$date = date( "Y-m-d H:i:s" );

				// Default due
				$default_due_date 					= get_option( 'default_duedate' );
				$due_date 							= date( 'Y-m-d', strtotime( '+'.$default_due_date. 'day', strtotime( $date ) ) );

				if ($invoice->attachments) {
					$attachments = json_decode($invoice->attachments, true);
				}
				$invoice_array 						= array(
					'client_id' 			=> $invoice->client_id,
					'user_id' 				=> $invoice->user_id,
					'invoice_number' 		=> $invoice_number,
					'subject' 				=> $invoice->subject,
					'pay_type' 				=> 1,
					'date' 					=> $date,
					'due_date' 				=> $due_date,
					'subtotal' 				=> $invoice->subtotal,
					'tax_amount' 			=> $invoice->tax_amount,
					'additional_taxes' 		=> $invoice->additional_taxes,
					'discount_amount' 		=> $invoice->discount_amount,
					'total'					=> $invoice->total,
					'amount_paid' 			=> 0,
					'amount_due' 			=> $invoice->total,
					'attachments' 			=> $invoice->attachments,
					'invoice_status' 		=> 'Unpaid',
					'sent' 					=> 'yes',
					'proforma_number' 		=> $proforma_number,
					'change_rate' 			=> $change_rate
				);
				// Set table and save data
				$CI->invoices->set_table( 'invoices' );
				$CI->invoices->save( $invoice_array );

				//$invoice_id = $invoice->id;
				if (has_repair_module()) {
					$invoice_array['repair_number']			= $invoice->repair_number;
				}
				if ($context === 'repair') {
					set_repair_vars($invoice->repair_number, array('invoice_number' => $invoice_number));
				}

				// Fetch all recurrent items
				$items = get_proforma_items( $proforma_number );

				foreach ( $items as $key => $item ) 
				{
					$item_array = array(
						'invoice_number' 	=> $invoice_number,
						'client_id' 		=> $item->client_id,
						'user_id' 			=> $item->user_id,
						'item_sku' 			=> $item->item_sku,
						'specific_serial_number' 			=> $item->specific_serial_number,
						'item_id' 			=> $item->item_id,
						'item_name' 		=> $item->item_name,
						'item_price' 		=> $item->item_price,
						'item_quantity'		=> $item->item_quantity,
						'item_discount' 	=> $item->item_discount,
						'item_subtotal' 	=> $item->item_subtotal,
						'item_tax_rate' 	=> $item->item_tax_rate,
					);
					if (has_repair_module()) {
						$item_array['repair_number']			= $item->repair_number;
					}
					$CI->invoices->set_table( 'invoices_items' );
					$CI->invoices->save( $item_array );
				}
				$data = array(
					'invoice_url'		=> base_url( 'index.php/viewinvoice/view?id=' ) . _eID( $invoice_array['invoice_number'] ),
					'to_name'           => client( $invoice_array['client_id'], 'name_company' ),
					'date'		    	=> _fdate( client( $client_id, 'client_language' ), $invoice_array['date'] ),
					'due_date'		    => _fdate( client( $client_id, 'client_language' ), $invoice_array['due_date'] ),
					'invoice_status'	=> __( strtolower( $invoice_array['invoice_status'] ), $invoice_array['client_id'] ),
					'invoice_number' 	=> get_option( 'invoice_prefix' ).invoice_number_format() . sprintf( "%04s", $invoice_array['invoice_number'] ),
					'invoicesubject'	=> $invoice_array['subject']
					);

				$data['invoice_amount'] 	= add_currency( format_number( $invoice_array['total'] * $invoice_array['change_rate'] ), $invoice_array['client_id'] );
				$data['amount_paid'] 		= add_currency( format_number( $invoice_array['amount_paid'] * $invoice_array['change_rate'] ), $invoice_array['client_id'] );
				$data['amount_due'] 		= add_currency(format_number($invoice_array['amount_due'] * $invoice_array['change_rate']), $invoice_array['client_id']);
				$data['client_account'] 	= base_url( 'index.php/client/index?id=' ) . _eID( $invoice_array['client_id'] );
				$data['logo_url'] 			= base_url( 'uploads/admin/img/' ). get_option( 'logo' );
				$data['btn_client_account'] = __( 'btn_client_account', $invoice_array['client_id'] );

				$CI->load->helper('file');
				$lang 					= lang_code_to_notif_string( client( $client_id, 'client_language' ) );
				$path_new_invoice 		= './notifications/' . $lang . '/invoices/new_invoice.php';
				$path_paid_invoice 		= './notifications/' . $lang . '/invoices/invoice_paid.php';
				$path_refunded_invoice 	= './notifications/' . $lang . '/invoices/invoice_refunded.php';

				$to = client( $invoice_array['client_id'], 'client_email' );
				
				$template = ( $invoice_array['invoice_status'] === "Paid" ) ? read_file( $path_paid_invoice ):
				read_file( $path_new_invoice );
				$subject = ( $invoice_array['invoice_status'] === "Paid" ) ? __( 'subject_payment_confirmation', $invoice_array['client_id'] ) : __( 'subject_invoice_generated', $invoice_array['client_id'] );
				$message = ( $invoice_array['invoice_status'] === "Paid" ) ? 
				$CI->parser->parse_string( $template, $data, true ) : 
				$CI->parser->parse_string( $template, $data, true );

				if ($client_id) {
					$client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
					if (1 == get_option('attach_pdf_to_invoice')) {
						generate_pdf_file('invoices', $invoice_array['invoice_number']);
					}
				}
				$attachments[] = FCPATH.'uploads/pdf/invoices/'.$invoice_array['invoice_number'].'.pdf';
				if (!_has_option('turn_off_customer_invoice_emails')) {
					send_email($to, $message, $subject, null, $client_cc, $attachments, get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $invoice_array['invoice_number']).'.pdf');
				}
			}
			if (get_option('delete_once_invoiced') == 1) { 
				delete('proforma', 'proforma_number', $proforma_number);
			}
		}
		return false;
	}
}
