<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function db_change_quote_quantity()
{
	global $db;
	$query = "SELECT COLUMN_TYPE FROM information_schema.COLUMNS WHERE TABLE_NAME = 'oc_quoteitems' AND COLUMN_NAME = 'item_quantity'";
	$data_type = $db->query($query);
	if ( gettype($data_type) == "integer" )
	{
		$query = "ALTER TABLE oc_quoteitems MODIFY COLUMN item_quantity decimal(10,2)";
		$db->query($query);
	}
	return FALSE;
}
// ------------------------------------------------------------------------
function upgrade_db_to_1_8()
{
	global $db;

	// Add new tables
	if ( ! db_table_exists('oc_payment_methods'))
	{
		global $db;
		$db->query("CREATE TABLE IF NOT EXISTS `oc_payment_methods` (`payment_method_id` int(11) NOT NULL AUTO_INCREMENT, `payment_method_name` varchar(225) COLLATE utf8_unicode_ci NOT NULL, PRIMARY KEY (`payment_method_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;");
		$db->query("INSERT INTO `oc_payment_methods` (`payment_method_id`, `payment_method_name`) VALUES (1, 'paypal'), (2, 'credit_card'),(3, 'check'),(4, 'bank_transfer'),(5, 'cash'),(6, 'credit_card')");
	}
	if ( ! db_table_exists('oc_notes'))
	{
		global $db;
		$db->query("CREATE TABLE IF NOT EXISTS `oc_notes` (`note_id` int(11) NOT NULL AUTO_INCREMENT, `note_title` varchar(225) NULL, `note_message` TEXT NULL, `note_referrer_key` varchar(225) NULL, `note_referrer_id` int(11), `note_referrer_value` varchar(225), `user_id` int(11), `updated_by` int(11), `note_created_on` DATETIME NULL, `note_updated_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`note_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
	if ( ! db_table_exists('oc_timeline'))
	{
		global $db;
		$db->query("CREATE TABLE IF NOT EXISTS `oc_timeline` (`id` int(11) NOT NULL AUTO_INCREMENT, `action` varchar(225) NULL, `referrer` varchar(225), `referrer_id` int(11) NULL, `referrer_value` varchar(225), `user_id` int(11), `client_id` int(11), `status` varchar(225), `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
	if ( ! db_table_exists('oc_calendar'))
	{
		global $db;
		$db->query("CREATE TABLE IF NOT EXISTS `oc_calendar` (`id` int(11) NOT NULL AUTO_INCREMENT, `title` varchar(225) NULL, `start` DATETIME NOT NULL, `end` DATETIME DEFAULT NULL, `url` varchar(225) NULL, `allDay` tinyint(1) DEFAULT 0, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
	// ------------------------------------------------------------------------
	if ( ! db_table_exists('oc_extensions'))
	{
		global $db;
		$db->query("CREATE TABLE IF NOT EXISTS `oc_extensions` (`id` int(11) NOT NULL AUTO_INCREMENT, `key` varchar(225) NOT NULL, `value` text, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
	// ------------------------------------------------------------------------
	if ( ! db_table_exists('oc_payment_history'))
	{
		global $db;
		$db->query("CREATE TABLE IF NOT EXISTS `oc_payment_history` (`payment_id` int(11) NOT NULL AUTO_INCREMENT, `payment_method` varchar(225) NOT NULL, `payment_reference` varchar(225) NOT NULL, `payment_amount` decimal(10,2) NOT NULL, `date_paid` datetime DEFAULT NULL, `invoice_number` int(11) NOT NULL, `payment_note` text, PRIMARY KEY (`payment_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");

		$query2 = "SELECT invoice_number, date_paid, payment_method, transaction_id, amount_paid FROM oc_invoices WHERE date_paid > '0000-00-00'";
		$results = $db->get_results($query2);
		if ($results)
		{
			foreach ($results as $r) {
				$db_data = array(
					'payment_method' => $r->payment_method,
					'payment_reference' => $r->transaction_id,
					'payment_amount' => $r->amount_paid,
					'date_paid' => $r->date_paid,
					'invoice_number' => $r->invoice_number
				);
				$db->query("INSERT INTO oc_payment_history SET ".$db->get_set($db_data));
			}
		}
	}
	// ------------------------------------------------------------------------
	// Alter tables
	if(user('user_avatar') == null)
	{
		$db->query("ALTER TABLE `users` ADD `user_avatar` varchar(225) NOT NULL DEFAULT 'default_user.jpg'");
	}
	if( ! col_exists('clients', 'client_tax_number'))
	{
		$db->query("ALTER TABLE `oc_clients` ADD `client_tax_number` varchar(225)");
		$db->query("ALTER TABLE `oc_clients` ADD `client_bank_number` varchar(225)");
	}
	if ( ! col_exists('invoices', 'amount_refunded'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `amount_refunded` decimal(10,2)");
	}
	if ( ! col_exists('invoices', 'payment_id'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `payment_id` varchar(225)");
	}
	if ( ! col_exists('clients', 'client_password'))
	{
		$db->query("ALTER TABLE `oc_clients` ADD `client_password` varchar(225) DEFAULT NULL");
	}
	if ( ! col_exists('clients', 'client_language'))
	{
		$db->query("ALTER TABLE `oc_clients` ADD `client_language` varchar(225) DEFAULT 'en_US'");
	}
	if ( ! col_exists('clients', 'client_currency'))
	{
		$default = get_option('user_currency');
		$db->query("ALTER TABLE `oc_clients` ADD `client_currency` varchar(225) DEFAULT '{$default}'");
	}
	if ( ! col_exists('invoices', 'change_rate'))
	{
		$default = 1;
		$db->query("ALTER TABLE `oc_invoices` ADD `change_rate` decimal(10,6) DEFAULT '{$default}'");
		$db->query("ALTER TABLE `oc_quotes` ADD `change_rate` decimal(10,6) DEFAULT '{$default}'");
	}
	if ( ! col_exists('invoices_items', 'change_rate'))
	{
		$default = 1;
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `change_rate` decimal(10,6) DEFAULT '{$default}'");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `invoice_is_cancelled` tinyint(1) DEFAULT 0");
	}
	if ( ! col_exists('quotes_items', 'change_rate'))
	{
		$default = 1;
		$db->query("ALTER TABLE `oc_quoteitems` ADD `change_rate` decimal(10,6) DEFAULT '{$default}'");
	}
	if ( ! col_exists('transactions', 'charges_value_without_tax'))
	{
		$db->query("ALTER TABLE `oc_transactions` ADD `charges_value_without_tax` decimal(10,2) DEFAULT NULL");
	}
	if ( ! col_exists('transactions', 'charges_tax_id'))
	{
		$db->query("ALTER TABLE `oc_transactions` ADD `charges_tax_id` int(11)");
	}
	if ( ! col_exists('transactions', 'charges_tax_rate'))
	{
		$db->query("ALTER TABLE `oc_transactions` ADD `charges_tax_rate` decimal(10,2) DEFAULT NULL");
	}
	if ( ! col_exists('transactions', 'charges_tax_amount'))
	{
		$db->query("ALTER TABLE `oc_transactions` ADD `charges_tax_amount` decimal(10,2) DEFAULT NULL");
	}
	if ( ! col_exists('transactions', 'update_on'))
	{
		$db->query("ALTER TABLE `oc_transactions` ADD `update_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
	}
	if ( ! col_exists('clients', 'client_custom_id'))
	{
		$db->query("ALTER TABLE `oc_clients` ADD `client_custom_id` varchar(225) DEFAULT NULL");
	}
	if ( ! col_exists('clients', 'client_website'))
	{
		$db->query("ALTER TABLE `oc_clients` ADD `client_website` varchar(225) DEFAULT NULL");
	}
	if ( ! col_exists('clients', 'client_term_payment'))
	{
		$db->query("ALTER TABLE `oc_clients` ADD `client_term_payment` int(11) DEFAULT 3");
	}
	if ( ! col_exists('clients', 'client_change_rate'))
	{
		$default = 1;
		$db->query("ALTER TABLE `oc_clients` ADD `client_change_rate` decimal(10,6) DEFAULT '{$default}'");
		$db->query("ALTER TABLE `oc_clients` ADD `client_bank_name` varchar(225)");
		$db->query("ALTER TABLE `oc_clients` ADD `client_chamber_com` varchar(225)");
		
		$db_data = array(
			array(
				'option_name'   => "user_currency",
				'option_value' => 'XAF'
			),
			array(
				'option_name'   => "email_settings",
				'option_value' => 'mail'
			),
			array(
				'option_name'   => "user_date_format",
				'option_value' => 'j F Y'
			)
		);
		foreach ($db_data as $key => $value) {
			set_option($db_data[$key]);
        }
	}
	if ( ! col_exists('invoices', 'payment_gateway'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `payment_gateway` varchar(225)");
	}
	if ( ! col_exists('transactions', 'incomes_value_without_tax'))
	{
		$db->query("ALTER TABLE `oc_transactions` ADD `incomes_value_without_tax` decimal(10,2) DEFAULT NULL");
	}
	if( ! col_exists('items', 'track_inventory'))
	{
		$db->query("ALTER TABLE `oc_items` ADD `track_inventory` tinyint(1) DEFAULT 1");
		$db->query("ALTER TABLE `oc_items` ADD `initial_stock` decimal(10,2)");
		$db->query("ALTER TABLE `oc_items` ADD `initial_cost` decimal(10,2)");
		$db->query("ALTER TABLE `oc_items` ADD `reorder_point` decimal(10,2) DEFAULT 2");
		$db->query("ALTER TABLE `oc_items` ADD `on_hand_stock` decimal(10,2)");
		$db->query("ALTER TABLE `oc_items` ADD `available` decimal(10,2)");
		$db->query("ALTER TABLE `oc_items` ADD `committed` decimal(10,2)");
		$db->query("ALTER TABLE `oc_items` ADD `ordered` decimal(10,2)");
		$db->query("ALTER TABLE `oc_items` ADD `valuation` decimal(10,2)");

		// Fetch all ordered items and update db
		get_ordered_items(true);
	}
	if ( ! col_exists('providers', 'provider_contact1'))
	{
		$db->query("ALTER TABLE `oc_providers` ADD `provider_contact1` varchar(225)");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_contact1_email` varchar(225)");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_contact2` varchar(225)");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_contact2_email` varchar(225)");
	}
	if( ! col_exists('items', 'next_stock_warning'))
	{
		$db->query("ALTER TABLE `oc_items` ADD `next_stock_warning` datetime DEFAULT NULL");
	}
	if( ! col_exists('items', 'has_barcode'))
	{
		$db->query("ALTER TABLE `oc_items` ADD `has_barcode` tinyint(1) DEFAULT 0");
		$db->query("ALTER TABLE `oc_items` ADD `has_qrcode` tinyint(1) DEFAULT 0");
		$db->query("ALTER TABLE `oc_items` ADD `qrcode` varchar(225) DEFAULT NULL");
		$db->query("ALTER TABLE `oc_items` ADD `barcode` varchar(225) DEFAULT NULL");
	}
	if ( ! col_exists('items', 'hsn_sac_id'))
	{
		$db->query("ALTER TABLE `oc_items` ADD `uom_id` int(11)");
		$db->query("ALTER TABLE `oc_items` ADD `hsn_sac_id` int(11)");
		$db->query("ALTER TABLE `oc_items` ADD `sgst_id` int(11)");
		$db->query("ALTER TABLE `oc_items` ADD `igst_id` int(11)");
		$db->query("ALTER TABLE `oc_items` ADD `cgst_id` int(11)");
		$db->query("ALTER TABLE `oc_items` ADD `cess_id` int(11)");

		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_hsn_sac` varchar(10)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_uom` varchar(10)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_cgst_rate` decimal(4,2)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_sgst_rate` decimal(4,2)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_igst_rate` decimal(4,2)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_cess_rate` decimal(4,2)");

		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_cgst_amount` decimal(10,2)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_sgst_amount` decimal(10,2)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_igst_amount` decimal(10,2)");
		$db->query("ALTER TABLE `oc_invoiceitems` ADD `item_cess_amount` decimal(10,2)");

		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_hsn_sac` varchar(10)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_uom` varchar(10)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_cgst_rate` decimal(4,2)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_sgst_rate` decimal(4,2)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_igst_rate` decimal(4,2)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_cess_rate` decimal(4,2)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_cgst_amount` decimal(10,2)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_sgst_amount` decimal(10,2)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_igst_amount` decimal(10,2)");
		$db->query("ALTER TABLE `oc_quoteitems` ADD `item_cess_amount` decimal(10,2)");

		// Create HSN/SAC table
		$db->query("CREATE TABLE IF NOT EXISTS `oc_hsn_sac` (`id` int(11) NOT NULL AUTO_INCREMENT, `hsn_sac_group` varchar(225) NULL, `hsn_sac_value` varchar(225),`hsn_sac_description` text, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");

		// Create UOM table
		$db->query("CREATE TABLE IF NOT EXISTS `oc_uom` (`id` int(11) NOT NULL AUTO_INCREMENT, `uom_value` varchar(225) NULL, `uom_description` text, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");

		// Create CGST table
		$db->query("CREATE TABLE IF NOT EXISTS `oc_cgst` (`id` int(11) NOT NULL AUTO_INCREMENT, `cgst_rate` decimal(4,2) NULL, `cgst_description` text, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");

		// Create SGST table
		$db->query("CREATE TABLE IF NOT EXISTS `oc_sgst` (`id` int(11) NOT NULL AUTO_INCREMENT, `sgst_rate` decimal(4,2) NULL, `sgst_description` text, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");

		// Create SGST table
		$db->query("CREATE TABLE IF NOT EXISTS `oc_igst` (`id` int(11) NOT NULL AUTO_INCREMENT, `igst_rate` decimal(4,2) NULL, `igst_description` text, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");

		// Create SGST table
		$db->query("CREATE TABLE IF NOT EXISTS `oc_cess` (`id` int(11) NOT NULL AUTO_INCREMENT, `cess_rate` decimal(4,2) NULL, `cess_description` text, `created_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;");
	}
	if ( ! col_exists('invoices', 'recurring_from'))
	{
		$db->query("ALTER TABLE `oc_invoices` ADD `recurring_from` DATETIME DEFAULT NULL");
		$db->query("ALTER TABLE `oc_invoices` ADD `recurring_to` DATETIME DEFAULT NULL");
	}
	if ( ! col_exists('providers', 'provider_language'))
	{
		$default = get_option('user_currency');
		$db->query("ALTER TABLE `oc_providers` ADD `provider_language` varchar(225) DEFAULT 'en_US'");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_currency` varchar(225) DEFAULT '{$default}'");
	}
	if( ! col_exists('providers', 'provider_tax_number'))
	{
		$db->query("ALTER TABLE `oc_providers` ADD `provider_tax_number` varchar(225) DEFAULT NULL");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_bank_number` varchar(225) DEFAULT NULL");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_chamber_com` varchar(225) DEFAULT NULL");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_bank_name` varchar(225) DEFAULT NULL");
	}
	if ( ! db_table_exists('oc_purchases'))
	{
		global $db;
		$db->query("DROP TABLE IF EXISTS oc_purchase_order");
		$db->query("DROP TABLE IF EXISTS oc_purchaseditems");
		$db->query("DROP TABLE IF EXISTS oc_buildings");
		$db->query("DROP TABLE IF EXISTS oc_calendar");
		$db->query("DROP TABLE IF EXISTS oc_extensions");
		$db->query("DROP TABLE IF EXISTS oc_networking");
		$db->query("DROP TABLE IF EXISTS oc_newsletter");
		$db->query("DROP TABLE IF EXISTS oc_plans");
	
		$db->query("CREATE TABLE oc_purchases LIKE oc_invoices");
		$db->query("ALTER TABLE oc_purchases CHANGE COLUMN invoice_number purchase_number varchar(20)");
		$db->query("ALTER TABLE oc_purchases CHANGE COLUMN invoice_status purchase_status varchar(20)");
		$db->query("ALTER TABLE oc_purchases CHANGE COLUMN client_id provider_id int(11)");
		$db->query("ALTER TABLE oc_purchases CHANGE COLUMN due_date shipping_date DATETIME NULL");
		$db->query("ALTER TABLE oc_purchases DROP INDEX `invoice_number`");
		$db->query("CREATE INDEX purchase_number ON oc_purchases (purchase_number)");
		// Add new table to transaction
		$db->query("ALTER TABLE oc_transactions ADD purchase_number varchar(20)");

		$db->query("CREATE TABLE oc_purchaseitems LIKE oc_invoiceitems");
		$db->query("ALTER TABLE oc_purchaseitems CHANGE COLUMN client_id provider_id int(11)");
		$db->query("ALTER TABLE oc_purchaseitems CHANGE COLUMN invoice_number purchase_number varchar(20)");
		$db->query("ALTER TABLE oc_purchaseitems DROP INDEX `invoice_number`");
		$db->query("CREATE INDEX purchase_number ON oc_purchaseitems (purchase_number)");
		
		$db->query("ALTER TABLE  `oc_purchaseitems` ADD CONSTRAINT  `fk_pur` FOREIGN KEY (`purchase_number`) REFERENCES `oc_purchases` (`purchase_number`) ON DELETE CASCADE ON UPDATE NO ACTION");
	}
	if( ! col_exists('purchases', 'shipping_amount'))
	{
		$db->query("ALTER TABLE `oc_purchases` ADD `shipping_amount` decimal(10,2)");
		$db->query("ALTER TABLE `oc_purchases` ADD `other_expenses` decimal(10,2)");
	}
	if( ! col_exists('transactions', 'purchase_number'))
	{
		$db->query("ALTER TABLE `oc_transactions` ADD `purchase_number` varchar(225)");
	}
	if ( ! col_exists('items', 'shipment_status'))
	{
		$db->query("ALTER TABLE `oc_items` ADD `shipment_status` varchar(225) DEFAULT NULL");
		$db->query("ALTER TABLE `oc_purchases` ADD `shipment_status` varchar(225) DEFAULT NULL");
		$db->query("ALTER TABLE `oc_providers` ADD `provider_password` varchar(225) DEFAULT NULL");
		// Add new table to transaction
		$db->query("ALTER TABLE `oc_payment_history` ADD `purchase_number` varchar(225)");
		set_option(array('option_name' => 'purchase_code', 'option_value' => 0));
	}
	set_option(array('option_name' => 'stable_version', 'option_value' => 1.8));
}