<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use PhpRbac\Rbac;

function upgrade_db_to_php_rbac() {
  global $db;

  $CI = & get_instance();
  $tables = $CI->db->list_tables();
  foreach ($tables as $table)
  {
      if ( ! col_exists('users', 'user_id')) {
          if (
               $table === 'users' ||
               $table === 'oc_transactions'||
               $table === 'oc_taxes'||
               $table === 'oc_quotes'||
               $table === 'oc_quoteitems'||    
               $table === 'oc_purchases'|| 
               $table === 'oc_purchaseitems'||     
               $table === 'oc_providers'||         
               $table === 'oc_productsgroups'||    
               $table === 'oc_payment_methods'||       
               $table === 'oc_payment_history'||       
               $table === 'oc_payment_history'||       
               $table === 'oc_items'||         
               $table === 'oc_invoices'||      
               $table === 'oc_invoiceitems'||  
               $table === 'oc_orders'||  
               $table === 'oc_orderitems'||  
               $table === 'oc_clients'      
           ) {
            $db->query("ALTER TABLE {$table} ADD `user_id` int(11) NOT NULL DEFAULT 1");
          }
      }
  }
  // Default root id
  $query = "SELECT id from users WHERE active = 1";
  $admin_id = $db->get_row($query)->id;

  if ( ! db_table_exists('oc_permissions')) {
    $db->query("CREATE TABLE IF NOT EXISTS `oc_permissions` (`ID` int(11) NOT NULL auto_increment,`Lft` int(11) NOT NULL,`Rght` int(11) NOT NULL,`Title` char(64) NOT NULL,`Description` text NOT NULL,PRIMARY KEY  (`ID`),KEY `Title` (`Title`),KEY `Lft` (`Lft`),KEY `Rght` (`Rght`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;");
    $db->query("CREATE TABLE IF NOT EXISTS `oc_rolepermissions` (`RoleID` int(11) NOT NULL,`PermissionID` int(11) NOT NULL,`AssignmentDate` int(11) NOT NULL,PRIMARY KEY  (`RoleID`,`PermissionID`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;");
    $db->query("CREATE TABLE IF NOT EXISTS `oc_roles` (`ID` int(11) NOT NULL auto_increment,`Lft` int(11) NOT NULL,`Rght` int(11) NOT NULL,`Title` varchar(128) NOT NULL,`Description` text NOT NULL,PRIMARY KEY  (`ID`),KEY `Title` (`Title`),KEY `Lft` (`Lft`),KEY `Rght` (`Rght`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;");
    $db->query("CREATE TABLE IF NOT EXISTS `oc_userroles` (`UserID` int(11) NOT NULL,`RoleID` int(11) NOT NULL,`AssignmentDate` int(11) NOT NULL,PRIMARY KEY  (`UserID`,`RoleID`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;");
    $db->query("INSERT INTO `oc_permissions` (`ID`, `Lft`, `Rght`, `Title`, `Description`) VALUES (1, 0, 1, 'root', 'root');");
    $db->query("INSERT INTO `oc_rolepermissions` (`RoleID`, `PermissionID`, `AssignmentDate`) VALUES (1, 1, UNIX_TIMESTAMP());");
    $db->query("INSERT INTO `oc_roles` (`ID`, `Lft`, `Rght`, `Title`, `Description`) VALUES (1, 0, 1, 'root', 'root');");
    $db->query("INSERT INTO `oc_userroles` (`UserID`, `RoleID`, `AssignmentDate`) VALUES ('{$admin_id}', 1, UNIX_TIMESTAMP());");

    if ( ! db_table_exists('oc_orders'))
    {
        global $db;
        $db->query("CREATE TABLE oc_orders LIKE oc_invoices");
        $db->query("ALTER TABLE oc_orders CHANGE COLUMN invoice_number order_number varchar(20)");
        $db->query("ALTER TABLE oc_orders CHANGE COLUMN invoice_status order_status varchar(20)");
        $db->query("ALTER TABLE oc_orders DROP INDEX `invoice_number`");
        $db->query("CREATE INDEX order_number ON oc_orders (order_number)");
        $db->query("ALTER TABLE `oc_orders` ADD `order_key` INT(11)");
        $db->query("ALTER TABLE `oc_orders` ADD `invoice_number` INT(11)");
        $db->query("ALTER TABLE `oc_invoices` ADD `order_number` INT(11)");
        $db->query("ALTER TABLE `oc_orders` ADD `has_picking_list` tinyint(1) DEFAULT 0");

        $db->query("CREATE TABLE oc_orderitems LIKE oc_invoiceitems");
        $db->query("ALTER TABLE oc_orderitems CHANGE COLUMN invoice_number order_number varchar(20)");
        $db->query("ALTER TABLE oc_orderitems CHANGE COLUMN invoice_is_cancelled order_is_cancelled tinyint(1)");
        $db->query("ALTER TABLE oc_orderitems DROP INDEX `invoice_number`");
        $db->query("ALTER TABLE oc_orderitems DROP COLUMN `invoice_key`");
        $db->query("ALTER TABLE `oc_orderitems` ADD `order_key` INT(11)");
        $db->query("ALTER TABLE `oc_orderitems` ADD `available` tinyint(1)");
        $db->query("ALTER TABLE `oc_orderitems` ADD `picked` tinyint(1)");
        $db->query("ALTER TABLE `oc_orderitems` ADD `picked_on` DATETIME NULL");
        $db->query("CREATE INDEX order_number ON oc_orderitems (order_number)");
        
        $db->query("ALTER TABLE  `oc_orderitems` ADD CONSTRAINT  `fk_ord` FOREIGN KEY (`order_number`) REFERENCES `oc_orders` (`order_number`) ON DELETE CASCADE ON UPDATE NO ACTION");
    }
    if ( ! db_table_exists('oc_messaging')) {
        // Upgrade to messaging
        upgrade_to_messaging();
    }
    if ( ! col_exists('clients', 'billing_name_company')) {
        // Add Client Billing Address
        $db->query("ALTER TABLE `oc_clients` ADD `billing_name_company` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `billing_phone` varchar(20)");
        $db->query("ALTER TABLE `oc_clients` ADD `billing_address1` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `billing_address2` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `billing_city` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `billing_state` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `billing_postcode` varchar(20)");
        $db->query("ALTER TABLE `oc_clients` ADD `billing_country` varchar(20)");

        // Add Client Shipping Address
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_name_company` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_phone` varchar(20)");
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_address1` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_address2` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_city` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_state` varchar(225)");
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_postcode` varchar(20)");
        $db->query("ALTER TABLE `oc_clients` ADD `shipping_country` varchar(20)");

        // add unique id in Transaction
        $db->query("ALTER TABLE `oc_transactions` ADD `unique_id` text DEFAULT NULL");
    }

    $rbac = new Rbac();
    // Create Roles
    $root_id = $rbac->Roles->returnId('root');
    // Add CEO Role
    $ceo_id = $rbac->Roles->add('ceo', 'CEO', $root_id);
    // Add Operation Role
    $operations_id = $rbac->Roles->add('operation', 'Operations', $ceo_id);
    // Add Financial Role
    $financial_id = $rbac->Roles->add('financial', 'Financial', $ceo_id);
    // Add Sales Role
    $sales_id = $rbac->Roles->add('sales', 'Sales', $financial_id);
    // Add Marketing Role
    $marketing_id = $rbac->Roles->add('marketing', 'Marketing', $financial_id);
    // Add Cost Role
    $cost_id = $rbac->Roles->add('cost', 'Cost', $financial_id);
    // Add Payroll Role
    $payroll_id = $rbac->Roles->add('payroll', 'Payroll', $financial_id);

    // Add Permissions
    $root_perm = $rbac->Permissions->returnId('root');
    $homepage_perm = $rbac->Permissions->add('homepage', 'User can access dashboard', $root_perm);
    $items_services_perm = $rbac->Permissions->add('items', 'User can manage items and services', $root_perm);
    $users_perm = $rbac->Permissions->add('users', 'User can manage users', $root_perm);
    $customers_perm = $rbac->Permissions->add('customers', 'User can manage customers', $root_perm);
    $providers_perm = $rbac->Permissions->add('providers', 'User can manage providers', $root_perm);
    $invoices_quotes_perm = $rbac->Permissions->add('invoices', 'User can manage invoices and quotes', $root_perm);
    $purchases_perm = $rbac->Permissions->add('purchases', 'User can manage purchases', $root_perm);
    $money_perm = $rbac->Permissions->add('money', 'User can manage Charges and Incomes', $root_perm);
    $reports_perm = $rbac->Permissions->add('reports', 'User can manage Reports and Stats', $root_perm);
    $system_perm = $rbac->Permissions->add('system', 'User can manage System and Settings', $root_perm);

    // Add Children
    $rbac->Permissions->add('homepage_access_any', 'User can view dashboard summaries', $homepage_perm);
    $rbac->Permissions->add('homepage_owner', 'Can view own records only', $homepage_perm);
    $rbac->Permissions->add('items_services_add_edit', 'Can add and edit items and services', $items_services_perm);
    $rbac->Permissions->add('items_services_add_edit_delete', 'Can add, edit and delete items and services', $items_services_perm);
    $rbac->Permissions->add('items_services_batch_update_price', 'Can batch edit items and services prices', $items_services_perm);
    $rbac->Permissions->add('items_services_edit_stocks', 'Can edit items and services stocks', $items_services_perm);
    $rbac->Permissions->add('user_add_edit', 'Can add, edit user', $users_perm);
    $rbac->Permissions->add('user_add_edit_delete', 'Can add, edit and delete user', $users_perm);
    $rbac->Permissions->add('user_run_time_tracking', 'Can run Time Tracking', $users_perm);
    $rbac->Permissions->add('user_reset_password', 'Can reset all passwords', $users_perm);
    $rbac->Permissions->add('user_manage_access', 'Can access and manage users roles and permissions', $users_perm);
    $rbac->Permissions->add('user_manage_commissions', 'Can manage users/agents commissions', $users_perm);
    $rbac->Permissions->add('customer_add_edit', 'Can add and edit customer', $customers_perm);
    $rbac->Permissions->add('customer_add_edit_delete', 'Can add, edit and delete customer', $customers_perm);
    $rbac->Permissions->add('customer_access_any', 'Can access all customers', $customers_perm);
    $rbac->Permissions->add('customer_owner', 'Can access own customers only', $customers_perm);
    $rbac->Permissions->add('provider_add_edit', 'Can add and edit provider', $providers_perm);
    $rbac->Permissions->add('provider_add_edit_delete', 'Can add, edit and delete provider', $providers_perm);
    $rbac->Permissions->add('invoice_add_edit', 'Can add and edit invoice', $invoices_quotes_perm);
    $rbac->Permissions->add('invoice_add_edit_delete', 'Can add, edit and delete invoice', $invoices_quotes_perm);
    $rbac->Permissions->add('invoice_create_credit_note', 'Can create credit note', $invoices_quotes_perm);
    $rbac->Permissions->add('invoice_access_any', 'Can access all invoices', $invoices_quotes_perm);
    $rbac->Permissions->add('invoice_owner', 'Can access own invoices only', $invoices_quotes_perm);
    $rbac->Permissions->add('purchase_add_edit', 'Can add and edit purchase order', $purchases_perm);
    $rbac->Permissions->add('purchase_add_edit_delete', 'Can add, edit and delete purchase order', $purchases_perm);
    $rbac->Permissions->add('charge_income_add_edit', 'Can add and edit charges and incomes', $money_perm);
    $rbac->Permissions->add('charge_income_add_edit_delete', 'Can add, edit and delete charges and incomes', $money_perm);
    $rbac->Permissions->add('charge_income_access_any', 'Can access all charges and incomes', $money_perm);
    $rbac->Permissions->add('charge_income_owner', 'Can access own charges and incomes only', $money_perm);
    $rbac->Permissions->add('report_access_any', 'Can access all reports and stats', $reports_perm);
    $rbac->Permissions->add('report_owner', 'Can access own reports and stats only', $reports_perm);
    $rbac->Permissions->add('setting_readonly', 'Can read only settings', $system_perm);
    $rbac->Permissions->add('setting_read_write', 'Can read and update settings', $system_perm);

    // Alter user table
    $db->query("ALTER TABLE `users` ADD `user_own_paypal` varchar(225)");
    $db->query("ALTER TABLE `users` ADD `user_own_skrill` varchar(225)");
    $db->query("ALTER TABLE `users` ADD `user_own_bank_number` varchar(225)");
    $db->query("ALTER TABLE `users` ADD `commission_type` varchar(225)");
    $db->query("ALTER TABLE `users` ADD `commission_type_value` decimal(10,2)");
    // Alter user table
    $db->query("ALTER TABLE `oc_invoices` ADD `user_commission` decimal(10,2)");
    $db->query("ALTER TABLE `oc_invoices` ADD `commission_status` varchar(225) NOT NULL DEFAULT 'Unpaid'");
    // Alter Invoice table
    $db->query("ALTER TABLE `oc_invoices` ADD `updated_on` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COLLATE utf8_unicode_ci NOT NULL");
    
    set_option(array(
        'option_name' => "theme",
        'option_value' => 'default'
        )
    );
    set_option(array(
        'option_name' => "order_layout",
        'option_value' => '1'
        )
    );
    set_option(array(
        'option_name' => "theme_name",
        'option_value' => 'darkblue'
        )
    );
  }
}
