<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller
{
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('charges_model', 'charges');
	}
	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function add_charges($id = NULL)
	{
		$config['upload_path']          = './uploads/charges/attachments';
		$config['allowed_types']        = 'gif|jpg|png|pdf';
		$config['overwrite']        	= TRUE;


		$this->load->library('upload', $config);
		$this->upload->do_upload('charges_attachment');
		$data = $this->upload->data();

		$post_array = array(
			'charges_name'					=> null != $this->input->post('charges_name') ? $this->input->post('charges_name') : __('charges_purchases'),
			'charges_sku'					=> null != $this->input->post('charges_sku') ? $this->input->post('charges_sku') : generate_sku(),
			'charges_category'				=> $this->input->post('charges_category'),
			'charges_value_without_tax'		=> $this->input->post('charges_value_without_tax'),
			'charges_tax_id'				=> $this->input->post('charges_tax_rate'),
			'charges_tax_rate'				=> get_tax($this->input->post('charges_tax_rate'), 'tax_percent'),
			'charges_value'					=> $this->input->post('charges_value'),
			'charges_tax_amount'			=> null != $this->input->post('charges_fixed_value') ? $this->input->post('charges_fixed_value'): $this->input->post('charges_tax_amount'),
			'charges_notes'					=> $this->input->post('charges_notes'),
			'payment_method'				=> $this->input->post('payment_method'),
			'created_on'					=> mysqlDate(get_option('user_language', 'users_options'), $this->input->post('created_on')),
			'update_on'						=> date('Y-m-d'),
			'attachment'					=> $data['file_name']
			);
		$config = array(
			array(
                    'field' => 'charges_category',
                    'label' => __('label_group_name'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => __('error_required_group')
                            )
                ),
			array(
                    'field' => 'charges_value',
                    'label' => __('label_amount'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => __('error_required_amount')
                            )
                ),
			array(
                    'field' => 'created_on',
                    'label' => __('date'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => __('error_required_field_error')
                            )
                )
			);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('transaction_id');
		$is_modal = $this->input->post('is_modal');

		if (!$id)
		{
			if (!$is_modal)
			{
				$this->charges->set_table('transactions');
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->charges->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
						$db_data = array(
							'note_title'		 	=> isset($notes_array['note_title']) ? $notes_array['note_title'] : $post_array['charges_name'],
							'note_message' 			=> isset($notes_array['note_message']) ? $notes_array['note_message'] : '',
							'note_referrer_key'     => 'charges',
							'note_referrer_id'      => $this->db->insert_id(),
							'note_referrer_value'   => $this->input->post('charges_name'),
							'user_id'				=> user('user_id'),
							'note_created_on'		=> date('Y-m-d')
						);
						$event = array(
							'action' 					=> 'add',
							'referrer' 					=> 'charges',
							'referrer_id' 				=> $this->db->insert_id(),
							'referrer_value' 			=> $this->input->post('charges_name'),
							'user_id' 					=> user('user_id'),
							'status' 					=> 'success'
						);
						record_notes($db_data);
						record_event($event);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors());
				}
			}
			else
			{
				$this->charges->set_table('transactions');
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->charges->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
						$db_data = array(
							'note_title'		 	=> isset($notes_array['note_title']) ? $notes_array['note_title'] : $post_array['charges_name'],
							'note_message' 			=> isset($notes_array['note_message']) ? $notes_array['note_message'] : '',
							'note_referrer_key'     => 'charges',
							'note_referrer_id'      => $this->db->insert_id(),
							'note_referrer_value'   => $this->input->post('charges_name'),
							'user_id'				=> user('user_id'),
							'note_created_on'		=> date('Y-m-d')
						);
						$event = array(
							'action' 					=> 'add',
							'referrer' 					=> 'charges',
							'referrer_id' 				=> $this->db->insert_id(),
							'referrer_value' 			=> $this->input->post('charges_name'),
							'user_id' 					=> user('user_id'),
							'status' 					=> 'success'
						);
						record_notes($db_data);
						record_event($event);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
				}
			}
			echo json_encode($this->response);

		}
		else
		{
			$this->charges->set_table('transactions');
			$this->charges->set_primary_key('transaction_id');
			if ($this->form_validation->run() == TRUE)
			{
				$row_affected = $this->charges->save($post_array, $id);
			}
			if ($row_affected != 0)
			{
				$this->response = array('status' => 1);
				$db_data = array(
					'note_title'		 	=> isset($notes_array['note_title']) ? $notes_array['note_title'] : $post_array['charges_name'],
					'note_message' 			=> isset($notes_array['note_message']) ? $notes_array['note_message'] : '',
					'note_referrer_key'     => 'charges',
					'note_referrer_id'      => $this->db->insert_id(),
					'note_referrer_value'   => $this->input->post('charges_name'),
					'user_id'				=> user('user_id'),
					'note_created_on'		=> date('Y-m-d')
				);
				$event = array(
					'action' 					=> 'update',
					'referrer' 					=> 'charges',
					'referrer_id' 				=> $id,
					'referrer_value' 			=> $this->input->post('charges_name'),
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_notes($db_data);
				record_event($event);
			}
			else
			{
				$this->response = array('status' => 0, 'error' => validation_errors());
			}
			echo json_encode($this->response);
		}
	}
	public function create_group($id = NULL)
	{
		$post_array = array(
			'group_name'					=> $this->input->post('group_name'),
			'group_description'				=> $this->input->post('description')
			);
		$config = array(
			array(
                    'field' => 'group_name',
                    'label' => __('label_group_name'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => __('error_required_group').'<br />'
                            )
                )
			);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('group_id');
		$is_modal = $this->input->post('is_modal');
		if (!$id)
		{
			if (!$is_modal)
			{
				$this->charges->set_table('charges_categories');
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->charges->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
						$event = array(
							'action' 					=> 'add',
							'referrer' 					=> 'charges',
							'referrer_id' 				=> $this->db->insert_id(),
							'referrer_value' 			=> $this->input->post('group_name'),
							'user_id' 					=> user('user_id'),
							'status' 					=> 'success'
						);
						record_event($event);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors());
				}
			}
			else
			{
				$this->charges->set_table('charges_categories');
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->charges->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
						$event = array(
							'action' 					=> 'add',
							'referrer' 					=> 'charges',
							'referrer_id' 				=> $this->db->insert_id(),
							'referrer_value' 			=> $this->input->post('group_name'),
							'user_id' 					=> user('user_id'),
							'status' 					=> 'success'
						);
						record_event($event);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
				}
			}
			echo json_encode($this->response);

		}
		else
		{
			$this->charges->set_table('charges_categories');
			$this->items->set_primary_key('group_id');
			if ($this->form_validation->run() == TRUE)
			{
				$row_affected = $this->items->save($post_array, $id);
			}
			if ($row_affected != 0)
			{
				$this->response = array('status' => 1);
				$event = array(
					'action' 					=> 'update',
					'referrer' 					=> 'charges',
					'referrer_id' 				=> $id,
					'referrer_value' 			=> $this->input->post('group_name'),
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
			}
			else
			{
				$this->response = array('status' => 0, 'error' => validation_errors());
			}
			echo json_encode($this->response);
		}
	}
}