<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Charges extends Admin_Controller {
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('charges_model', 'charges');
		$this->load->library('m_manager');
		$this->view_data['pageJs'] = array(
            'products.js',
            'taxes.js',
        );
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$this->view_data['modal'] = $this->Template->render('charges', 'add_charges_modal.phtml', array('categories' => $this->get_groups('array')), true);
		$this->view_data['localPluginJs'] = array('bootstrap-fileinput/bootstrap-fileinput.js');
		$this->data['breadcrumb'] = anchor('charges', __('link_charges'));
		$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	public function index()
	{
		if (can_access('incomes_charges')) {
			array_push($this->view_data['pageJs'], 'chargescharts.js');
			$this->view_data['pluginsJs'] = array(
	            'https://cdnjs.cloudflare.com/ajax/libs/echarts/3.5.0/echarts.min.js'
	        );
			$data = array(
				'breadcrumb' 		=> anchor('charges', __('link_charges')),
				'toolbar'    		=> "",
				'page_title' 		=> __('link_charges'),
				'page_description' 	=> __('message_manage') .' '.__('link_charges'),
				'filter' => 'all'
				);
			$this->view_data['content'] = $this->Template->render('charges', 'index.phtml', $data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit_charges()
	{
		$id = isset($_REQUEST['id']) ?  $_REQUEST['id'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('charges', __('link_charges')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_charges'),
			'page_description' 	=> __('message_manage') .' '.__('charges_charge'),
			'charges'         => get_charges($id),
			'categories'      => $this->get_groups('array')
			);
		$this->view_data['content'] = $this->Template->render('charges', 'edit_charges_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function charges_details()
	{
		$cat = isset($_REQUEST['cat']) ?  $_REQUEST['cat'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('charges', __('link_charges')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_charges'),
			'page_description' 	=> __('message_manage') .' '.__('charges_charge'),
			'category'          => $cat
			);
		$this->view_data['content'] = $this->Template->render('charges', 'charges_details.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function delete_charges()
	{
		$protected = [];
		$to_del = [];
		$ids = $_REQUEST['id'];
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (!can_delete_charges($i))
				{
					array_push($to_del, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('transactions', 'transaction_id', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function income_by_category()
	{
		$incomeByCategory = [];
		$interval = (!isset($_REQUEST['interval'])) ? 'this_month' : $_REQUEST['interval'];
		$results = income_by_category($interval);
		foreach ($results as $value) 
		{
		 	$incomeByCategory[] = array(
		 		'name' => ($value->name === null) ? __('label_uncategorized'): $this->m_manager->category_name($value->name),
		 		'value'    => floatval($value->value)
		 	);
		 }
		 echo json_encode($incomeByCategory);
	}
	public function financial_accounting($interval=null)
	{
	    if (isset($_REQUEST['interval']))
	    {
	        $interval = $_REQUEST['interval'];
	        echo json_encode(financial_accounting($interval));
	    }
	    else 
	    {
	        echo json_encode(financial_accounting(3));
	    }
	}
	public function get_charges_list($filter=null)
	{
		$list = [];
		if (!$filter)
		{
			$charges = get_charges_list('all');
			if ($charges)
			{
				foreach ($charges as $charge) {
					array_push($list, array(
						'charges_name'        => $charge->charges_name,
						'charges_category'    => get_charges_category($charge->charges_category),
						'charges_key'    	  => $charge->charges_category,
						'charges_value'   	  => floatval($charge->charges_value)
						)
					);
				}
			}
		}
		else
		{
			$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
			$charges = get_charges_list($filter);
			if ($charges)
			{
				foreach ($charges as $charge) {
					array_push($list, array(
						'charges_name'        => $charge->charges_name,
						'charges_category'    => get_charges_category($charge->charges_category),
						'charges_key'    	  => $charge->charges_category,
						'charges_value'   	  => floatval($charge->charges_value)
						)
					);
				}
			}
		}
		echo json_encode($list);
	}
	/**
	 * Charges per category for charges charts
	 */
	public function get_charges_per_category()
	{
		$charges = [];
		$results = get_charges_list();
		if ($results)
		{
			foreach ($results as $v) {
				array_push($charges, array(
				    'name' => get_charges_category($v->charges_category),
				    'value' => $v->charges_value
				    )
				);
			}
		}
		echo json_encode($charges);
	}
	public function get_incomes_list($filter=null)
	{
		$list = [];
		if (!$filter)
		{
			$incomes = get_incomes_list('all');
			if ($incomes)
			{
				foreach ($incomes as $income) {
					array_push($list, array(
						'incomes_category'    	  => $income->incomes_category,
						'incomes_value'           => floatval($income->incomes_value)
						)
					);
				}
			}
		}
		else
		{
			$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
			$incomes = get_incomes_list($filter);
			if ($incomes)
			{
				foreach ($incomes as $income) {
					array_push($list, array(
						'incomes_category'    	  => $income->incomes_category,
						'incomes_value'           => floatval($income->incomes_value)
						)
					);
				}
			}
		}
		echo json_encode($list);
	}
	public function get_charges_details()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['category']) ? $_REQUEST['category'] : 'all';
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'transaction_id';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : '';

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$charges = $this->charges->findAll(
			array(
				'filter' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination,
				'type' => 'charges'
			)
		);
		if ($charges)
		{
			foreach ($charges as $charge) {
				array_push($rows, array(
					'transaction_id'      			=> $charge->transaction_id,
					'charges_name'        			=> $charge->charges_name,
					'charges_sku'        			=> $charge->charges_sku,
					'charges_category'    			=> __($charge->group_name),
					'created_on'          			=> _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $charge->created_on),
					'charges_value'   	  			=> floatval($charge->charges_value),
					'invoice_number'   	   			=> $charge->invoice_number,
					'purchase_number'   	   		=> $charge->purchase_number,
					'encrypt_invoice_number'   	  	=> _eID($charge->invoice_number),
					'encrypt_purchase_number'   	=> _eID($charge->purchase_number),
					'attachment'					=> $charge->attachment
					)
				);
			}
			if ( $search) {
				$list = array(
					'total' => count($charges),
					'totalNotFiltered' => count($charges),
					'rows' => $rows
				);
			} else {
				$total = $this->charges->count_rows('transactions', $filter, 'charges');
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows
				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function get_incomes_details()
	{
		$list = [];
		$category = empty($_REQUEST['category']) ? 'all' : $_REQUEST['category'];
		$incomes = get_incomes_by_category($category);
		if ($incomes)
		{
			foreach ($incomes as $income) {
				array_push($list, array(	
					'transaction_id'      		=> $income->transaction_id,
					'incomes_category'    		=> $income->incomes_category,
					'created_on'         		 => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $income->created_on),
					'incomes_value'   	 		 => floatval($income->incomes_value),
					'invoice_number'   	 		 => $income->invoice_number,
					'encrypt_invoice_number'   	  => _eID($income->invoice_number)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function get_invoiced_items_count()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'this_month' : $_REQUEST['filter'];
		$counts = invoiced_items_count($filter);
		if ($counts)
		{
			foreach ($counts as $count) {
				array_push($list, array(
				'name' 		=> $count->name,	
				'quantity' 	=> intval($count->quantity),	
				'value' 	=> floatval($count->value),	
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function get_groups($type=null)
	{
		$groups = [];
		$results = get_charges_categories();
		if($results)
		{
			foreach ($results as $group) {
				array_push($groups, array(
					'group_id' 			=> $group->group_id,
					'group_name' 		=> get_charges_category($group->group_id),
					'group_description' => $group->group_description
					)
				);
			}
		}
		if(!$type)
		{
			echo json_encode($groups);
		}
		else if($type == 'array')
		{
			return $groups;
		}
	}
}