<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller {
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('clients_model', 'clients');
		$this->clients->set_primary_key('client_id');
	}
	
	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function add_client($id=NULL)
	{
		$this->load->model('users/ion_auth_model', 'auth');
		$is_modal = $this->input->post('is_modal');
		$password = null != $this->input->post('client_password') ? $this->input->post('client_password'): false;
		$post_array = array(
			'name_company' 				=> htmlentities($this->input->post('name_company')),
			'client_email' 				=> strtolower($this->input->post('client_email')),
			'client_cc' 				=> (! empty($this->input->post('client_cc'))) ? json_encode($this->input->post('client_cc')) : json_encode([]),
			'client_address1' 			=> $this->input->post('client_address1'),
			'client_address2'			=> $this->input->post('client_address2'),
			'client_city' 				=> $this->input->post('client_city'),
			'client_state' 				=> $this->input->post('client_state'),
			'client_postcode' 			=> $this->input->post('client_postcode'),
			'client_country'			=> $this->input->post('client_country'),
			'client_phone' 				=> $this->input->post('client_phone'),
			'client_tax_number' 		=> $this->input->post('client_tax_number'),
			'client_bank_number' 		=> $this->input->post('client_bank_number'),
			'client_bank_name' 			=> $this->input->post('client_bank_name'),
			'client_chamber_com' 		=> $this->input->post('client_chamber_com'),
			'client_type' 				=> $this->input->post('client_type'),
			'client_credit' 			=> floatval($this->input->post('client_credit')),
			'client_status' 			=> $this->input->post('client_status'),
			'client_custom_id' 			=> $this->input->post('client_custom_id'),
			'client_website' 			=> $this->input->post('client_website'),
			'client_language' 			=> $this->input->post('client_language'),
			'client_term_payment' 		=> $this->input->post('client_term_payment'),
			'send_overdue_reminder' 	=> $this->input->post('send_overdue_reminder'),
			'support_contract' 			=> floatval($this->input->post('support_contract')) * 60,

			// Billing Address
			'billing_name_company'		=> $this->input->post('billing_name_company'),
			'billing_phone'				=> $this->input->post('billing_phone'),
			'billing_address1'			=> $this->input->post('billing_address1'),
			'billing_address2'			=> $this->input->post('billing_address2'),
			'billing_city'				=> $this->input->post('billing_city'),
			'billing_state'				=> $this->input->post('billing_state'),
			'billing_postcode'			=> $this->input->post('billing_postcode'),
			'billing_country'			=> $this->input->post('billing_country'),

			// Shipping Address
			'shipping_name_company'		=> $this->input->post('shipping_name_company'),
			'shipping_phone'			=> $this->input->post('shipping_phone'),
			'shipping_address1'			=> $this->input->post('shipping_address1'),
			'shipping_address2'			=> $this->input->post('shipping_address2'),
			'shipping_city'				=> $this->input->post('shipping_city'),
			'shipping_state'			=> $this->input->post('shipping_state'),
			'shipping_postcode'			=> $this->input->post('shipping_postcode'),
			'shipping_country'			=> $this->input->post('shipping_country'),
			'exclude_late_fees'			=> $this->input->post('exclude_late_fees'),
			'user_id' 					=> null !== $this->input->post('user_id') ? $this->input->post('user_id'): USERID
			);
		if ( is_italian_company() )
		{
			$post_array['client_fiscal_code'] = null !== $this->input->post('client_fiscal_code') ? $this->input->post('client_fiscal_code'): '';
		}
		if ( _has_option('change_currency') )
		{
			$post_array['client_currency'] = null !== $this->input->post('client_currency') ? $this->input->post('client_currency'): get_option('user_currency');
			$post_array['client_change_rate'] = get_change_rate( null !== $this->input->post('client_currency') ? $this->input->post('client_currency') : get_option('user_currency') );
		}
		else
		{
			$post_array['client_currency'] = get_option('user_currency');
		}
		$notes_array = array(
			'note_message' 				=> $this->input->post('client_notes'),
			'note_title' 		        => $this->input->post('client_notes_title')
			);

		if($password)
		{
			$config = array(
				array(
					'field' => 'name_company',
					'label' => lang('label_name_company'),
					'rules' => 'required',
					'errors' => array(
						'required' => lang('error_required_name'). '<br />'
						)
					),
				array(
					'field' => 'client_email',
					'label' => lang('email'),
					'rules' => 'required|valid_email',
					'errors' => array(
						'required' => lang('error_required_email'). '<br />',
						'valid_email' => lang('error_required_valid_email'). '<br />'
						)
					),
				array(
					'field' => 'client_password',
					'label' => lang('label_password'),
					'rules' => 'required|matches[password_confirm]',
					'errors' => array(
						'matches' => lang('error_password_confirm'). '<br />'
						)
					),
				array(
					'field' => 'password_confirm',
					'label' => lang('label_password_confirm'),
					'rules' => 'required',
					'errors' => array(
	                    'required' => lang('error_password_confirm_required_field_error') . '<br />'
	                )
				)
			);
		}
		else
		{
			$config = array(
				array(
					'field' => 'name_company',
					'label' => lang('label_name_company'),
					'rules' => 'required',
					'errors' => array(
						'required' => lang('error_required_name'). '<br />'
					)
				),
				array(
					'field' => 'client_email',
					'label' => lang('email'),
					'rules' => 'required|valid_email',
					'errors' => array(
						'required' => lang('error_required_email'). '<br />',
						'valid_email' => lang('email_not_valid'). '<br />'
					)
				)
			);
		}
		
		$this->form_validation->set_rules($config);
		$id = $this->input->post('client_id');
		if ($password)
		{
			if (!$id)
			{
				$message = sprintf( __( 'message_client_password' ), $password );
				$subject = sprintf( __( 'your_password_for_store' ), get_option( 'company' ) );

				if (!_has_option('turn_off_customer_password_email')) {
					send_email( $post_array['client_email'], $message, $subject );
				}
			}

			$hash_password = password_hash($password, PASSWORD_DEFAULT);
			$post_array['client_password'] = $hash_password;
		}
		if (!$id)
		{
			if (!$is_modal)
			{
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->clients->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
						$db_data = array(
							'note_title'		 	=> isset($notes_array['note_title']) ? $notes_array['note_title'] : $post_array['name_company'],
							'note_message' 			=> isset($notes_array['note_message']) ? $notes_array['note_message'] : '',
							'note_referrer_key'     => 'clients',
							'note_referrer_id'      => $this->db->insert_id(),
							'note_referrer_value'   => $this->input->post('name_company'),
							'user_id'				=> user('user_id'),
							'note_created_on'		=> date('Y-m-d')
						);
						$event = array(
							'action' 					=> 'add',
							'referrer' 					=> 'clients',
							'referrer_id' 				=> $this->db->insert_id(),
							'referrer_value' 			=> $this->input->post('name_company'),
							'user_id' 					=> user('user_id'),
							'status' 					=> 'success'
						);
						record_notes($db_data);
						record_event($event);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors());
				}
			}
			else
			{
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->clients->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
						$db_data = array(
							'note_title'		 	=> isset($notes_array['note_title']) ? $notes_array['note_title'] : $post_array['name_company'],
							'note_message' 			=> isset($notes_array['note_message']) ? $notes_array['note_message'] : '',
							'note_referrer_key'     => 'clients',
							'note_referrer_id'      => $this->db->insert_id(),
							'note_referrer_value'   => $this->input->post('name_company'),
							'user_id'				=> user('user_id'),
							'note_created_on'		=> date('Y-m-d')
						);
						$event = array(
							'action' 					=> 'add',
							'referrer' 					=> 'clients',
							'referrer_id' 				=> $this->db->insert_id(),
							'referrer_value' 			=> $this->input->post('name_company'),
							'user_id' 					=> user('user_id'),
							'status' 					=> 'success'
						);
						record_notes($db_data);
						record_event($event);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
				}
			}
			echo json_encode($this->response);
		}
		else
		{
			if ($this->form_validation->run() === TRUE)
			{
				$this->clients->save($post_array, $id);
				$this->response = array('status' => 1);
				$db_data = array(
					'note_title'		 	=> isset($notes_array['note_title']) ? $notes_array['note_title'] : $post_array['name_company'],
					'note_message' 			=> isset($notes_array['note_message']) ? $notes_array['note_message'] : '',
					'note_referrer_key'     => 'clients',
					'note_referrer_id'      => $id,
					'note_referrer_value'   => $this->input->post('name_company'),
					'user_id'				=> user('user_id'),
					'updated_by'			=> user('user_id'),
					'note_created_on'		=> date('Y-m-d')
				);
				$event = array(
					'action' 					=> 'update',
					'referrer' 					=> 'clients',
					'referrer_id' 				=> $id,
					'referrer_value' 			=> $this->input->post('name_company'),
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_notes($db_data, 'note_referrer_id', $id);
				record_event($event);
			}
			else
			{
				$this->response = array('status' => 0, 'error' => validation_errors());
			}
			echo json_encode($this->response);
		}
	}
}