<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * CLIENT CLASS
 * @copyright copyright information
 * @author Eric Claver AKAFFOU
 */
use Mmanager\Domain\Factory\ParserFactory;
use Mmanager\Utils\UserAgent;
use Mmanager\Extensions\Woocommerce\WooCommerce as Woocommerce;
use Mmanager\Extensions\Mrepair\MRepair as MRepair;

class Clients extends Admin_Controller
{
	/**
	 * Class constructor
	 * @return type
	 */
	protected $data;
	public function __construct()
	{
		parent::__construct();

		$this->load->model('clients_model', 'clients');
		$this->view_data['pageJs'] = array(
            'clients.js'
        );
        $this->view_data['externalPluginJs'] = array(
            'https://maps.googleapis.com/maps/api/js?key=AIzaSyCC9-4zhLwMQcrpSgrs_zOkUso0Varmlj0',
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js'
            
        );
        $this->view_data['localPluginJs'] = array(
            'jgooglemap/jquery.googlemap.js'
        );
        $this->data['breadcrumb'] = anchor('clients', __('link_clients'));
        $this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	/**
	 * Index Page
	 * @param type|string $a 
	 * @param type|bool $id 
	 * @return type
	 */
	public function add_client()
	{
		$client_password = generate_password();
		$data = array(
			'breadcrumb' 		=> anchor('clients', __('link_clients')),
			'toolbar'    		=> "",
			'page_title' 		=> __('clients_client'),
			'page_description' 	=> __('link_add_new') . ' '. __('clients_client'),
			'countries' => get_countries(),
			'currencies' => get_currencies(),
			'client_type' => array(
				'1' => __('option_individual'),
				'2' => __('option_professional')
				),
			'client_status' => array(
				'1' => __('active'),
				'0' => __('inactive')
				)
			);
		$this->view_data['content'] = $this->Template->render('clients', 'add_client_form.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		$id = isset($_REQUEST['id']) ? _dID($_REQUEST['id']) : NULL;
		$client_cc = [];
		
		if ($id) {
			$client_cc = json_decode( null !== client($id, 'client_cc' ) ? client($id, 'client_cc' ): json_encode( array() ));
		}
		$client_password = generate_password();
		$notes = get_notes($id);
		if ($notes)
		{
			foreach ($notes as $note) {
				$note_title = $note->note_title;
				$note_message = $note->note_message;
			}
		}
		else
		{
			$note_title = "";
			$note_message = "";
		}
		$data = array(
			'breadcrumb' 		=> anchor('clients', __('link_clients')),
			'toolbar'    		=> "",
			'page_title' 		=> __('clients_client'),
			'page_description' 	=> __('message_manage') . ' '. __('clients_client'),
			'clients'	=> client($id),
			'note_title'     => $note_title,
			'note_message'     => $note_message,
			'client_type' => array(
				'1' => __('option_individual'),
				'2' => __('option_professional')
				),
			'client_status' => array(
				'1' => __('label_active'),
				'0' => __('label_inactive')
				),
			'client_cc' => $client_cc
			);
		$this->view_data['content'] = $this->Template->render('clients', 'edit_client_form.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function index()
	{
		$data = array(
			'breadcrumb' 		=> anchor('clients', __('link_clients')),
			'toolbar'    		=> "",
			'page_title' 		=> __('clients_client'),
			'page_description' 	=> __('message_manage') . ' '. __('clients_client'),
			'filter'  => ''
			);
		if (can_access('customers')) {
			$this->view_data['content'] = $this->Template->render('clients', 'index.phtml', $data, TRUE);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view($a = null, $id = null)
	{
		$this->load->model('clients/clients_model', 'clients');
		$view_data['pageJs'] = array(
            'clients.js',
            'products.js',
            'invoices.js'
        );
        
		if (!isset($_REQUEST['id']))
		{
			die();
		}
		else
		{
			$id = _dID($_REQUEST['id']);
			$data = array(
				'breadcrumb' 		=> anchor('clients', __('link_clients')),
				'toolbar'    		=> "",
				'page_title' 		=> __('clients_client'),
				'page_description' 	=> __('message_view_client'),
				'client_id'       => _eID($id),
				'name_company'	  => client($id, 'name_company'),
				'total_income'    => income_by_client($id),
				'total_due'       => unpaid_invoice_by_client($id),
				'unpaid_invoices_list'	  => client_invoices($id),
				'clients'	=> client($id),
				'client_type' => array(
					'1' => __('option_individual'),
					'2' => __('option_professional')
					),
				'client_status' => array(
					'1' => __('label_active'),
					'0' => __('label_inactive')
					),
				'filter' => ''
				);
			$view_data['content'] = $this->Template->render('clients', 'client_account.phtml', $data, TRUE);
			$this->Template->render('templates', 'layout.phtml', $view_data);
		}
	}
	/**
	 * Get all clients
	 * @return type json
	 */
	public function get_clients()
	{
		echo json_encode(clients());
	}
	public function get_active_clients()
	{
		echo json_encode(select2GetClients());
	}
	public function get_client_credit()
	{
		$client_id = $_REQUEST['client_id'];
		echo json_encode(get_credit($client_id));
	}
	public function get_client_support()
	{
		$client_id = $_REQUEST['client_id'];
		echo json_encode(get_support($client_id));
	}
	/**
	 * Delete a client
	 * @return type json response
	 */
	public function delete_client()
	{

		$protected = [];
		$to_del = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (!has_invoice($i))
				{
					array_push($to_del, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('clients', 'client_id', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function client_account()
	{
		$id = _dID($_REQUEST['id']);
		$data = array(
			'breadcrumb' 		=> anchor('clients', __('link_clients')),
			'toolbar'    		=> "",
			'page_title' 		=> "",
			'page_description' 	=> "",
			'client_id'       => _eID($id),
			'name_company'	  => client($id, 'name_company'),
			'total_income'    => income_by_client($id),
			'total_due'       => unpaid_invoice_by_client($id),
			'unpaid_invoices_list'	  => client_invoices($id),
			'clients'	=> client($id),
			'client_type' => array(
				'1' => __('option_individual'),
				'2' => __('option_professional')
				),
			'client_status' => array(
				'1' => __('label_active'),
				'0' => __('label_inactive')
				),
			'filter' => ''
			);
		$this->view_data['content'] = $this->Template->render('clients', 'client_account.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function get_client_invoices()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$id = _dID($_REQUEST['id']);
		$invoices = client_invoices($id, $filter);
		if ($invoices)
		{
			foreach ($invoices as $invoice) {
				if ($invoice->amount_paid > $invoice->amount_refunded AND $invoice->invoice_status == 'Refunded')
				{
					$status = __('label_partially_refunded', $id);
				}
				elseif ($invoice->amount_paid > 0 AND $invoice->invoice_status !== 'Paid')
				{
					$status = __('label_partially_paid');
				}
				elseif( $invoice->invoice_status == 'Expired' || $invoice->invoice_status == 'Open' || $invoice->invoice_status == 'Pending' || $invoice->invoice_status == 'Failed')
				{
					$status = __('unpaid');
				}
				else
				{
					$status = __(strtolower($invoice->invoice_status), $id);
				}
				array_push($list, array(
					'id' 			  	  => $invoice->id,
					'invoice_number'      => $invoice->invoice_number,
					'enc_invoice_number'  => _eID($invoice->invoice_number),
					'date'   	 		  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $invoice->date),
					'due_date' 		  	  => _fdate(language_string_to_locale_notation( get_option('user_language', 'users_options') ), $invoice->due_date),
					'total' 		  	  => format_number($invoice->total),
					'amount_paid' 		  => $invoice->amount_paid,
					'amount_refunded' 	  => $invoice->amount_refunded,
					'status'              => $status,
					'stbool'			  => invoice_status($invoice->invoice_number)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function income_by_client()
	{
		$id = _dID($_REQUEST['id']);
		$range = $_REQUEST['range'];
		$income = income_by_client($id, $range);
		$unpaid = unpaid_invoice_by_client($id, $range);
		echo json_encode(array($income, $unpaid));
	}
	public function products_services()
	{
		$list = [];
		$id = _dID($_REQUEST['id']);

		$products_services = client_products_services($id);
		if ($products_services)
		{
			foreach ($products_services as $products_service) {
				if ($products_service->value > 0) {
					array_push($list, array(
						'name' 		  		  => $products_service->name,
						'value' 	          => $products_service->value,
						'price' 	          => format_number($products_service->price)
						)
					);
				}
			}
		}
		echo json_encode($list);
	}
	public function get_clients_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['status']) ? $_REQUEST['status'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'ASC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'name_company';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : '';

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$clients = $this->clients->findAll(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);
		if ($clients)
		{
			foreach ($clients as $client) {
				$client = (object)$client;
				if (isset($client->client_address1) && $client->client_postcode && $client->client_city && $client->client_country)
				{
					$address = $client->client_address1 . ' ' . $client->client_postcode . ' ' . $client->client_city . ' ' . get_countries($client->client_country);
				}
				else
				{
					$address = false;
				}
				array_push($rows, array(
					'client_id' 		  => $client->client_id,
					'enc_client_id' 	  => _eID($client->client_id),
					'name_company'        => $client->name_company,
					'client_email'   	  => $client->client_email,
					'client_phone' 		  => $client->client_phone,
					'client_address' 	  => $address,
					'client_status'       => $client->client_status,
					'support_contract'    => $client->support_contract * 60,
					'client_credit'       => floatval($client->client_credit),
					'client_tax_number'	  => isset($client->client_tax_number) ? $client->client_tax_number : "",
					'client_bank_number'  => isset($client->client_bank_number) ? $client->client_bank_number : "",
					'client_status_str'   => status_str($client->client_status),
					'client_date_created' => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $client->client_date_created)
					)
				);
			}

			if ( $search) {
				$list = array(
					'total' => count($clients),
					'totalNotFiltered' => count($clients),
					'rows' => $rows
				);
			} else {
				$total = $this->clients->count_rows('clients', $filter);
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows

				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function get_clients_address()
	{
		$address = [];
		$results = get_clients_address();
		if ($results)
		{
			foreach ($results as $k => $v) {
				if (isset($v->client_address1) && $v->client_postcode && $v->client_city && $v->client_country)
				{
					$address[] = array(
						'address' => $v->client_address1 . ' ' . $v->client_postcode . ' ' . $v->client_city . ' ' . $v->client_country
						);
				}
			}
		}
		echo json_encode($address);
	}
	public function activate_client()
	{
		$ids = _dID($_REQUEST['id']);
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				activate('clients', 'client_status', 'client_id', $i);	
			}
		}
		echo json_encode(array('success' => 1));
	}
	public function desactivate_client()
	{
		$ids = _dID($_REQUEST['id']);
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				desactivate('clients', 'client_status', 'client_id', $i);
			}
		}
		echo json_encode(array('success' => 1));
	}
	public function clients_autocomplete() {
		$clients = [];
		$results = clients();
		if ($results)
		{
			foreach ($results as $k => $v) {
				$clients[] = $v->name_company;
			}
		}
		echo json_encode($clients);
	}
	public function substract_from_support() {
		$duration = $_REQUEST['duration'];
		$client_id = $_REQUEST['client_id'];

		$ticket_id = $_REQUEST['ticket_id'];

		update_client_support_contract($client_id, $duration, '-');
		set_support_extra_time($ticket_id, $duration, '-');
	}
	public function get_client_duedate() {
		$id = $_REQUEST['client_id'];
		if ($id) {
			echo json_encode(null != client($id, 'client_term_payment') ? client($id, 'client_term_payment') : get_option('default_duedate'));
		} else {
			echo json_encode(get_option('default_duedate'));
		}
	}
	public function test() {
		var_dump(get_countries(-1));
	}
} 