<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpRbac\Rbac;
/**
 * Clients_model
 * @since 1.0.6
 */
class Clients_model extends MY_Model {
	/**
	 * Class constructor
	 * @return type void
	 */
	public function __construct()
	{
		parent::__construct();
		$this->_table = 'clients';
		$this->_primaryKey = 'client_id';
	}
	/**
	 * delete
	 * @param type $id 
	 * @return type mixed
	 */
	public function delete($id)
	{
		$this->_tables = ['invoices', 'quotes'];
		$this->set_table('clients');
		$this->_select = 'client_id';
		$this->_primary_key = 'client_id';

		if (!$this->before_delete($id))
		{
			return parent::delete($id);
		}
		return false;
	}
	/*
	|--------------------------------------------------------------------------
	| Clients - Model 
	|--------------------------------------------------------------------------
	|
	| A complete rewrite of the client model
	|
	*/

	/**
	 * Get a client object
	 * @param type $id 
	 * @param type|array $cols 
	 * @return type
	 */
	public function find($id = null, $cols = []) {
		$db = MysqliDb::getInstance();
		is_array($cols) OR $cols = (array)$cols;

		if ($id){
			$db->where("c.client_id", intval($id));
			return $db->ObjectBuilder()->get('oc_clients c', 1, $cols);
		} else {
			return $db->ObjectBuilder()->get('oc_clients c', null, $cols);
		}
	}

	/**
	 * Get all clients
	 * @param type|array $params 
	 * @return type
	 */
	public function findAll($params = [])
	{
		$db = MysqliDb::getInstance();
		is_array($params) OR $params = (array)$params;
		$status = isset($params['status']) ? $params['status']: false;
		$search = isset($params['search']) ? $params['search']: false;
		$sort   = isset($params['sort']) ? $params['sort']: 'name_company';
		$order  = isset($params['order']) ? $params['order']: 'ASC';
		$pagination = isset($params['pagination']) ? $params['pagination']: false;
		$offset = isset($params['offset']) ? $params['offset'] : 0;
		$limit = isset($params['limit']) ? $params['limit']: get_option('default_table_size');

	    $rbac = new Rbac;
	    if ($rbac->check('customer_owner', USERID) and !$rbac->check('customer_access_any', USERID)) {
	        $db->where('user_id', USERID);
	    }
	    // Columns to collect
	    $cols = array(
	        "c.*"
	    );
	    // Set order
	    $db->orderBy($sort, $order);

	    if ($status && $status != 'All') {
	    	switch ($status) {
	    		case 'inactive':
	    			$status = 0;
	    			break;
	    		case 'active':
	    			$status = 1;
	    			break;
	    		default:
	    			$status = 1;
	    			break;
	    	}
	        $db->where('c.client_status = ? ', array(boolval($status)));
	    } 
	    if ($search) {

	        $db->where('c.client_id', '%' . $search . '%', 'LIKE');
	        $db->orWhere('c.name_company', '%' . $search . '%', 'LIKE');
	        $db->orWhere('c.client_email', '%' . $search . '%', 'LIKE');
	        $db->orWhere('c.client_phone', '%' . $search . '%', 'LIKE');
	    }
	    if (!$pagination) {
	    	return $db->ObjectBuilder()->get('oc_clients c', null, $cols);
	    } else {
	    	return $db->ObjectBuilder()->get('oc_clients c', array($offset, $limit), $cols);
	    }
	}
}