<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
use Mmanager\Domain\Factory\InvoiceFactory; 

class Creditnote extends Admin_Controller {
	/**
	 * @var type
	 */
	protected $_invoice = [];

	/**
	 * @var type
	 */
	protected $_client = [];

	/**
	 * Description
	 * @return type
	 */
	public function __construct(){
		parent::__construct();
		$this->load->model('clients/clients_model', 'clients');
		$this->clients->set_primary_key('client_id');
		$this->load->model('invoices/invoices_model', 'invoices');

		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js',
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
        $this->view_data['modal'] = $this->Template->render('clients', 'add_client_modal.phtml', '', true);
        $this->data['breadcrumb'] = anchor('creditnote', __('link_credit_note'));
        $this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	
	/**
	 * Description
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type
	 */
	public function index()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('creditnote', __('link_credit_note')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_credit_note'),
			'page_description' 	=> __('message_manage') .' '.__('link_credit_note'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'filter'			=> 'Refunded'
			);
		$this->view_data['page_header'] = $this->Template->render('creditnote', 'page_header.phtml', '', true);
		if (can_access('invoices')) {
			$this->view_data['content'] = $this->Template->render('creditnote', 'index.phtml', $view_data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		$id = _dID($_REQUEST['id']);
		$view_data = array(
			'breadcrumb' 		=> anchor('creditnote', __('link_credit_note')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_credit_note'),
			'page_description' 	=> __('message_manage') .' '.__('link_credit_note'),
			'user_language' => get_option('user_language', 'users_options'),
			'invoices' => get_invoice_by_number($id),
			'invoice_items' => get_invoiced_items($id),
			'clients' => json_encode(clients()),
			'payment_fees'  => null !== get_invoice_charges($id) ? get_invoice_charges($id) : floatval(0),
			'charges_sku'  => null !== get_charges_sku($id) ? get_charges_sku($id) : generate_sku(),
			'invoiceObj' => new InvoiceFactory,
			'invoice_status' => array(
				'Draft' => ucfirst(__('option_draft')),
				'Unpaid' => ucfirst(__('option_unpaid')),
				'Paid' => ucfirst(__('option_paid')),
				'Open' => ucfirst(__('label_opened')),
				'Paidout' => ucfirst(__('label_paidout')),
				'Failed' => ucfirst(__('is_failed')),
				'Expired' => ucfirst(__('label_expired')),
				'Refunded' => ucfirst(__('label_refunded')),
				'Pending' => ucfirst(__('label_pending')),
				'Charged_back' => ucfirst(__('label_charged_back')),
				'Overdue' => ucfirst(__('option_overdue')),
				'Cancelled' => ucfirst(__('option_cancelled'))
				),
			'pay_type' => array(
				'1' => __('option_once'),
				'2' => __('option_weekly'),
				'3' => __('option_biweekly'),
				'4' => __('option_monthly'),
				'5' => __('option_yearly'),
				'6' => __('option_quarterly'),
				'7' => __('option_half_yearly')
				),
			'payment_history' => get_payment_history($id)
			);
		$this->view_data['content'] = $this->Template->render('creditnote', 'edit_invoice_form.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function create_credit_note()
	{
		$protected = [];
		$to_mark_refund = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (invoice_status($i) == 'is_paid' || invoice_status($i) == 'is_refunded')
				{
					array_push($to_mark_refund, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_refund);
			$response['fail'] = count($protected);

			if(!empty($to_mark_refund))
			{
				mass_refund('invoices', 'invoice_number', $to_mark_refund);
			}
		}
		echo json_encode($response);
	}
}