<?php
defined('BASEPATH') or exit('No direct script access allowed');
/**
 * AJAX Class to handle language preferences
 */
class Ajax extends Ajax_Controller
{
	public function __construct()
	{
		parent::__construct();		
	}

	/**
	 * Dynamically change the App language for each user.
	 * @return json
	 */
	public function set_user_language()
	{
		$db_data = array(
			'user_id'      => user('user_id'),
			'option_key'   => "user_language",
			'option_value' => strtolower( $_REQUEST['option_value'] )
		);
		$lang = $_REQUEST['option_value'];
		switch ($lang) {
			case 'french':
				$system_lang = 'fr-FR';
				break;
			case 'dutch':
				$system_lang = 'nl-NL';
				break;
			case 'english':
				$system_lang = 'en-US';
				break;
			case 'swedish':
				$system_lang = 'sv-SE';
				break;
			case 'english-gb':
				$system_lang = 'en-GB';
				break;
			case 'italian':
				$system_lang = 'it-IT';
				break;
			case 'russian':
				$system_lang = 'ru-RU';
				break;
			case 'spanish':
				$system_lang = 'es-ES';
				break;
			case 'german':
				$system_lang = 'de-DE';
				break;
			case 'arabic':
				$system_lang = 'ar-AR';
				break;
			case 'greek':
				$system_lang = 'el-EL';
				break;
			case 'romanian':
				$system_lang = 'ro';
				break;
			default:
				$system_lang = 'en-US';
				break;
		}
		$db_data2 = array(
			'option_name'   => "default_language",
			'option_value' => $system_lang
		);
		set_option($db_data2);
		$response = ($this->m_manager->updateOption($db_data) != 0) ? 1 : 0;
		echo json_encode($response); 
	}
	public function set_client_language()
	{
		$client_id = _dID($_REQUEST['client_id']);
		$lang = $_REQUEST['option_value'];
		switch ($lang) {
			case 'french':
				$system_lang = 'fr_FR';
				break;
			case 'dutch':
				$system_lang = 'nl_NL';
				break;
			case 'english':
				$system_lang = 'en_US';
				break;
			case 'english-gb':
				$system_lang = 'en_GB';
				break;
			case 'italian':
				$system_lang = 'it_IT';
				break;
			case 'russian':
				$system_lang = 'ru_RU';
				break;
			case 'spanish':
				$system_lang = 'es_ES';
				break;
			case 'german':
				$system_lang = 'de_DE';
				break;
			case 'arabic':
				$system_lang = 'ar_AR';
				break;
			case 'greek':
				$system_lang = 'el_EL';
				break;
			case 'romanian':
				$system_lang = 'ro';
				break;
			default:
				$system_lang = 'en_US';
				break;
		}
		$db_data = array(
			'client_id'      => $client_id,
			'client_language'   => $system_lang
		);
		$this->load->model('clients/clients_model', 'clients');
		$this->clients->set_primary_key('client_id');
		$response = ($this->clients->save($db_data, $client_id) != 0) ? 1 : 0;
		echo json_encode($response); 
	}
	public function set_provider_language()
	{
		$provider_id = _dID($_REQUEST['provider_id']);
		$lang = $_REQUEST['option_value'];
		switch ($lang) {
			case 'french':
				$system_lang = 'fr_FR';
				break;
			case 'dutch':
				$system_lang = 'nl_NL';
				break;
			case 'english':
				$system_lang = 'en_US';
				break;
			case 'english-gb':
				$system_lang = 'en_GB';
				break;
			case 'italian':
				$system_lang = 'it_IT';
				break;
			case 'russian':
				$system_lang = 'ru_RU';
				break;
			case 'spanish':
				$system_lang = 'es_ES';
				break;
			case 'german':
				$system_lang = 'de_DE';
				break;
			case 'arabic':
				$system_lang = 'ar_AR';
				break;
			case 'greek':
				$system_lang = 'el_EL';
				break;
			case 'romanian':
				$system_lang = 'ro';
				break;
			default:
				$system_lang = 'en_US';
				break;
		}
		$db_data = array(
			'provider_id'      => $provider_id,
			'provider_language'   => $system_lang
		);
		$this->load->model('providers/providers_model', 'providers');
		$this->providers->set_primary_key('provider_id');
		$response = ($this->providers->save($db_data, $provider_id) != 0) ? 1 : 0;
		echo json_encode($response);
	}
	public function save_message() {
		$db_array = array(
			'message' =>  $_REQUEST['message'],
			'message_to' => $_REQUEST['userid'],
			'message_from' => user('user_id'),
			'user_id'	=> user('user_id'),
			'is_read'		=> '0'
		);
		$this->session->set_userdata('message_to', $_REQUEST['userid']);
		save_message($db_array);
		echo json_encode(1);
	}
	public function backup_DB_now() {
		mysql_backup_db();
		echo json_encode(1);
	}
	public function run_system_cron() {
		$this->load->library('../controllers/cron');
		$this->cron->index();
		echo json_encode(1);
	}
	public function run_annual_cron() {
		$this->load->library('../controllers/cron');
		$this->cron->reset_annual_number();
		echo json_encode(1);
	}
}