<?php
defined('BASEPATH') or exit('No direct script access allowed');
use PhpRbac\Rbac;
/**
 * 
 */
class Dashboard extends Admin_Controller {

    /**
     * Class constructor
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Description
     * @return type
     */
    public function index()
    {
        $this->view_data['pluginsJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/echarts/4.0.4/echarts.min.js'
        );
        $this->view_data['pageJs'] = array(
            'dashboard.js',
            'mcharts.js',
            'timeline.js'
        );

        $rbac = new Rbac;
        if ( $rbac->check('homepage_access_any', USERID) OR $rbac->check('homepage_owner', USERID)) {
            $date = date('Y-m-d');
            $start = isset($_REQUEST['start']) ? $_REQUEST['start']: date('Y-m-d', strtotime($date .' -8 day'));
            $end = isset($_REQUEST['end']) ? $_REQUEST['end']: date('Y-m-d', strtotime($date .' +1 day'));

            $data = array(
                'breadcrumb'        => anchor('dashboard', __('link_dashboard')),
                'toolbar'           => "",
                'page_title'        => __('label_admin_dashboard'),
                'page_description'  => __('message_admin_dashboard'),
                'month_progression'             => financial_accounting('last_month', 'incomes'),
                'unpaid_invoice_amount'         => get_invoices_amount('Unpaid'),
                'annual_income'                 => financial_accounting('this_year', 'incomes'),
                'income_month'                  => financial_accounting('this_month', 'incomes'),
                'overdue_invoice_amount'        => get_invoices_amount('Overdue'),
                'unpaid_invoices_number'        => count_invoices('Unpaid'),
                'overdue_invoices_number'       => count_invoices('Overdue'),
                'annual_progression'            => annual_incomes_progression(),
                'month_progression'             => incomes_progession('last_month'),
                'timeline'                      => get_events($start, $end)    
                );
        } else {
            $data = array(
                'page_breadcrumb' => 'Support Tickets'
                );
            $url = base_url('index.php/users/auth/edit_user/') .USERID;
            redirect($url);
        }
        
		$this->view_data['content'] = $this->Template->render('dashboard', 'index.phtml', $data, TRUE);
		// Load the template from the views directory
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
    }
    public function get_due_date()
    {
        $duedate = [];
        $results = get_due_date();
        if ($results)
        {
            foreach ($results as $result) {
                $duedate[] = _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $result->dueDate);
            }
        }
        return $duedate;
    }
    public function incomeByCategory($interval=null)
    {
        if (isset($_REQUEST['interval']))
        {
            $interval = $_REQUEST['interval'];
            echo json_encode($this->m_manager->incomeByCategory($interval));
        }
        else 
        {
            echo json_encode($this->m_manager->incomeByCategory(3));
        }
    }
    public function chartSales($interval=null)
    {
        if (isset($_REQUEST['interval']))
        {
            $interval = $_REQUEST['interval'];
            echo json_encode($this->m_manager->chartSales($interval));
        }
        else 
        {
            echo json_encode($this->m_manager->chartSales('this_month'));
        }
    }
    public function invoicedItemsSum($interval=null, $start_date = false, $end_date = false)
    {
        $this->load->model('reports/reports_model', 'reports');

        $items = [];
        $isservice = isset($_REQUEST['isservice']) ? $_REQUEST['isservice']: 0;
        $interval = isset($_REQUEST['interval']) ? $_REQUEST['interval']: false;

        if (isset($_REQUEST['start']))
        {
            $start = $_REQUEST['start'];
            $end = $_REQUEST['end'];
            $user_language = get_option('default_language');
            $start_date = mysqlDate($user_language, $start);
            $end_date = mysqlDate($user_language, $end);
        }
    	$results = $this->reports->invoicedItemsSum($interval, $start_date, $end_date);
        if ($results)
        {
            if ($isservice == 1) {
                foreach ($results as $v) {
                    if ($v->value > 0 && 1 == is_service(sku_to_name($v->sku))) { // Remove refunded items
                        array_push($items, array(
                            'name' => sku_to_name($v->sku),
                            'value' => $v->value
                            )
                        );
                    }
                }
            } else {
                foreach ($results as $v) {
                    if ($v->value > 0 && 0 == is_service(sku_to_name($v->sku))) { // Remove refunded items
                        array_push($items, array(
                            'name' => sku_to_name($v->sku),
                            'value' => $v->value
                            )
                        );
                    }
                }
            }
        }
    	echo json_encode($items);
    }
    public function invoicedItemsCount($interval=null)
    {
        $this->load->model('reports/reports_model', 'reports');
        $items = [];
        $isservice = isset($_REQUEST['isservice']) ? $_REQUEST['isservice']: 0;
        $interval = isset($_REQUEST['interval']) ? $_REQUEST['interval']: false;
    	$results = $this->reports->invoicedItemsCount($interval);
	    if ($results)
        {
            if ($isservice == 1) {
                foreach ($results as $v) {
                    if ($v->value > 0 && 1 == is_service(sku_to_name($v->sku))) { // Remove refunded items
                        array_push($items, array(
                            'name' => sku_to_name($v->sku),
                            'value' => $v->value
                            )
                        );
                    }
                }
            } else {
                foreach ($results as $v) {
                    if ($v->value > 0 && 0 == is_service(sku_to_name($v->sku))) { // Remove refunded items
                        array_push($items, array(
                            'name' => sku_to_name($v->sku),
                            'value' => $v->value
                            )
                        );
                    }
                }
            }
        }
        echo json_encode($items);
    }
    public function dashboard_low_stock_alert() {
        echo json_encode(array('status' => dashboard_alert_low_stock()));
    }
    public function dashboard_invalid_license_alert() {
        echo json_encode(array('status' => \Mmanager\Mmanager::isValidLicense()));
    }
    public function dashboard_unpaid_commission_warning() {
        echo json_encode(array('status' => dashboard_warning_unpaid_commission()));
    }
}