<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller
{
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('incomes_model', 'incomes');
	}
	
	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function add_incomes($id = NULL)
	{
		$config['upload_path']          = './uploads/incomes/attachments';
		$config['allowed_types']        = '*';
		$config['overwrite']        	= TRUE;


		$this->load->library('upload', $config);
		$this->upload->do_upload('incomes_attachment');
		$data = $this->upload->data();

		$post_array = array(
			'incomes_name'			    	=> null != $this->input->post('incomes_name') ? $this->input->post('incomes_name') : __('incomes_sales_services_goods'),
			'incomes_sku'					=> null != $this->input->post('incomes_sku') ? $this->input->post('incomes_sku') : generate_sku(),
			'incomes_category'				=> $this->input->post('incomes_category'),
			'incomes_value'					=> $this->input->post('incomes_value'),
			'incomes_notes'					=> $this->input->post('incomes_notes'),
			'turnover_included'				=> $this->input->post('turnover_included'),
			'created_on'					=> mysqlDate(get_option('user_language', 'users_options'), $this->input->post('created_on')),
			'payment_method'				=> $this->input->post('payment_method'),
			'attachment'					=> $data['file_name'],
			'incomes_value_without_tax'		=> $this->input->post('incomes_value_without_tax'),
			'charges_name' 					=> __('label_payment_fees'),
			'charges_category' 				=> 7,
			'charges_tax_rate'				=> get_tax($this->input->post('charges_tax_rate'), 'tax_percent'),
			'charges_value'	    			=> $this->input->post('charges_value'),
			'charges_sku'					=> generate_sku()
			);
		$config = array(
			array(
                    'field' => 'incomes_name',
                    'label' => __('label_item'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => lang('error_required_name')
                            )
                ),
			array(
                    'field' => 'incomes_category',
                    'label' => __('label_group_name'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => lang('error_required_group')
                            )
                ),
			array(
                    'field' => 'incomes_value',
                    'label' => __('label_amount'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => lang('error_required_amount')
                            )
                ),
			array(
                    'field' => 'created_on',
                    'label' => __('date_created_on'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => lang('error_required_date')
                            )
                )
			);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('transaction_id');
		$is_modal = $this->input->post('is_modal');

		if ($id === NULL)
		{
			if (!$is_modal)
			{
				$this->incomes->set_table('transactions');
				$this->response = ($this->form_validation->run() === TRUE && $this->incomes->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors());
			}
			else
			{
				$this->incomes->set_table('transactions');
				$this->response = ($this->form_validation->run() === TRUE && $this->incomes->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			}
			echo json_encode($this->response);
		}
		else
		{
			$this->incomes->set_table('transactions');
			$this->incomes->set_primary_key('transaction_id');
			$this->response = ($this->form_validation->run() == TRUE && $this->incomes->save($post_array, $id) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			echo json_encode($this->response);
		}
	}
	public function create_group($id = NULL)
	{
		$post_array = array(
			'group_name'					=> $this->input->post('group_name'),
			'group_description'				=> $this->input->post('description')
			);
		$config = array(
			array(
                    'field' => 'group_name',
                    'label' => __('label_group_name'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => __('error_required_group').'<br />'
                            )
                )
			);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('group_id');
		$is_modal = $this->input->post('is_modal');

		if ($id === NULL)
		{
			if (!$is_modal)
			{
				$this->incomes->set_table('incomes_categories');
				$this->response = ($this->form_validation->run() === TRUE && $this->incomes->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors());
			}
			else
			{
				$this->incomes->set_table('incomes_categories');
				$this->response = ($this->form_validation->run() === TRUE && $this->incomes->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			}
			echo json_encode($this->response);
		}
		else
		{
			$this->incomes->set_table('incomes_categories');
			$this->items->set_primary_key('group_id');
			$this->response = ($this->form_validation->run() == TRUE && $this->items->save($post_array, $id) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			echo json_encode($this->response);
		}
	}
}