<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Incomes extends Admin_Controller {
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('incomes_model', 'incomes');
		$this->load->library('m_manager');
		$this->view_data['pageJs'] = array(
            'products.js',
            'taxes.js'
        );
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js'
        );
        $this->view_data['localPluginJs'] = array('bootstrap-fileinput/bootstrap-fileinput.js');
		$this->view_data['modal'] = $this->Template->render('incomes', 'add_incomes_modal.phtml', array('categories' => $this->get_groups('array')), true);
		$this->data['breadcrumb'] = anchor('incomes', __('link_incomes'));
		$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	public function edit()
	{
		$id = isset($_REQUEST['id']) ?  $_REQUEST['id'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('incomes', __('link_incomes')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_incomes'),
			'page_description' 	=> __('message_manage') .' '.__('incomes_income'),
			'incomes'         => get_charges($id),
			'categories'      => $this->get_groups('array')
			);
		$this->view_data['content'] = $this->Template->render('incomes', 'edit_incomes_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function incomes_details()
	{
		$cat = isset($_REQUEST['cat']) ?  $_REQUEST['cat'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('incomes', __('link_incomes')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_incomes'),
			'page_description' 	=> __('message_manage') .' '.__('incomes_income'),
			'category'          => $cat
			);
		$this->view_data['content'] = $this->Template->render('incomes', 'incomes_details.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function index()
	{
		if (can_access('incomes_charges')) {
			array_push($this->view_data['pageJs'], 'incomescharts.js');
			$this->view_data['pluginsJs'] = array(
	            'https://cdnjs.cloudflare.com/ajax/libs/echarts/3.5.0/echarts.min.js'
	        );
			$data = array(
				'breadcrumb' 		=> anchor('incomes', __('link_incomes')),
				'toolbar'    		=> "",
				'page_title' 		=> __('link_incomes'),
				'page_description' 	=> __('message_manage') .' '.__('incomes_income'),
				'filter' => 'all'
				);
			$this->view_data['content'] = $this->Template->render('incomes', 'index.phtml', $data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function get_incomes_list()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$incomes = get_incomes_list($filter);
		if ($incomes)
		{
			foreach ($incomes as $income) {
				array_push($list, array(
					'incomes_category'    	  => get_incomes_category($income->incomes_category),
					'incomes_key'    	      => $income->incomes_category,
					'incomes_value'           => floatval($income->incomes_value)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function get_incomes_details()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['category']) ? $_REQUEST['category'] : 'all';
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'transaction_id';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : '';

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$incomes = $this->incomes->findAll(
			array(
				'filter' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);
		if ($incomes)
		{
			foreach ($incomes as $income) {
				array_push($rows, array(	
					'transaction_id'      		=> $income->transaction_id,
					'incomes_name'    		    => $income->incomes_name,
					'incomes_sku'    		    => $income->incomes_sku,
					'incomes_category'    		 => __($income->group_name),
					'incomes_category_ID'    	=> $income->incomes_category,
					'created_on'         		 => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $income->created_on),
					'incomes_value'   	 		 => floatval($income->incomes_value),
					'invoice_number'   	 		 => $income->invoice_number,
					'encrypt_invoice_number'   	  => _eID($income->invoice_number),
					'attachment'				  => $income->attachment,
					'payment_method'			  => strtoupper($income->payment_method)
					)
				);
			}
			if ( $search) {
				$list = array(
					'total' => count($incomes),
					'totalNotFiltered' => count($incomes),
					'rows' => $rows
				);
			} else {
				$total = $this->incomes->count_rows('transactions', $filter, 'incomes');
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows
				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function get_groups($type=null)
	{
		$groups = [];
		$results = get_incomes_categories();
		if($results)
		{
			foreach ($results as $group) {
				array_push($groups, array(
					'group_id' 			=> $group->group_id,
					'group_name' 		=> get_incomes_category($group->group_id),
					'group_description' => $group->group_description
					)
				);
			}
		}
		if(!$type)
		{
			echo json_encode($groups);
		}
		else if($type == 'array')
		{
			return $groups;
		}
	}
	/**
	 * Incomes per category for incomes charts
	 */
	public function get_incomes_per_category()
	{
		$incomes = [];
		$results = get_incomes_list();
		if ($results)
		{
			foreach ($results as $v) {
				array_push($incomes, array(
				    'name' => get_incomes_category($v->incomes_category),
				    'value' => $v->incomes_value
				    )
				);
			}
		}
		echo json_encode($incomes);
	}
}