<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Incomes_model extends MY_Model{

	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
	}
	public function incomeByCategory($interval=null)
	{
		$range = isset($_REQUEST['interval']) ? $_REQUEST['interval'] : 3;
		switch ($interval) {
			case 'this_month':
				$range = 1;
				break;
			case 'latest_three_months':
				$range = 3;
				break;
			case 'this_year':
				$query = "SELECT item_group AS iTemGroup,
					SUM(item_subtotal) AS TotalSales
					FROM {$this->tables['invoices_items']}
					WHERE YEAR(date_paid) = YEAR(CURDATE())
					GROUP BY item_group
					ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			case 'last_month':
				$query = "SELECT item_group AS iTemGroup,
					SUM(item_subtotal) AS TotalSales
					FROM {$this->tables['invoices_items']}
					WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
					GROUP BY item_group
					ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			case 'last_year':
				$query = "SELECT item_group AS iTemGroup,
				SUM(item_subtotal) AS TotalSales
				FROM {$this->tables['invoices_items']}
				WHERE YEAR(date_paid) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR))
				GROUP BY item_group
				ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			case 'all_dates':
				$query = "SELECT item_group AS iTemGroup,
				SUM(item_subtotal) AS TotalSales
				FROM {$this->tables['invoices_items']}
				WHERE YEAR(date_paid) IS NOT NULL
				GROUP BY item_group
				ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			default:
				$range = 3;
				break;
		}
		$query = "SELECT item_group AS iTemGroup,
			SUM(item_subtotal) AS TotalSales
			FROM {$this->tables['invoices_items']}
			WHERE date_paid >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL {$range} MONTH
			GROUP BY item_group
			ORDER BY item_group ASC";
		return $this->oneric->get_results($query);
	}
	public function chartSales($interval)
	{
		switch ($interval) {
			case 'last_month':
				$query = "SELECT item_name AS name,   
				SUM(item_subtotal) AS value,
				SUM(item_quantity) AS count
				FROM {$this->tables['invoices_items']}
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )  
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			case 'this_month':
				$query = "SELECT item_name AS name,   
				SUM(item_subtotal) AS value,
				SUM(item_quantity) AS count
				FROM {$this->tables['invoices_items']}
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			
			default:
				$query = "SELECT item_name AS name,   
				SUM(item_subtotal) AS value,
				SUM(item_quantity) AS count
				FROM {$this->tables['invoices_items']}
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
		}
	}
	public function invoicedItemsSum($interval)
	{
		switch ($interval) {
			case 'last_month':
				$query = "SELECT item_name AS name,   
				SUM(item_subtotal) AS value
				FROM {$this->tables['invoices_items']}
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )  
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			case 'this_month':
				$query = "SELECT item_name AS name,   
				SUM(item_subtotal) AS value
				FROM {$this->tables['invoices_items']}
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			
			default:
				$query = "SELECT item_name AS name,   
				SUM(item_subtotal) AS value,
				FROM {$this->tables['invoices_items']}
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
		}
	}
	public function invoicedItemsCount($interval)
	{
		switch ($interval) {
			case 'last_month':
				$query = "SELECT item_name AS name,
				SUM(item_quantity) AS value
				FROM {$this->tables['invoices_items']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH )
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			case 'this_month':
				$query = "SELECT item_name AS name,
				SUM(item_quantity) AS value
				FROM {$this->tables['invoices_items']}
				WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) 
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			default:
				$query = "SELECT item_name AS name,
				SUM(item_quantity) AS value
				FROM {$this->tables['invoices_items']}   
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
		}
	}
	public function findAll($params = [])
	{
		$db = MysqliDb::getInstance();
		is_array($params) OR $params = (array)$params;
		$filter = isset($params['filter']) ? $params['filter']: 'All';
		$search = isset($params['search']) ? $params['search']: false;
		$sort   = isset($params['sort']) ? $params['sort']: 'transaction_id';
		$order  = isset($params['order']) ? $params['order']: 'DESC';
		$pagination = isset($params['pagination']) ? $params['pagination']: false;
		$offset = isset($params['offset']) ? $params['offset'] : 0;
		$limit = isset($params['limit']) ? $params['limit']: get_option('default_table_size');

		$db->join("oc_incomes_categories ic", "t.incomes_category=ic.group_id", "LEFT");
	    // Columns to collect
	    $cols = array(
	        "t.*",
	        "ic.group_name",
	    );
	    // Set order
	    $db->orderBy($sort, $order);

	    if ($filter && $filter != 'All') {
	        $db->where('t.incomes_category = ? ', array($filter));
	    } 
	    if ($search) {

	        $db->where('t.transaction_id', '%' . $search . '%', 'LIKE');
	        $db->orWhere('t.incomes_sku', '%' . $search . '%', 'LIKE');
	        $db->orWhere('t.incomes_value', '%' . $search . '%', 'LIKE');
	        $db->orWhere('t.invoice_number', '%' . $search . '%', 'LIKE');
	    }
	    if (!$pagination) {
	    	return $db->ObjectBuilder()->get('oc_transactions t', null, $cols);
	    } else {
	    	return $db->ObjectBuilder()->get('oc_transactions t', array($offset, $limit), $cols);
	    }
	}
}