<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Invoice Ajax Class
 * Create and Update Invoice
 * Also used to make refunds.
 */
class Ajax extends Ajax_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('invoices/invoices_model', 'invoices');
	}
	/**
	 * Refund Payment
	 * @return type json
	 */
	public function refund_payment()
	{
		$invoice_number = $_REQUEST['invoice_number'];
		$amount = $_REQUEST['amount'];

		if ($invoice_number && $amount > 0)
		{
			$this->load->library('m_manager');
			$this->m_manager->mark_refunded($invoice_number, $amount);
			$event = array(
				'action' 					=> 'refunded',
				'referrer' 					=> 'invoices',
				'referrer_id' 				=> $invoice_number,
				'referrer_value' 			=> $invoice_number,
				'user_id' 					=> user('user_id'),
				'status' 					=> 'success'
			);
			record_event($event);
			echo json_encode(array('success' => 1));
		}
		else
		{
			echo json_encode(array('fail' => 1));
		}
	}
	/**
	 * Create and Update Invoice 
	 * @return type mixed
	 */
	public function create_invoice()
	{
		// Assign the Mmanager Object
		$m = $this->m;
		$attachments = [];
		$context = [];
		
		$user_language 			= get_option('user_language', 'users_options');
		$default_duedate 		= get_option('default_duedate');

		$invoice_number 		= $this->input->post('invoice_number'); // Invoice number fetchs the hidden invoice number (auto increment), not formatted (with prefix)
		$invoice_key 			= $this->input->post('invoice_number'); // Invoice number fetchs the hidden invoice number (auto increment), not formatted (with prefix)
		$annual_number_key 		= $this->input->post('annual_number_key'); // Invoice number fetchs the hidden invoice number (auto increment), not formatted (with prefix)
		$is_credit_note 		= $this->input->post('is_credit_note');
		$initial_invoice_number = $this->input->post('initial_invoice_number');
		$invoice_status 		= $this->input->post('invoice_status'); // The invoice status, to see if is marked paid, draft and so on.
		$date 					= null == $this->input->post('date') ? date('Y-m-d') : $this->input->post('date'); // Issued date
		$due_date 				= null == $this->input->post('due_date') ? date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( mysqlDate($user_language, $this->input->post('from')) ) ) ): $this->input->post('due_date');// Invoice due date
		$pay_type 				= $this->input->post('pay_type'); // Is invoice recurring ?
		$recurring_from			= null == $this->input->post('from') ? date('Y-m-d') : $this->input->post('from');
		$recurring_to			= null == $this->input->post('to') ? date('Y').'-12-31' : $this->input->post('to');
		$subtotal 				= round( $this->input->post('subtotal'), 2); // Invoice subtotal
		$tax_amount 			= round( $this->input->post('tax_amount'), 2); // Total tax applied if any.
		$global_discount 		= round($this->input->post('global_discount'), 2); // Is there a global discount precentage ?
		$discount_amount 		= round( $this->input->post('discount_amount'), 2); // The discount amount
		$amount 				= round( $this->input->post('totalAftertax'), 2); // Total with all taxes applied
		$total 					= round( $this->input->post('total'),2); // Invoice final value after taxes and discount if any
		$new_payment 			= null !== $this->input->post('new_payment') ? round($this->input->post('new_payment'), 2): round(0, 2); // Is there any partial payment ?
		$credit_used 			= null !== $this->input->post('client_credit') ? round($this->input->post('client_credit'), 2): round(0, 2); // Does customer have credit used to pay invoice ?
		$amount_paid 			= round( floatval($this->input->post('amountPaid')) + $new_payment + $credit_used, 2); // partial or total payment
		$sent 					= $this->input->post('notify_client') == 1 ? 'yes': 'no'; // Is invoice sent to customer ?
		$amount_due 			= $total - $amount_paid; // Remaining amount to pay if partial or total payment
		$payment_fees 			= round($this->input->post('payment_fees'), 2); // Is there a payment fee, paypal fee for example ?
		$charges_sku 			= $this->input->post('charges_sku'); // If payment fee, get its identifier
		$notes 					= $this->input->post('notes'); // is there notes
		$external_number 		= $this->input->post('subject'); // Input field should be named $external_number, but database has unused subjet field. So let's use it
		$client_id 				= $this->input->post('client_id'); // Customer ID, value will be 0 if guest (non registered customer)
		$payment_method 		= null === $this->input->post('payment_method') ? get_option('default_payment_method') :$this->input->post('payment_method'); // If null, default payment method will be used.

		if ($amount_paid || $new_payment) {
			$transaction_id 		= null == $this->input->post('transaction_id') ? time() : $this->input->post('transaction_id'); // If null, time function is used to generate unique ID
		} else {
			$transaction_id = null;
		}
		$item_sku 				= $this->input->post('itemSku'); // Array of all items purhased sku.
		$specific_serial_number 				= $this->input->post('itemSN'); // Array of all items purhased sku.
		$item_id 				= $this->input->post('itemID'); // Array of all items purhased ID. If not registered before invoice, ID on creation will be 0, then updated on edit based on item name
		$item_name 					= $this->input->post('itemName'); // Array of all items purhased names

		$additional_taxes			= $this->input->post('additional_taxes');
		$additional_taxes_ID		= $this->input->post('additional_taxes_ID');
		$additional_taxes_values	= $this->input->post('additional_taxes_values');
		$files						= isset($_FILES['files']['name']) ? $_FILES['files']['name']: [];

		$additional_taxes_array = null;
		if ($additional_taxes) {
			// Additional tax
			$additional_taxes_array = [];
			for ($i=0; $i < count($additional_taxes); $i++) { 
				array_push($additional_taxes_array, array(
					array(
						'id'  => $additional_taxes_ID[$i],
						'rate' => $additional_taxes[$i],
						'value' => $additional_taxes_values[$i]
					)
				));
			}
		}
		// Get the change rate if multicurrency is enabled
		$currency = $client_id == 0 ? get_option('user_currency') : client($client_id, 'client_currency');
		$change_rate = _has_option('change_currency') ? get_change_rate( $currency ) : 1;

		//format dates
		if ($pay_type > 1) {
			$recurring_from = mysqlDate( $user_language, $recurring_from );
			$recurring_to = mysqlDate( $user_language, $recurring_to );
			$date = $recurring_from;
			$due_date = date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( mysqlDate($user_language, $this->input->post('from')) ) ) );

			if ( ! isValidDate($recurring_from) ) {
				$recurring_from = date('Y-m-d H:i:s');
			}
			if ( ! isValidDate($recurring_to)) {
				$recurring_to = date('Y').'-12-31 00:00:00';
			}
		} else {
			$recurring_from = null;
			$recurring_to = null;
			$date = mysqlDate( $user_language, $date );
			$due_date = mysqlDate( $user_language, $due_date );
			if ( ! isValidDate($date)) {
				$date = date('Y-m-d H:i:s');
			}
			if ( ! isValidDate($due_date)) {
				$due_date = date('Y-m-d H:i:s');
			}
		}
		// $date = mysqlDate( $user_language, $date );
		// $due_date = mysqlDate( $user_language, $due_date );
		// $recurring_from = mysqlDate( $user_language, $recurring_from );
		// $recurring_to = mysqlDate( $user_language, $recurring_to );
		// Data that will be saved in invoices table
		$invoiceTable 								= []; // All data that will be saved on oc_invoices
		$invoiceTable['change_rate'] 				= $change_rate; // Save change_rate for reference
		$invoiceTable['user_id'] 					= $m->getUserID();
		$invoiceTable['invoice_number'] 			= $invoice_number;
		$invoiceTable['annual_number_key'] 			= $annual_number_key;
		$invoiceTable['invoice_key'] 				= $invoice_key;
		$invoiceTable['payment_method'] 			= $payment_method;
		$invoiceTable['transaction_id'] 			= $transaction_id;
		$invoiceTable['invoice_status'] 			= $invoice_status;
		$invoiceTable['client_id'] 				    = $client_id;
		$invoiceTable['date'] 						= $date;
		$invoiceTable['due_date'] 					= $due_date;
		$invoiceTable['recurring_from'] 			= $recurring_from;
		$invoiceTable['recurring_to'] 				= $recurring_to;
		$invoiceTable['pay_type'] 					= $pay_type;
		$invoiceTable['subtotal'] 					= $subtotal;
		$invoiceTable['tax_amount'] 				= $tax_amount;
		$invoiceTable['global_discount'] 			= $global_discount;
		$invoiceTable['discount_amount'] 			= $discount_amount;
		$invoiceTable['total'] 						= $total;
		$invoiceTable['notes'] 						= $notes;
		$invoiceTable['subject'] 					= $external_number;
		$invoiceTable['amount_paid']				= $amount_paid;
		$invoiceTable['amount_due']					= $amount_due;
		$invoiceTable['credit_used']				= $credit_used;
		$invoiceTable['additional_taxes']			= null != $additional_taxes_array ? json_encode($additional_taxes_array) : "";
		$invoiceTable['sent']						= $sent; // Set Invoice to sent or not
		$invoiceTable['attachments']				= null;
		$itemTable 									= []; // Data that will be saved in oc_invoiceitems table
		$itemTable['amount']						= $amount;
		$itemTable['item_sku']						= $item_sku;
		$itemTable['specific_serial_number']		= $specific_serial_number;
		$itemTable['item_id']						= $item_id;
		$itemTable['item_name']						= $item_name;
		$itemTable['client_id']						= $client_id;
		$itemTable['user_id']						= $m->getUserID();
		$itemTable['notes']							= $notes;


		remove_credit($client_id, $credit_used); // If client_id && client_credit used

		$client_language = client($client_id, 'client_language');

		// Set the next due date if recurring
		switch ($pay_type) {
			case 2:
				$invoiceTable['next_duedate'] = date('Y-m-d', strtotime('+1 week', strtotime($date)));
				break;
			case 3:
				$invoiceTable['next_duedate'] = date('Y-m-d', strtotime('+2 week', strtotime($date)));
				break;
			case 4:
				$invoiceTable['next_duedate'] = date('Y-m-d', strtotime('+1 month', strtotime($date)));
				break;
			case 5:
				$invoiceTable['next_duedate'] = date('Y-m-d', strtotime('+1 year', strtotime($date)));
				break;
			case 6:
				$invoiceTable['next_duedate'] = date('Y-m-d', strtotime('+3 month', strtotime($date)));
				break;
			case 7:
				$invoiceTable['next_duedate'] = date('Y-m-d', strtotime('+6 month', strtotime($date)));
				break;
			default:
				$invoiceTable['next_duedate'] = NULL;
				break;
		}
		# Insert the paid date if any transaction found
		if( $new_payment && $new_payment > 0 )
		{
			// Record transaction
			$db_data = array(
				'payment_method'		=> $payment_method, 
				'payment_reference'		=> $transaction_id,
				'payment_amount'		=> $new_payment,
				'date_paid'				=> $this->current_date,
				'invoice_number'		=> $invoice_number, 
				'payment_note'		    => "",
				'user_id'				=> $m->getUserID()
			);
			if ($db_data['payment_amount'] > 0) {
				record_transaction($db_data);
			}
		}
		// Update all values if user set the invoice to Paid
		if ($invoice_status === "Paid")
		{
			$last_amount_paid = get_invoice_vars($invoice_number, 'amount_paid');
			if ($last_amount_paid > 0)
			{
				// Record transaction
				$db_data = array(
					'payment_method'		=> $payment_method, 
					'payment_reference'		=> $transaction_id,
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> $this->current_date,
					'invoice_number'		=> $invoice_number, 
					'payment_note'		    => "",
					'user_id'				=> $m->getUserID()
				);
				if ($db_data['payment_amount'] > 0) {
					record_transaction($db_data);
				}
			} else {
				// Record transaction
				$db_data = array(
					'payment_method'		=> $payment_method, 
					'payment_reference'		=> $transaction_id,
					'payment_amount'		=> $total,
					'date_paid'				=> $this->current_date,
					'invoice_number'		=> $invoice_number, 
					'payment_note'		    => "",
					'user_id'				=> $m->getUserID()
				);
				if ($db_data['payment_amount'] > 0) {
					record_transaction($db_data);
				}
			}
			$invoiceTable['date_paid'] = $this->current_date;
			$invoiceTable['amount_paid'] = $total;
			$invoiceTable['amount_due'] = 0;
			$item_paid_date = $this->current_date;
			$invoiceTable['invoice_status'] = "Paid";
		}
		// Update invoice to paid if amount due is less or equal to 0
		if ($amount_due <= 0)
		{
			$invoice_status = "Paid";
			$invoiceTable['date_paid'] = $this->current_date;
			$amount_paid = $total;
			$item_paid_date = $this->current_date;
		}

		// Set Invoice to Unpaid if client notification is set to 'yes'
		if($sent === 'yes' && $invoice_status === "Draft")
		{
			$invoiceTable['invoice_status'] = "Unpaid";
		}
		if (1 == $this->input->post('add_to_client_credit')) {
			$invoiceTable['credit_is_added'] = 1;
		}
		// Get array fields for validation
		$ids = $this->input->post('itemID');
		$names = $this->input->post('itemName');
		$quantity = $this->input->post('itemQuantity');
		$price = $this->input->post('itemPrice');

		if(!empty($names))
		{
        // Loop through $names and add the validation
			foreach($names as $key => $value)
			{
				$this->form_validation->set_rules('itemName[' . $key . ']', 'lang:item_name', 'required',
					array(
						'required' => lang('error_required_name') . '<br />'
						)
					);
			}
		}
		if(!empty($quantity))
		{
        // Loop through quantity and add the validation
			foreach($quantity as $key => $value)
			{
				$this->form_validation->set_rules('itemQuantity[' . $key . ']', 'lang:item_quantity', 'required',
					array(
						'required' => lang('error_required_quantity') . '<br />'
						)
					);
			}
		}

		if(!empty($price))
		{
        // Loop through price and add the validation
			foreach($price as $key => $value)
			{
				$this->form_validation->set_rules('itemPrice[' . $key . ']', 'lang:item_price', 'required',
					array(
						'required' => lang('error_required_price') . '<br />'
						)
					);
			}
		}
		if(count($files)){
			
			$config['upload_path']          = './uploads/invoices';
			if (!file_exists($config['upload_path']))
			    mkdir($config['upload_path']);

			if( chmod($config['upload_path'], 0755) ) 
	        {
	            chmod($config['upload_path'], 0777);
	        }

			for ($i=0; $i < count($files); $i++) { 
				if (!empty($_FILES['files']['name'][$i])){
					$_FILES['file']['name'] = $_FILES['files']['name'][$i];
					$_FILES['file']['type'] = $_FILES['files']['type'][$i];
					$_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
					$_FILES['file']['error'] = $_FILES['files']['error'][$i];
					$_FILES['file']['size'] = $_FILES['files']['size'][$i];

					$config['upload_path']          = './uploads/invoices';
					$config['allowed_types']        = '*';
					$config['max_size']        		= '5000';
					$config['file_name']        	= $_FILES['files']['name'][$i];

					$this->load->library('upload', $config);
					if ( ! $this->upload->do_upload('file'))
					{
						$error = $this->upload->display_errors();
						$this->form_validation->set_rules($error);
					} else {
						$data = $this->upload->data();
						$attachments[] = './uploads/invoices/'.$data['file_name'];
					}
				}
			}
			$invoiceTable['attachments'] = json_encode($attachments);
		}
		if ( $this->form_validation->run() === FALSE )
		{
			$this->response = array('status' => 0, 'error' => validation_errors() );
		}
		else
		{
			if ($this->input->post('invoice_id'))
			{
				$id = $this->input->post('invoice_id');
				// Invoice attachments
				$invoice = get_invoice_by_number($id);
				$last_files = json_decode($invoice[0]->attachments, true);

				if($last_files){
					foreach ($last_files as $file) {
						$attachments[] = $file;
					}
				}
				$invoiceTable['attachments'] = json_encode($attachments);
				delete('invoices_items', 'invoice_number', $id);
				$invoiceTable['user_id'] = $this->input->post('user_id');
				$this->invoices->set_table('invoices');
				$this->invoices->save($invoiceTable, $id);
				$event = array(
					'action' 					=> 'update',
					'referrer' 					=> 'invoices',
					'referrer_id' 				=> $id,
					'referrer_value' 			=> $invoice_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
				if ($invoice_status == 'Refunded' && 0 == $is_credit_note)
				{
					mark_refunded($id, $amount_paid);
					$event = array(
						'action' 					=> 'refunded',
						'referrer' 					=> 'invoices',
						'referrer_id' 				=> $id,
						'referrer_value' 			=> $invoice_number,
						'user_id' 					=> user('user_id'),
						'status' 					=> 'success'
					);
					record_event($event);
				}
				if ($invoice_status == 'Refunded' && 1 == $is_credit_note && 0 != $initial_invoice_number)
				{
					$event = array(
						'action' 					=> 'refunded',
						'referrer' 					=> 'invoices',
						'referrer_id' 				=> $id,
						'referrer_value' 			=> $invoice_number,
						'user_id' 					=> user('user_id'),
						'status' 					=> 'success'
					);
					$item_paid_date = $this->current_date;
					record_event($event);
					update_transaction($id, $subtotal, $tax_amount);
					if (1 == $this->input->post('add_to_client_credit') && 0 == $this->input->post('credit_is_added')) {
						refund($client_id, $amount_due);
					}
				}
				if (1 == $this->input->post('add_to_client_credit') && 0 == $this->input->post('credit_is_added')) {
					refund($client_id, $this->input->post('amount_refunded'));
				}
			}
			else
			{
				$this->invoices->set_table('invoices');
				$this->invoices->save($invoiceTable);
				$event = array(
					'action' 					=> 'add',
					'referrer' 					=> 'invoices',
					'referrer_id' 				=> $this->db->insert_id(),
					'referrer_value' 			=> $invoice_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
				update_annual_sequencing('invoice', intval($annual_number_key)+1);
			}

			// Record charges
			if ($invoice_status == "Paid" && ! refunded_invoice($invoice_number))
			{
				$db_data = array(
					'charges_name' 		=> __('label_payment_fees'),
					'charges_category' 	=> 7,
					'charges_value'	    => $payment_fees,
					'charges_sku'	    => $charges_sku,
					'incomes_name'	    => __('incomes_sales_services_goods'),
					'incomes_sku'	    => generate_sku(),
					'incomes_category'	=> 1,
					'incomes_value'	    => $subtotal,
					'payment_method'    => $payment_method,
					'turnover_included'	=> 1,
					'taxes'             => $tax_amount,
					'created_on' 	    => $this->current_date,
					'invoice_number'    => $invoice_number,
					'user_id'			=> $m->getUserID()
					);
				record_charges($db_data, 'invoice_number', isset($id) ? $id: null);
				$event = array(
					'action' 					=> 'paid',
					'referrer' 					=> 'invoices',
					'referrer_id' 				=> isset($id) ? $id: $invoice_number,
					'referrer_value' 			=> $invoice_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
				record_additional_taxes_meta($invoice_number);
			}

			// Insert Items in database
			$items_num = count( array_filter( $this->input->post('itemName')) ); // Get number of items, strip empty lines
			$item_sku = $this->input->post('itemSku');
			$specific_serial_number = $this->input->post('itemSN');
			$item_id = $this->input->post('itemID');
			$item_name  = array_filter( $this->input->post('itemName') );
			$item_quantity = array_filter( $this->input->post('itemQuantity') );
			$item_price  = array_filter( $this->input->post('itemPrice') );
			$item_discount = $this->input->post('itemDiscount');
			$item_tax_rate = $this->input->post('itemTax');
			// Indan Vars
			$item_hsn_sac  = $this->input->post('itemHSNSAC');
			$item_uom  = $this->input->post('itemUom');
			$item_cgst_tax_rate = $this->input->post('itemTaxCGST');
			$item_sgst_tax_rate = $this->input->post('itemTaxSGST');
			$item_igst_tax_rate = $this->input->post('itemTaxIGST');
			$item_cess_tax_rate = $this->input->post('itemTaxCESS');

			$item_cgst_amount = $this->input->post('itemTaxAmountCGST');
			$item_sgst_amount = $this->input->post('itemTaxAmountSGST');
			$item_igst_amount = $this->input->post('itemTaxAmountIGST');
			$item_cess_amount = $this->input->post('itemTaxAmountCESS');

			$item_subtotal = array_filter( $this->input->post('itemSubTotal') );
			$client_id = $client_id;
			if ($pay_type == 2)
			{
				$item_recurring = 2;
			}
			else
			{
				$item_recurring = 1;
			}
			if ($invoice_status == "Cancelled" || $invoice_status == 'Refunded' && 1 == $is_credit_note)
			{
				$invoice_is_cancelled = 1;
			}
			else
			{
				$invoice_is_cancelled = 0;
			}

			$invoices_items = $this->tables['invoices_items'];
			$this->invoices->set_table('invoices_items');
			for($i = 0; $i < $items_num; $i++){
				$item_array = array(
					'invoice_number' => $invoice_number,
					'invoice_key' => $invoice_key,
					'client_id' => $client_id,
					'user_id' => $m->getUserID(),
					'item_sku' => $item_sku[$i],
					'specific_serial_number' => $specific_serial_number[$i],
					'item_id' => $item_id[$i],
					'item_group' => $this->m_manager->category_id($item_id[$i]),
					'item_name' => addslashes($item_name[$i]),
					'item_hsn_sac' => $item_hsn_sac[$i],
					'item_uom' => $item_uom[$i],
					'item_price' => $item_price[$i],
					'item_discount' => $item_discount[$i],
					'item_quantity' => $item_quantity[$i],
					'item_subtotal' => $item_subtotal[$i],
					'item_tax_rate' => $item_tax_rate[$i],
					'item_cgst_rate' => $item_cgst_tax_rate[$i],
					'item_sgst_rate' => $item_sgst_tax_rate[$i],
					'item_igst_rate' => $item_igst_tax_rate[$i],
					'item_cess_rate' => $item_cess_tax_rate[$i],
					'item_cgst_amount' => $item_cgst_amount[$i],
					'item_sgst_amount' => $item_sgst_amount[$i],
					'item_igst_amount' => $item_igst_amount[$i],
					'item_cess_amount' => $item_cess_amount[$i],
					'item_recurring' => $item_recurring,
					'invoice_is_cancelled' => $invoice_is_cancelled,
					'date_paid' => isset($item_paid_date) ? $item_paid_date : null 
					);
				if ($this->input->post('invoice_id'))
				{
					$item_array['user_id'] = $this->input->post('user_id');
				}
				$this->invoices->save($item_array);
				remove_committed_items($invoice_number);
				$this->response = array('status' => 1, 'invoice_number' => $invoice_number);
			}
			// End insert items
			
			// Since 1.5 Add Item to database if not found in autocomplete
			for($i = 0; $i < $items_num; $i++){
				if ( !item_exists($item_name[$i]) )
				{
					$new_item_array = array(
						'sku' => null !== $item_sku[$i] ? $item_sku[$i]: generate_sku(),
						'serial_number' => json_encode(null !== $specific_serial_number[$i] ? (array)$specific_serial_number[$i]: array()),
						'group_id' => 0,
						'name' => $item_name[$i],
						'price' => $item_price[$i],
						'user_id' => $m->getUserID()
						);
					if ($this->input->post('invoice_id'))
					{
						$new_item_array['user_id'] = $this->input->post('user_id');
					}
					$this->load->model('products/products_model', 'items');
					$this->items->set_table('items');
					$this->items->save($new_item_array);
				}
			}
			// Do not send email for Draft Invoices or on update
			if ( $invoiceTable['invoice_status'] !== 'Draft' && $invoiceTable['invoice_status'] !== 'Refunded' && $client_id > 0 && $this->input->post('notify_client') == 1 )
			{
				$data = array(
					'invoice_url'		=> base_url('index.php/viewinvoice/view?id=') . _eID($invoice_number),
					'to_name'            => html_entity_decode(htmlentities(client( $client_id, 'name_company' ))),
					'date'		    	=> _fdate( $client_language, $date ),
					'due_date'		    => _fdate( $client_language, $due_date),
					'invoice_status'	=> __( strtolower( $invoiceTable['invoice_status'] ), $client_id ),
					'invoice_number' 	=> get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $invoice_number),
					'transaction_id' 	=> isset($transaction_id) ? $transaction_id: '',
					'invoicesubject'	=> $external_number
					);
				$data['client_account'] = base_url('index.php/client/index?id=') . _eID($client_id);
				$data['btn_client_account'] = __( 'btn_client_account', $client_id );
				$data['logo_url'] = base_url('uploads/admin/img/'). get_option('logo');
			
				$data['invoice_amount'] = add_currency( format_number($total * $change_rate), $client_id );

				if ($invoiceTable['invoice_status'] === "Paid" OR $invoiceTable['amount_due'] <= 0)
				{
					$last_amount_paid = get_invoice_vars($invoice_number, 'amount_paid');
					if ($last_amount_paid > 0)
					{
						$data['amount_paid'] = add_currency( format_number($total * $change_rate), $client_id );
						$data['amount_due'] = add_currency( format_number(0), $client_id );
					}
				}
				else
				{
					$data['amount_paid'] = add_currency( format_number($invoiceTable['amount_paid'] * $change_rate), $client_id );
					$data['amount_due'] = add_currency( format_number($invoiceTable['amount_due'] * $change_rate), $client_id );
				}
				$this->load->helper('file');
				$lang = lang_code_to_notif_string( $client_language );
				$path_new_invoice = './notifications/' . $lang . '/invoices/new_invoice.php';
				$path_paid_invoice = './notifications/' . $lang . '/invoices/invoice_paid.php';

				$to = client( $client_id, 'client_email' );
				$template = ($invoice_status === "Paid" OR $amount_due <= 0 ) ? read_file($path_paid_invoice):
				read_file($path_new_invoice);
				$subject = ($invoice_status === "Paid" OR $amount_due <= 0 ) ? __('subject_payment_confirmation', $client_id) : __('subject_invoice_generated', $client_id);
				$message = ($invoice_status === "Paid" OR $amount_due <= 0 ) ? 
				$this->parser->parse_string($template, $data, true) : 
				$this->parser->parse_string($template, $data, true);

				$sms_message = ($invoice_status === "Paid" OR $amount_due <= 0 ) ? get_option('sms_invoice_paid'). " ".__('invoices_invoice'). ' #'. $invoice_number. " ". get_option('company'): get_option('sms_invoice_with_status'). __( strtolower( $invoiceTable['invoice_status'] ), $client_id ). ". ". __('message_thanks'). " ".__('invoices_invoice'). ' #'. $invoice_number. " ". get_option('company');

				if ($client_id) {
					$client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
					if (1 == get_option('attach_pdf_to_invoice')) {
						generate_pdf_file('invoices', $invoice_number);
					}
				}
				$attachments[] = FCPATH.'uploads/pdf/invoices/'.$invoice_number.'.pdf';
				send_email($to, $message, $subject, null, $client_cc, $attachments, get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $invoice_number).'.pdf');

				if (_has_option('sms_notification')) {
					try {
						if (get_option( 'notify_when_invoice_is' )) {
							$context = json_decode(get_option( 'notify_when_invoice_is' ));
						}
						if (in_array($invoiceTable['invoice_status'], $context)) {
							$this->sms->sendMessage(client($client_id, 'client_phone'), $sms_message);
						}
					} catch (Exception $e) {
						
					}
				}
				$event = array(
					'action' 					=> 'invoice_sent',
					'referrer' 					=> 'invoices',
					'referrer_id' 				=> $invoice_number,
					'referrer_value' 			=> $invoice_number,
					'client_id' 				=> $client_id,
					'status' 					=> 'success'
				);
				record_event($event);
			}
			if ( $invoiceTable['invoice_status'] == 'Refunded' && $client_id > 0 && $this->input->post('notify_client') == 1 )
			{
				$data = array(
					'invoice_url'		=> base_url('index.php/viewinvoice/view?id=') . _eID($invoice_number),
					'to_name'            => html_entity_decode(htmlentities(client( $client_id, 'name_company' ))),
					'date'		    	=> _fdate( $client_language, $date ),
					'due_date'		    => _fdate( $client_language, $due_date),
					'invoice_status'	=> __( strtolower( $invoiceTable['invoice_status'] ), $client_id ),
					'invoice_number' 	=> get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $invoice_number),
					'transaction_id' 	=> isset($transaction_id) ? $transaction_id: '',
					'invoicesubject'	=> $external_number
					);
				$data['client_account'] = base_url('index.php/client/index?id=') . _eID($client_id);
				$data['btn_client_account'] = __( 'btn_client_account', $client_id );
				$data['logo_url'] = base_url('uploads/admin/img/'). get_option('logo');
			
				$data['invoice_amount'] = add_currency( format_number($total * $change_rate), $client_id );
				$data['amount_refunded'] = add_currency( format_number( $total * $change_rate ), $client_id );
				$data['amount_paid'] = add_currency( format_number($invoiceTable['amount_due'] * $change_rate), $client_id );
				$data['amount_due'] = add_currency( format_number(0), $client_id );

				$this->load->helper('file');
				$lang = lang_code_to_notif_string( $client_language );
				$path_refunded_invoice 		= './notifications/' . $lang . '/invoices/invoice_refunded.php';

				$to = client( $client_id, 'client_email' );
				$template 	= read_file( $path_refunded_invoice );
				$subject 	= __( 'subject_payment_refunded', $client_id );

				$message 	= $this->parser->parse_string($template, $data, true);

				if ($client_id) {
					$client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
					if (1 == get_option('attach_pdf_to_invoice')) {
						generate_pdf_file('invoices', $invoice_number);
					}
				}
				$attachments[] = FCPATH.'uploads/pdf/invoices/'.$invoice_number.'.pdf';
				send_email($to, $message, $subject, null, $client_cc, $attachments, get_option('invoice_prefix').invoice_number_format() . sprintf("%04s", $invoice_number).'.pdf');

				if (_has_option('sms_notification')) {
					try {
						$context = json_decode(null != get_option( 'notify_when_invoice_is' ) ? get_option( 'notify_when_invoice_is' ): json_encode([]));
						if (in_array($invoiceTable['invoice_status'], $context)) {
							$this->sms->sendMessage(client($client_id, 'client_phone'), get_option('sms_invoice_with_status'). __( strtolower( $invoiceTable['invoice_status'] ), $client_id ). ". ". __('message_thanks'). " ".__('invoices_invoice'). ' #'. $invoice_number. " ". get_option('company'));
						}
					} catch (Exception $e) {
						
					}
				}
				$event = array(
					'action' 					=> 'invoice_sent',
					'referrer' 					=> 'invoices',
					'referrer_id' 				=> $invoice_number,
					'referrer_value' 			=> $invoice_number,
					'client_id' 				=> $client_id,
					'status' 					=> 'success'
				);
				record_event($event);
			}
		}
		if (! $this->input->post('invoice_id')) {
			// Update next invoice ID
			setAccountEntityId('invoice', get_last_id('invoices'));
		}
		// Remove any late fees that applied
		if ( ! _has_late_fees($invoice_number)){
			$this->invoices->set_table('invoices');
			$this->invoices->save(array('invoice_number' => $invoice_number, 'late_fees_tax_rate' => 0, 'late_fees_tax_amount' => 0, 'late_fees_subtotal' => 0), $invoice_number);
		}
	
		echo json_encode($this->response);
	}
}