<?php defined('BASEPATH') OR exit('No direct script access allowed');
use Mmanager\Domain\Factory\InvoiceFactory;
/**
 * 
 */
class Invoices extends Admin_Controller {
	/**
	 * @var type
	 */
	protected $_invoice = [];

	/**
	 * @var type
	 */
	protected $_client = [];

	/**
	 * Description
	 * @return type
	 */
	public function __construct(){
		parent::__construct();
		$this->load->model('clients/clients_model', 'clients');
		$this->clients->set_primary_key('client_id');
		$this->load->model('invoices_model', 'invoices');
		
        $this->view_data['modal'] = $this->Template->render('clients', 'add_client_modal.phtml', '', true);
        $this->data['breadcrumb'] = anchor('invoices', __('link_invoices'));
        $this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	
	/**
	 * Description
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type
	 */
	public function index()
	{
		$this->view_data['pageJs'] = array(
	            'invoices-index.js'.'?v='.get_option('stable_version')
	        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoice'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'filter'			=> 'All'
			);
		if (can_access('invoices')) {
			$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function credit_notes()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices/credit_notes', __('link_credit_note')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_credit_note'),
			'page_description' 	=> __('message_manage') .' '.__('link_credit_note'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'filter'			=> 'Refunded'
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'page_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function create_invoice()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('link_add_new') .' '.__('invoices_invoice'),
			'clients'         => clients()
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('invoices', 'create_invoice_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$id = _dID($_REQUEST['id']);
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoice'),
			'user_language' => get_option('user_language', 'users_options'),
			'invoices' => get_invoice_by_number($id),
			'invoiceObj' => new InvoiceFactory,
			'invoice_items' => get_invoiced_items($id),
			'clients' => json_encode(clients()),
			'payment_fees'  => null !== get_invoice_charges($id) ? get_invoice_charges($id) : floatval(0),
			'charges_sku'  => null !== get_charges_sku($id) ? get_charges_sku($id) : generate_sku(),
			'invoice_status' => array(
				'Draft' => ucfirst(__('option_draft')),
				'Unpaid' => ucfirst(__('option_unpaid')),
				'Paid' => ucfirst(__('option_paid')),
				'Open' => ucfirst(__('label_opened')),
				'Paidout' => ucfirst(__('label_paidout')),
				'Failed' => ucfirst(__('is_failed')),
				'Expired' => ucfirst(__('label_expired')),
				'Refunded' => ucfirst(__('label_refunded')),
				'Pending' => ucfirst(__('label_pending')),
				'Charged_back' => ucfirst(__('label_charged_back')),
				'Overdue' => ucfirst(__('option_overdue')),
				'Cancelled' => ucfirst(__('option_cancelled'))
				),
			'pay_type' => array(
				'1' => __('option_once'),
				'2' => __('option_weekly'),
				'3' => __('option_biweekly'),
				'4' => __('option_monthly'),
				'5' => __('option_yearly'),
				'6' => __('option_quarterly'),
				'7' => __('option_half_yearly')
				),
			'payment_history' => get_payment_history($id)
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('invoices', 'edit_invoice_form.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_all()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter'		=> 'All'
			);

		$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_paid()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Paid'
			);

		$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_unpaid()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Unpaid'
			);

		$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_overdue()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Overdue'
			);

		$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_cancelled()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Cancelled'
			);

		$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_refunded()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'.'?v='.get_option('stable_version')
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js'.'?v='.get_option('stable_version'),
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Refunded'
			);

		$this->view_data['content'] = $this->Template->render('invoices', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}

	public function delete_invoice()
	{
		$protected = [];
		$to_del = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (invoice_status($i) == 'is_paid' || invoice_status($i) == 'is_refunded' )
				{
					array_push($protected, $i);
				}
				else
				{
					array_push($to_del, $i);
				}
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('invoices', 'invoice_number', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function mark_paid()
	{
		$protected = [];
		$to_mark_paid = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (invoice_status($i) !== 'is_paid')
				{
					array_push($to_mark_paid, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_paid);
			$response['fail'] = count($protected);

			if(!empty($to_mark_paid))
			{
				mass_payment('invoices', 'invoice_number', $to_mark_paid);
			}
		}
		echo json_encode($response);
	}
	public function mass_invoices_email()
	{
		$protected = [];
		$to_send = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (invoiced_to_guest($i) > 0)
				{
					array_push($to_send, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_send);
			$response['fail'] = count($protected);

			if(!empty($to_send))
			{
				foreach ($to_send as $invoice_number) {
					$this->m_manager->send_invoice_email($invoice_number);
				}
			}
		}
		echo json_encode($response);
	}
	public function invoices_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'id';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : null;

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$invoices = $this->invoices->findAll(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);

		if ($invoices)
		{
			foreach ($invoices as $invoice) {
				$invoice = (object)$invoice;
				if (get_option('annual_numbering')) {
					$inv_f_number = null == get_option('invoice_prefix') ? __('invoice_prefix_short') . date('y', strtotime($invoice->updated_on)). sprintf( "%04s", $invoice->annual_number_key) : get_option('invoice_prefix') . date('y', strtotime($invoice->updated_on)).sprintf( "%04s", $invoice->annual_number_key );
				} else {
					$inv_f_number = null == get_option('invoice_prefix') ? __('invoice_prefix_short') . sprintf( "%04s", $invoice->invoice_number ) : get_option('invoice_prefix') . sprintf( "%04s", $invoice->invoice_number );
				}
				$amount_due = format_number($invoice->amount_due);
				$amount_refunded = format_number($invoice->amount_refunded);
				$amount_paid = format_number($invoice->amount_paid);
				$credit_prefix = '';
				$credit_note_number = _eID(intval($invoice->invoice_number) + 1);

				if ($invoice->order_number) {
					$order_prefix = null == get_option('sale_order_prefix') ? __('sale_order_prefix') . sprintf( "%04s", $invoice->order_number ) : get_option('sale_order_prefix') . sprintf( "%04s", $invoice->order_number );
				} else {
					$order_prefix = '';
				}
				if ($invoice->proforma_number) {
					$proforma_prefix = null == get_option('proforma_prefix') ? __('proforma_prefix') . sprintf( "%04s", $invoice->proforma_number ) : get_option('proforma_prefix') . sprintf( "%04s", $invoice->proforma_number );
				} else {
					$proforma_prefix = '';
				}
				if ($invoice->amount_paid > 0 AND $invoice->invoice_status == 'Refunded')
				{
					$status = __('label_partially_refunded');
					$credit_prefix = null == get_option('credit_note_prefix') ? __('credit_note_prefix') . sprintf( "%04s", $invoice->initial_invoice_number ) : get_option('credit_note_prefix') . sprintf( "%04s", $invoice->initial_invoice_number );
					$amount_due = format_number(0);
					$amount_refunded = format_number($invoice->amount_refunded);
					$amount_paid = format_number($invoice->amount_paid);
				}
				elseif ($invoice->invoice_status == 'Refunded')
				{
					$credit_prefix = null == get_option('credit_note_prefix') ? __('credit_note_prefix') . sprintf( "%04s", $invoice->initial_invoice_number ) : get_option('credit_note_prefix') . sprintf( "%04s", $invoice->initial_invoice_number );
					$status = __(strtolower($invoice->invoice_status));
					$amount_due = format_number(0);
					$amount_refunded = format_number($invoice->total);
					$amount_paid = format_number($invoice->total);
				}
				elseif ($invoice->amount_paid > 0 AND $invoice->amount_due > 0 AND $invoice->invoice_status !== 'Paid')
				{
					$status = __('label_partially_paid');
				}
				elseif( $invoice->invoice_status == 'Expired' || $invoice->invoice_status == 'Open' || $invoice->invoice_status == 'Pending' || $invoice->invoice_status == 'Failed')
				{
					$status = __('unpaid');
				}
				else
				{
					$status = __(strtolower($invoice->invoice_status));
				}
				array_push($rows, array(
					'id' 				  => $invoice->id,
					'client_id'           => _eID($invoice->client_id),
					'inv_f_number'   	  => $inv_f_number,
					'so_f_number'   	  => $order_prefix,
					'cn_f_number'   	  => $credit_prefix,
					'proforma_f_number'   => $invoice->proforma_number,
					'has_proforma'  	  => boolval($invoice->proforma_number),
					'proforma_encrypt_number'  	  => _eID($invoice->proforma_number),
					'invoice_number'   	  => $invoice->invoice_number,
					'enc_invoice_number'  => _eID($invoice->invoice_number),
					'enc_order_number'    => _eID($invoice->order_number),
					'name_company'		  => $invoice->name_company,
					'date'				  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $invoice->date ),
					'due_date'			  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $invoice->due_date ),
					'total'				  => format_number($invoice->total),
					'amount_due'		  => $amount_due,
					'amount_paid'		  => $amount_paid,
					'amount_refunded'	  => $amount_refunded,
					'invoice_status'              => $status,
					'stbool'			  => invoice_status($invoice->invoice_number),
					'pay_type'			  => $invoice->pay_type,
					'next_due_date'		  => $invoice->next_duedate,
					'has_credit_note'	  => refunded_invoice($invoice->invoice_number),
					'creditnotenumber'	  => $credit_note_number
					)
				);
			}
			
			if ( $search) {
				$list = array(
					'total' => count($invoices),
					'totalNotFiltered' => count($invoices),
					'rows' => $rows
				);
			}
			else
			{
				$total = $this->invoices->count_rows('invoices',$filter);
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows
				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	
	public function invoice_autocomplete()
	{
		$data = [];
		$results = get_all_items(1);
		if(! empty($results) )
		{
			if (! _has_option('is_indian') )
			{
				foreach($results as $row)
				{
					// $name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id;
					// array_push($data, $name);
					$serial_numbers = json_decode($row->serial_number, true);
					if ($serial_numbers) {
						foreach ($serial_numbers as $key => $value) {
							$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate. '|'. $value;
							array_push($data, $name);
						}
					} else {
						$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
						array_push($data, $name);
					}
				}
			}
			else
			{
				foreach($results as $row)
				{
					$serial_numbers = json_decode($row->serial_number, true);
					if ($serial_numbers) {
						foreach ($serial_numbers as $key => $value) {
							$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate. '|'. $value;
							array_push($data, $name);
						}
					} else {
						$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
						array_push($data, $name);
					}
				}
			}
		}
		echo json_encode($data);
	}
	public function next_invoice_number()
	{
		echo json_encode(next_invoice_number());
	}
	public function create_credit_note()
	{
		$protected = [];
		$to_mark_refund = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (invoice_status($i) == 'is_paid' || invoice_status($i) == 'is_refunded')
				{
					array_push($to_mark_refund, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_refund);
			$response['fail'] = count($protected);

			if(!empty($to_mark_refund))
			{
				mass_refund('invoices', 'invoice_number', $to_mark_refund);
			}
		}
		echo json_encode($response);
	}
	public function generate_from_tracker() {
		$invoice_number = next_invoice_number();
		$invoice_key = getAccountEntityNextId('invoice');
		$client_id = get_client_id($_REQUEST['client_name']);
		$currency = $client_id == 0 ? get_option('user_currency') : client( $client_id, 'client_currency' );
		$change_rate = _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
		$date = date('Y-m-d');
		$default_duedate = get_option('default_duedate');
		$duedate = date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( $date ) ) );

		$invoice_data = [
			'invoice_number'		=> $invoice_number,
			'invoice_key' 			=> $invoice_key,
			'client_id' 			=> get_client_id($_REQUEST['client_name']),
			'subtotal' 				=> $_REQUEST['subtotal'],
			'total' 				=> $_REQUEST['subtotal'],
			'amount_due' 			=> $_REQUEST['subtotal'],
			'tax_amount' 			=> 0,
			'discount_amount' 		=> 0,
			'amount_refunded' 		=> 0,
			'notes' 				=> $_REQUEST['notes'],
			'next_duedate' 			=> null,
			'recurring_from' 		=> null,
			'recurring_to' 			=> null,
			'subject' 				=> null,
			'pay_type' 				=> 1,
			'date' 					=> $date,
			'due_date' 				=> $duedate,
			'invoice_status' 		=> 'Unpaid',
			'sent' 					=> 'no',
			'change_rate' 			=> $change_rate
		];
		// Set table and save data
		$this->invoices->set_table( 'invoices' );
		$this->invoices->save( $invoice_data );

		$item_data = [
			'invoice_number' 			=> $invoice_number,
			'invoice_key' 				=> $invoice_key,
			'client_id' 				=> $client_id,
			'item_sku' 					=> generate_sku(),
			'item_id' 					=> 0,
			'item_name' 				=> $_REQUEST['item_name'],
			'item_price' 				=> $_REQUEST['item_price'],
			'item_quantity' 			=> _durationToHour($_REQUEST['item_quantity']),
			'item_discount' 			=> 0,
			'item_subtotal' 			=> $_REQUEST['subtotal'],
			'item_tax_rate' 			=> 0,
			'item_recurring' 			=> 1,
			'item_uom' 					=> 'hr'
		];

		$this->invoices->set_table('invoices_items');
		$this->invoices->save($item_data);

		// Update next invoice ID
		setAccountEntityId('invoice', $invoice_key);
		echo json_encode(1);
	}
	public function generate_from_support() {
		$invoice_number = next_invoice_number();
		$invoice_key = getAccountEntityNextId('invoice');
		$client_id = $_REQUEST['client_id'];
		$currency = $client_id == 0 ? get_option('user_currency') : client( $client_id, 'client_currency' );
		$change_rate = _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
		$date = date('Y-m-d');
		$default_duedate = get_option('default_duedate');
		$duedate = date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( $date ) ) );

		$notes = get_ticket_messages($_REQUEST['ticket_id']);
		$html = '';
		if($notes) {
			foreach ($notes as $note) {
				$html .= "\n".$note->title.' ('.convertToHoursMins($note->duration).')'. "\n".$note->message."\n"."\n";
			}
		}
		$invoice_data = [
			'invoice_number'		=> $invoice_number,
			'invoice_key' 			=> $invoice_key,
			'client_id' 			=> $_REQUEST['client_id'],
			'subtotal' 				=> floatval($_REQUEST['duration'] / 60) * 1,
			'total' 				=> floatval($_REQUEST['duration'] / 60) * 1,
			'amount_due' 			=> floatval($_REQUEST['duration'] / 60) * 1,
			'tax_amount' 			=> 0,
			'discount_amount' 		=> 0,
			'amount_refunded' 		=> 0,
			'notes' 				=> $html,
			'next_duedate' 			=> null,
			'recurring_from' 		=> null,
			'recurring_to' 			=> null,
			'subject' 				=> null,
			'pay_type' 				=> 1,
			'date' 					=> $date,
			'due_date' 				=> $duedate,
			'invoice_status' 		=> 'Unpaid',
			'sent' 					=> 'no',
			'change_rate' 			=> $change_rate
		];
		// Set table and save data
		$this->invoices->set_table( 'invoices' );
		$this->invoices->save( $invoice_data );

		$item_data = [
			'invoice_number' 			=> $invoice_number,
			'invoice_key' 				=> $invoice_key,
			'client_id' 				=> $client_id,
			'item_sku' 					=> generate_sku(),
			'item_id' 					=> 0,
			'item_name' 				=> $_REQUEST['subject'],
			'item_price' 				=> 1,
			'item_quantity' 			=> _durationToHour($_REQUEST['duration'] /60),
			'item_discount' 			=> 0,
			'item_subtotal' 			=> floatval($_REQUEST['duration'] / 60) * 1,
			'item_tax_rate' 			=> 0,
			'item_recurring' 			=> 1,
			'item_uom' 					=> 'hr'
		];

		$this->invoices->set_table('invoices_items');
		$this->invoices->save($item_data);

		set_support_vars($_REQUEST['ticket_id'], array('status' => 'Billed'));
		// Update next invoice ID
		setAccountEntityId('invoice', $invoice_key);
		echo json_encode(array('success' => 1, 'invoicenumb' => _eID($invoice_number)));
	}
	public function download_invoice() {
		$this->load->helper('download');
		$invoice_number = $_REQUEST['invoice_number'];
		generate_pdf_file('invoices', $invoice_number);
		force_download('./uploads/pdf/invoices/'.$invoice_number.'.pdf', null);
	}
}