<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * 
 */
class Messaging extends Basic_Controller {

    /**
     * Class constructor
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }
    public function get_messages() {
        header("Access-Control-Allow-Origin: *");
        if(!empty($_REQUEST['recipient_id'])) {
            $recipient_id = $_REQUEST['recipient_id'];
            $sender_id = $_REQUEST['sender_id'];
            $avatarPath = 'uploads/users/avatars/';
        }
        $messages = get_messages($sender_id, $recipient_id);
        if ($messages) {
            foreach ($messages as $message) {
                $type = $message->user_id == intval($sender_id) ? 'out': 'in';
                $sender = $message->message_from == intval($sender_id) ? ' ' : get_user_var($message->message_from, 'first_name');
                mark_read($message->id);
                echo 
                    '<div class="post '.$type.'">
                        <img class="avatar" alt="" src="'.base_url($avatarPath).get_user_avatar($message->message_from).'" />
                        <div class="message">
                            <span class="arrow"></span>
                            <a href="javascript:;" class="name">'.$sender.'</a>
                            <span class="datetime">'._dateDiff($message->created_on).'</span>
                            <span class="body"> '.$message->message.' </span>
                        </div>
                    </div>';
            }
        }      
    }
    public function has_unread_message() {
        echo json_encode(count_user_unread_messages(USERID));
    }
}