<?php

class New_payment extends Basic_Controller
{
	protected $amount;
	protected $description;
	protected $mollie_api_key;
	protected $invoice_number;

	public function index()
	{
		$this->amount = isset($_REQUEST['amount']) ? $_REQUEST['amount']: die();
		$this->description = isset($_REQUEST['description']) ? __('invoices_invoice') . " #" ._dID($_REQUEST['description']): " ";
		$this->invoice_number = _dID($_REQUEST['invoice_number']);
		$this->mollie_api_key = get_option('mollie_api_key');
		try
		{
			/*
			 * Initialize the Mollie API library with your API key.
			 *
			 * See: https://www.mollie.com/beheer/account/profielen/
			 */
			require_once APPPATH . "third_party/Mollie/API/Autoloader.php";
			/*
			 * Initialize the Mollie API library with your API key.
			 *
			 * See: https://www.mollie.com/beheer/account/profielen/
			 */
			$mollie = new Mollie_API_Client;
			$mollie->setApiKey($this->mollie_api_key);

			/*
			 * Generate a unique order id for this example. It is important to include this unique attribute
			 * in the redirectUrl (below) so a proper return page can be shown to the customer.
			 */
			$order_id = time();
			/*
			 * Payment parameters:
			 *   amount        Amount in EUROs. This example creates a € 10,- payment.
			 *   description   Description of the payment.
			 *   redirectUrl   Redirect location. The customer will be redirected there after the payment.
			 *   webhookUrl    Webhook location, used to report when the payment changes state.
			 *   metadata      Custom metadata that is stored with the payment.
			 */
			$payment = $mollie->payments->create(array(
				"amount"       			=> $this->amount,
				"description"  			=> $this->description,
				"redirectUrl"  			=> base_url('index.php/mollie/return_page/index?invoice_number=') . _eID($this->invoice_number),
				"webhookUrl"  			=> base_url('index.php/mollie/webhook_verification/check_payment'),
				"metadata"     			=> array(
					"order_id" 			=> $order_id,
					"invoice_number" 	=> $this->invoice_number
				),
			));
			/*
			 * We store the order with its payment status in a database.
			 */

			update_invoice_status($this->invoice_number, ucfirst( $payment->status ), $payment->id);
			/*
			 * Send the customer off to complete the payment.
			 */
			header("Location: " . $payment->getPaymentUrl());
		}
		catch (Mollie_API_Exception $e)
		{
			echo "API call failed: " . htmlspecialchars($e->getMessage());
		}
	}
}
