<?php
/*
 * Example 2 - How to verify Mollie API Payments in a webhook.
 */
class Webhook_verification extends CI_Controller
{
	protected $mollie_api_key;
	public function check_payment()
	{
		$this->mollie_api_key = get_option('mollie_api_key');
		try
		{
			/*
			 * Initialize the Mollie API library with your API key.
			 *
			 * See: https://www.mollie.com/beheer/account/profielen/
			 */
			require_once APPPATH . "third_party/Mollie/API/Autoloader.php";

			/*
			 * Initialize the Mollie API library with your API key.
			 *
			 * See: https://www.mollie.com/beheer/account/profielen/
			 */
			$mollie = new Mollie_API_Client;
			$mollie->setApiKey($this->mollie_api_key);

			/*
			 * Check if this is a test request by Mollie
			 */
			if (!empty($_GET['testByMollie']))
			{
				die('OK');
			}

			/*
			 * Retrieve the payment's current state.
			 */
			$payment  = $mollie->payments->get($_REQUEST["id"]);
			$order_id = $payment->metadata->order_id;
			$invoice_number = $payment->metadata->invoice_number;
			$status = $payment->status;

			if ($status === 'cancelled')
			{
				$status = 'open';
			}
			elseif ($status === 'paid')
			{
				$status = 'paid';
				$this->load->library('m_manager');
				$this->m_manager->mass_payment(array($invoice_number));
				$this->output->set_header('HTTP/1.1 200 OK');
			}
			elseif ($status === 'refunded')
			{
				$status = 'refunded';
				$this->load->library('m_manager');
				$this->m_manager->mark_refunded($invoice_number, $payment->getAmountRefunded());
				$this->output->set_header('HTTP/1.1 200 OK');
			}
			/*
			 * Update the order in the database.
			 */
			update_invoice_status($invoice_number, ucfirst($status), $_REQUEST["id"]);

		}
		catch (Mollie_API_Exception $e)
		{
			echo "API call failed: " . htmlspecialchars($e->getMessage());
		}
	}
}
