<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Notes extends Admin_Controller {
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->library('m_manager');
	}

	public function index()
	{
		$data = array(
			'filter' => 'all', 
			);
		$this->view_data['content'] = $this->load->view('index.phtml', $data, TRUE);
		// Load the template from the views directory
		$this->load->view('templates/layout.phtml', $this->view_data);
	}
	public function get_notes_list()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$notes = get_notes();
		if ($notes)
		{
			foreach ($notes as $note) {
				$refKey = $note->note_referrer_key;
				switch ($refKey) {
					case 'clients':
						$refID = _eID($note->note_referrer_id);
						break;
					default:
						$refID = $note->note_referrer_id;
						break;
				}
				array_push($list, array(
					'note_id' 		  		=> $note->note_id,
					'note_title' 	        => $note->note_title,
					'note_message'          => strlen($note->note_message) > 50 ? substr($note->note_message, 0, 50)."&#133;" : $note->note_message,
					'note_referrer_id'   	=> $refID,
					'note_referrer_key'   	=> $note->note_referrer_key,
					'note_referrer_value' 	=> $note->note_referrer_value,
					'user_id'               => $note->user_id,
					'username'              => get_user_var($note->updated_by, 'first_name'),
					'note_created_on'   => $note->note_created_on,
					'note_updated_on' => $note->note_updated_on,
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function delete_notes()
	{
		$to_del = [];
		$ids = $_REQUEST['id'];
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				array_push($to_del, $i);
			}
			$response['success']  = count($to_del);
			if(!empty($to_del))
			{
				delete('notes', 'note_id', $to_del);
			}
		}
		echo json_encode($response);
	}
}