<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Invoice Ajax Class
 * Create and Update Invoice
 * Also used to make refunds.
 */
class Ajax extends Ajax_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('orders/orders_model', 'orders');
	}
	/**
	 * Refund Payment
	 * @return type json
	 */
	public function refund_payment()
	{
		$order_number = $_REQUEST['order_number'];
		$amount = $_REQUEST['amount'];

		if ($order_number && $amount > 0)
		{
			$this->load->library('m_manager');
			$this->m_manager->mark_refunded($order_number, $amount);
			$event = array(
				'action' 					=> 'refunded',
				'referrer' 					=> 'orders',
				'referrer_id' 				=> $order_number,
				'referrer_value' 			=> $order_number,
				'user_id' 					=> user('user_id'),
				'status' 					=> 'success'
			);
			record_event($event);
			echo json_encode(array('success' => 1));
		}
		else
		{
			echo json_encode(array('fail' => 1));
		}
	}
	/**
	 * Create and Update Invoice 
	 * @return type mixed
	 */
	public function create_order()
	{
		// Assign the Mmanager Object
		$m = $this->m;
		
		$user_language 			= get_option('user_language', 'users_options');
		$default_duedate 		= get_option('default_duedate');

		$order_number 			= $this->input->post('order_number'); // Invoice number fetchs the hidden order number (auto increment), not formatted (with prefix)
		$order_key 				= $this->input->post('order_number'); // Invoice number fetchs the hidden order number (auto increment), not formatted (with prefix)
		$is_credit_note 		= $this->input->post('is_credit_note');
		$initial_order_number 	= $this->input->post('initial_order_number');
		$order_status 			= $this->input->post('order_status'); // The order status, to see if is marked paid, draft and so on.
		$date 					=  $this->input->post('date'); // Issued date
		$due_date 				= $this->input->post('due_date'); // Invoice due date
		$subtotal 				= round( $this->input->post('subtotal'), 2); // Invoice subtotal
		$tax_amount 			= round( $this->input->post('tax_amount'), 2); // Total tax applied if any.
		$global_discount 		= round($this->input->post('global_discount'), 2); // Is there a global discount precentage ?
		$discount_amount 		= round( $this->input->post('discount_amount'), 2); // The discount amount
		$amount 				= round( $this->input->post('totalAftertax'), 2); // Total with all taxes applied
		$total 					= round( $this->input->post('total'), 2); // Invoice final value after taxes and discount if any
		$new_payment 			= null !== $this->input->post('new_payment') ? $this->input->post('new_payment'): 0; // Is there any partial payment ?
		$credit_used 			= null !== $this->input->post('client_credit') ? $this->input->post('client_credit'): 0; // Does customer have credit used to pay order ?
		$amount_paid 			= round( $this->input->post('amountPaid') + $new_payment + $credit_used, 2); // partial or total payment
		$sent 					= $this->input->post('notify_client') == 1 ? 'yes': 'no'; // Is order sent to customer ?
		$amount_due 			= $total - $amount_paid; // Remaining amount to pay if partial or total payment
		$payment_fees 			= round($this->input->post('payment_fees'), 2); // Is there a payment fee, paypal fee for example ?
		$charges_sku 			= $this->input->post('charges_sku'); // If payment fee, get its identifier
		$notes 					= $this->input->post('notes'); // is there notes
		$external_number 		= $this->input->post('subject'); // Input field should be named $external_number, but database has unused subjet field. So let's use it
		$client_id 				= $this->input->post('client_id'); // Customer ID, value will be 0 if guest (non registered customer)
		$payment_method 		= null === $this->input->post('payment_method') ? get_option('default_payment_method') :$this->input->post('payment_method'); // If null, default payment method will be used.
		$transaction_id 		= null === $this->input->post('transaction_id') ? time() : $this->input->post('transaction_id'); // If null, time function is used to generate unique ID
		$item_sku 				= $this->input->post('itemSku'); // Array of all items purhased sku.
		$specific_serial_number = $this->input->post('itemSN'); // Array of all items purhased sku.
		$item_id 				= $this->input->post('itemID'); // Array of all items purhased ID. If not registered before order, ID on creation will be 0, then updated on edit based on item name
		$item_name 				= $this->input->post('itemName'); // Array of all items purhased names

		// Indian Invoice additionnal vars

		// Get the change rate if multicurrency is enabled
		$currency = $client_id == 0 ? get_option('user_currency') : client($client_id, 'client_currency');
		$change_rate = _has_option('change_currency') ? get_change_rate( $currency ) : 1;

		$date = mysqlDate( $user_language, $date );
		$due_date = mysqlDate( $user_language, $due_date );
		// Data that will be saved in orders table
		$orderTable 								= []; // All data that will be saved on oc_orders
		$orderTable['change_rate'] 					= $change_rate; // Save change_rate for reference
		$orderTable['user_id'] 						= $m->getUserID();
		$orderTable['order_number'] 				= $order_number;
		$orderTable['order_key'] 					= $order_key;
		$orderTable['payment_method'] 				= $payment_method;
		$orderTable['transaction_id'] 				= $transaction_id;
		$orderTable['order_status'] 				= $order_status;
		$orderTable['client_id'] 				    = $client_id;
		$orderTable['date'] 						= $date;
		$orderTable['due_date'] 					= $due_date;
		$orderTable['subtotal'] 					= $subtotal;
		$orderTable['tax_amount'] 					= $tax_amount;
		$orderTable['global_discount'] 				= $global_discount;
		$orderTable['discount_amount'] 				= $discount_amount;
		$orderTable['total'] 						= $total;
		$orderTable['notes'] 						= $notes;
		$orderTable['subject'] 						= $external_number;
		$orderTable['amount_paid']					= $amount_paid;
		$orderTable['amount_due']					= $amount_due;
		$orderTable['credit_used']					= $credit_used;
		$orderTable['sent']							= $sent; // Set Invoice to sent or not
		$itemTable 									= []; // Data that will be saved in oc_orderitems table
		$itemTable['amount']						= $amount;
		$itemTable['item_sku']						= $item_sku;
		$itemTable['specific_serial_number']		= $specific_serial_number;
		$itemTable['item_id']						= $item_id;
		$itemTable['item_name']						= $item_name;
		$itemTable['client_id']						= $client_id;
		$itemTable['user_id']						= $m->getUserID();
		$itemTable['notes']							= $notes;


		remove_credit($client_id, $credit_used); // If client_id && client_credit used

		$client_language = client($client_id, 'client_language');
		# Insert the paid date if any transaction found
		if( $new_payment && $new_payment > 0 )
		{
			// Record transaction
			$db_data = array(
				'payment_method'		=> $payment_method, 
				'payment_reference'		=> $transaction_id,
				'payment_amount'		=> $new_payment,
				'date_paid'				=> $this->current_date,
				'order_number'			=> $order_number, 
				'payment_note'		    => "",
				'user_id'				=> $m->getUserID()
			);
			record_transaction($db_data);
		}
		// Update all values if user set the order to Paid
		if ($order_status === "Paid" OR $amount_due <= 0)
		{
			$last_amount_paid = get_order_vars($order_number, 'amount_paid');
			if ($last_amount_paid > 0)
			{
				// Record transaction
				$db_data = array(
					'payment_method'		=> $payment_method, 
					'payment_reference'		=> $transaction_id,
					'payment_amount'		=> $total - $last_amount_paid,
					'date_paid'				=> $this->current_date,
					'order_number'			=> $order_number, 
					'payment_note'		    => "",
					'user_id'				=> $m->getUserID()
				);
				record_transaction($db_data);
			} else {
				// Record transaction
				$db_data = array(
					'payment_method'		=> $payment_method, 
					'payment_reference'		=> $transaction_id,
					'payment_amount'		=> $total,
					'date_paid'				=> $this->current_date,
					'order_number'			=> $order_number, 
					'payment_note'		    => "",
					'user_id'				=> $m->getUserID()
				);
				record_transaction($db_data);
			}
			$orderTable['date_paid'] = $this->current_date;
			$orderTable['amount_paid'] = $total;
			$orderTable['amount_due'] = 0;
			$item_paid_date = $this->current_date;
			$orderTable['order_status'] = "Paid";
		}
		// Update order to paid if amount due is less or equal to 0
		if ($amount_due <= 0)
		{
			$order_status = "Paid";
			$orderTable['date_paid'] = $this->current_date;
			$amount_paid = $total;
			$item_paid_date = $this->current_date;
		}

		// Set Invoice to Unpaid if client notification is set to 'yes'
		if($sent === 'yes' && $order_status === "Draft")
		{
			$orderTable['order_status'] = "Pending";
		}
		if (1 == $this->input->post('add_to_client_credit')) {
			$orderTable['credit_is_added'] = 1;
		}
		// Get array fields for validation
		$ids = $this->input->post('itemID');
		$names = $this->input->post('itemName');
		$quantity = $this->input->post('itemQuantity');
		$price = $this->input->post('itemPrice');

		if(!empty($names))
		{
        // Loop through $names and add the validation
			foreach($names as $key => $value)
			{
				$this->form_validation->set_rules('itemName[' . $key . ']', 'lang:item_name', 'required',
					array(
						'required' => lang('error_required_name') . '<br />'
						)
					);
			}
		}
		if(!empty($quantity))
		{
        // Loop through quantity and add the validation
			foreach($quantity as $key => $value)
			{
				$this->form_validation->set_rules('itemQuantity[' . $key . ']', 'lang:item_quantity', 'required',
					array(
						'required' => lang('error_required_quantity') . '<br />'
						)
					);
			}
		}

		if(!empty($price))
		{
        // Loop through price and add the validation
			foreach($price as $key => $value)
			{
				$this->form_validation->set_rules('itemPrice[' . $key . ']', 'lang:item_price', 'required',
					array(
						'required' => lang('error_required_price') . '<br />'
						)
					);
			}
		}
		if ( $this->form_validation->run() === FALSE )
		{
			$this->response = array('status' => 0, 'error' => validation_errors() );
		}
		else
		{
			if ($this->input->post('order_id'))
			{
				$id = $this->input->post('order_id');
				delete('orders_items', 'order_number', $id);
				$orderTable['user_id'] = $this->input->post('user_id');

				$this->orders->set_table('orders');
				$this->orders->save($orderTable, $id);
				
				$event = array(
					'action' 					=> 'update',
					'referrer' 					=> 'orders',
					'referrer_id' 				=> $id,
					'referrer_value' 			=> $order_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
				if ($order_status == 'Refunded' && 0 == $is_credit_note)
				{
					mark_refunded($id, $amount_paid);
					$event = array(
						'action' 					=> 'refunded',
						'referrer' 					=> 'orders',
						'referrer_id' 				=> $id,
						'referrer_value' 			=> $order_number,
						'user_id' 					=> user('user_id'),
						'status' 					=> 'success'
					);
					record_event($event);
				}
				if ($order_status == 'Refunded' && 1 == $is_credit_note && 0 != $initial_order_number)
				{
					$event = array(
						'action' 					=> 'refunded',
						'referrer' 					=> 'orders',
						'referrer_id' 				=> $id,
						'referrer_value' 			=> $order_number,
						'user_id' 					=> user('user_id'),
						'status' 					=> 'success'
					);
					$item_paid_date = $this->current_date;
					record_event($event);
					update_transaction($id, $subtotal, $tax_amount);
					if (1 == $this->input->post('add_to_client_credit') && 0 == $this->input->post('credit_is_added')) {
						refund($client_id, $amount_due);
					}
				}
			}
			else
			{
				$this->orders->set_table('orders');
				$this->orders->save($orderTable);
				$event = array(
					'action' 					=> 'add',
					'referrer' 					=> 'orders',
					'referrer_id' 				=> $this->db->insert_id(),
					'referrer_value' 			=> $order_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
			}

			// Record charges
			if ($order_status == "Paid" && ! refunded_order($order_number))
			{
				$db_data = array(
					'charges_name' 		=> __('label_payment_fees'),
					'charges_category' 	=> 7,
					'charges_value'	    => $payment_fees,
					'charges_sku'	    => $charges_sku,
					'incomes_name'	    => __('incomes_sales_services_goods'),
					'incomes_sku'	    => generate_sku(),
					'incomes_category'	=> 1,
					'incomes_value'	    => $subtotal,
					'payment_method'    => $payment_method,
					'turnover_included'	=> 1,
					'taxes'             => $tax_amount,
					'created_on' 	    => $this->current_date,
					'order_number'    => $order_number,
					'user_id'			=> $m->getUserID()
					);
				record_charges($db_data, 'order_number', isset($id) ? $id: null);
				$event = array(
					'action' 					=> 'paid',
					'referrer' 					=> 'orders',
					'referrer_id' 				=> isset($id) ? $id: $order_number,
					'referrer_value' 			=> $order_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
			}

			// Insert Items in database
			$items_num = count( array_filter( $this->input->post('itemName')) ); // Get number of items, strip empty lines
			$item_sku = $this->input->post('itemSku');
			$specific_serial_number = $this->input->post('itemSN');
			$item_id = $this->input->post('itemID');
			$item_name  = array_filter( $this->input->post('itemName') );
			$item_quantity = array_filter( $this->input->post('itemQuantity') );
			$item_price  = array_filter( $this->input->post('itemPrice') );
			$item_discount = $this->input->post('itemDiscount');
			$item_tax_rate = $this->input->post('itemTax');
			$available = $this->input->post('available');
			$picked = $this->input->post('picked');
			$picked_on = $this->input->post('picked_on');
			// Indan Vars
			$item_hsn_sac  = $this->input->post('itemHSNSAC');
			$item_uom  = $this->input->post('itemUom');
			$item_cgst_tax_rate = $this->input->post('itemTaxCGST');
			$item_sgst_tax_rate = $this->input->post('itemTaxSGST');
			$item_igst_tax_rate = $this->input->post('itemTaxIGST');
			$item_cess_tax_rate = $this->input->post('itemTaxCESS');

			$item_cgst_amount = $this->input->post('itemTaxAmountCGST');
			$item_sgst_amount = $this->input->post('itemTaxAmountSGST');
			$item_igst_amount = $this->input->post('itemTaxAmountIGST');
			$item_cess_amount = $this->input->post('itemTaxAmountCESS');

			$item_subtotal = array_filter( $this->input->post('itemSubTotal') );
			$client_id = $client_id;
			
			if ($order_status == "Cancelled" || $order_status == 'Refunded' && 1 == $is_credit_note)
			{
				$order_is_cancelled = 1;
			}
			else
			{
				$order_is_cancelled = 0;
			}

			$orders_items = $this->tables['orders_items'];
			$this->orders->set_table('orders_items');
			for($i = 0; $i < $items_num; $i++){
				$item_array = array(
					'order_number' => $order_number,
					'order_key' => $order_key,
					'client_id' => $client_id,
					'user_id' => $m->getUserID(),
					'item_sku' => $item_sku[$i],
					'specific_serial_number' => $specific_serial_number[$i],
					'item_id' => $item_id[$i],
					'item_group' => $this->m_manager->category_id($item_id[$i]),
					'item_name' => addslashes($item_name[$i]),
					'item_hsn_sac' => $item_hsn_sac[$i],
					'item_uom' => $item_uom[$i],
					'item_price' => $item_price[$i],
					'item_discount' => $item_discount[$i],
					'item_quantity' => $item_quantity[$i],
					'item_subtotal' => $item_subtotal[$i],
					'item_tax_rate' => $item_tax_rate[$i],
					'item_cgst_rate' => $item_cgst_tax_rate[$i],
					'item_sgst_rate' => $item_sgst_tax_rate[$i],
					'item_igst_rate' => $item_igst_tax_rate[$i],
					'item_cess_rate' => $item_cess_tax_rate[$i],
					'item_cgst_amount' => $item_cgst_amount[$i],
					'item_sgst_amount' => $item_sgst_amount[$i],
					'item_igst_amount' => $item_igst_amount[$i],
					'item_cess_amount' => $item_cess_amount[$i],
					'order_is_cancelled' => $order_is_cancelled,
					'available' => isset($available[$i]) ? $available[$i] : 0,
					'picked' => isset($picked[$i]) ? $picked[$i] : 0,
					'picked_on' => isset($picked_on[$i]) ? $picked_on[$i]: null,
					'date_paid' => isset($item_paid_date) ? $item_paid_date : null 
					);
				if ($this->input->post('order_id'))
				{
					$item_array['user_id'] = $this->input->post('user_id');
				}
				$this->orders->save($item_array);
				$this->response = array('status' => 1);
			}
			// End insert items
			
			// Since 1.5 Add Item to database if not found in autocomplete
			for($i = 0; $i < $items_num; $i++){
				if ( !item_exists($item_name[$i]) )
				{
					$new_item_array = array(
						'sku' => null !== $item_sku[$i] ? $item_sku[$i]: generate_sku(),
						'specific_serial_number' => json_decode(null !== $specific_serial_number[$i] ? (array)$specific_serial_number[$i]: array()),
						'group_id' => 0,
						'name' => $item_name[$i],
						'price' => $item_price[$i],
						'user_id' => $m->getUserID()
						);
					if ($this->input->post('order_id'))
					{
						$new_item_array['user_id'] = $this->input->post('user_id');
					}
					$this->load->model('products/products_model', 'items');
					$this->items->set_table('items');
					$this->items->save($new_item_array);
				}
			}
			// Do not send email for Draft Invoices or on update
			if ( $orderTable['order_status'] !== 'Draft' && $orderTable['order_status'] !== 'Refunded' && $client_id > 0 && $this->input->post('notify_client') == 1 )
			{
				$data = array(
					'order_url'			 => base_url('index.php/vieworder/view?id=') . _eID($order_number),
					'to_name'            => html_entity_decode(htmlentities((client( $client_id, 'name_company' )))),
					'date'		    	=> _fdate( $client_language, $date ),
					'shipping_date'		    => _fdate( $client_language, $due_date),
					'order_status'	=> __( strtolower( $orderTable['order_status'] ), $client_id ),
					'order_number' 	=> get_option('order_prefix').invoice_number_format() . sprintf("%04s", $order_number),
					'transaction_id' 	=> isset($transaction_id) ? $transaction_id: '',
					'ordersubject'	=> $external_number
					);
				$data['client_account'] = base_url('index.php/client/index?id=') . _eID($client_id);
				$data['btn_client_account'] = __( 'btn_client_account', $client_id );
				$data['logo_url'] = base_url('uploads/admin/img/'). get_option('logo');
			
				$data['order_amount'] = add_currency( format_number($total * $change_rate), $client_id );

				if ($orderTable['order_status'] === "Paid" OR $orderTable['amount_due'] <= 0)
				{
					$last_amount_paid = get_order_vars($order_number, 'amount_paid');
					if ($last_amount_paid > 0)
					{
						$data['amount_paid'] = add_currency( format_number($amount_due * $change_rate), $client_id );
						$data['amount_due'] = add_currency( format_number(0), $client_id );
					}
				}
				else
				{
					$data['amount_paid'] = add_currency( format_number($orderTable['amount_paid'] * $change_rate), $client_id );
					$data['amount_due'] = add_currency( format_number($orderTable['amount_due'] * $change_rate), $client_id );
				}
				$this->load->helper('file');
				$lang = lang_code_to_notif_string( $client_language );
				$path_new_order = './notifications/' . $lang . '/orders/new_order.php';
				$path_shipped_order = './notifications/' . $lang . '/orders/order_shipped.php';

				$to = client( $client_id, 'client_email' );
				$template = ($order_status === "Shipped") ? read_file($path_shipped_order):
				read_file($path_new_order);
				$subject = ($order_status === "Shipped") ? __('subject_order_shipped_notification', $client_id) : __('subject_order_placed', $client_id);
				$message = ($order_status === "Shipped") ? 
				$this->parser->parse_string($template, $data, true) : 
				$this->parser->parse_string($template, $data, true);

				if ($client_id) {
					$client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
					if (1 == get_option('attach_pdf_to_invoice')) {
						generate_pdf_file('orders', $order_number);
					}
				}

				if ( ! _has_option('turn_off_customer_so_emails')) {
					send_email($to, $message, $subject, null, $client_cc, FCPATH.'uploads/pdf/orders/'.$order_number.'.pdf', get_option('order_prefix').invoice_number_format() . sprintf("%04s", $order_number).'.pdf');
				}

				$event = array(
					'action' 					=> 'order_sent',
					'referrer' 					=> 'orders',
					'referrer_id' 				=> $order_number,
					'referrer_value' 			=> $order_number,
					'client_id' 				=> $client_id,
					'status' 					=> 'success'
				);
				record_event($event);
			}
			if ( $orderTable['order_status'] == 'Refunded' && $client_id > 0 && $this->input->post('notify_client') == 1 )
			{
				$data = array(
					'order_url'		=> base_url('index.php/vieworder/view?id=') . _eID($order_number),
					'to_name'            => html_entity_decode(htmlentities((client( $client_id, 'name_company' )))),
					'date'		    	=> _fdate( $client_language, $date ),
					'due_date'		    => _fdate( $client_language, $due_date),
					'order_status'	=> __( strtolower( $orderTable['order_status'] ), $client_id ),
					'order_number' 	=> get_option('order_prefix').invoice_number_format() . sprintf("%04s", $order_number),
					'transaction_id' 	=> isset($transaction_id) ? $transaction_id: '',
					'ordersubject'	=> $external_number
					);
				$data['client_account'] = base_url('index.php/client/index?id=') . _eID($client_id);
				$data['btn_client_account'] = __( 'btn_client_account', $client_id );
				$data['logo_url'] = base_url('uploads/admin/img/'). get_option('logo');
			
				$data['order_amount'] = add_currency( format_number($total * $change_rate), $client_id );
				$data['amount_refunded'] = add_currency( format_number( $total * $change_rate ), $client_id );
				$data['amount_paid'] = add_currency( format_number($orderTable['amount_due'] * $change_rate), $client_id );
				$data['amount_due'] = add_currency( format_number(0), $client_id );

				$this->load->helper('file');
				$lang = lang_code_to_notif_string( $client_language );
				$path_refunded_order 		= './notifications/' . $lang . '/invoices/invoice_refunded.php';

				$to = client( $client_id, 'client_email' );
				$template 	= read_file( $path_refunded_order );
				$subject 	= __( 'subject_payment_refunded', $client_id );

				$message 	= $this->parser->parse_string($template, $data, true);
				if ($client_id) {
					$client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
					if (1 == get_option('attach_pdf_to_invoice')) {
						generate_pdf_file('orders', $order_number);
					}
				}

				if ( ! _has_option('turn_off_customer_so_emails')) { 
					send_email($to, $message, $subject, null, $client_cc, FCPATH.'uploads/pdf/orders/'.$order_number.'.pdf', get_option('order_prefix').invoice_number_format() . sprintf("%04s", $order_number).'.pdf');
				}

				$event = array(
					'action' 					=> 'order_sent',
					'referrer' 					=> 'orders',
					'referrer_id' 				=> $order_number,
					'referrer_value' 			=> $order_number,
					'client_id' 				=> $client_id,
					'status' 					=> 'success'
				);
				record_event($event);
			}
		}
		if (! $this->input->post('order_id')) {
			// Update next invoice ID
			setAccountEntityId('order', get_last_id('orders'));
		}
		echo json_encode($this->response);
	}
}