<?php defined('BASEPATH') OR exit('No direct script access allowed');
use Mmanager\Domain\Factory\InvoiceFactory;
/**
 * 
 */
class Orders extends Admin_Controller {
	/**
	 * @var type
	 */
	protected $_invoice = [];

	/**
	 * @var type
	 */
	protected $_client = [];

	/**
	 * Description
	 * @return type
	 */
	public function __construct(){
		parent::__construct();
		$this->load->model('clients/clients_model', 'clients');
		$this->clients->set_primary_key('client_id');
		$this->load->model('orders_model', 'orders');

		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js',
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
        $this->view_data['modal'] = $this->Template->render('clients', 'add_client_modal.phtml', '', true);
        $this->data['breadcrumb'] = anchor('invoices', __('link_invoices'));
        $this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	
	/**
	 * Description
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type
	 */
	public function index()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('orders', __('link_orders')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_orders'),
			'page_description' 	=> __('message_manage') .' '.__('link_orders'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'filter'			=> 'All'
			);
		if (can_access('invoices')) {
			$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
			$this->view_data['page_header'] = $this->Template->render('orders', 'page_header.phtml', '', true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function credit_notes()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices/credit_notes', __('link_credit_note')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_credit_note'),
			'page_description' 	=> __('message_manage') .' '.__('link_credit_note'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'filter'			=> 'Refunded'
			);
		$this->view_data['page_header'] = $this->Template->render('orders', 'page_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function place_order()
	{
		$data = array(
			'breadcrumb' 		=> anchor('orders', __('link_orders')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_orders'),
			'page_description' 	=> __('link_add_new') .' '.__('label_order'),
			'clients'         	=> clients()
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('orders', 'create_order_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		$id = _dID($_REQUEST['id']);
		$view_data = array(
			'breadcrumb' 		=> anchor('orders', __('link_orders')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_orders'),
			'page_description' 	=> __('message_manage') .' '.__('link_orders'),
			'user_language' => get_option('user_language', 'users_options'),
			'invoices' => get_order_by_number($id),
			'invoiceObj' => new InvoiceFactory,
			'invoice_items' => get_sale_items($id),
			'clients' => json_encode(clients()),
			'payment_fees'  => null !== get_invoice_charges($id) ? get_invoice_charges($id) : floatval(0),
			'charges_sku'  => null !== get_charges_sku($id) ? get_charges_sku($id) : generate_sku(),
			'order_status' => array(
				'Draft' => ucfirst(__('option_draft')),
				'Progress' => ucfirst(__('label_progress')),
				'Awaiting Payment' => ucfirst(__('label_awaiting_payment')),
				'Awaiting Fulfillment' => ucfirst(__('label_awaiting_fulfillment')),
				'Awaiting Shipment' => ucfirst(__('label_awaiting_shipment')),
				'Awaiting Pickup' => ucfirst(__('label_awaiting_pickup')),
				'Partially Shipped' => ucfirst(__('label_partially_shipped')),
				'Completed' => ucfirst(__('label_completed')),
				'Billed' => ucfirst(__('label_billed')),
				'Shipped' => ucfirst(__('label_shipped')),
				'Cancelled' => ucfirst(__('option_cancelled')),
				'Declined' => ucfirst(__('label_declined')),
				'Refunded' => ucfirst(__('label_refunded')),
				'Disputed' => ucfirst(__('label_disputed')),
				'Manual Verification Required' => ucfirst(__('label_manual_verification_required')),
				'Partially Refunded' => ucfirst(__('option_partially_refunded'))
				),
			'pay_type' => array(
				'1' => __('option_once'),
				'2' => __('option_weekly'),
				'3' => __('option_biweekly'),
				'4' => __('option_monthly'),
				'5' => __('option_yearly'),
				'6' => __('option_quarterly'),
				'7' => __('option_half_yearly')
				),
			'payment_history' => get_payment_history($id)
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('orders', 'edit_order_form.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_all()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter'		=> 'All'
			);

		$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_paid()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Paid'
			);

		$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_unpaid()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Unpaid'
			);

		$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_overdue()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Overdue'
			);

		$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_cancelled()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Cancelled'
			);

		$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_refunded()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('invoices', __('link_invoices')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_invoices'),
			'page_description' 	=> __('message_manage') .' '.__('invoices_invoices'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Refunded'
			);

		$this->view_data['content'] = $this->Template->render('orders', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}

	public function delete_order()
	{
		$protected = [];
		$to_del = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (order_status($i) !== 'is_pending' || order_status($i) == 'is_cancelled' || order_status($i) == 'is_declined' || order_status($i) == 'is_declined' )
				{
					array_push($protected, $i);
				}
				else
				{
					array_push($to_del, $i);
				}
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('orders', 'order_number', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function generate_invoices()
	{
		$protected = [];
		$generate_invoices = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (order_status($i) !== 'Shipped')
				{
					array_push($generate_invoices, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($generate_invoices);
			$response['fail'] = count($protected);

			if(!empty($generate_invoices))
			{
				mass_generate_invoices($generate_invoices);
			}
		}
		echo json_encode($response);
	}
	public function generate_picking_list()
	{
		$add_to_list = [];
		$remove_from_list = [];
		$ids = _dID($_REQUEST['id']);

		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				$items = get_sale_items($i);
				if ($items) {
					foreach ($items as $item) {
						if (get_item_service_vars_by_name($item->item_name, 'available') > 0)
						{
							$id = $item->id;

							update_ordered_items($id, array('available' => 1, 'picked' => 1, 'picked_on' => date('Y-m-d h-i-s')));
							update_order($i, array('has_picking_list' => 1));
							setAccountEntityId('picking_list', $i);
							array_push($add_to_list, $item);
						} else {
							array_push($remove_from_list, $item);
						}	
					}
				}
			}
			$response['success']  = count($add_to_list);
			$response['fail']  = count($remove_from_list);
		}
		echo json_encode($response);
	}
	public function mass_orders_email()
	{
		$protected = [];
		$to_send = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (ordered_by_guest($i) > 0)
				{
					array_push($to_send, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_send);
			$response['fail'] = count($protected);

			if(!empty($to_send))
			{
				foreach ($to_send as $order_number) {
					$this->m_manager->send_order_email($order_number);
				}
			}
		}
		echo json_encode($response);
	}
	public function orders_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'id';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : null;

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$orders = $this->orders->findAll(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);
		if ($orders)
		{
			foreach ($orders as $order) {
				$order = (object)$order;
				if ($order->amount_paid > 0 AND $order->order_status == 'Refunded')
				{
					$number_prefix = null == get_option('credit_note_prefix') ? __('credit_note_prefix') . sprintf( "%04s", $order->order_number ) : get_option('credit_note_prefix') . sprintf( "%04s", $order->order_number );
				}
				elseif ($order->order_status == 'Refunded')
				{
					$number_prefix = null == get_option('credit_note_prefix') ? __('credit_note_prefix') . sprintf( "%04s", $order->order_number ) : get_option('credit_note_prefix') . sprintf( "%04s", $order->order_number );
				}
				elseif ($order->amount_paid > 0 AND $order->amount_due > 0 AND $order->order_status !== 'Paid')
				{
					$number_prefix = null == get_option('sale_order_prefix') ? __('sale_order_prefix_short') . sprintf( "%04s", $order->order_number ) : get_option('sale_order_prefix') . sprintf( "%04s", $order->order_number );
				}
				elseif( $order->order_status == 'Expired' || $order->order_status == 'Open' || $order->order_status == 'Pending' || $order->order_status == 'Failed')
				{
					$number_prefix = null == get_option('sale_order_prefix') ? __('sale_order_prefix_short') . sprintf( "%04s", $order->order_number ) : get_option('sale_order_prefix') . sprintf( "%04s", $order->order_number );
				}
				else
				{
					$number_prefix = null == get_option('sale_order_prefix') ? __('sale_order_prefix_short') . sprintf( "%04s", $order->order_number ) : get_option('sale_order_prefix') . sprintf( "%04s", $order->order_number );
				}
				array_push($rows, array(
					'id' 				  => $order->id,
					'client_id'           => _eID($order->client_id),
					'number_prefix'   	  => $number_prefix,
					'order_number'   	  => $order->order_number,
					'enc_order_number'    => _eID($order->order_number),
					'name_company'		  => $order->name_company,
					'date'				  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $order->date ),
					'due_date'			  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $order->due_date ),
					'total'				  => format_number($order->total),
					'amount_due'		  => format_number($order->amount_due),
					'amount_paid'		  => format_number($order->amount_paid),
					'amount_refunded'	  => format_number($order->amount_refunded),
					'order_status'        => order_status_str($order->order_status),
					'stbool'			  => order_status($order->order_number),
					'pay_type'			  => $order->pay_type,
					'has_picking_list'	  => $order->has_picking_list,
					'next_due_date'		  => $order->next_duedate
					)
				);

				if ( $search) {
					$list = array(
						'total' => count($orders),
						'totalNotFiltered' => count($orders),
						'rows' => $rows
					);
				}
				else
				{
					$total = $this->orders->count_rows('orders', $filter);
					$list = array(
						'total' => $total,
						'totalNotFiltered' => $total,
						'rows' => $rows
					);
				}
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function invoice_autocomplete()
	{
		$data = [];
		$results = get_all_items(1);
		if(! empty($results) )
		{
			if (! _has_option('is_indian') )
			{
				foreach($results as $row)
				{
					// $name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id;
					// array_push($data, $name);
					$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
					array_push($data, $name);
				}
			}
			else
			{
				foreach($results as $row)
				{
					$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
					array_push($data, $name);
				}
			}
		}
		echo json_encode($data);
	}
	public function next_order_number()
	{
		echo json_encode(next_order_number());
	}
	public function create_credit_note()
	{
		$protected = [];
		$to_mark_refund = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (order_status($i) == 'is_paid' || order_status($i) == 'is_refunded')
				{
					array_push($to_mark_refund, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_refund);
			$response['fail'] = count($protected);

			if(!empty($to_mark_refund))
			{
				mass_refund('invoices', 'order_number', $to_mark_refund);
			}
		}
		echo json_encode($response);
	}
	public function generate_from_tracker() {
		$order_number = next_order_number();
		$invoice_key = getAccountEntityNextId('invoice');
		$client_id = get_client_id($_REQUEST['client_name']);
		$currency = $client_id == 0 ? get_option('user_currency') : client( $client_id, 'client_currency' );
		$change_rate = _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
		$date = date('Y-m-d');
		$default_duedate = get_option('default_duedate');
		$duedate = date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( $date ) ) );

		$invoice_data = [
			'order_number'		=> $order_number,
			'invoice_key' 			=> $invoice_key,
			'client_id' 			=> get_client_id($_REQUEST['client_name']),
			'subtotal' 				=> $_REQUEST['subtotal'],
			'total' 				=> $_REQUEST['subtotal'],
			'amount_due' 			=> $_REQUEST['subtotal'],
			'tax_amount' 			=> 0,
			'discount_amount' 		=> 0,
			'amount_refunded' 		=> 0,
			'notes' 				=> $_REQUEST['notes'],
			'next_duedate' 			=> null,
			'recurring_from' 		=> null,
			'recurring_to' 			=> null,
			'subject' 				=> null,
			'pay_type' 				=> 1,
			'date' 					=> $date,
			'due_date' 				=> $duedate,
			'order_status' 		=> 'Unpaid',
			'sent' 					=> 'no',
			'change_rate' 			=> $change_rate
		];
		// Set table and save data
		$this->invoices->set_table( 'invoices' );
		$this->invoices->save( $invoice_data );

		$item_data = [
			'order_number' 			=> $order_number,
			'invoice_key' 				=> $invoice_key,
			'client_id' 				=> $client_id,
			'item_sku' 					=> generate_sku(),
			'item_id' 					=> 0,
			'item_name' 				=> $_REQUEST['item_name'],
			'item_price' 				=> $_REQUEST['item_price'],
			'item_quantity' 			=> _durationToHour($_REQUEST['item_quantity']),
			'item_discount' 			=> 0,
			'item_subtotal' 			=> $_REQUEST['subtotal'],
			'item_tax_rate' 			=> 0,
			'item_recurring' 			=> 1,
			'item_uom' 					=> 'hr'
		];

		$this->invoices->set_table('invoices_items');
		$this->invoices->save($item_data);

		// Update next invoice ID
		setAccountEntityId('invoice', $invoice_key);
		echo json_encode(1);
	}
	public function admin_view() {
		$id = _dID($_REQUEST['id']);
		$order = [];
		$item = [];
		$order = get_order_by_number($id);
		$order_items = get_sale_items($id);
		if ($order) {
			foreach ($order as $val) {
				$order = (object)$val;
			}
			foreach ($order_items as $value) {
				$item[] = (object)$value;
			}
			$view_data = array(
				'breadcrumb' 		=> anchor('orders', __('link_orders')),
				'toolbar'    		=> "",
				'page_title' 		=> __('link_orders'),
				'page_description' 	=> __('message_manage') .' '.__('link_orders'),
				'user_language' 	=> get_option('user_language', 'users_options'),
				'filter'			=> 'All',
				'order'				=> $order,
				'item'				=> $item
			);
			if (can_access('invoices')) {
				$this->view_data['content'] = $this->Template->render('orders', 'order_view.phtml', $view_data, true);
			}
			$this->Template->render('templates', 'layout.phtml', $this->view_data);
		} else {
			show_custom404();
		}
	}
	public function reOrder() {
		// Assign the Mmanager Object
		$m = $this->m;

		$order_number = _dID($_REQUEST['order_number']);
		$order = get_order_by_number($order_number);
		$order_items = get_sale_items($order_number);

		$order_key = next_order_number();

		if ($order) {
			foreach ($order as $order) {
				// Get the change rate if multicurrency is enabled
				$currency = $order->client_id == 0 ? get_option('user_currency') : client($order->client_id, 'client_currency');
				$change_rate = _has_option('change_currency') ? get_change_rate( $currency ) : 1;


				$orderTable 								= []; // All data that will be saved on oc_orders
				$orderTable['change_rate'] 					= $change_rate; // Save change_rate for reference
				$orderTable['user_id'] 						= $m->getUserID();
				$orderTable['order_number'] 				= next_order_number();
				$orderTable['order_key'] 					= $order_key;
				$orderTable['order_status'] 				= 'Pending';
				$orderTable['client_id'] 				    = $order->client_id;
				$orderTable['date'] 						= date('Y-m-d');
				$orderTable['due_date'] 					= date('Y-m-d');
				$orderTable['subtotal'] 					= $order->subtotal;
				$orderTable['tax_amount'] 					= $order->tax_amount;
				$orderTable['global_discount'] 				= $order->global_discount;
				$orderTable['discount_amount'] 				= $order->discount_amount;
				$orderTable['total'] 						= $order->total;
				$orderTable['notes'] 						= $order->notes;
				$orderTable['subject'] 						= $order->subject;
				$orderTable['amount_paid']					= 0;
				$orderTable['amount_due']					= $order->total;
				$orderTable['credit_used']					= 0;
				$orderTable['sent']							= 'no'; // Set Invoice to sent or not

				$this->orders->set_table('orders');
				$this->orders->save($orderTable);
				$event = array(
					'action' 					=> 'add',
					'referrer' 					=> 'orders',
					'referrer_id' 				=> $this->db->insert_id(),
					'referrer_value' 			=> $order_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);


				foreach ($order_items as $item) {
					$itemTable 									= []; // Data that will be saved in oc_orderitems table
					$itemTable['order_number']					= $order_key;
					$itemTable['order_key']						= $order_key;
					$itemTable['item_price']					= $item->item_price;
					$itemTable['item_quantity']					= $item->item_quantity;
					$itemTable['item_discount']					= $item->item_discount;
					$itemTable['item_subtotal']					= $item->item_subtotal;
					$itemTable['item_tax_rate']					= $item->item_tax_rate;
					$itemTable['available']						= 0 < get_item_service_vars_by_name($item->item_name, 'available') ? '1' : 0;
					$itemTable['item_uom']						= $item->item_uom;
					$itemTable['item_sku']						= $item->item_sku;
					$itemTable['item_id']						= $item->item_id;
					$itemTable['item_name']						= $item->item_name;
					$itemTable['client_id']						= $item->client_id;
					$itemTable['user_id']						= $m->getUserID();

					$this->orders->set_table('orders_items');
					$this->orders->save($itemTable);
				}
			}
		}
		setAccountEntityId('order', $order_key);
		echo json_encode(array('success' => 1));
	}
}