<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller
{
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('products_model', 'items');
		$this->_primary_key = 'item_id';
		$this->_table = 'items';
	}
	

	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function create_group($id = NULL)
	{
		$post_array = array(
			'group_name'					=> addslashes($this->input->post('group_name')),
			'group_description'				=> $this->input->post('description')
			);
		$config = array(
			array(
                    'field' => 'group_name',
                    'label' => __('label_group_name'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => __('error_required_group').'<br />'
                            )
                )
			);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('group_id');
		$is_modal = $this->input->post('is_modal');

		if ($id === NULL)
		{
			if (!$is_modal)
			{
				$this->items->set_table('items_groups');
				$this->response = ($this->form_validation->run() === TRUE && $this->items->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors());
			}
			else
			{
				$this->items->set_table('items_groups');
				$this->response = ($this->form_validation->run() === TRUE && $this->items->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			}
			echo json_encode($this->response);
		}
		else
		{
			$this->items->set_table('items_groups');
			$this->items->set_primary_key('group_id');
			$this->response = ($this->form_validation->run() == TRUE && $this->items->save($post_array, $id) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			echo json_encode($this->response);
		}
	}

	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function add_product($id=false)
	{
		if ($this->input->post('product_group') != -1)
		{
			$post_array['group_id'] 			= $this->input->post('product_group');
		}
		else
		{
			$post_array['group_id'] = 0;
		}
		if ($this->input->post('tax_id') != -1)
		{
			$post_array['tax_id'] 			= $this->input->post('tax_id');
		}
		$post_array['sku'] 					= $this->input->post('product_sku');
		$post_array['product_ean13'] 		= strlen($this->input->post('product_ean13')) >= 13 ? substr($this->input->post('product_ean13'), 0, -1): $this->input->post('product_ean13');
		$post_array['name'] 				= addslashes(str_replace('|', '/', $this->input->post('product_name')));
		$post_array['description'] 			= $this->input->post('product_description');
		$post_array['product_mpn'] 			= $this->input->post('product_mpn');
		$post_array['serial_number'] 		= (! empty($this->input->post('serial_number'))) ? json_encode($this->input->post('serial_number')) : json_encode([]);
		$post_array['price'] 				= $this->input->post('product_price');
		$post_array['purchase_price'] 		= $this->input->post('purchase_price');
		$post_array['item_profit'] 			= $this->input->post('item_profit');
		$purchase_price 		            = isset($post_array['purchase_price']) ? $post_array['purchase_price']: 0;
		$post_array['provider_name'] 		= $this->input->post('provider_name');
		$post_array['provider_contact'] 	= $this->input->post('provider_contact');
		$post_array['track_inventory'] 	    = null == $this->input->post('track_inventory') ? 0 : 1;
		$post_array['has_qrcode'] 	    	= null == $this->input->post('has_qrcode') ? 0 : 1;
		$post_array['has_barcode'] 	    	= null == $this->input->post('has_barcode') ? 0 : 1;
		$post_array['reorder_point'] 	    = $this->input->post('reorder_point');
		$item_status	                    = $this->input->post('item_status');
		$post_array['item_status']          = isset($item_status) ? $item_status : 1;
		$post_array['initial_stock'] 		= $this->input->post('initial_stock');
		$post_array['uom_id'] 				= $this->input->post('uom_id');
		$post_array['hsn_sac_id'] 			= $this->input->post('hsn_sac_id');
		$post_array['sgst_id'] 				= $this->input->post('sgst_id');
		$post_array['cgst_id'] 				= $this->input->post('cgst_id');
		$post_array['igst_id'] 				= $this->input->post('igst_id');
		$post_array['cess_id'] 				= $this->input->post('cess_id');
		$config = array(
                array(
                        'field' => 'product_name',
                        'label' => __('label_name'),
                        'rules' => 'required',
                        'errors' => array(
                        'required' => __('error_required_name').'<br />'
                        ),
                ),
                array(
                        'field' => 'product_sku',
                        'label' => __('label_sku'),
                        'rules' => 'required',
                        'errors' => array(
                        'required' => __('error_required_sku').'<br />'
                        ),
                ),
                array(
                        'field' => 'product_description',
                        'label' => __('label_description'),
                        'rules' => ''
                ),
                array(
                        'field' => 'product_price',
                        'label' => __('label_price'),
                        'rules' => 'required',
                        'errors' => array(
                        'required' => __('error_required_price').'<br />',
                        ),
                )
        	);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('item_id');
		if (!$id)
		{
			$post_array['on_hand_stock'] 		= $this->input->post('initial_stock');
			$post_array['available'] 		    = $this->input->post('initial_stock');
			if (null != $this->input->post('purchase_price'))
			{
				$post_array['initial_cost'] 		= floatval(floatval($this->input->post('initial_stock')) * floatval($this->input->post('purchase_price')));
				$post_array['valuation'] 		    = floatval(floatval($this->input->post('initial_stock')) * floatval($this->input->post('purchase_price')));
			}
			$this->items->set_table('items');
			$db_data = array(
				'charges_name' 		=> $post_array['name'],
				'charges_category' 	=> __('charges_purchases'),
				'charges_value'	    => floatval(0),
				'created_on' 	    => 'NOW()',
				'item_sku'			=> $post_array['sku']
				);
			record_charges($db_data);

			// Record QR Code
			if ($post_array['has_qrcode']) {
				// Set QR Code file name to item ID for database insertion
				$post_array['qrcode'] = get_next_id('items').'_'. time().'.png';

				// here our data 
			    $itemSku = $post_array['sku'];
			    $itemName = $post_array['name'];
			    $itemPrice = add_currency($post_array['price']);
			    $itemDescription = $post_array['description'];
			    $contactName = get_option('company'); 
			    $contactPhone = get_option('phone'); 
			    $contactEmail = get_option('email'); 
			    // we building raw data 
			    $codeContents  = "\n"; 
			    $codeContents .= __('label_sku').': '.$itemSku."\n"; 
			    $codeContents .= __('label_name').': '.$itemName."\n"; 
			    $codeContents .= __('label_price'). ': '.$itemPrice."\n"; 
			    $codeContents .= __('label_description'). ': '.$itemDescription; 
			    $codeContents .= "\n";
			    $codeContents .= "\n". __('message_intered_in_our_products'). ' '.__('label_contact_us')."\n";
		        // we building raw data 
		        $codeContents .= $contactName."\n"; 
		        $codeContents .= __('label_phone'). ': '.$contactPhone."\n"; 
		        $codeContents .= __('label_email'). ': '.$contactEmail."\n"; 
		        $codeContents .= "\n"; 

				generateQrcode(get_next_id('items').'_'. time(), $codeContents);
			}
			if ($post_array['has_barcode']) {
				// Set Barcode file name to item ID for database insertion
				$post_array['barcode'] = get_next_id('items').'_'. time().'.png';

				if (null == $post_array['product_ean13']) {
					// Generate QR Code with default params
					$Barcode_data = $post_array['sku'];
					$Barcode_data .= "-";
					$Barcode_data .= $post_array['name'];
					generateBarcode(get_next_id('items').'_'. time(), formatBarCodeOutput($Barcode_data));
				} else {
					// Generate QR Code with default params
					$Barcode_data = $post_array['product_ean13'];
					generateBarcode(get_next_id('items').'_'. time(), $Barcode_data, true);
				}
			}
			$this->response = ($this->form_validation->run() === TRUE && $this->items->save($post_array) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors());
			echo json_encode($this->response);
		}
		else
		{
			$this->items->set_table('items');
			$this->items->set_primary_key('item_id');
			// Record QR Code
			if ($post_array['has_qrcode']) {
				// Set QR Code file name to item ID for database insertion
				$post_array['qrcode'] = $id.'_'. time().'.png';
				// Generate QR Code with default params
				// here our data 
			    $itemSku = $post_array['sku'];
			    $itemName = $post_array['name'];
			    $itemPrice = add_currency($post_array['price']);
			    $itemDescription = $post_array['description'];
			    $contactName = get_option('company'); 
			    $contactPhone = get_option('phone'); 
			    $contactEmail = get_option('email'); 
			    // we building raw data 
			    $codeContents  = "\n"; 
			    $codeContents .= __('label_sku').': '.$itemSku."\n"; 
			    $codeContents .= __('label_name').': '.$itemName."\n"; 
			    $codeContents .= __('label_price'). ': '.$itemPrice."\n"; 
			    $codeContents .= __('label_description'). ': '.$itemDescription; 
			    $codeContents .= "\n";
			    $codeContents .= "\n". __('message_intered_in_our_products'). ' '.__('label_contact_us')."\n";
		        // we building raw data 
		        $codeContents .= $contactName."\n"; 
		        $codeContents .= __('label_phone'). ': '.$contactPhone."\n"; 
		        $codeContents .= __('label_email'). ': '.$contactEmail."\n"; 
		        $codeContents .= "\n";

				generateQrcode($id.'_'. time(), $codeContents);
			}
			if ($post_array['has_barcode']) {
				// Set Barcode file name to item ID for database insertion
				$post_array['barcode'] = $id.'_'. time().'.png';

				if (null == $post_array['product_ean13']) {
					// Generate QR Code with default params
					$Barcode_data = $post_array['sku'];
					$Barcode_data .= "-";
					$Barcode_data .= $post_array['name'];
					generateBarcode($id.'_'. time(), formatBarCodeOutput($Barcode_data));
				} else {
					// Generate QR Code with default params
					$Barcode_data = $post_array['product_ean13'];
					generateBarcode($id.'_'. time(), $Barcode_data, true);
				}
			}
			$this->response = ($this->form_validation->run() == TRUE && $this->items->save($post_array, $id) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			$this->items->update_invoiced_items_group($id, $post_array['group_id']);
			echo json_encode($this->response);
		}
	}
	public function batch_update()
	{
		$db_data = $_REQUEST['db_data'];

		$post_array['sku'] 					= $db_data['sku'];
		$post_array['name'] 				= $db_data['name'];
		$post_array['price'] 				= $db_data['price'];
		$post_array['purchase_price'] 		= $db_data['purchase_price'];

		$id = $_REQUEST['item_id'];
		$this->items->set_table('items');
		$this->items->set_primary_key('item_id');
		$this->response = ($this->items->save($post_array, $id) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
		$this->items->update_invoiced_items_group($id, $post_array['group_id']);
		echo json_encode($this->response);
	}
	public function update_stock()
	{
		$id = $this->input->post('pk');
		$name = $this->input->post('name');
		$value = $this->input->post('value');
		$post_array[$name] 		= $value;
		$this->items->set_table('items');
		$this->items->set_primary_key('item_id');
		$this->response = ($this->items->save($post_array, $id) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
		echo json_encode($this->response);
	}
	public function add_hsn_sac()
	{
		$post_array = array(
			'hsn_sac_group'				=> $this->input->post('hsn_sac_group'),
			'hsn_sac_value'				=> $this->input->post('hsn_sac_value'),
			'hsn_sac_description'		=> $this->input->post('hsn_sac_description')
			);
		record_hsn_sac($post_array);
		echo json_encode( array('status' => 1) );
	}
	public function add_uom()
	{
		$post_array = array(
			'uom_value'					=> $this->input->post('uom_value'),
			'uom_description'		    => $this->input->post('uom_description')
			);
		record_uom($post_array);
		echo json_encode( array('status' => 1) );
	}
	public function add_cgst()
	{
		$post_array = array(
			'cgst_rate'						=> $this->input->post('cgst_rate'),
			'cgst_description'		    	=> $this->input->post('cgst_description')
			);
		record_cgst($post_array);
		echo json_encode( array('status' => 1) );
	}
	public function add_sgst()
	{
		$post_array = array(
			'sgst_rate'						=> $this->input->post('sgst_rate'),
			'sgst_description'		    	=> $this->input->post('sgst_description')
			);
		record_sgst($post_array);
		echo json_encode( array('status' => 1) );
	}
	public function add_igst()
	{
		$post_array = array(
			'igst_rate'						=> $this->input->post('igst_rate'),
			'igst_description'		    => $this->input->post('sgst_description')
			);
		record_igst($post_array);
		echo json_encode( array('status' => 1) );
	}
	public function add_cess()
	{
		$post_array = array(
			'cess_rate'						=> $this->input->post('cess_rate'),
			'cess_description'		    	=> $this->input->post('cess_description')
			);
		record_cess($post_array);
		echo json_encode( array('status' => 1) );
	}
}