<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Products extends Admin_Controller {
	/**
	 * Description
	 * @return type
	 */

	public function __construct(){
		parent::__construct();
		$this->load->model('products_model', 'items');
		$this->view_data['pageJs'] = array(
            'products.js',
            'taxes.js',
        );
        $this->view_data['modal'] = array(
	    	$this->Template->render('products', 'add_group_modal.phtml', '', true),
	    	$this->Template->render('providers', 'add_provider_modal.phtml', '', true),
	    	$this->Template->render('products', 'show_qrcode_barcode_modal.phtml', '', true),
    	);
    	$this->data['breadcrumb'] = anchor('products', __('link_items'));
    	$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}

	/**
	 * Description
	 * @param type|string $a 
	 * @param type|null $id 
	 * @return type
	 */
	public function add_product()
	{
		$data = array(
			'breadcrumb' 		=> anchor('products', __('link_items')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_items'),
			'page_description' 	=> __('link_add_new') .' '.__('items_item'),
			'providers' => providers()
			);
		$this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
        $this->view_data['page_header'] = $this->Template->render('products', 'page_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('products', 'add_product_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		$this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$id = isset($_REQUEST['id']) ?  $_REQUEST['id'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('products', __('link_items')),
			'toolbar'    		=> "",
			'page_title' 		=> __('items_items'),
			'page_description' 	=> __('message_manage') . ' ' . __('items_item'),
			'groups' => $this->products_groups(),
			'providers' => providers(),
			'uoms'		=> get_uom(),
			'hsn_sac'			=> get_hsn_sac(),
			'cgst'			=> get_cgst(),
			'sgst'			=> get_sgst(),
			'igst'			=> get_igst(),
			'cess'			=> get_cess(),
			'items'			=> $this->items->get_item($id), // with join clauses
			'item_status' => array(
				'1' => __('label_available'),
				'0' => __('label_out_of_stock')
				)
			);
		$this->view_data['page_header'] = $this->Template->render('products', 'page_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('products', 'edit_product_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit_group()
	{
		$id = isset($_REQUEST['id']) ?  $_REQUEST['id'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('products', __('link_items')),
			'toolbar'    		=> "",
			'page_title' 		=> __(''),
			'page_description' 	=> __(''),
			'groups'	=> $this->items->get_group($id)
			);
		$this->view_data['content'] = $this->Template->render('products', 'edit_category_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function index($a = '', $id = NULL)
	{
		$data = array(
			'breadcrumb' 		=> anchor('products', __('link_items')),
			'toolbar'    		=> "",
			'page_title' 		=> __('items_items'),
			'page_description' 	=> __('message_manage') . ' ' . __('items_items'),
			'items' 			=> array(),
			'filter' 			=> 'All'
			);
		if (can_access('items')) {
			$this->view_data['content'] = $this->Template->render('products', 'index.phtml', $data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}

	/**
	 * Description
	 * @return type
	 */
	public function get_products_groups()
	{
		echo json_encode($this->items->get_products_groups());
	}
	public function generate_sku()
	{
		echo json_encode(generate_sku());
	}
	public function products_groups()
	{
		return $this->items->get_products_groups();
	}
	public function delete_item()
	{
		$protected = [];
		$to_del = [];
		$ids = $_REQUEST['id'];
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (!is_invoiced($i))
				{
					array_push($to_del, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('items', 'item_id', $to_del);
			}
		}
		echo json_encode($response);
	}
	
	// Since 2.2.4
	public function get_items_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$status = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'asc';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'name';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : null;

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$items = $this->items->findAll(
			array(
				'status' => $status,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination,
				'is_service' => 0
			)
		);
		if ($items)
		{
			foreach ($items as $item) {
				if (null !== $item->qrcode OR null !== $item->barcode) {
					$hasqrbar = 1;
				} else {
					$hasqrbar = 0;
				}
				array_push($rows, array(
					'item_id' 			  => $item->item_id,
					'sku'           	  => $item->sku,
					'name'   	 		  => $item->name,
					'mpn'   	 		  => $item->product_mpn,
					'group_name' 		  => $item->group_name,
					'group_id' 		  	  => $item->group_id,
					'price'		  		  => format_number($item->price),
					'tax_percent'		  => $item->tax_percent,
					'item_status'         => $item->item_status,
					'qrcode'         	  => $item->qrcode,
					'barcode'         	  => $item->barcode,
					'hasqrbar'         	  => $hasqrbar,
					'item_status_str'     => '0.00' !== $item->current_stock ? $item->current_stock .'&nbsp;' .item_status_str($item->item_status) : '' .'&nbsp;' .item_status_str($item->item_status)
					)
				);
			}

			if ( $search) {
				$list = array(
					'total' => count($items),
					'totalNotFiltered' => count($items),
					'rows' => $rows
				);
			} else {
				$total = $this->items->count_items(false, boolval($status));
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows
				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	/**
	 * Used for items and services autocomplete modal
	 * Fetchs only the items and services name
	 * @return type json
	 */
	public function get_items_services_name()
	{
		$items = [];
		$results = get_items_services_name();
		if ($results)
		{
			foreach ($results as $k => $v) {
				$items[] = $v->name;
			}
		}
		echo json_encode($items);
	}
	public function activate_item()
	{
		$ids = $_REQUEST['id'];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				activate('items', 'item_status', 'item_id', $i);	
			}
		}
		echo json_encode(array('success' => 1));
	}
	public function generateQRBarCode()
	{
		$ids = $_REQUEST['id'];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				$this->_generateQRBarCode($i);	
			}
		}
		echo json_encode(array('success' => 1));
	}
	public function print_barcode()
	{
		$barcodes = [];

		$barcodeSavePath = './uploads/printbarcode';
		if (!file_exists($barcodeSavePath))
		    mkdir($barcodeSavePath);

		if( chmod($barcodeSavePath, 0755) ) 
        {
            chmod($barcodeSavePath, 0777);
        }

		$ids = $_REQUEST['id'];
		is_array($ids) OR $ids = array($ids);

		if($ids) {
			foreach ($ids as $id) {
				$item = get_item_barcode_data($id);
				if ($item) {
					foreach ($item as $v) {
						$barcodes[] = array(
							'img' => $v->barcode,
							'name' => $v->name,
							'price' => $v->price,
							'sku' => $v->sku
						);
					}
				}
			}
		}
		$data = [
			'filename' => 'barcode',
			'barcodes'	=> $barcodes
		];
		$html = '
		<!DOCTYPE html>
		<html>
		<head>
			<style>
			* {
			    box-sizing: border-box;
			}

			/* Create two equal columns that floats next to each other */
			.column {
			    float: left;
			    width: 50%;
			    padding: 10px;
			    border:#999 dashed 2px;
			}
			/* Clear floats after the columns */
			.row:after {
			    content: "";
			    display: table;
			    clear: both;
			}
			</style>
			<title></title>
		</head>
		<body>';

		$html .='
		<div class="row">';

		foreach ($barcodes as $key => $value) {
			if ($key % 2 == 0) {
			$html .='
			<div class="column1" style="background-color:#aaa;">
			  <span class="itemname">'.$barcodes[$key]['name'].'</span><br />
			  <span class="itemprice">'.add_currency(format_number($barcodes[$key]['price'])).'</span>
			  <img style="float: right;" src="./uploads/barcode/'.$barcodes[$key]['img'].'" width="50%" alt="" /><br />
			  <span class="itemsku">'.$barcodes[$key]['sku'].'</span>
			</div>
			'; } else {
		$html .='
			<div class="column2" style="background-color:#aaa;">
			  <span class="itemname">'.$barcodes[$key]['name'].'</span><br />
			  <span class="itemprice">'.add_currency(format_number($barcodes[$key]['price'])).'</span>
			  <img style="float: right;" src="./uploads/barcode/'.$barcodes[$key]['img'].'" width="50%" alt="" /><br />
			  <span class="itemsku">'.$barcodes[$key]['sku'].'</span>
			</div>
			';}
			if ($key == 28) {
				$html .='<p style="page-break-before:always;">';
			}
		}
		$html .='
		</div>
		</body>
		</html>';

		//==============================================================
		//==============================================================
		//==============================================================
		//==============================================================
		//==============================================================
		//==============================================================

		require_once 'vendor/autoload.php';

		$mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8', 'format' => 'A4-P']);
		$mpdf->SetMargins(3, 3, 3);

		$mpdf->SetTitle($data['filename']);

		// LOAD a stylesheet
		$stylesheet = file_get_contents(__common('pages/css/barcode.css'));
		$mpdf->WriteHTML($stylesheet,1); // The parameter 1 tells that this is css/style only and no body/html/text
		$mpdf->WriteHTML($html);

		$mpdf->Output('./uploads/printbarcode/'.$data['filename'].'.pdf', 'F');
		echo json_encode(array('success' => 1));
	}
	public function desactivate_item()
	{
		$ids = $_REQUEST['id'];
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				desactivate('items', 'item_status', 'item_id', $i);
			}
		}
		echo json_encode(array('success' => 1));
	}
	public function update_price()
	{
		$this->view_data['pageJs'] = array(
            'datatable.js',
            'table-editable.js'
        );
        $data = array(
        	'breadcrumb' 		=> anchor('products', __('link_items')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_items'),
			'page_description' 	=> __('message_manage') .' '.__('link_items'),
        	);
        if (can_access('update_price')){
			$this->view_data['content'] = $this->Template->render('products', 'update_price.phtml', $data, true);
        }
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function item_services_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : 1;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'asc';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'name';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : null;

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$items = $this->items->get_items_services(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);
		if ($items)
		{
			foreach ($items as $item) {
				array_push($rows, array(
					'item_id' 			  => $item->item_id,
					'sku'           	  => $item->sku,
					'name'   	 		  => $item->name,
					'purchase_price'	  => format_number($item->purchase_price),
					'price'		  		  => format_number($item->price),
					'item_status'         => $item->item_status
					)
				);
			}
			if ( $search) {
				$list = array(
					'total' => count($items),
					'totalNotFiltered' => count($items),
					'rows' => $rows
				);
			} else {
				$total = $this->items->count_items_services($filter);
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows

				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function get_hsn_sac()
	{
		echo json_encode( get_hsn_sac() );
	}
	public function get_uom()
	{
		echo json_encode( get_uom() );
	}
	public function get_cgst()
	{
		echo json_encode( get_cgst() );
	}
	public function get_sgst()
	{
		echo json_encode( get_sgst() );
	}
	public function get_igst()
	{
		echo json_encode( get_igst() );
	}
	public function get_cess()
	{
		echo json_encode( get_cess() );
	}
	private function _generateQRBarCode($id) {
		$itemSku = '';
		$itemName = '';
		$itemPrice = 0;
		$itemDescription = '';
		$is_ean_code = 0;
		$contactName = get_option('company'); 
	    $contactPhone = get_option('phone'); 
	    $contactEmail = get_option('email');
	    $post_array = [];

		$item = $this->items->get_item($id);
		if ($item) {
			foreach ($item as $value) {
				// here our data 
				if (null != $value->product_ean13) {
					$is_ean_code = 1;
				}
			    $itemSku = $value->sku;
			    $itemEAN13 = $value->product_ean13;
			    $itemName = $value->name;
			    $itemPrice = add_currency($value->price);
			    $itemDescription = $value->description;
			}
			$post_array['barcode'] = $id.'_'. time().'.png';
			$post_array['qrcode'] = $id.'_'. time().'.png';
		}
	    // we building raw data 
	    $codeContents  = "\n"; 
	    $codeContents .= __('label_sku').': '.$itemSku."\n"; 
	    $codeContents .= __('label_name').': '.$itemName."\n"; 
	    $codeContents .= __('label_price'). ': '.$itemPrice."\n"; 
	    $codeContents .= __('label_description'). ': '.$itemDescription; 
	    $codeContents .= "\n";
	    $codeContents .= "\n". __('message_intered_in_our_products'). ' '.__('label_contact_us')."\n";
        // we building raw data 
        $codeContents .= $contactName."\n"; 
        $codeContents .= __('label_phone'). ': '.$contactPhone."\n"; 
        $codeContents .= __('label_email'). ': '.$contactEmail."\n"; 
        $codeContents .= "\n";

        if (0 == $is_ean_code) {
        	$Barcode_data = $itemSku;
        	$Barcode_data .= "-";
        	$Barcode_data .= $itemName;

        	generateQrcode($id.'_'. time(), $codeContents);
        	generateBarcode($id.'_'. time(), formatBarCodeOutput($Barcode_data));
        }
        else
        {
        	$Barcode_data = $itemEAN13;
        	generateQrcode($id.'_'. time(), $codeContents);
        	generateBarcode($id.'_'. time(), $Barcode_data, true);
        }

        $this->items->set_primary_key('item_id');
        $this->items->set_table('items');
        $this->items->save($post_array, $id);
	}
	public function download_barcode() {
		$this->load->helper('download');
		force_download('./uploads/printbarcode/barcode.pdf', NULL);
	}
}