<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Products_model extends MY_Model{

	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->_table = 'items';
		$this->_primary_key = 'item_id';
	}
	public function findAll($params = [])
	{
	    $db = MysqliDb::getInstance();
	    is_array($params) OR $params = (array)$params;
	    $is_service = isset($params['is_service']) ? $params['is_service']: 0;
	    $status = isset($params['status']) ? $params['status']: null;
	    $search = isset($params['search']) ? $params['search']: false;
	    $sort   = isset($params['sort']) ? $params['sort']: 'item_id';
	    $order  = isset($params['order']) ? $params['order']: 'DESC';
	    $pagination = isset($params['pagination']) ? $params['pagination']: false;
	    $offset = isset($params['offset']) ? $params['offset'] : 0;
	    $limit = isset($params['limit']) ? $params['limit']: get_option('default_table_size');

	    $db->join("oc_productsgroups g", "i.group_id=g.group_ID", "LEFT");
	    $db->join("oc_taxes t", "i.tax_id=t.id", "LEFT");
	    // Columns to collect
	    $cols = array(
	        "i.*",
	        "g.group_name",
	        "t.tax_percent"
	    );
	    // Get items only, not service
	    $db->where('i.is_service = ?', array($is_service));
	    $db->where("i.item_id !=?", array(-1));
	    // Set order
	    $db->orderBy($sort, $order);

	    if ($search) {
	        // Search by invoice number
	        $db->where('i.sku', '%' . $search . '%', 'LIKE');
	        $db->orWhere('i.name', '%' . $search . '%', 'LIKE');
	        $db->orWhere('i.price', '%' . $search . '%', 'LIKE');
	        $db->orWhere('g.group_name', '%' . $search . '%', 'LIKE');
		}
		if ( !$pagination) {
		    return $db->ObjectBuilder()->get('oc_items i', null, $cols);
		} else {
		    return $db->ObjectBuilder()->get('oc_items i', array($offset, $limit), $cols);
		}
	}
	public function get_items_services($params = [])
	{
	    $db = MysqliDb::getInstance();
	    is_array($params) OR $params = (array)$params;
	    $status = isset($params['status']) ? $params['status']: 1;
	    $search = isset($params['search']) ? $params['search']: false;
	    $sort   = isset($params['sort']) ? $params['sort']: 'name';
	    $order  = isset($params['order']) ? $params['order']: 'asc';
	    $pagination = isset($params['pagination']) ? $params['pagination']: false;
	    $offset = isset($params['offset']) ? $params['offset'] : 0;
	    $limit = isset($params['limit']) ? $params['limit']: get_option('default_table_size');

	    // Columns to collect
	    $cols = array(
	        "i.item_id",
	        "i.sku",
	        "i.name",
	        "i.purchase_price",
	        "i.price",
	        "i.item_status"
	    );
	    // Exclude late fees item
	    $db->where("i.item_id !=?", array(-1));
	    $db->where('i.item_status = ?', array($status));
	    // Set order
	    $db->orderBy($sort, $order);

	    if ($search) {
	        // Search by invoice number
	        $db->where('i.sku', '%' . $search . '%', 'LIKE');
	        $db->orWhere('i.name', '%' . $search . '%', 'LIKE');
	        $db->orWhere('i.price', '%' . $search . '%', 'LIKE');
	        $db->orWhere('i.purchase_price', '%' . $search . '%', 'LIKE');
		}
		if ( !$pagination) {
		    return $db->ObjectBuilder()->get('oc_items i', null, $cols);
		} else {
		    return $db->ObjectBuilder()->get('oc_items i', array($offset, $limit), $cols);
		}
	}
	/**
	 * Description
	 * @param type $id 
	 * @return type
	 */
	public function get_item($id, $cols=[]) {
		$db = MysqliDb::getInstance();
		is_array($cols) OR $cols = (array)$cols;
		if ($id){
			$db->join("oc_productsgroups g", "i.group_id=g.group_ID", "LEFT");
			$db->join("oc_taxes t", "i.tax_id=t.id", "LEFT");
			$db->where("i.item_id", intval($id));
			return $db->ObjectBuilder()->get('oc_items i', 1, $cols);
		}
		return [];
	}

	public function get_group($id, $cols=[])
	{
		$db = MysqliDb::getInstance();
		is_array($cols) OR $cols = (array)$cols;
		$table = $this->tables['items_groups'];
		if ($id){
		
			$db->where('group_id', $id);
			return $db->ObjectBuilder()->get($table, 1, $cols);
		}
		return false;
	}
	/**
	 * Description
	 * @return type
	 */
	public function get_products_groups()
	{
		$db = MysqliDb::getInstance();
		$table = $this->tables['items_groups'];
		$db->where('is_service', 0);
		$db->orderBy('group_name', 'ASC');

		return $db->ObjectBuilder()->get($table, null, array('group_id', 'group_name'));
	}
	public function category_id($item_id)
	{
		$db = MysqliDb::getInstance();
		$db->where('item_id', $item_id);
		$result = $db->ObjectBuilder()->get('oc_items',null, 'group_id');
		return $result[0]->group_id;
	}
	public function category_name($category_id)
	{
		$db = MysqliDb::getInstance();
		$table = $this->tables['items_groups'];
		$db->where('group_id', $category_id);
		$result = $db->ObjectBuilder()->get($table,null, 'group_name');
		return $result[0]->group_name;
	}
	public function update_invoiced_items_group($item_id, $group_id)
	{
		$db = MysqliDb::getInstance();
		if (!is_empty_table('invoices_items'))
		{
			$table = $this->tables['invoices_items'];
			$db->where('item_id', $item_id);
			$items = $db->ObjectBuilder()->get($table, null, 'id');
			if ($items)
			{
				foreach ($items as $v) {
					$id = $v->id;
					$db_data = array('item_group' => $group_id);
					$db->where('id', $id);
					$db->update($table, $db_data);
				}
			}
			return false;
		}
		return false;
	}
	public function delete($id)
	{
		$db = MysqliDb::getInstance();
		$this->_tables = ['invoices_items', 'quotes_items', 'orders_items', 'purchases_items', 'proforma_items'];
		$this->set_table('items');
		$this->_select = 'item_id';
		$this->_primary_key = 'item_id';

		if (!$this->before_delete($id))
		{
			return parent::delete($id);
		}
		return false;
	}
	/**
	 * Count items
	 * @param type|null $status 
	 * @return type
	 */
	public function count_items($is_service = false, $status = 1) {
		$db = MysqliDb::getInstance();
	    if ($is_service) {
	        $db->where('i.is_service', 1);
	    } else {
	    	$db->where('i.is_service', 0);
	    }
	    if ($status && $status != 'All') {
	    	switch ($status) {
	    		case 'inactive':
	    			$status = 0;
	    			break;
	    		case 'active':
	    			$status = 1;
	    			break;
	    		default:
	    			$status = 1;
	    			break;
	    	}
	    	$db->where('i.item_status = ?', array($status));
	    }
	    // Exclude late fees item
	    $db->where("i.item_id !=?", array(-1));
	    return $db->getValue("oc_items i", "count(item_id)");
	}
	public function count_items_services($status = 1) {
		$db = MysqliDb::getInstance();
		switch ($status) {
			case 'inactive':
				$status = 0;
				break;
			case 'active':
				$status = 1;
				break;
			default:
				$status = 1;
				break;
		}
	    $db->where('i.item_status = ?', array($status));
	    // Exclude late fees item
	    $db->where("i.item_id !=?", array(-1));
	    return $db->getValue("oc_items i", "count(item_id)");
	}

	public function get_items_stocks($params=[])
	{

		$db = MysqliDb::getInstance();
		is_array($params) OR $params = (array)$params;
		$status = isset($params['status']) ? $params['status']: 1;
		$search = isset($params['search']) ? $params['search']: false;
		$sort   = isset($params['sort']) ? $params['sort']: 'name';
		$order  = isset($params['order']) ? $params['order']: 'asc';
		$pagination = isset($params['pagination']) ? $params['pagination']: false;
		$offset = isset($params['offset']) ? $params['offset'] : 0;
		$limit = isset($params['limit']) ? $params['limit']: get_option('default_table_size');

		if ($offset == 0) {
			get_ordered_items(true);
			get_committed_items(true);
			update_stock();
			stock_valuation();
		}
		$db->join("oc_productsgroups g", "i.group_id=g.group_id", "LEFT");
		$db->join("oc_taxes t", "i.tax_id=t.id", "LEFT");
		// Columns to collect
	    $cols = array(
	        "i.item_id",
	        "i.sku",
	        "i.name",
	        "i.reorder_point",
	        "i.on_hand_stock",
	        "i.available",
	        "i.committed",
	        "i.ordered",
	        "i.valuation"
	    );
	    // Exclude late fees item
	    $db->where("i.item_id !=?", array(-1));
	    $db->where('i.is_service = ?', array(0));
	    $db->where('i.track_inventory = ?', array(1));
	    // Set order
	    $db->orderBy($sort, $order);

	    if ($search) {
	        // Search by invoice number
	        $db->where('i.sku', '%' . $search . '%', 'LIKE');
	        $db->orWhere('i.name', '%' . $search . '%', 'LIKE');
		}
		if ($status && $status != "All") {
			switch ($status) {
				case 'inactive':
					$status = 0;
					break;
				case 'active':
					$status = 1;
					break;
				default:
					$status = 1;
					break;
			}
			$db->where('i.item_status = ?', array($status));
		}
		if ( !$pagination) {
		    return $db->ObjectBuilder()->get('oc_items i', null, $cols);
		} else {
		    return $db->ObjectBuilder()->get('oc_items i', array($offset, $limit), $cols);
		}
	}
}