<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Invoice Ajax Class
 * Create and Update Invoice
 * Also used to make refunds.
 */
class Ajax extends Ajax_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('proforma/proforma_model', 'proformas');
	}

	/**
	 * Create and Update Proforma 
	 * @return type mixed
	 */
	public function create_proforma()
	{
		// Assign the Mmanager Object
		$m = $this->m;
		$attachments = [];
		$context = [];
		
		$user_language 			= get_option('user_language', 'users_options');
		$default_duedate 		= get_option('default_duedate');

		$proforma_number 		= $this->input->post('proforma_number'); // Proforma number fetchs the hidden Proforma number (auto increment), not formatted (with prefix)
		$proforma_key 			= $this->input->post('proforma_number'); // Proforma number fetchs the hidden Proforma number (auto increment), not formatted (with prefix)
		$annual_number_key 		= $this->input->post('annual_number_key'); // Proforma number fetchs the hidden Proforma number (auto increment), not formatted (with prefix)
		$initial_proforma_number = $this->input->post('initial_proforma_number');
		$proforma_status 		= $this->input->post('proforma_status'); // The invoice status, to see if is marked paid, draft and so on.
		$date 					= null == $this->input->post('date') ? date('Y-m-d') : $this->input->post('date'); // Issued date
		$due_date 				= null == $this->input->post('due_date') ? date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( mysqlDate($user_language, $this->input->post('from')) ) ) ): $this->input->post('due_date');// Invoice due date
		$pay_type 				= 1;
		$new_payment 			= null !== $this->input->post('new_payment') ? round($this->input->post('new_payment'), 2): round(0, 2);
		$credit_used 			= null !== $this->input->post('client_credit') ? round($this->input->post('client_credit'), 2): round(0, 2);
		$amount_paid 			= round( floatval($this->input->post('amountPaid')) + $new_payment + $credit_used, 2);
		$subtotal 				= round( $this->input->post('subtotal'), 2); // Invoice subtotal
		$tax_amount 			= round( $this->input->post('tax_amount'), 2); // Total tax applied if any.
		$global_discount 		= round($this->input->post('global_discount'), 2); // Is there a global discount precentage ?
		$discount_amount 		= round( $this->input->post('discount_amount'), 2); // The discount amount
		$amount 				= round( $this->input->post('totalAftertax'), 2); // Total with all taxes applied
		$total 					= round( $this->input->post('total'), 2); // Invoice final value after taxes and discount if any
		$sent 					= $this->input->post('notify_client') == 1 ? 'yes': 'no'; // Is invoice sent to customer ?
		$amount_due 			= $total - $amount_paid;
		$notes 					= $this->input->post('notes'); // is there notes
		$transaction_id 		= $this->input->post('transaction_id'); // is there notes
		$transaction_id 		= $this->input->post('transaction_id'); // is there notes
		$payment_gateway 		= $this->input->post('payment_method'); // is there notes
		$external_number 		= $this->input->post('subject'); // Input field should be named $external_number, but database has unused subjet field. So let's use it
		$client_id 				= $this->input->post('client_id'); // Customer ID, value will be 0 if guest (non registered customer)

		$item_sku 				= $this->input->post('itemSku'); // Array of all items purhased sku.
		$specific_serial_number 				= $this->input->post('itemSN'); // Array of all items purhased sku.
		$item_id 				= $this->input->post('itemID'); // Array of all items purhased ID. If not registered before invoice, ID on creation will be 0, then updated on edit based on item name
		$item_name 					= $this->input->post('itemName'); // Array of all items purhased names

		$additional_taxes			= is_array($this->input->post('additional_taxes')) ? $this->input->post('additional_taxes') : array($this->input->post('additional_taxes'));
		$additional_taxes_ID		= $this->input->post('additional_taxes_ID');
		$additional_taxes_values	= $this->input->post('additional_taxes_values');

		$files						= isset($_FILES['files']['name']) ? $_FILES['files']['name']: [];

		// Additional tax
		$additional_taxes_array = [];
		for ($i=0; $i < count($additional_taxes); $i++) { 
			array_push($additional_taxes_array, array(
				array(
					'id'  => $additional_taxes_ID[$i],
					'rate' => $additional_taxes[$i],
					'value' => $additional_taxes_values[$i]
				)
			));
		}

		// Get the change rate if multicurrency is enabled
		$currency = $client_id == 0 ? get_option('user_currency') : client($client_id, 'client_currency');
		$change_rate = _has_option('change_currency') ? get_change_rate( $currency ) : 1;

		//format dates
		$date = mysqlDate( $user_language, $date );
		$due_date = mysqlDate( $user_language, $due_date );
		if ( ! isValidDate($date)) {
			$date = date('Y-m-d H:i:s');
		}
		if ( ! isValidDate($due_date)) {
			$due_date = date('Y-m-d H:i:s');
		}

		// $date = mysqlDate( $user_language, $date );
		// $due_date = mysqlDate( $user_language, $due_date );
		// Data that will be saved in invoices table
		$proformaTable 								= []; // All data that will be saved on oc_invoices
		$proformaTable['change_rate'] 				= $change_rate; // Save change_rate for reference
		$proformaTable['user_id'] 					= $m->getUserID();
		$proformaTable['proforma_number'] 			= $proforma_number;
		$proformaTable['annual_number_key'] 		= $annual_number_key;
		$proformaTable['proforma_key'] 				= $proforma_key;
		$proformaTable['proforma_status'] 			= $proforma_status;
		$proformaTable['client_id'] 				= $client_id;
		$proformaTable['date'] 						= $date;
		$proformaTable['due_date'] 					= $due_date;
		$proformaTable['pay_type'] 					= $pay_type;
		$proformaTable['subtotal'] 					= $subtotal;
		$proformaTable['tax_amount'] 				= $tax_amount;
		$proformaTable['global_discount'] 			= $global_discount;
		$proformaTable['discount_amount'] 			= $discount_amount;
		$proformaTable['total'] 					= $total;
		$proformaTable['notes'] 					= $notes;
		$proformaTable['subject'] 					= $external_number;
		$proformaTable['amount_paid']				= $amount_paid;
		$proformaTable['amount_due']				= $amount_due;
		$proformaTable['payment_gateway']			= $payment_gateway;
		$proformaTable['transaction_id']			= $transaction_id;
		$proformaTable['additional_taxes']			= json_encode($additional_taxes_array);
		$proformaTable['sent']						= $sent; // Set Invoice to sent or not
		$itemTable 									= []; // Data that will be saved in oc_invoiceitems table
		$itemTable['amount']						= $amount;
		$itemTable['specific_serial_number']		= $specific_serial_number;
		$itemTable['item_id']						= $item_id;
		$itemTable['item_name']						= $item_name;
		$itemTable['client_id']						= $client_id;
		$itemTable['user_id']						= $m->getUserID();
		$itemTable['notes']							= $notes;


		$client_language = client($client_id, 'client_language');

		// Set Invoice to Unpaid if client notification is set to 'yes'
		if($sent == 'yes' && $proforma_status == "Draft")
		{
			$proformaTable['proforma_status'] = "Unpaid";
		}
		// For mow pay once
		if($proforma_status == "Paid" || $proformaTable['amount_due'] == floatval(0))
		{
			$proformaTable['amount_paid'] = $total;
			$proformaTable['amount_due'] = 0;
			$proformaTable['proforma_status'] = "Paid";
		}
		if($proformaTable['amount_paid'] > 0 && $proformaTable['amount_due'] > 0)
		{
			$proformaTable['proforma_status'] = "Partially Paid";
		}
		if (1 == $this->input->post('add_to_client_credit')) {
			$proformaTable['credit_is_added'] = 1;
		}
		// Get array fields for validation
		$ids = $this->input->post('itemID');
		$names = $this->input->post('itemName');
		$quantity = $this->input->post('itemQuantity');
		$price = $this->input->post('itemPrice');

		if(!empty($names))
		{
        // Loop through $names and add the validation
			foreach($names as $key => $value)
			{
				$this->form_validation->set_rules('itemName[' . $key . ']', 'lang:item_name', 'required',
					array(
						'required' => lang('error_required_name') . '<br />'
						)
					);
			}
		}
		if(!empty($quantity))
		{
        // Loop through quantity and add the validation
			foreach($quantity as $key => $value)
			{
				$this->form_validation->set_rules('itemQuantity[' . $key . ']', 'lang:item_quantity', 'required',
					array(
						'required' => lang('error_required_quantity') . '<br />'
						)
					);
			}
		}

		if(!empty($price))
		{
        // Loop through price and add the validation
			foreach($price as $key => $value)
			{
				$this->form_validation->set_rules('itemPrice[' . $key . ']', 'lang:item_price', 'required',
					array(
						'required' => lang('error_required_price') . '<br />'
						)
					);
			}
		}

		if(count($files)){
			
			$config['upload_path']          = './uploads/proforma';
			if (!file_exists($config['upload_path']))
			    mkdir($config['upload_path']);

			if( chmod($config['upload_path'], 0755) ) 
	        {
	            chmod($config['upload_path'], 0777);
	        }

			for ($i=0; $i < count($files); $i++) { 
				if (!empty($_FILES['files']['name'][$i])){
					$_FILES['file']['name'] = $_FILES['files']['name'][$i];
					$_FILES['file']['type'] = $_FILES['files']['type'][$i];
					$_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
					$_FILES['file']['error'] = $_FILES['files']['error'][$i];
					$_FILES['file']['size'] = $_FILES['files']['size'][$i];

					$config['upload_path']          = './uploads/proforma';
					$config['allowed_types']        = '*';
					$config['max_size']        		= '5000';
					$config['file_name']        	= $_FILES['files']['name'][$i];

					$this->load->library('upload', $config);
					if ( ! $this->upload->do_upload('file'))
					{
						$error = $this->upload->display_errors();
						$this->form_validation->set_rules($error);
					} else {
						$data = $this->upload->data();
						$attachments[] = './uploads/proforma/'.$data['file_name'];
					}
				}
			}
			$proformaTable['attachments'] = json_encode($attachments);
		}

		if ( $this->form_validation->run() == FALSE )
		{
			$this->response = array('status' => 0, 'error' => validation_errors() );
		}
		else
		{
			if ($this->input->post('proforma_id'))
			{
				$id = $this->input->post('proforma_id');
				// Invoice attachments
				$proforma = get_proforma_by_number($id);
				$last_files = json_decode($proforma[0]->attachments, true);

				if($last_files){
					foreach ($last_files as $file) {
						$attachments[] = $file;
					}
				}
				$proformaTable['attachments'] = json_encode($attachments);
				delete('proforma_items', 'proforma_number', $id);
				$proformaTable['user_id'] = $this->input->post('user_id');
				$this->proformas->set_table('proforma');
				$this->proformas->save($proformaTable, $id);
				$event = array(
					'action' 					=> 'update',
					'referrer' 					=> 'proforma',
					'referrer_id' 				=> $id,
					'referrer_value' 			=> $proforma_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
			}
			else
			{
				$this->proformas->set_table('proforma');
				$this->proformas->save($proformaTable);
				$event = array(
					'action' 					=> 'add',
					'referrer' 					=> 'proforma',
					'referrer_id' 				=> $this->db->insert_id(),
					'referrer_value' 			=> $proforma_number,
					'user_id' 					=> user('user_id'),
					'status' 					=> 'success'
				);
				record_event($event);
				update_annual_sequencing('proforma', intval($annual_number_key)+1);
			}

			// Insert Items in database
			$items_num = count( array_filter( $this->input->post('itemName')) ); // Get number of items, strip empty lines
			$item_sku = $this->input->post('itemSku');
			$specific_serial_number = $this->input->post('itemSN');
			$item_id = $this->input->post('itemID');
			$item_name  = array_filter( $this->input->post('itemName') );
			$item_quantity = array_filter( $this->input->post('itemQuantity') );
			$item_price  = array_filter( $this->input->post('itemPrice') );
			$item_discount = $this->input->post('itemDiscount');
			$item_tax_rate = $this->input->post('itemTax');
			$item_uom = $this->input->post('itemUom');
			

			$item_subtotal = array_filter( $this->input->post('itemSubTotal') );
			$client_id = $client_id;
			$item_recurring = 1;

			if ($proforma_status == "Cancelled")
			{
				$proforma_is_cancelled = 1;
			}
			else
			{
				$proforma_is_cancelled = 0;
			}

			$proforma_items = $this->tables['proforma_items'];
			$this->proformas->set_table('proforma_items');
			for($i = 0; $i < $items_num; $i++){
				$item_array = array(
					'proforma_number' => $proforma_number,
					'proforma_key' => $proforma_key,
					'client_id' => $client_id,
					'user_id' => $m->getUserID(),
					'item_sku' => $item_sku[$i],
					'specific_serial_number' => $specific_serial_number[$i],
					'item_id' => $item_id[$i],
					'item_group' => $this->m_manager->category_id($item_id[$i]),
					'item_name' => addslashes($item_name[$i]),
					'item_uom' => $item_uom[$i],
					'item_price' => $item_price[$i],
					'item_discount' => $item_discount[$i],
					'item_quantity' => $item_quantity[$i],
					'item_subtotal' => $item_subtotal[$i],
					'item_tax_rate' => $item_tax_rate[$i],
					'item_recurring' => $item_recurring,
					'proforma_is_cancelled' => $proforma_is_cancelled,
					);
				if ($this->input->post('proforma_id'))
				{
					$item_array['user_id'] = $this->input->post('user_id');
				}
				$this->proformas->save($item_array);
				//remove_committed_items($proforma_number);
				$this->response = array('status' => 1);
			}
			// End insert items
			
			// Since 1.5 Add Item to database if not found in autocomplete
			for($i = 0; $i < $items_num; $i++){
				if ( !item_exists($item_name[$i]) )
				{
					$new_item_array = array(
						'sku' => null !== $item_sku[$i] ? $item_sku[$i]: generate_sku(),
						'serial_number' => json_encode(null !== $specific_serial_number[$i] ? (array)$specific_serial_number[$i]: array()),
						'group_id' => 0,
						'name' => $item_name[$i],
						'price' => $item_price[$i],
						'user_id' => $m->getUserID()
						);
					if ($this->input->post('invoice_id'))
					{
						$new_item_array['user_id'] = $this->input->post('user_id');
					}
					$this->load->model('products/products_model', 'items');
					$this->items->set_table('items');
					$this->items->save($new_item_array);
				}
			}
			// Do not send email for Draft Proforma or on update
			if ( $proformaTable['proforma_status'] !== 'Draft' && $client_id > 0 && $this->input->post('notify_client') == 1 )
			{
				$data = array(
					'proforma_url'		=> base_url('index.php/viewproforma/view?id=') . _eID($proforma_number),
					'to_name'            => html_entity_decode(htmlentities((client( $client_id, 'name_company' )))),
					'date'		    	=> _fdate( $client_language, $date ),
					'due_date'		    => _fdate( $client_language, $due_date),
					'proforma_status'	=> __( strtolower( $proformaTable['proforma_status'] ), $client_id ),
					'proforma_number' 	=> get_option('proforma_prefix').invoice_number_format() . sprintf("%04s", $proforma_number)
					);
				$data['client_account'] = base_url('index.php/client/index?id=') . _eID($client_id);
				$data['btn_client_account'] = __( 'btn_client_account', $client_id );
				$data['logo_url'] = base_url('uploads/admin/img/'). get_option('logo');
			
				$data['proforma_amount'] = add_currency( format_number($total * $change_rate), $client_id );
				
				$this->load->helper('file');
				$lang = lang_code_to_notif_string( $client_language );
				$path_new_proforma = './notifications/' . $lang . '/proforma/new_proforma.php';

				$to = client( $client_id, 'client_email' );
				$template = read_file($path_new_proforma);
				$subject = __('subject_proforma_generated', $client_id);
				$message = $this->parser->parse_string($template, $data, true);

				if ($client_id) {
					$client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
					if (1 == get_option('attach_pdf_to_invoice')) {
						generate_pdf_file('proforma', $proforma_number);
					}
				}
				$attachments[] = FCPATH.'uploads/pdf/proforma/'.$proforma_number.'.pdf';
				send_email($to, $message, $subject, null, $client_cc, $attachments, get_option('proforma_prefix').invoice_number_format() . sprintf("%04s", $proforma_number).'.pdf');

				$event = array(
					'action' 					=> 'proforma_sent',
					'referrer' 					=> 'proforma',
					'referrer_id' 				=> $proforma_number,
					'referrer_value' 			=> $proforma_number,
					'client_id' 				=> $client_id,
					'status' 					=> 'success'
				);
				record_event($event);
			}
		}
		if (! $this->input->post('proforma_id')) {
			// Update next proforma ID
			setAccountEntityId('proforma', get_last_id('proforma'));
		}
		echo json_encode($this->response);
	}
}