<?php defined('BASEPATH') OR exit('No direct script access allowed');

use Mmanager\Domain\Factory\InvoiceFactory;
/**
 * 
 */
class Proforma extends Admin_Controller {
	/**
	 * @var type
	 */
	protected $_invoice = [];

	/**
	 * @var type
	 */
	protected $_client = [];

	/**
	 * Description
	 * @return type
	 */
	public function __construct(){
		parent::__construct();
		$this->load->model('clients/clients_model', 'clients');
		$this->clients->set_primary_key('client_id');
		$this->load->model('proforma_model', 'proforma');

        $this->view_data['modal'] = $this->Template->render('clients', 'add_client_modal.phtml', '', true);
        $this->data['breadcrumb'] = anchor('proforma', __('link_proforma'));
        $this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	
	/**
	 * Description
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type
	 */
	public function index()
	{
		$this->view_data['pageJs'] = array(
			'proforma-index.js',
		);
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('link_proforma'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'filter'			=> 'All'
			);
		if (can_access('invoices')) {
			$this->view_data['page_header'] = $this->Template->render('proforma', 'page_header.phtml', '', true);
			$this->view_data['content'] = $this->Template->render('proforma', 'index.phtml', $view_data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function create_proforma()
	{
		$this->view_data['pageJs'] = array(
			'proforma.js',
		);
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );

		$data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('link_add_new') .' '.__('link_proforma'),
			'clients'         => clients()
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('proforma', 'create_proforma_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		$this->view_data['pageJs'] = array(
			'proforma.js'
		);
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
        
		$id = _dID($_REQUEST['id']);
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('link_proforma'),
			'user_language' => get_option('user_language', 'users_options'),
			'proformas' => get_proforma_by_number($id),
			'invoiceObj' => new InvoiceFactory,
			'invoice_items' => get_proforma_items($id),
			'clients' => json_encode(clients()),
			'payment_fees'  => floatval(0),
			'invoice_status' => array(
				'Draft' => ucfirst(__('option_draft')),
				'Partially Paid' => ucfirst(__('label_partially_paid')),
				'Partially Refunded' => ucfirst(__('label_partially_refunded')),
				'Unpaid' => ucfirst(__('option_unpaid')),
				'Paid' => ucfirst(__('option_paid')),
				'Refunded' => ucfirst(__('label_refunded')),
				'Pending' => ucfirst(__('label_pending')),
				'Overdue' => ucfirst(__('option_overdue')),
				'Cancelled' => ucfirst(__('option_cancelled'))
				),
			'pay_type' => array(
				'1' => __('option_once'),
				'2' => __('option_weekly'),
				'3' => __('option_biweekly'),
				'4' => __('option_monthly'),
				'5' => __('option_yearly'),
				'6' => __('option_quarterly'),
				'7' => __('option_half_yearly')
				)
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('proforma', 'edit_proforma_form.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_all()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('proforma_proforma'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter'		=> 'All'
			);

		$this->view_data['content'] = $this->Template->render('proforma', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_paid()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('proforma_proforma'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Paid'
			);

		$this->view_data['content'] = $this->Template->render('proforma', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_unpaid()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('proforma_proforma'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Unpaid'
			);

		$this->view_data['content'] = $this->Template->render('proforma', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_overdue()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('proforma_proforma'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Overdue'
			);

		$this->view_data['content'] = $this->Template->render('proforma', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_cancelled()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('proforma_proforma'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Cancelled'
			);

		$this->view_data['content'] = $this->Template->render('proforma', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function view_refunded()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('proforma', __('link_proforma')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_proforma'),
			'page_description' 	=> __('message_manage') .' '.__('proforma_proforma'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter' 		=> 'Refunded'
			);

		$this->view_data['content'] = $this->Template->render('proforma', 'index.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}

	public function delete_proforma()
	{
		$protected = [];
		$to_del = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				array_push($to_del, $i);
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('proforma', 'proforma_number', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function mass_proforma_email()
	{
		$protected = [];
		$to_send = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (proforma_for_guest($i) > 0)
				{
					array_push($to_send, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_send);
			$response['fail'] = count($protected);

			if(!empty($to_send))
			{
				foreach ($to_send as $proforma_number) {
					$this->m_manager->send_proforma_email($proforma_number);
				}
			}
		}
		echo json_encode($response);
	}
	public function merge_proforma()
	{
		$fail = [];
		$success = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];

		is_array($ids) OR $ids = array($ids);
		$client_id = (array) get_proforma_vars($ids[0], 'client_id');

		foreach ($ids as $i) {
			if (proforma_for_guest($i) > 0 && count($ids) > 1 && in_array(get_proforma_vars($i, 'client_id'), $client_id))
			{
				array_push($success, $i);
			}
			else
			{
				array_push($fail, $i);
			}
		}
		$response['fail'] = count($fail);
		$response['success']  = count($success);
		$response['post_delete']  = get_option('delete_once_merged');

		if( count($success) > 1 )
		{
			merge_proforma($success);
		}

		echo json_encode($response);
	}
	public function convert_to_invoice()
	{
		$ids = _dID($_REQUEST['id']);
		$response = [];

		is_array($ids) OR $ids = array($ids);
		$response['fail'] = 0;
		$response['success']  = count($ids);

		if($ids)
		{
			foreach ($ids as $id) {
				from_proforma_to_invoice($id);
			}
		}
		echo json_encode($response);
	}
	public function proforma_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'id';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : null;

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$proformas = $this->proforma->findAll(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);

		if ($proformas)
		{
			foreach ($proformas as $proforma) {
				$proforma = (object)$proforma;
				if (get_option('annual_numbering')) {
					$inv_f_number = null == get_option('proforma_prefix') ? __('proforma_prefix_short') . date('y', strtotime($proforma->updated_on)). sprintf( "%04s", $proforma->annual_number_key) : get_option('proforma_prefix') . date('y', strtotime($proforma->updated_on)).sprintf( "%04s", $proforma->annual_number_key );
				} else {
					$inv_f_number = null == get_option('proforma_prefix') ? __('proforma_prefix_short') . sprintf( "%04s", $proforma->proforma_number ) : get_option('proforma_prefix') . sprintf( "%04s", $proforma->proforma_number );
				}
				array_push($rows, array(
					'id' 				  => $proforma->id,
					'client_id'           => _eID($proforma->client_id),
					'inv_f_number'   	  => $inv_f_number,
					'enc_proforma_number' => _eID($proforma->proforma_number),
					'proforma_number'   	  => $proforma->proforma_number,
					'proforma_status'   	  				=> $proforma->proforma_status,
					'stbool'			  => get_proforma_vars($proforma->proforma_number, 'proforma_status'),
					'name_company'		  => $proforma->name_company,
					'date'				  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $proforma->date ),
					'due_date'			  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $proforma->due_date ),
					'total'				  => format_number($proforma->total)
					)
				);
			}
			if ( $search) {
				$list = array(
					'total' => count($proformas),
					'totalNotFiltered' => count($proformas),
					'rows' => $rows
				);
			}
			else
			{
				$total = $this->proforma->count_rows('proforma',$filter);
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows
				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function invoice_autocomplete()
	{
		$data = [];
		$results = get_all_items(1);
		if(! empty($results) )
		{
			if (! _has_option('is_indian') )
			{
				foreach($results as $row)
				{
					// $name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id;
					// array_push($data, $name);
					$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
					array_push($data, $name);
				}
			}
			else
			{
				foreach($results as $row)
				{
					$name = $row->sku .'|'. $row->name .'|' .$row->price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
					array_push($data, $name);
				}
			}
		}
		echo json_encode($data);
	}
	public function next_proforma_number()
	{
		echo json_encode(next_proforma_number());
	}
	public function create_credit_note()
	{
		$protected = [];
		$to_mark_refund = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (invoice_status($i) == 'is_paid' || invoice_status($i) == 'is_refunded')
				{
					array_push($to_mark_refund, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_refund);
			$response['fail'] = count($protected);

			if(!empty($to_mark_refund))
			{
				mass_refund('proforma', 'proforma_number', $to_mark_refund);
			}
		}
		echo json_encode($response);
	}
	public function generate_from_tracker() {
		$proforma_number = next_proforma_number();
		$invoice_key = getAccountEntityNextId('invoice');
		$client_id = get_client_id($_REQUEST['client_name']);
		$currency = $client_id == 0 ? get_option('user_currency') : client( $client_id, 'client_currency' );
		$change_rate = _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
		$date = date('Y-m-d');
		$default_duedate = get_option('default_duedate');
		$duedate = date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( $date ) ) );

		$invoice_data = [
			'proforma_number'		=> $proforma_number,
			'invoice_key' 			=> $invoice_key,
			'client_id' 			=> get_client_id($_REQUEST['client_name']),
			'subtotal' 				=> $_REQUEST['subtotal'],
			'total' 				=> $_REQUEST['subtotal'],
			'amount_due' 			=> $_REQUEST['subtotal'],
			'tax_amount' 			=> 0,
			'discount_amount' 		=> 0,
			'amount_refunded' 		=> 0,
			'notes' 				=> $_REQUEST['notes'],
			'next_duedate' 			=> null,
			'recurring_from' 		=> null,
			'recurring_to' 			=> null,
			'subject' 				=> null,
			'pay_type' 				=> 1,
			'date' 					=> $date,
			'due_date' 				=> $duedate,
			'invoice_status' 		=> 'Unpaid',
			'sent' 					=> 'no',
			'change_rate' 			=> $change_rate
		];
		// Set table and save data
		$this->proforma->set_table( 'proforma' );
		$this->proforma->save( $invoice_data );

		$item_data = [
			'proforma_number' 			=> $proforma_number,
			'invoice_key' 				=> $invoice_key,
			'client_id' 				=> $client_id,
			'item_sku' 					=> generate_sku(),
			'item_id' 					=> 0,
			'item_name' 				=> $_REQUEST['item_name'],
			'item_price' 				=> $_REQUEST['item_price'],
			'item_quantity' 			=> _durationToHour($_REQUEST['item_quantity']),
			'item_discount' 			=> 0,
			'item_subtotal' 			=> $_REQUEST['subtotal'],
			'item_tax_rate' 			=> 0,
			'item_recurring' 			=> 1,
			'item_uom' 					=> 'hr'
		];

		$this->proforma->set_table('proforma_items');
		$this->proforma->save($item_data);

		// Update next invoice ID
		setAccountEntityId('invoice', $invoice_key);
		echo json_encode(1);
	}
	public function generate_from_support() {
		$proforma_number = next_proforma_number();
		$invoice_key = getAccountEntityNextId('invoice');
		$client_id = $_REQUEST['client_id'];
		$currency = $client_id == 0 ? get_option('user_currency') : client( $client_id, 'client_currency' );
		$change_rate = _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
		$date = date('Y-m-d');
		$default_duedate = get_option('default_duedate');
		$duedate = date( 'Y-m-d', strtotime( '+'.$default_duedate. 'day', strtotime( $date ) ) );

		$notes = get_ticket_messages($_REQUEST['ticket_id']);
		$html = '';
		if($notes) {
			foreach ($notes as $note) {
				$html .= "\n".$note->title.' ('.convertToHoursMins($note->duration).')'. "\n".$note->message."\n"."\n";
			}
		}
		$invoice_data = [
			'proforma_number'		=> $proforma_number,
			'invoice_key' 			=> $invoice_key,
			'client_id' 			=> $_REQUEST['client_id'],
			'subtotal' 				=> floatval($_REQUEST['duration'] / 60) * 1,
			'total' 				=> floatval($_REQUEST['duration'] / 60) * 1,
			'amount_due' 			=> floatval($_REQUEST['duration'] / 60) * 1,
			'tax_amount' 			=> 0,
			'discount_amount' 		=> 0,
			'amount_refunded' 		=> 0,
			'notes' 				=> $html,
			'next_duedate' 			=> null,
			'recurring_from' 		=> null,
			'recurring_to' 			=> null,
			'subject' 				=> null,
			'pay_type' 				=> 1,
			'date' 					=> $date,
			'due_date' 				=> $duedate,
			'invoice_status' 		=> 'Unpaid',
			'sent' 					=> 'no',
			'change_rate' 			=> $change_rate
		];
		// Set table and save data
		$this->proforma->set_table( 'proforma' );
		$this->proforma->save( $invoice_data );

		$item_data = [
			'proforma_number' 			=> $proforma_number,
			'invoice_key' 				=> $invoice_key,
			'client_id' 				=> $client_id,
			'item_sku' 					=> generate_sku(),
			'item_id' 					=> 0,
			'item_name' 				=> $_REQUEST['subject'],
			'item_price' 				=> 1,
			'item_quantity' 			=> _durationToHour($_REQUEST['duration'] /60),
			'item_discount' 			=> 0,
			'item_subtotal' 			=> floatval($_REQUEST['duration'] / 60) * 1,
			'item_tax_rate' 			=> 0,
			'item_recurring' 			=> 1,
			'item_uom' 					=> 'hr'
		];

		$this->proforma->set_table('proforma_items');
		$this->proforma->save($item_data);

		set_support_vars($_REQUEST['ticket_id'], array('status' => 'Billed'));
		// Update next invoice ID
		setAccountEntityId('invoice', $invoice_key);
		echo json_encode(array('success' => 1, 'invoicenumb' => _eID($proforma_number)));
	}
}