<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller {
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('providers_model', 'providers');
		$this->providers->set_primary_key('provider_id');
	}
	
	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function add_provider($id = NULL)
	{
		$is_modal = $this->input->post('is_modal');
		$post_array = array(
			'name_company' 			=> $this->input->post('name_company'),
			'provider_email' 		=> strtolower($this->input->post('provider_email')),
			'provider_fax' 		    => $this->input->post('provider_fax'),
			'provider_code' 		=> $this->input->post('provider_code'),
			'provider_contact1' 	=> $this->input->post('provider_contact1'),
			'provider_contact1_email' 	=> $this->input->post('provider_contact1_email'),
			'provider_contact2_email' 	=> $this->input->post('provider_contact2_email'),
			'provider_contact2' 	=> $this->input->post('provider_contact2'),
			'provider_address1' 	=> $this->input->post('provider_address1'),
			'provider_address2'		=> $this->input->post('provider_address2'),
			'provider_city' 		=> $this->input->post('provider_city'),
			'provider_state' 		=> $this->input->post('provider_state'),
			'provider_postcode' 	=> $this->input->post('provider_postcode'),
			'provider_country'		=> $this->input->post('provider_country'),
			'provider_phone' 		=> $this->input->post('provider_phone'),
			'provider_notes' 		=> $this->input->post('provider_notes'),
			'provider_type' 		=> $this->input->post('provider_type'),
			'provider_status' 		=> $this->input->post('provider_status'),
			'provider_naf_code' 	=> $this->input->post('provider_naf_code'),
			'provider_location' 	=> $this->input->post('provider_location'),
			'provider_tax_id' 	    => $this->input->post('provider_tax_id'),
			'provider_activity' 	=> $this->input->post('provider_activity'),
			'provider_tax_type' 	=> $this->input->post('provider_tax_type'),
			'provider_account' 	    => $this->input->post('provider_account'),
			'provider_language' 	=> $this->input->post('provider_language'),
			'provider_payment_method'  => $this->input->post('provider_payment_method'),
			'provider_credit'          => $this->input->post('provider_credit'),
			'provider_password' 	=> $this->input->post('provider_password')

			);
			if ( _has_option('change_currency') )
			{
				$post_array['provider_currency'] = null !== $this->input->post('provider_currency') ? $this->input->post('provider_currency'): get_option('user_currency');
			}
			else
			{
				$post_array['provider_currency'] = get_option('user_currency');
			}
			if(!empty($post_array['provider_password']))
			{
				$config = array(
					array(
						'field' => 'name_company',
						'label' => __('label_name_company'),
						'rules' => 'required',
						'errors' => array(
							'required' => __('error_required_name'). '<br />'
							)
						),
					array(
						'field' => 'provider_email',
						'label' => __('label_email'),
						'rules' => 'required|valid_email',
						'errors' => array(
							'required' => __('error_required_email'). '<br />',
							'valid_email' => __('error_required_valid_email'). '<br />'
							)
						),
					array(
						'field' => 'provider_password',
						'label' => __('label_password'),
						'rules' => 'required|matches[password_confirm]',
						'errors' => array(
							'matches' => __('error_password_confirm'). '<br />'
							)
						),
					array(
						'field' => 'password_confirm',
						'label' => __('label_password_confirm'),
						'rules' => 'required',
						'errors' => array(
		                    'required' => __('error_password_confirm_required_field_error') . '<br />'
		                )
					),
					array(
						'field' => 'provider_contact1_email',
						'label' => __('label_email'),
						'rules' => 'valid_email',
						'errors' => array(
							'valid_email' => __('error_required_valid_email').'<br />'
							)
						),
					array(
						'field' => 'provider_contact2_email',
						'label' => __('label_email'),
						'rules' => 'valid_email',
						'errors' => array(
							'valid_email' => __('error_required_valid_email').'<br />'
							)
						)
				);
			}
			else
			{
				$config = array(
					array(
						'field' => 'name_company',
						'label' => __('label_name_company'),
						'rules' => 'required',
						'errors' => array(
							'required' => __('error_required_name'). '<br />'
						)
					),
					array(
						'field' => 'provider_email',
						'label' => __('label_email'),
						'rules' => 'required|valid_email',
						'errors' => array(
							'required' => __('error_required_email'). '<br />',
							'valid_email' => __('error_required_valid_email'). '<br />'
						)
					),
					array(
						'field' => 'provider_contact1_email',
						'label' => __('label_email'),
						'rules' => 'valid_email',
						'errors' => array(
							'valid_email' => __('error_required_valid_email').'<br />'
							)
						),
					array(
						'field' => 'provider_contact2_email',
						'label' => __('label_email'),
						'rules' => 'valid_email',
						'errors' => array(
							'valid_email' => __('error_required_valid_email').'<br />'
							)
						)
				);
			}
		$this->form_validation->set_rules($config);
		$id = $this->input->post('provider_id');
		$password = null !== $post_array['provider_password'] ? $post_array['provider_password'] : false;
		if ($password)
		{
			$this->load->library('encryption');

			// Send plain password to client before encryption
			if (!$id)
			{
				$message = sprintf( __( 'message_provider_password' ), $password );
				$subject = sprintf( __( 'your_password_for_store' ), get_option( 'company' ) );

				if ( ! _has_option('turn_off_provider_password_email') ) {
					send_email( $post_array['provider_email'], $message, $subject );
				}
			}

			$hash_password = $this->encryption->encrypt(trim($password));
			$post_array['provider_password'] = $hash_password;
		}
		else
		{
			$hash_password = null;
			$post_array['provider_password'] = $hash_password;
		}
		if (!$id)
		{
			if (!$is_modal)
			{
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->providers->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors());
				}
			}
			else
			{
				if ($this->form_validation->run() === TRUE)
				{
					$row_affected = $this->providers->save($post_array);
					if ($row_affected != 0)
					{
						$this->response = array('status' => 1);
					}
				}
				else
				{
					$this->response = array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
				}
			}
			echo json_encode($this->response);
		}
		else
		{
			if ($this->form_validation->run() === TRUE)
			{
				$this->providers->save($post_array, $id);
				$this->response = array('status' => 1);
			}
			else
			{
				$this->response = array('status' => 0, 'error' => validation_errors());
			}
			echo json_encode($this->response);
		}
	}
}