<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * CLIENT CLASS
 * 
 * @copyright copyright information
 * @author Eric Claver AKAFFOU
 */
class Providers extends Admin_Controller
{
	/**
	 * Class constructor
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('providers_model', 'providers');

    	$this->data['breadcrumb'] = anchor('providers', __('link_providers'));
    	$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	/**
	 * Index Page
	 * @param type|string $a 
	 * @param type|bool $id 
	 * @return type
	 */
	public function add_provider()
	{
		if ( _has_option( 'is_indian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'india-purchase-order.js'
            );
    	}
    	elseif ( _has_option( 'is_romanian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'romania-purchase-order.js'
            );
    	}
    	else
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'purchase-order.js'
            );
    	}
		$data = array(
			'breadcrumb' 		=> anchor('providers', __('link_providers')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_providers'),
			'page_description' 	=> __('link_add_new') .' '.__('providers_provider'),
			'countries' 		=> get_countries(),
			'provider_type'		=> array(
				'1' => __('individual_provider'),
				'2' => __('professional_provider')
				),
			'provider_status' => array(
				'1' => __('option_active'),
				'0' => __('option_inactive')
				)
			);
		$this->view_data['content'] = $this->Template->render('providers', 'add_provider_form.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		if ( _has_option( 'is_indian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'india-purchase-order.js'
            );
    	}
    	elseif ( _has_option( 'is_romanian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'romania-purchase-order.js'
            );
    	}
    	else
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'purchase-order.js'
            );
    	}
		$id = isset($_REQUEST['id']) ? _dID($_REQUEST['id']) : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('providers', __('link_providers')),
			'toolbar'    		=> "",
			'page_title' 		=> __('providers_provider'),
			'page_description' 	=> __('message_manage') .' '.__('providers_provider'),
			'providers'	=> provider($id),
			'provider_location' => array(
				'1' => __('label_france'),
				'2' => __('label_EU'),
				'3' => __('label_outside_EU')
				),
			'provider_status' => array(
				'1' => __('option_active'),
				'0' => __('option_inactive')
				),
			'provider_type' => array(
				'1' => __('option_individual'),
				'2' => __('option_professional')
				),
			'provider_activity' => array(
				'1' => __('option_goods_provider'),
				'2' => __('option_services_provider')
				),
			'provider_tax_type' => array(
				'1' => __('option_tax_collection'),
				'2' => __('option_tax_debit')
				),
			'provider_payment_method' => array(
				'1' => __('option_check'),
				'2' => __('option_cash'),
				'3' => __('option_credit_card'),
				'4' => __('option_bank_transfer')
				),
			);
		$this->view_data['content'] = $this->Template->render('providers', 'edit_provider_form.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function index()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
				'providers-index.js'
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
				'providers-index.js'
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
				'providers-index.js'
	        );
		}
		$data = array(
			'breadcrumb' 		=> anchor('providers', __('link_providers')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_providers'),
			'page_description' 	=> __('message_manage') .' '.__('providers_providers'),
			'providers' => get_providers(),
			'filter'  => ''
			);
		if (can_access('items')) {
			$this->view_data['content'] = $this->Template->render('providers', 'index.phtml', $data, TRUE);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}

	/**
	 * Get all providers
	 * @return type json
	 */
	public function get_providers()
	{
		echo json_encode(providers());
	}
	public function get_active_providers()
	{
		echo json_encode(providers(1));
	}
	public function get_provider_credit()
	{
		$provider_id = $_REQUEST['provider_id'];
		echo json_encode(get_credit($provider_id));
	}
	/**
	 * Delete a provider
	 * @return type json response
	 */
	public function delete_provider()
	{
		$protected = [];
		$to_del = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				array_push($to_del, $i);
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('providers', 'provider_id', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function provider_account()
	{
		if ( _has_option( 'is_indian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'india-purchase-order.js'
            );
    	}
    	elseif ( _has_option( 'is_romanian') )
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'romania-purchase-order.js'
            );
    	}
    	else
    	{
    		$this->view_data['pageJs'] = array(
    			'providers.js',
    			'products.js',
                'purchase-order.js'
            );
    	}
		$id = _dID($_REQUEST['id']);
		$data = array(
			'breadcrumb' 		=> anchor('providers', __('link_providers')),
			'toolbar'    		=> "",
			'page_title' 		=> "",
			'page_description' 	=> "",
			'filter'			=> 'All',
			'provider_id'       => _eID($id),
			'name_company'	  => provider($id, 'name_company'),
			'total_income'    => '', //income_by_provider($id),
			'total_due'       => '', //unpaid_invoice_by_provider($id),
			'unpaid_invoices_list'	  => '', //provider_invoices($id),
			'providers'	=> provider($id),
			'provider_type' => array(
				'1' => __('individual_provider'),
				'2' => __('professional_provider')
				),
			'provider_status' => array(
				'1' => __('active'),
				'0' => __('inactive')
				)
			);
		$this->view_data['content'] = $this->Template->render('providers', 'provider_account.phtml', $data, TRUE);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function get_provider_purchases()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$id = _dID($_REQUEST['id']);
		$purchases = provider_purchases($id, $filter);
		if ($purchases)
		{
			foreach ($purchases as $purchase) {
				array_push($list, array(
					'id' 			  	  => $purchase->id,
					'purchase_number'      => $purchase->purchase_number,
					'enc_purchase_number'  => _eID($purchase->purchase_number),
					'date'   	 		  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $purchase->date),
					'shipping_date' 		  	  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $purchase->shipping_date),
					'total' 		  	  => format_number($purchase->total),
					'status'              => __(strtolower($purchase->purchase_status)),
					'stbool'			  => purchase_status($purchase->purchase_number)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function purchases_by_provider()
	{
		$id = _dID($_REQUEST['id']);
		$range = $_REQUEST['range'];
		$income = purchases_by_provider($id, $range);
		$unpaid = unpaid_purchase_by_provider($id, $range);
		echo json_encode(array($income, $unpaid));
	}
	public function products_services()
	{
		$list = [];
		$id = _dID($_REQUEST['id']);

		$products_services = provider_products_services($id);
		if ($products_services)
		{
			foreach ($products_services as $products_service) {
				array_push($list, array(
					'name' 		  		  => $products_service->name,
					'value' 	          => $products_service->value,
					'price'				  => $products_service->price,
					'total_value'		  => $products_service->value * $products_service->price
					)
				);
			}
		}
		echo json_encode($list);
	}

	public function get_providers_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'asc';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'name_company';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : '';

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$providers = $this->providers->findAll(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);
		if ($providers)
		{
			foreach ($providers as $provider) {
				array_push($rows, array(
					'provider_id' 		  => $provider->provider_id,
					'enc_provider_id' 	  => _eID($provider->provider_id),
					'name_company'        => $provider->name_company,
					'email'   	 		  => $provider->provider_email,
					'provider_phone' 		  => $provider->provider_phone,
					'provider_contact1' 	 => $provider->provider_contact1,
					'provider_contact2' 	 => $provider->provider_contact2,
					'provider_contact1_email' 	 => $provider->provider_contact1_email,
					'provider_contact2_email' 	 => $provider->provider_contact2_email,
					'provider_status'       => $provider->provider_status,
					'provider_status_str'   => status_str($provider->provider_status),
					'provider_date_created' => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $provider->provider_date_created)
					)
				);
			}

			if ( $search) {
				$list = array(
					'total' => count($providers),
					'totalNotFiltered' => count($providers),
					'rows' => $rows
				);
			} else {
				$total = $this->providers->count_rows('providers', $filter);
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows
				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function activate_provider()
	{
		$ids = _dID($_REQUEST['id']);
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				activate('providers', 'provider_status', 'provider_id', $i);	
			}
		}
		echo json_encode(array('success' => 1));
	}
	public function desactivate_provider()
	{
		$ids = _dID($_REQUEST['id']);
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				desactivate('providers', 'provider_status', 'provider_id', $i);
			}
		}
		echo json_encode(array('success' => 1));
	}
	public function get_provider_contacts()
	{
		$id = $_REQUEST['provider_id'];
		echo json_encode(provider($id, 'contact'));
	}
	public function get_provider_invoices()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'all' : $_REQUEST['filter'];
		$id = _dID($_REQUEST['id']);
		$invoices = provider_invoices($id, $filter);
		if ($invoices)
		{
			foreach ($invoices as $invoice) {
				if ($invoice->amount_paid > $invoice->amount_refunded AND $invoice->purchase_status == 'Refunded')
				{
					$status = __('label_partially_refunded', $id);
				}
				elseif ($invoice->amount_paid > 0 AND $invoice->purchase_status !== 'Paid')
				{
					$status = __('label_partially_paid');
				}
				elseif( $invoice->purchase_status == 'Expired' || $invoice->purchase_status == 'Open' || $invoice->purchase_status == 'Pending' || $invoice->purchase_status == 'Failed')
				{
					$status = __('unpaid');
				}
				else
				{
					$status = __(strtolower($invoice->purchase_status), $id);
				}
				array_push($list, array(
					'id' 			  	  => $invoice->id,
					'invoice_number'      => $invoice->invoice_number,
					'enc_invoice_number'  => _eID($invoice->invoice_number),
					'date'   	 		  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $invoice->date),
					'due_date' 		  	  => _fdate(language_string_to_locale_notation( get_option('user_language', 'users_options') ), $invoice->due_date),
					'total' 		  	  => format_number($invoice->total),
					'amount_paid' 		  => $invoice->amount_paid,
					'amount_refunded' 	  => $invoice->amount_refunded,
					'status'              => $status,
					'stbool'			  => purchase_status($invoice->invoice_number)
					)
				);
			}
		}
		echo json_encode($list);
	}
}