<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Providers_model
 * @since 1.0.6
 */
class Providers_model extends MY_Model {
	/**
	 * Class constructor
	 * @return type void
	 */
	public function __construct()
	{
		parent::__construct();
		$this->_table = 'providers';
		$this->_primaryKey = 'provider_id';
	}
	/**
	 * delete
	 * @param type $id 
	 * @return type mixed
	 */
	public function delete($id)
	{
		$this->_tables = ['invoices', 'quotes'];
		$this->set_table('providers');
		$this->_select = 'provider_id';
		$this->_primary_key = 'provider_id';

		if (!$this->before_delete($id))
		{
			return parent::delete($id);
		}
		return false;
	}
	/*
	|--------------------------------------------------------------------------
	| Providers - Model 
	|--------------------------------------------------------------------------
	|
	| A complete rewrite of the provider model
	|
	*/

	/**
	 * Get a provider object
	 * @param type $id 
	 * @param type|array $cols 
	 * @return type
	 */
	public function find($id = null, $cols = []) {
		$db = MysqliDb::getInstance();
		is_array($cols) OR $cols = (array)$cols;

		if ($id){
			$db->where("p.provider_id", intval($id));
			return $db->ObjectBuilder()->get('oc_providers p', 1, $cols);
		} else {
			return $db->ObjectBuilder()->get('oc_providers p', null, $cols);
		}
	}

	/**
	 * Get all clients
	 * @param type|array $params 
	 * @return type
	 */
	public function findAll($params = [])
	{
		$db = MysqliDb::getInstance();
		is_array($params) OR $params = (array)$params;
		$status = isset($params['status']) ? $params['status']: false;
		$search = isset($params['search']) ? $params['search']: false;
		$sort   = isset($params['sort']) ? $params['sort']: 'name_company';
		$order  = isset($params['order']) ? $params['order']: 'asc';
		$pagination = isset($params['pagination']) ? $params['pagination']: false;
		$offset = isset($params['offset']) ? $params['offset'] : 0;
		$limit = isset($params['limit']) ? $params['limit']: get_option('default_table_size');

	    // Columns to collect
	    $cols = array(
	        "p.*"
	    );
	    // Set order
	    $db->orderBy($sort, $order);

	    if ($status) {
	        $db->where('p.provider_status', $status, '=');
	    } elseif ($search) {

	        $db->where('p.provider_id', '%' . $search . '%', 'LIKE');
	        $db->orWhere('p.name_company', '%' . $search . '%', 'LIKE');
	        $db->orWhere('p.provider_email', '%' . $search . '%', 'LIKE');
	        $db->orWhere('p.provider_phone', '%' . $search . '%', 'LIKE');
	    }
	    if (!$pagination) {
	    	return $db->ObjectBuilder()->get('oc_providers p', null, $cols);
	    } else {
	    	return $db->ObjectBuilder()->get('oc_providers p', array($offset, $limit), $cols);
	    }
	}
}