<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ajax extends Ajax_Controller {

	protected $item_paid_date;
	public function __construct()
	{
		parent::__construct();
		$this->load->model('purchases/purchases_model', 'purchases');
	}

	/**
	 * Create/Update Quote
	 * @return type mixed
	 */
	public function create_purchase()
	{
		$attachments = [];
		$repair_number								= null != $this->input->post('repair_number') ? _dID($this->input->post('repair_number')): null;
		$purchase_number							= $this->input->post('purchase_number');
		$purchase_status							= $this->input->post('purchase_status');
		$provider_id								= $this->input->post('provider_id');
		$ship_to									= $this->input->post('ship_to');
		$date 										= $this->input->post('date');
		$shipping_date								= $this->input->post('shipping_date');
		$shipment_status							= $this->input->post('shipment_status');
		$subtotal 									= $this->input->post('subtotal');
		$tax_amount 								= $this->input->post('tax_amount');
		$global_discount 							= $this->input->post('global_discount');
		$discount_amount 							= $this->input->post('discount_amount');
		$total 										= $this->input->post('total');
		$notes 										= $this->input->post('notes');
		$external_number 							= $this->input->post('subject');
		$shipping_amount 							= $this->input->post('shipping_amount');
		$other_expenses								= $this->input->post('other_expenses');
		$amount_due 								= $this->input->post('amountDue');
		$amount 									= $this->input->post('totalAftertax');
		$item_sku 									= $this->input->post('itemSku');
		$item_id 									= $this->input->post('itemID');
		$item_name 									= $this->input->post('itemName');
		$files										= isset($_FILES['files']['name']) ? $_FILES['files']['name']: [];
		
		$currency 		= $provider_id == 0 ? get_option( 'user_currency' ) : provider( $provider_id, 'provider_currency' );
		$change_rate 	= _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
		// Data that will be saved in quotes table
		$purchaseTable 								= [];
		$purchaseTable['purchase_number'] 				= $purchase_number;
		$purchaseTable['repair_number'] 				= $repair_number;
		$purchaseTable['purchase_status'] 				= $purchase_status;
		$purchaseTable['provider_id'] 				    = $provider_id;
		$purchaseTable['date'] 							= $date;
		$purchaseTable['ship_to'] 						= $ship_to;
		$purchaseTable['shipping_date'] 				= $shipping_date;
		$purchaseTable['shipment_status'] 				= $shipment_status;
		$purchaseTable['subtotal'] 						= $subtotal;
		$purchaseTable['tax_amount'] 					= $tax_amount;
		$purchaseTable['global_discount'] 				= $global_discount;
		$purchaseTable['discount_amount'] 				= $discount_amount;
		$purchaseTable['total'] 						= $total;
		$purchaseTable['notes'] 						= $notes;
		$purchaseTable['subject'] 						= $external_number;
		$purchaseTable['amount_due']					= $amount_due;
		$purchaseTable['shipping_amount']				= $shipping_amount;
		$purchaseTable['other_expenses']				= $other_expenses;

		// Data that will be saved in the items table
		$itemTable									= [];
		$itemTable['amount']						= $amount;
		$itemTable['item_sku']						= $item_sku;
		$itemTable['item_id']						= $item_id;
		$itemTable['item_name']						= $item_name;
		$itemTable['provider_id']					= $provider_id;
		$itemTable['notes']							= $notes;

		// Set Invoice to sent or not
		$purchaseTable['sent'] = ($this->input->post('notify_provider') == 1) ? 'yes': 'no';

		# Convert dates before insertion
		$user_language 				= get_option('user_language', 'users_options');
		$provider_language  			= provider($provider_id, 'provider_language');
		$purchaseTable['date'] 		= mysqlDate($user_language, $purchaseTable['date']);
		$purchaseTable['shipping_date']     = mysqlDate($user_language, $purchaseTable['shipping_date']);

		// Set Invoice to Unpaid if client notification is set to 'yes'
		if($purchaseTable['sent'] === 'yes' && $purchaseTable['purchase_status'] === "Draft")
		{
			$purchaseTable['purchase_status'] = "Pending";
		}
		// Get array fields for validation
		$ids = $this->input->post('itemID');
		$names = $this->input->post('itemName');
		$quantity = $this->input->post('itemQuantity');
		$price = $this->input->post('itemPrice');

		// Insert in purchased item
		if ($purchaseTable['purchase_status'] == 'Paid')
		{
			$db_data = array(
				'charges_name' 		=> __('charges_purchases'),
				'charges_category' 	=> 1,
				'charges_value'	    => $total + $shipping_amount + $other_expenses,
				'charges_sku'	    => generate_sku(),
				'incomes_name'	    => null,
				'incomes_sku'	    => null,
				'incomes_category'	=> null,
				'incomes_value'	    => null,
				'payment_method'    => get_option('default_payment_method'),
				'turnover_included'	=> 1,
				'taxes'             => null,
				'created_on' 	    => $this->current_date,
				'purchase_number'   => $purchase_number
				);
			record_charges($db_data, 'purchase_number', isset($id) ? $id: $purchase_number);
			$purchaseTable['date_paid'] = date('Y-m-d');
			$purchaseTable['amount_paid'] = $total + $shipping_amount + $other_expenses;
			$purchaseTable['amount_due'] = 0;
			$this->item_paid_date = date('Y-m-d');

		}

		if(!empty($names))
		{
        // Loop through $names and add the validation
			foreach($names as $key => $value)
			{
				$this->form_validation->set_rules('itemName[' . $key . ']', 'lang:item_name', 'required',
					array(
						'required' => lang('error_required_name') . '<br />'
						)
					);
			}
		}
		if(!empty($quantity))
		{
        // Loop through quantity and add the validation
			foreach($quantity as $key => $value)
			{
				$this->form_validation->set_rules('itemQuantity[' . $key . ']', 'lang:item_quantity', 'required',
					array(
						'required' => lang('error_required_quantity') . '<br />'
						)
					);
			}
		}

		if(!empty($price))
		{
        // Loop through price and add the validation
			foreach($price as $key => $value)
			{
				$this->form_validation->set_rules('itemPrice[' . $key . ']', 'lang:item_price', 'required',
					array(
						'required' => lang('error_required_price') . '<br />'
						)
					);
			}
		}

		if(count($files)){
			
			$config['upload_path']          = './uploads/purchases';
			if (!file_exists($config['upload_path']))
			    mkdir($config['upload_path']);

			if( chmod($config['upload_path'], 0755) ) 
	        {
	            chmod($config['upload_path'], 0777);
	        }

			for ($i=0; $i < count($files); $i++) { 
				if (!empty($_FILES['files']['name'][$i])){
					$_FILES['file']['name'] = $_FILES['files']['name'][$i];
					$_FILES['file']['type'] = $_FILES['files']['type'][$i];
					$_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
					$_FILES['file']['error'] = $_FILES['files']['error'][$i];
					$_FILES['file']['size'] = $_FILES['files']['size'][$i];

					$config['upload_path']          = './uploads/purchases';
					$config['allowed_types']        = '*';
					$config['max_size']        		= '5000';
					$config['file_name']        	= $_FILES['files']['name'][$i];

					$this->load->library('upload', $config);
					if ( ! $this->upload->do_upload('file'))
					{
						$error = $this->upload->display_errors();
						$this->form_validation->set_rules($error);
					} else {
						$data = $this->upload->data();
						$attachments[] = './uploads/purchases/'.$data['file_name'];
					}
				}
			}
			$purchaseTable['attachments'] = json_encode($attachments);
		}
		if ( $this->form_validation->run() === FALSE )
		{
			$this->response = array('status' => 0, 'error' => validation_errors() );
		}
		else
		{
			if ($this->input->post('purchase_id'))
			{
				$id = $this->input->post('purchase_id');
				// Invoice attachments
				$purchase = get_purchase_by_number($id);
				$last_files = json_decode($purchase[0]->attachments, true);

				if($last_files){
					foreach ($last_files as $file) {
						$attachments[] = $file;
					}
				}
				$purchaseTable['attachments'] = json_encode($attachments);
				delete('purchases_items', 'purchase_number', $id);
				$this->purchases->set_table('purchases');
				$this->purchases->save($purchaseTable, $id);
			}
			else
			{
				$this->purchases->set_table('purchases');
				$this->purchases->save($purchaseTable);
			}

			// Insert Items in database
			$items_num 			= count( array_filter( $this->input->post('itemName')) ); // Get number of items, strip empty lines
			$item_sku 			= $this->input->post('itemSku');
			$item_id 			= $this->input->post('itemID');
			$item_name  		= array_filter( $this->input->post('itemName') );
			$item_quantity 		= array_filter( $this->input->post('itemQuantity') );
			$item_price  		= array_filter( $this->input->post('itemPrice') );
			$item_discount 		= $this->input->post('itemDiscount');
			$item_tax_rate 		= $this->input->post('itemTax');
			// Indan Vars
			$item_hsn_sac  = $this->input->post('itemHSNSAC');
			$item_uom  = $this->input->post('itemUom');
			$item_mpn  = $this->input->post('itemMpn');
			$item_cgst_tax_rate = $this->input->post('itemTaxCGST');
			$item_sgst_tax_rate = $this->input->post('itemTaxSGST');
			$item_igst_tax_rate = $this->input->post('itemTaxIGST');
			$item_cess_tax_rate = $this->input->post('itemTaxCESS');

			$item_cgst_amount = $this->input->post('itemTaxAmountCGST');
			$item_sgst_amount = $this->input->post('itemTaxAmountSGST');
			$item_igst_amount = $this->input->post('itemTaxAmountIGST');
			$item_cess_amount = $this->input->post('itemTaxAmountCESS');
			$item_subtotal 		= array_filter( $this->input->post('itemSubTotal') );
			$provider_id 			= $this->input->post('provider_id');
			$purchase_number 		= $this->input->post('purchase_number');

			$this->purchases->set_table('purchases_items');
			for($i = 0; $i < $items_num; $i++){
				$item_array = array(
					'purchase_number' 		=> $purchase_number,
					'repair_number' 		=> $repair_number,
					'provider_id' => $provider_id,
					'item_sku' => $item_sku[$i],
					'item_id' => $item_id[$i],
					'item_group' => $this->m_manager->category_id($item_id[$i]),
					'item_name' => addslashes($item_name[$i]),
					'item_hsn_sac' => $item_hsn_sac[$i],
					'item_uom' => $item_uom[$i],
					'product_mpn' => $item_mpn[$i],
					'item_price' => $item_price[$i],
					'item_discount' => $item_discount[$i],
					'item_quantity' => $item_quantity[$i],
					'item_subtotal' => $item_subtotal[$i],
					'item_tax_rate' => $item_tax_rate[$i],
					'item_cgst_rate' => $item_cgst_tax_rate[$i],
					'item_sgst_rate' => $item_sgst_tax_rate[$i],
					'item_igst_rate' => $item_igst_tax_rate[$i],
					'item_cess_rate' => $item_cess_tax_rate[$i],
					'item_cgst_amount' => $item_cgst_amount[$i],
					'item_sgst_amount' => $item_sgst_amount[$i],
					'item_igst_amount' => $item_igst_amount[$i],
					'item_cess_amount' => $item_cess_amount[$i],
					'date_paid' => isset($this->item_paid_date) ? $this->item_paid_date : null
					);
				$this->purchases->save($item_array);
				$this->response = array('status' => 1);
			}
			// End insert items
			// Since 1.5 Add Item to database if not found in autocomplete
			for($i = 0; $i < $items_num; $i++){
				if ( !item_exists($item_name[$i]) )
				{
					if ( $shipment_status == 'Received' AND 'Received' !== $this->input->post('already_shipped'))
					{
						$new_item_array = array(
							'sku' => null !== $item_sku[$i] ? $item_sku[$i]: generate_sku(),
							'group_id' => 0,
							'name' => $item_name[$i],
							'purchase_price' => $item_price[$i],
							'on_hand_stock' => $item_quantity[$i] // Item not in db, but purchase is received. Record quantity as on hand stock
							);
						$this->load->model('products/products_model', 'items');
						$this->items->set_table('items');
						$this->items->save($new_item_array);
					}
					else
					{
						$new_item_array = array(
							'sku' => null !== $item_sku[$i] ? $item_sku[$i]: generate_sku(),
							'group_id' => 0,
							'name' => addslashes($item_name[$i]),
							'purchase_price' => $item_price[$i],
							'on_hand_stock' => 0
							);
						$this->load->model('products/products_model', 'items');
						$this->items->set_table('items');
						$this->items->save($new_item_array);
					}
				}
				else
				{
					if ( $shipment_status == 'Received' AND 'Received' !== $this->input->post('already_shipped'))
					{
						update_on_hand( $item_name[$i], $item_quantity[$i] );
						$this->response = array('status' => 1, 'stockupdated' => 1);
					}
				}
			}
			// Do not send email for Draft Invoices or on update
			if ( $purchaseTable['purchase_status'] !== 'Draft' && $provider_id > 0 && $this->input->post('notify_provider') == 1 )
			{
				$data = array(
					'purchase_url'				=> base_url( 'index.php/viewpurchase/view?id=' ) . _eID( $purchase_number ),
					'to_name'            	=> html_entity_decode(htmlentities((provider( $provider_id, 'name_company' )))),
					'date'		    		=> _fdate( $provider_language, $date ),
					'shipping_date'		    => _fdate( $provider_language, $shipping_date ),
					'purchase_status'			=> __( strtolower( $purchase_status ), $provider_id ),
					'purchase_number' 			=> get_option('purchase_order_prefix').invoice_number_format() . sprintf("%04s", $purchase_number),
					'invoicesubject'		=> $external_number
					);

				$data['purchase_amount'] 		= add_provider_currency( format_number( $total * $change_rate ), $provider_id );
				//$data['amount_paid'] 		= add_provider_currency( format_number( $amount_paid * $change_rate ), $provider_id );
				//$data['payment_id'] 		= $payment_id;
				$data['amount_due'] 		= add_provider_currency( format_number( $amount_due * $change_rate ), $provider_id );

				$data['provider_account'] 	= base_url( 'index.php/provider/index?id=' ) . _eID( $provider_id );
				$data['logo_url'] 			= base_url( 'uploads/admin/img/' ). get_option( 'logo' );
				$data['btn_provider_account'] = __( 'btn_provider_account', $provider_id );

				$this->load->helper('file');
				$lang 						= lang_code_to_notif_string( provider( $provider_id, 'provider_language' ) );
				$path_new_purchase 			= './notifications/' . $lang . '/purchases/new_purchase.php';
				$path_purchase_paid 			= './notifications/' . $lang . '/purchases/purchase_paid.php';

				if ( $purchase_status === "Paid" )
				{
					$template 	= read_file( $path_purchase_paid );
					$subject 	= __( 'subject_paid_purchase_order', $provider_id );
				}
				else
				{
					$template 					= read_file( $path_new_purchase );
					$subject 					= __( 'subject_purchase_order', $provider_id );
				}
				
				$to 						= provider( $provider_id, 'provider_email' );
				$message 					= $this->parser->parse_string($template, $data, true);

				send_email($to, $message, $subject, null,null, $attachments);
			}
			if ($this->input->post('notify_client') == 1) {
				$message = __('message_purchase_order_status_changed');
				$subject =  __('subject_purchase_order_changes');
				send_email(get_option('notifications_email'), $message, $subject, null,null, $attachments);
			}
		}
		echo json_encode( $this->response );
	}
	public function add_address() {
		$post_array = [
			'name_company' => $this->input->post('name_company'),
			'status' => $this->input->post('status'),
			'address1' => $this->input->post('address1'),
			'address2' => $this->input->post('address2'),
			'city' => $this->input->post('city'),
			'postcode' => $this->input->post('postcode'),
			'state' => $this->input->post('state'),
			'country' => $this->input->post('country'),
			'phone' => $this->input->post('phone')
		];
		$config = array(
			array(
				'field' => 'name_company',
				'label' => lang('label_name_company'),
				'rules' => 'required',
				'errors' => array(
					'required' => lang('error_required_name'). '<br />'
					)
				)
			);
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() === TRUE)
		{
			$id = $this->input->post('id'); 
			if ($id) {
				$row_affected = save_company_shipping_address($post_array, $id);
			} else {
				$row_affected = save_company_shipping_address($post_array);
			}
			if ($row_affected != 0)
			{
				if ($id) {
					$this->response = array('status' => 1, 'notify' => 1);
				} else {
					$this->response = array('status' => 1);
				}
			}
		}
		else
		{
			if ( !$id) {
				$this->response = array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			} else {
				$this->response = array('status' => 0, 'error' => validation_errors());
			}
		}
		echo json_encode( $this->response );
	}
}