<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Purchasesprovider extends Basic_Controller {
	/**
	 * @var type
	 */
	protected $_purchase = [];

	/**
	 * @var type
	 */
	protected $_provider = [];

	/**
	 * Description
	 * @return type
	 */
	public function __construct(){
		parent::__construct();
		$this->load->model('providers/providers_model', 'providers');
		$this->providers->set_primary_key('provider_id');
		$this->load->model('purchases_model', 'purchases');
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-purchase-order.js'
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-purchase-order.js'
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'purchase-order.js'
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
        $this->view_data['modal'] = $this->load->view('providers/add_provider_modal.phtml', '', true);
	}
	
	/**
	 * Description
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type
	 */
	public function index()
	{
		$view_data = array(
			'breadcrumb' 		=> anchor('purchases', __('link_purchase_orders')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_purchase_orders'),
			'page_description' 	=> __('message_manage') .' '.__('link_purchase_orders'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'filter'			=> 'All'
			);
		$this->view_data['content'] = $this->load->view('index.phtml', $view_data, true);
		$this->load->view('templates/layout.phtml', $this->view_data);
	}
	public function create_purchase()
	{
		$data = array(
			'breadcrumb' 		=> anchor('purchases', __('link_purchase_orders')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_purchase_orders'),
			'page_description' 	=> __('link_add_new') .' '.__('label_purchase')
			);
		$this->view_data['content'] = $this->load->view('create_purchase_form.phtml', $data, true);
		$this->load->view('templates/layout.phtml', $this->view_data);
	}
	public function edit()
	{
		$id = _dID($_REQUEST['id']);
		$provider_id = $_REQUEST['providerid'];
		$view_data = array(
			'breadcrumb' 		=> anchor('purchases', __('link_purchase_orders')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_purchase_orders'),
			'page_description' 	=> __('message_manage') .' '.__('label_purchase'),
			'user_language' 	=> get_option('user_language', 'users_options'),
			'purchases' 		=> get_purchase_by_number($id),
			'purchase_items' 	=> get_purchased_items($id),
			'providers' 		=> json_encode(providers()),
			'provider_id'		=> $provider_id,
			'name_company'		=> 'Eric',
			'purchase_status' 	=> array(
				'Accepted' 		=> __('label_accepted'),
				'Declined' 		=> __('label_declined'),
				'Pending' 		=> __('label_pending'),
				'Draft' 		=> __('label_draft'),
				'Cancelled' 	=> __('label_cancelled'),
				'Paid' 			=> __('label_paid')
				),
			'shipment_status' 	=> array(
				'Pending' 		=> __('label_pending'),
				'Received' 		=> __('label_received')
				)
			);
		$this->view_data['content'] = $this->load->view('edit_purchase_form.phtml', $view_data, true);
		$this->load->view('templates/provider_account.phtml', $this->view_data);
	}
	public function delete_purchase()
	{
		$protected = [];
		$to_del = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (purchase_status($i) == 'is_paid' || purchase_status($i) == 'is_accepted' )
				{
					array_push($protected, $i);
				}
				else
				{
					array_push($to_del, $i);
				}
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('purchases', 'purchase_number', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function mark_approved()
	{
		$protected = [];
		$to_mark_approved = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (purchase_status($i) !== 'is_accepted' AND purchase_status($i) !== 'is_paid')
				{
					array_push($to_mark_approved, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_approved);
			$response['fail'] = count($protected);

			if(!empty($to_mark_approved))
			{
				mass_approved_purchases($to_mark_approved);
			}
		}
		echo json_encode($response);
	}
	public function mass_email()
	{
		$protected = [];
		$to_send = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (purchased_from_guest($i) > 0)
				{
					array_push($to_send, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_send);
			$response['fail'] = count($protected);

			if(!empty($to_send))
			{
				foreach ($to_send as $order_number) {
					$this->m_manager->send_purchase_email($order_number);
				}
			}
		}
		echo json_encode($response);
	}
	public function purchases_list()
	{
		$list 			= [];
		$filter 		= $_REQUEST['filter'];
		$purchases 		= get_purchase_orders($filter);
		if ($purchases)
		{
			foreach ($purchases as $purchase) {
				array_push($list, array(
					'id' 				  		=> $purchase->id,
					'provider_id'         		=> _eID($purchase->provider_id),
					'purchase_number'   	  	=> $purchase->purchase_number,
					'enc_purchase_number'    	=> _eID($purchase->purchase_number),
					'name_company'		  		=> $purchase->name_company,
					'date' 						=> _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $purchase->date),
					'shipping_date'			  	=> _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $purchase->shipping_date),
					'total'				  		=> format_number($purchase->total + $purchase->shipping_amount + $purchase->other_expenses),
					'status'              		=> __(strtolower($purchase->purchase_status)),
					'shipment_status'           => __(strtolower($purchase->shipment_status)),
					'stbool'			  		=> purchase_status($purchase->purchase_number)
					)
				);
			}
		}
		echo json_encode($list);
	}
	public function next_purchase_order_number()
	{
		echo json_encode(next_purchase_order_number());
	}
	public function purchase_autocomplete()
	{
		$data = [];
		$results = get_all_items(1);
		if(! empty($results) )
		{
			if (! _has_option('is_indian') )
			{
				foreach($results as $row)
				{
					$name = $row->sku .'|'. $row->name .'|' .$row->purchase_price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
					array_push($data, $name);
				}
			}
			else
			{
				foreach($results as $row)
				{
					$name = $row->sku .'|'. $row->name .'|' .$row->purchase_price .'|'. $row->tax_percent . '|' . $row->item_id . '|'. $row->uom_value . '|'. $row->hsn_sac_value. '|'. $row->sgst_rate. '|'. $row->igst_rate. '|'. $row->cgst_rate. '|'. $row->cess_rate;
					array_push($data, $name);
				}
			}
		}
		echo json_encode($data);
	}
	public function provider_account()
	{
		$id = _dID($_REQUEST['id']);
		$data = array(
			'breadcrumb' 				=> anchor('providers', __('link_providers')),
			'toolbar'    				=> "",
			'page_title' 				=> "",
			'page_description' 			=> "",
			'provider_id'       		=> _eID($id),
			'name_company'	  			=> provider($id, 'name_company'),
			'total_income'    			=> income_by_client($id),
			'total_due'       			=> unpaid_invoice_by_client($id),
			'unpaid_invoices_list'	  	=> client_invoices($id),
			'providers'					=> provider($id),
			'filter' 					=> ''
			);
		$this->view_data['content'] 	= $this->load->view('provider_account.phtml', $data, TRUE);
		$this->load->view('templates/layout.phtml', $this->view_data);
	}
}