<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */

use PhpRbac\Rbac;

class Purchases_model extends MY_Model{

	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->_table = 'purchases';
		$this->_primary_key = 'purchase_number';
	}
	/**
	 * Description
	 * @return type
	 */
	public function getRecurrentInvoices()
	{
		$query = "SELECT * 
						FROM {$this->tables['invoices']}
						WHERE pay_type > 1 AND next_duedate = CURDATE()";
		return $this->oneric->get_results($query);
	}
	/**
	 * Description
	 * @param type $id 
	 * @return type
	 */
	public function countInvoices()
	{
		$query = "SELECT COUNT(id) AS InvoiceNumb FROM {$this->tables['invoices']}";
		return $this->oneric->get_results($query);
	}
	public function duplicate_invoiced_items($invoice_number)
	{
		$query = "SELECT * 
						FROM {$this->tables['invoices_items']}
						WHERE invoice_number = {$invoice_number}";
		return $this->oneric->get_results($query);
	}
	 /*
	|--------------------------------------------------------------------------
	| Invoices - Model 
	|--------------------------------------------------------------------------
	|
	| A complete rewrite of the invoices model
	|
	*/
	public function findAll($params = [])
	{
	    $db = MysqliDb::getInstance();
	    is_array($params) OR $params = (array)$params;
	    $status = isset($params['status']) ? $params['status']: null;
	    $search = isset($params['search']) ? $params['search']: false;
	    $sort   = isset($params['sort']) ? $params['sort']: 'id';
	    $order  = isset($params['order']) ? $params['order']: 'DESC';
	    $pagination = isset($params['pagination']) ? $params['pagination']: false;
	    $offset = isset($params['offset']) ? $params['offset'] : 0;
	    $limit = isset($params['limit']) ? $params['limit']: get_option('default_table_size');

	    $rbac = new Rbac;
	    if ($rbac->check('report_owner', USERID) and !$rbac->check('report_access_any', USERID)) {
	        $db->where('user_id', USERID);
	    }
	    $db->join('oc_providers s', "p.provider_id=s.provider_id", 'LEFT');
	    // Columns to collect
	    $cols = array(
	        "p.*",
	        "s.name_company",
	    );
	   
	    if ($search) {
	        // Search by invoice number
	        $db->where('p.id', '%' . $search . '%', 'LIKE');
	        $db->orWhere('s.name_company', '%' . $search . '%', 'LIKE');
	        $db->orWhere('p.total', '%' . $search . '%', 'LIKE');
	    }

	    if ($status != 'All') {
	        $db->where('p.purchase_status', ucfirst(strtolower($status)), '=');
	    }

	    // Set order
	    $db->orderBy($sort, $order);

	    if ( !$pagination) {
	        return $db->get('oc_purchases p', null, $cols);
	    } else {
	        return $db->get('oc_purchases p', array($offset, $limit), $cols);
	    }
	}
}