<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * 
 */
class Ajax extends Ajax_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('quotes/quotes_model', 'quotes');
	}

	/**
	 * Create/Update Quote
	 * @return type mixed
	 */
	public function create_quote()
	{
		$m = $this->m;
		$attachments = [];
		$repair_number								= true == has_repair_module() ? _dID($this->input->post('repair_number')): false;
		$quote_number								= $this->input->post('quote_number');
		$quote_status								= $this->input->post('quote_status');
		$client_id									= $this->input->post('client_id');
		$date 										= $this->input->post('date');
		$due_date									= $this->input->post('due_date');
		$subtotal 									= $this->input->post('subtotal');
		$tax_amount 								= $this->input->post('tax_amount');
		$global_discount 							= $this->input->post('global_discount');
		$discount_amount 							= $this->input->post('discount_amount');
		$total 										= $this->input->post('total');
		$notes 										= $this->input->post('notes');
		$external_number 							= $this->input->post('subject');
		$amount_due 								= $this->input->post('amountDue');
		$amount 									= $this->input->post('totalAftertax');
		$item_sku 									= $this->input->post('itemSku');
		$specific_serial_number 					= $this->input->post('itemSN');
		$item_id 									= $this->input->post('itemID');
		$item_name 									= $this->input->post('itemName');
		$files										= isset($_FILES['files']['name']) ? $_FILES['files']['name']: [];
		$currency 		= $client_id == 0 ? get_option( 'user_currency' ) : client( $client_id, 'client_currency' );
		$change_rate 	= _has_option( 'change_currency' ) ? get_change_rate( $currency ) : 1;
		// Data that will be saved in quotes table
		$quoteTable 								= [];
		$quoteTable['quote_number'] 				= $quote_number;
		$quoteTable['quote_status'] 				= $quote_status;
		$quoteTable['client_id'] 				    = $client_id;
		$quoteTable['user_id'] 				    	= $m->getUserID();
		$quoteTable['date'] 						= $date;
		$quoteTable['due_date'] 					= $due_date;
		$quoteTable['subtotal'] 					= $subtotal;
		$quoteTable['tax_amount'] 					= $tax_amount;
		$quoteTable['global_discount'] 				= $global_discount;
		$quoteTable['discount_amount'] 				= $discount_amount;
		$quoteTable['total'] 						= $total;
		$quoteTable['notes'] 						= $notes;
		$quoteTable['subject'] 						= $external_number;
		$quoteTable['amount_due']					= $amount_due;

		if ($repair_number) {
			$quoteTable['repair_number']			= $repair_number;
		}

		// Data that will be saved in the items table
		$itemTable									= [];
		$itemTable['amount']						= $amount;
		$itemTable['item_sku']						= $item_sku;
		$itemTable['specific_serial_number']		= $specific_serial_number;
		$itemTable['item_id']						= $item_id;
		$itemTable['item_name']						= $item_name;
		$itemTable['client_id']						= $client_id;
		$itemTable['notes']							= $notes;

		// Set Invoice to sent or not
		$quoteTable['sent'] = ($this->input->post('notify_client') == 1) ? 'yes': 'no';

		# Convert dates before insertion
		$user_language 				= get_option('user_language', 'users_options');
		$client_language  			= client($client_id, 'client_language');
		$quoteTable['date'] 		= mysqlDate($user_language, $quoteTable['date']);
		$quoteTable['due_date']     = mysqlDate($user_language, $quoteTable['due_date']);

		// Set Invoice to Unpaid if client notification is set to 'yes'
		if($quoteTable['sent'] === 'yes' && $quoteTable['quote_status'] === "Draft")
		{
			$quoteTable['quote_status'] = "Pending";
		}
		// Get array fields for validation
		$ids = $this->input->post('itemID');
		$names = $this->input->post('itemName');
		$quantity = $this->input->post('itemQuantity');
		$price = $this->input->post('itemPrice');

		if(!empty($names))
		{
        // Loop through $names and add the validation
			foreach($names as $key => $value)
			{
				$this->form_validation->set_rules('itemName[' . $key . ']', 'lang:item_name', 'required',
					array(
						'required' => lang('error_required_name') . '<br />'
						)
					);
			}
		}
		if(!empty($quantity))
		{
        // Loop through quantity and add the validation
			foreach($quantity as $key => $value)
			{
				$this->form_validation->set_rules('itemQuantity[' . $key . ']', 'lang:item_quantity', 'required',
					array(
						'required' => lang('error_required_quantity') . '<br />'
						)
					);
			}
		}

		if(!empty($price))
		{
        // Loop through price and add the validation
			foreach($price as $key => $value)
			{
				$this->form_validation->set_rules('itemPrice[' . $key . ']', 'lang:item_price', 'required',
					array(
						'required' => lang('error_required_price') . '<br />'
						)
					);
			}
		}
		if(count($files)){
			
			$config['upload_path']          = './uploads/quotes';
			if (!file_exists($config['upload_path']))
			    mkdir($config['upload_path']);

			if( chmod($config['upload_path'], 0755) ) 
	        {
	            chmod($config['upload_path'], 0777);
	        }

			for ($i=0; $i < count($files); $i++) { 
				if (!empty($_FILES['files']['name'][$i])){
					$_FILES['file']['name'] = $_FILES['files']['name'][$i];
					$_FILES['file']['type'] = $_FILES['files']['type'][$i];
					$_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
					$_FILES['file']['error'] = $_FILES['files']['error'][$i];
					$_FILES['file']['size'] = $_FILES['files']['size'][$i];

					$config['upload_path']          = './uploads/quotes';
					$config['allowed_types']        = '*';
					$config['max_size']        		= '5000';
					$config['file_name']        	= $_FILES['files']['name'][$i];

					$this->load->library('upload', $config);
					if ( ! $this->upload->do_upload('file'))
					{
						$error = $this->upload->display_errors();
						$this->form_validation->set_rules($error);
					} else {
						$data = $this->upload->data();
						$attachments[] = './uploads/quotes/'.$data['file_name'];
					}
				}
			}
			$quoteTable['attachments'] = json_encode($attachments);
		}
		if ( $this->form_validation->run() === FALSE )
		{
			$this->response = array('status' => 0, 'error' => validation_errors() );
		}
		else
		{
			if ($this->input->post('quote_id'))
			{
				$id = $this->input->post('quote_id');
				$quoteTable['user_id'] = $this->input->post('user_id');
				// Invoice attachments
				$quote = get_quote_by_number($id);
				$last_files = json_decode($quote[0]->attachments, true);

				if($last_files){
					foreach ($last_files as $file) {
						$attachments[] = $file;
					}
				}
				$quoteTable['attachments'] = json_encode($attachments);
				delete('quotes_items', 'quote_number', $id);
				$this->quotes->set_table('quotes');
				$this->quotes->save($quoteTable, $id);
			}
			else
			{
				$this->quotes->set_table('quotes');
				$this->quotes->save($quoteTable);
			}

			// Insert Items in database
			$items_num 			= count( array_filter( $this->input->post('itemName')) ); // Get number of items, strip empty lines
			$item_sku 			= $this->input->post('itemSku');
			$specific_serial_number 			= $this->input->post('itemSN');
			$item_id 			= $this->input->post('itemID');
			$item_name  		= array_filter( $this->input->post('itemName') );
			$item_quantity 		= array_filter( $this->input->post('itemQuantity') );
			$item_price  		= array_filter( $this->input->post('itemPrice') );
			$item_discount 		= $this->input->post('itemDiscount');
			$item_tax_rate 		= $this->input->post('itemTax');
			// Indan Vars
			$item_hsn_sac  = $this->input->post('itemHSNSAC');
			$item_uom  = $this->input->post('itemUom');
			$item_cgst_tax_rate = $this->input->post('itemTaxCGST');
			$item_sgst_tax_rate = $this->input->post('itemTaxSGST');
			$item_igst_tax_rate = $this->input->post('itemTaxIGST');
			$item_cess_tax_rate = $this->input->post('itemTaxCESS');

			$item_cgst_amount = $this->input->post('itemTaxAmountCGST');
			$item_sgst_amount = $this->input->post('itemTaxAmountSGST');
			$item_igst_amount = $this->input->post('itemTaxAmountIGST');
			$item_cess_amount = $this->input->post('itemTaxAmountCESS');
			$item_subtotal 		= array_filter( $this->input->post('itemSubTotal') );
			$client_id 			= $this->input->post('client_id');
			$quote_number 		= $this->input->post('quote_number');

			$this->quotes->set_table('quotes_items');
			for($i = 0; $i < $items_num; $i++){
				$item_array = array(
					'quote_number' 		=> $quote_number,
					'client_id' => $client_id,
					'user_id' => $m->getUserID(),
					'item_sku' => $item_sku[$i],
					'specific_serial_number' => $specific_serial_number[$i],
					'item_id' => $item_id[$i],
					'item_group' => $this->m_manager->category_id($item_id[$i]),
					'item_name' => addslashes($item_name[$i]),
					'item_hsn_sac' => $item_hsn_sac[$i],
					'item_uom' => $item_uom[$i],
					'item_price' => $item_price[$i],
					'item_discount' => $item_discount[$i],
					'item_quantity' => $item_quantity[$i],
					'item_subtotal' => $item_subtotal[$i],
					'item_tax_rate' => $item_tax_rate[$i],
					'item_cgst_rate' => $item_cgst_tax_rate[$i],
					'item_sgst_rate' => $item_sgst_tax_rate[$i],
					'item_igst_rate' => $item_igst_tax_rate[$i],
					'item_cess_rate' => $item_cess_tax_rate[$i],
					'item_cgst_amount' => $item_cgst_amount[$i],
					'item_sgst_amount' => $item_sgst_amount[$i],
					'item_igst_amount' => $item_igst_amount[$i],
					'item_cess_amount' => $item_cess_amount[$i]
					);
				if ($this->input->post('quote_id'))
				{
					$item_array['user_id'] = $this->input->post('user_id');
				}
				if ($repair_number) {
					$item_array['repair_number']			= $repair_number;
				}
				$this->quotes->save($item_array);
				$this->response = array('status' => 1);
			}
			// End insert items
			// Since 1.5 Add Item to database if not found in autocomplete
			if ( ! $repair_number) {
				for($i = 0; $i < $items_num; $i++){
					if ( !item_exists($item_name[$i]) )
					{
						$new_item_array = array(
							'sku' => null !== $item_sku[$i] ? $item_sku[$i]: generate_sku(),
							'serial_number' => json_encode(null !== $specific_serial_number[$i] ? (array)$specific_serial_number[$i]: array()),
							'group_id' => 0,
							'name' => addslashes($item_name[$i]),
							'price' => $item_price[$i]
							);
						$this->load->model('products/products_model', 'items');
						$this->items->set_table('items');
						$this->items->save($new_item_array);
					}
				}
			}
			// Do not send email for Draft Invoices or on update
			if ($quoteTable['quote_status'] !== 'Draft' && $client_id > 0 && $this->input->post('notify_client') == 1)
			{
				$data = array(
					'quote_url'				=> base_url( 'index.php/viewquote/view?id=' ) . _eID( $quoteTable['quote_number'] ),
					'accept_quote_url'	    => base_url( 'index.php/viewquote/view_accepted?id=' ) . _eID( $quoteTable['quote_number'] ),
					'decline_quote_url'	    => base_url( 'index.php/viewquote/view_declined?id=' ) . _eID( $quoteTable['quote_number'] ),
					'to_name'               => html_entity_decode(htmlentities((client( $client_id, 'name_company' )))),
					'date'		    		=> _fdate( $client_language, $quoteTable['date'] ),
					'due_date'		    	=> _fdate( $client_language, $quoteTable['due_date'] ),
					'quote_status'			=> __( strtolower( $quoteTable['quote_status'] ), $client_id ),
					'quote_number' 			=> get_option( 'quote_prefix' ).invoice_number_format() . sprintf( "%04s", $quoteTable['quote_number'] ),
					'quotesubject'			=> $quoteTable['subject'],
					'btn_accept_quote' 		=> __( 'btn_accept_quote', $client_id ),
					'btn_decline_quote' 	=> __( 'btn_decline_quote', $client_id ),
					'btn_client_account' 	=> __( 'btn_client_account', $client_id ),
					'client_account'		=> base_url( 'index.php/client/index?id=' ) . _eID( $client_id )
					);
				$data['quote_amount'] 		= add_currency( format_number( $quoteTable['total'] * $change_rate ), $client_id );
				$data['amount_due'] 		= add_currency( format_number( $quoteTable['amount_due'] * $change_rate ), $client_id );
				$data['logo_url'] 			= base_url( 'uploads/admin/img/' ). get_option( 'logo' );

				$this->load->helper( 'file' );
				$lang = lang_code_to_notif_string( $client_language );
				$path_new_quote = './notifications/' . $lang . '/quotes/new_quote.php';
				$path_accepted_quote = './notifications/' . $lang . '/quotes/quote_accepted.php';

				$to = client( $client_id, 'client_email' );

				$template = ( $quoteTable['quote_status'] === "Accepted" ) ? read_file( $path_accepted_quote ) :
				read_file($path_new_quote);
				$subject = ( $quoteTable['quote_status'] === "Accepted" ) ? __( 'subject_quote_approved' ) : __( 'subject_quote_generated' );
				$message = ( $quoteTable['quote_status'] === "Accepted" ) ? 
				$this->parser->parse_string( $template, $data, true ) : 
				$this->parser->parse_string( $template, $data, true );

				if ($client_id) {
					$client_cc = json_decode( null !== client($client_id, 'client_cc' ) ? client($client_id, 'client_cc' ): json_encode( array() ));
					if (1 == get_option('attach_pdf_to_invoice')) {
						generate_pdf_file('quotes', $quote_number);
					}
				}
				$attachments[] = FCPATH.'uploads/pdf/quotes/'.$quote_number.'.pdf';
				send_email($to, $message, $subject, null, $client_cc, $attachments, get_option('quote_prefix').invoice_number_format() . sprintf("%04s", $quote_number).'.pdf');
			}
		}
		echo json_encode( $this->response );
	}
}