<?php defined('BASEPATH') OR exit('No direct script access allowed');
use Mmanager\Domain\Factory\InvoiceFactory;
/**
 * 
 */
class Quotes extends Admin_Controller {
	/**
	 * @var type
	 */
	protected $_invoice = [];

	/**
	 * @var type
	 */
	protected $_client = [];

	/**
	 * Description
	 * @return type
	 */
	public function __construct(){
		parent::__construct();
		$this->load->model('clients/clients_model', 'clients');
		$this->clients->set_primary_key('client_id');
		$this->load->model('quotes_model', 'quotes');
		
        $this->view_data['modal'] = $this->Template->render('clients', 'add_client_modal.phtml', '', true);
        $this->data['breadcrumb'] = anchor('quotes', __('link_quotes'));
        $this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}
	
	/**
	 * Description
	 * @param type|null $a 
	 * @param type|null $id 
	 * @return type
	 */
	public function index()
	{
		$this->view_data['pageJs'] = array(
	       	'invoices-index.js');
		$view_data = array(
			'breadcrumb' 		=> anchor('quotes', __('link_quotes')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_quotes'),
			'page_description' 	=> __('message_manage') .' '.__('quotes_quotes'),
			'user_language' => get_option('user_language', 'users_options'),
			'filter'		=> 'All',
			'pageJs'        => 'invoices-index.js'
			);
		if (can_access('invoices')) {
			$this->view_data['content'] = $this->Template->render('quotes', 'index.phtml', $view_data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function create_quote()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js',
	        );
		}
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$data = array(
			'breadcrumb' 		=> anchor('quotes', __('link_quotes')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_quotes'),
			'page_description' 	=> __('link_add_new') .' '.__('quotes_quote'),
			'clients'         => clients()
			);
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('quotes', 'create_quote_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		if ( _has_option( 'is_indian') )
		{
			$this->view_data['pageJs'] = array(
	            'indian-invoices.js'
	        );
		}
		elseif ( _has_option( 'is_romanian') )
		{
			$this->view_data['pageJs'] = array(
	            'romanian-invoices.js'
	        );
		}
		else
		{
			$this->view_data['pageJs'] = array(
	            'invoices.js',
	        );
		}
		$this->view_data['page_header'] = $this->Template->render('invoices', 'rounding_header.phtml', '', true);
        $this->view_data['externalPluginJs'] = array(
            'https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js',
        );
		$id = _dID($_REQUEST['id']);
		$view_data = array(
			'breadcrumb' 		=> anchor('quotes', __('link_quotes')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_quotes'),
			'page_description' 	=> __('message_manage') .' '.__('quotes_quote'),
			'user_language' => get_option('user_language', 'users_options'),
			'quotes' => get_quote_by_number($id),
			'invoiceObj' => new InvoiceFactory,
			'quote_items' => get_quoted_items($id),
			'clients' => json_encode(clients()),
			'quote_status' => array(
				'Accepted' => __('label_accepted'),
				'Declined' => __('label_declined'),
				'Pending' => __('label_pending'),
				'Draft' => __('label_draft'),
				'Cancelled' => __('label_cancelled')
				)
			);
		$this->view_data['content'] = $this->Template->render('quotes', 'edit_quote_form.phtml', $view_data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function delete_quote()
	{
		$protected = [];
		$to_del = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (quote_status($i) !== 'is_accepted')
				{
					array_push($to_del, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_del);
			$response['fail'] = count($protected);

			if(!empty($to_del))
			{
				delete('quotes', 'quote_number', $to_del);
			}
		}
		echo json_encode($response);
	}
	public function mark_approved()
	{
		$protected = [];
		$to_mark_approved = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (quote_status($i) !== 'is_accepted')
				{
					array_push($to_mark_approved, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_mark_approved);
			$response['fail'] = count($protected);

			if(!empty($to_mark_approved))
			{
				mass_approved($to_mark_approved);
			}
		}
		echo json_encode($response);
	}
	public function mass_quotes_email()
	{
		$protected = [];
		$to_send = [];
		$ids = _dID($_REQUEST['id']);
		$response = [];
		if (is_array($ids))
		{
			foreach ($ids as $i) {
				if (quoted_to_guest($i) > 0)
				{
					array_push($to_send, $i);
				}
				else
				{
					array_push($protected, $i);
				}
			}
			$response['success']  = count($to_send);
			$response['fail'] = count($protected);

			if(!empty($to_send))
			{
				foreach ($to_send as $quote_number) {
					$this->m_manager->send_quote_email($quote_number);
				}
			}
		}
		echo json_encode($response);
	}
	public function quotes_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'id';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : null;

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$quotes = $this->quotes->findAll(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination
			)
		);

		if ($quotes)
		{
			foreach ($quotes as $quote) {
				$quote = (object)$quote;
				array_push($rows, array(
					'id' 				  => $quote->id,
					'client_id'           => _eID($quote->client_id),
					'quote_number'   	  => $quote->quote_number,
					'enc_quote_number'    => _eID($quote->quote_number),
					'name_company'		  => $quote->name_company,
					'date'				  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $quote->date),
					'due_date'			  => _fdate( language_string_to_locale_notation( get_option('user_language', 'users_options') ), $quote->due_date),
					'total'				  => format_number($quote->total),
					'quote_status'              => __(strtolower($quote->quote_status)),
					'stbool'			  => quote_status($quote->quote_number)
					)
				);
			}
			if ( $search) {
				$list = array(
					'total' => count($quotes),
					'totalNotFiltered' => count($quotes),
					'rows' => $rows
				);
			} else {
				$total = $this->quotes->count_rows('quotes', $filter);
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows

				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
	public function next_quote_number()
	{
		echo json_encode(next_quote_number());
	}
}