<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Reports extends Admin_Controller {
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reports_model', 'reports');
		$this->load->library('m_manager');
		$this->data['breadcrumb'] = anchor('reports', __('link_reports'));
		$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}

	public function index()
	{
		if (can_access('invoices')) {
			$data = array(
				'breadcrumb' 		=> anchor('reports', __('link_reports')),
				'toolbar'    		=> "",
				'page_title' 		=> __('link_reports'),
				'page_description' 	=> __('message_view_data'),
				);
			$this->view_data['content'] = $this->Template->render('reports', 'index.phtml', $data, TRUE);
			// Load the template from the views directory
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function income_by_category()
	{
		$incomeByCategory = [];
		$interval = (!isset($_REQUEST['interval'])) ? 'this_month' : $_REQUEST['interval'];
		$results = income_by_category($interval);
		foreach ($results as $value) 
		{
		 	$incomeByCategory[] = array(
		 		'name' => ($value->name === null) ? __('uncategorized'): $this->m_manager->category_name($value->name),
		 		'value'    => floatval($value->value)
		 	);
		 }
		 echo json_encode($incomeByCategory);
	}
	public function financial_accounting($interval=null)
	{
	    if (isset($_REQUEST['interval']))
	    {
	        $interval = $_REQUEST['interval'];
	        echo json_encode(financial_accounting($interval));
	    }
	    else 
	    {
	        echo json_encode(financial_accounting(3));
	    }
	}
	public function home_chart_invoiced_items_count()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'this_month' : $_REQUEST['filter'];
		$is_service = empty($_REQUEST['is_service']) ? 0 : $_REQUEST['is_service'];
		$counts = home_chart_invoiced_items_count($filter);
		if ($counts)
		{
			if ($is_service == 1) {
				foreach ($counts as $count) {
					if ($count->quantity > 0 && 1 == is_service(sku_to_name($count->sku))) { // Remove refunded items
						array_push($list, array(
						'sku' 		=> $count->sku,	
						'name' 		=> sku_to_name($count->sku),	
						'quantity' 	=> intval($count->quantity),	
						'value' 	=> floatval($count->value),	
							)
						);
					}
				}
			} else {
				foreach ($counts as $count) {
					if ($count->quantity > 0 && 0 == is_service(sku_to_name($count->sku))) { // Remove refunded items
						array_push($list, array(
						'sku' 		=> $count->sku,	
						'name' 		=> sku_to_name($count->sku),	
						'quantity' 	=> intval($count->quantity),	
						'value' 	=> floatval($count->value),	
							)
						);
					}
				}
			}
		}
		echo json_encode($list);
	}
	public function get_invoiced_items_count()
	{
		$list = [];

		if (isset($_REQUEST['start']))
		{
		    $start = $_REQUEST['start'];
		    $end = $_REQUEST['end'];
		}
		
		$is_service = isset($_REQUEST['isservice']) ? $_REQUEST['isservice']: 0;
		$counts = invoiced_items_count($start, $end);
		if ($counts)
		{
			if ($is_service == 1) {
				foreach ($counts as $count) {
					if ($count->quantity > 0 && 1 == is_service(sku_to_name($count->sku))) { // Remove refunded items
						array_push($list, array(
						'sku' 		=> $count->sku,	
						'name' 		=> sku_to_name($count->sku),	
						'quantity' 	=> intval($count->quantity),	
						'value' 	=> floatval($count->value),	
							)
						);
					}
				}
			} else {
				foreach ($counts as $count) {
					if ($count->quantity > 0 && 0 == is_service(sku_to_name($count->sku))) { // Remove refunded items
						array_push($list, array(
						'sku' 		=> $count->sku,	
						'name' 		=> sku_to_name($count->sku),	
						'quantity' 	=> intval($count->quantity),	
						'value' 	=> floatval($count->value),	
							)
						);
					}
				}
			}
		}
		echo json_encode($list);
	}
	public function get_income_by_client()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$clients = clients();
		if ($clients)
		{
			foreach ($clients as $client) {
				$income = report_income_by_client($client->client_id, $start, $end);
				if ($income > 0) {
					array_push($list, array(
						'name' 		=> client($client->client_id, 'name_company'),	
						'value' 	=> floatval($income)
						)
					);
				}
			}
		}
		echo json_encode($list);
	}
	public function get_income_by_user()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];
		$eligible_roles = json_decode( null !== get_option( 'eligible_roles' ) ? get_option( 'eligible_roles' ): json_encode([]));

		$users = get_users();
		if ($users)
		{
			foreach ($users as $user) {
				if (in_array( strtolower(hasRole($user->id, false)), $eligible_roles)) {
					$results = report_income_by_user($user->id, $start, $end);
					foreach ($results as $key => $value) {
						if ($value->TotalPaid > 0) {
							array_push($list, array(
								'name' 		=> get_user_var($user->id, 'first_name'),
								'user_id'	=> _eID($value->UserID),
								'value' 	=> floatval($value->TotalPaid),
								'paid_commission' => floatval($value->PaidCommission),
								'unpaid_commission' => floatval($value->UnPaidCommission),
								'payment_method' => get_user_payment_method($user->id)
								)
							);
						}
					}
				}
			}
		}
		echo json_encode($list);
	}
	public function chart_income_by_client()
	{
		$list = [];
		$filter = empty($_REQUEST['filter']) ? 'this_month' : $_REQUEST['filter'];
		$clients = clients();
		if ($clients)
		{
			foreach ($clients as $client) {
				$income = income_by_client($client->client_id,	$filter);
				if ($income > 0) {
					array_push($list, array(
						'name' 		=> client($client->client_id, 'name_company'),	
						'value' 	=> $income
						)
					);
				}
			}
		}
		echo json_encode($list);
	}
	public function tax_report()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode(tax_report($start_date, $end_date));
	}
	public function additional_taxes_report()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode(additional_taxes_report($start_date, $end_date));
	}
	public function tax_report_cgst()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode(tax_report_cgst($start_date, $end_date));
	}
	public function tax_report_sgst()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode(tax_report_sgst($start_date, $end_date));
	}
	public function tax_report_igst()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode(tax_report_igst($start_date, $end_date));
	}
	public function monthly_orders_report()
	{
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode( monthly_orders_report($start_date, $end_date) );
	}
	public function get_tax_total()
	{
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];
		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode(get_tax_totals($start, $end));
	}
	public function get_additional_taxes_total()
	{
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];
		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

		echo json_encode(get_tax_totals($start, $end));
	}
	public function income_annual()
	{
		$list = [];
		$incomes = report_annual_income();
		if ($incomes)
		{
			foreach ($incomes as $income) {
				if ($income['incomes'] > 0) {
					array_push($list, array(
						'name' 		=> $income['year'],	
						'value' 	=> $income['incomes'],
						'taxes' 	=> $income['taxes'],
						'total_with_taxes' 	=> floatval($income['taxes']) + floatval($income['incomes'])
						)
					);
				}
			}
		}
		echo json_encode($list);
	}
	public function income_forecast()
	{
	    echo json_encode(report_forecast_income());
	}
	public function view()
	{
		$data = array(
			'breadcrumb' 		=> anchor('reports', __('link_reports')),
			'toolbar'    		=> "",
			'page_title' 		=> __('link_reports'),
			'page_description' 	=> __('message_view_data')
			);
		$this->view_data['pluginsJs'] = array(
		    'https://cdnjs.cloudflare.com/ajax/libs/echarts/4.0.4/echarts.min.js'
		);
		$a = isset($_REQUEST['a']) ? $_REQUEST['a'] : "";
		switch ($a) {
			case 'tax_report':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_tax_report'),
					'page_description' 	=> __('message_tax_report')
					);
				if ( ! _has_option( 'is_indian' ) )
				{
					$this->view_data['pageJs'] = array(
			            'reports.js'
		        	);
				}
				else
				{
					$this->view_data['pageJs'] = array(
			            'india-cgst-reports.js',
			            'india-sgst-reports.js',
			            'india-igst-reports.js'
		        	);
				}
				$view_file = "tax_report.phtml";
				break;
			case 'additional_tax_report':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_tax_report'),
					'page_description' 	=> __('message_tax_report')
					);
				$this->view_data['pageJs'] = array(
					'additional_taxes_reports.js'
		        );
				$view_file = "additional_tax_report.phtml";
				break;
			case 'monthly_orders_report':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_monthly_order'),
					'page_description' 	=> __('message_monthly_order')
					);
				$this->view_data['pageJs'] = array(
		            'products.js',
		            'monthly-order-report.js'
		        );
				$view_file = "monthly_orders_report.phtml";
				break;
			case 'income_per_product':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_income_per_product'),
					'page_description' 	=> __('message_income_per_product')
					);
				$this->view_data['pageJs'] = array(
		            'products.js',
		            'products-report.js'
		        );
				$view_file = "income_per_product.phtml";
				break;
			case 'income_per_service':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_income_per_service'),
					'page_description' 	=> __('message_income_per_service')
					);
				$this->view_data['pageJs'] = array(
		            'products.js',
		            'products-report.js'
		        );
				$view_file = "income_per_service.phtml";
				break;
			case 'income_per_customer':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_income_per_customer'),
					'page_description' 	=> __('message_income_per_customer')
					);
				$this->view_data['pageJs'] = array(
		            'products.js',
		            'client-income.js'
		        );
				$view_file = "income_per_client.phtml";
				break;
			case 'income_per_user':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_income_per_user'),
					'page_description' 	=> __('message_income_per_user')
					);
				$this->view_data['pageJs'] = array(
		            'products.js',
		            'user-income.js'
		        );
		        $this->view_data['page_header'] = $this->Template->render('reports', 'user_commission_header.phtml', '', true);
				$view_file = "income_per_user.phtml";
				break;
			case 'income_annual':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_income_annual'),
					'page_description' 	=> __('message_income_annual')
					);
				$this->view_data['pageJs'] = array(
		            'products.js',
		            'income-annual.js'
		        );
				$view_file = "income_annual.phtml";
				break;
			case 'income_forecast':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_income_forecast'),
					'page_description' 	=> __('message_income_forecast')
					);
				$this->view_data['pageJs'] = array(
		            'products.js',
		            'income-forecast.js'
		        );
		        $this->view_data['page_header'] = $this->Template->render('reports', 'income_forecast_page_header.phtml', '', true);
				$view_file = "income_forecast.phtml";
				break;
			case 'cashflow':
				$data = array(
					'breadcrumb' 		=> anchor('reports', __('link_reports')),
					'toolbar'    		=> "",
					'page_title' 		=> __('label_cashflow'),
					'page_description' 	=> __('message_cashflow')
					);
				$this->view_data['pageJs'] = array(
					'cashflow.js',
				);
		        $this->view_data['page_header'] = $this->Template->render('reports', 'cashflow_page_header.phtml', '', true);
				$view_file = "cashflow.phtml";
				break;
			default:
				$this->index();
		}
		$this->view_data['content'] = $this->Template->render('reports', $view_file, $data, TRUE);
		// Load the template from the views directory
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function generate_commissions() {
		$pay = isset($_REQUEST['pay']) ? $_REQUEST['pay']: false;
		if (batch_pay_commissions($pay)) {
			echo json_encode(array('success' => 1));
		} else {
			echo json_encode(array('fail' => 1));
		}
	}
	public function generate_users_commissions() {
		$pay = isset($_REQUEST['pay']) ? $_REQUEST['pay']: false;
		$ids = $_REQUEST['id'];
		
		if (batch_pay_users_commissions($ids, $pay)) {
			echo json_encode(array('success' => 1));
		} else {
			echo json_encode(array('fail' => 1));
		}
	}
    public function cashflow()
    {
		$list = [];
		$start = $_REQUEST['start'];
		$end = $_REQUEST['end'];

		$user_language = get_option('default_language');
		$start_date = mysqlDate($user_language, $start);
		$end_date = mysqlDate($user_language, $end);

    	$results = get_transactions($start_date, $end_date);
		if ($results) {
			foreach ($results as $trans) {
				if ($trans->charges_name && $trans->charges_value > 0) {
					array_push($list, array(
						'date' => $trans->created_on,
						'payee' => $trans->charges_name,
						'charges_value' => floatval($trans->charges_value),
					));
				}
				if ($trans->incomes_name && $trans->incomes_value > 0) {
					array_push($list, array(
						'date' => $trans->created_on,
						'payee' => $trans->incomes_name,
						'incomes_value' => floatval($trans->incomes_value)
					));
				}
			}
		}
		echo json_encode($list);
	}
}