<?php defined('BASEPATH') OR exit('No direct script access allowed');
use PhpRbac\Rbac;
/**
 * 
 */
class Reports_model extends MY_Model{

	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
	}
	public function incomeByCategory($interval=null)
	{
		$rbac = new Rbac;
		if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
			$additional_where = ' AND user_id = '. USERID;
		} else {
			$additional_where = '';
		}
		$range = isset($_REQUEST['interval']) ? $_REQUEST['interval'] : 3;
		switch ($interval) {
			case 'this_month':
				$range = 1;
				break;
			case 'latest_three_months':
				$range = 3;
				break;
			case 'this_year':
    				$query = "SELECT I.item_group AS iTemGroup,
    				SUM(CASE WHEN invoice_is_cancelled = 0 
    					THEN item_quantity ELSE 0 End) - 
    				SUM(CASE WHEN invoice_is_cancelled = 1
    						THEN item_quantity ELSE 0 End) AS total_qty
    				FROM oc_invoiceitems I
    				WHERE YEAR(date_paid) = YEAR(CURDATE()) {$additional_where}
          			GROUP BY item_group
          			ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			case 'last_month':
				$query = "SELECT I.item_group AS iTemGroup,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS total_qty
				FROM oc_invoiceitems I
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}
      			GROUP BY item_group
      			ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			case 'last_year':
				$query = "SELECT I.item_group AS iTemGroup,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS total_qty
				FROM oc_invoiceitems I
				WHERE YEAR(date_paid) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 YEAR)) {$additional_where}
      			GROUP BY item_group
      			ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			case 'all_dates':
				$query = "SELECT I.item_group AS iTemGroup,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS total_qty
				FROM oc_invoiceitems I
				WHERE YEAR(date_paid) IS NOT NULL {$additional_where}
      			GROUP BY item_group
      			ORDER BY item_group ASC";
				return $this->oneric->get_results($query);
				break;
			default:
				$range = 3;
				break;
		}
		$query = "SELECT I.item_group AS iTemGroup,
		SUM(CASE WHEN invoice_is_cancelled = 0 
			THEN item_quantity ELSE 0 End) - 
		SUM(CASE WHEN invoice_is_cancelled = 1
				THEN item_quantity ELSE 0 End) AS total_qty
		FROM oc_invoiceitems I
		WHERE date_paid >= last_day(NOW()) + INTERVAL 1 DAY - INTERVAL {$range} MONTH {$additional_where}
		GROUP BY item_group
		ORDER BY item_group ASC";
		return $this->oneric->get_results($query);
	}
	public function chartSales($interval)
	{
		$rbac = new Rbac;
		if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
			$additional_where = ' AND user_id = '. USERID;
		} else {
			$additional_where = '';
		}
		switch ($interval) {
			case 'last_month':
				$query = "SELECT I.item_name AS name,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS count,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_subtotal ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_subtotal ELSE 0 End) AS value
				FROM oc_invoiceitems I
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			case 'this_month':
				$query = "SELECT I.item_name AS name,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS count,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_subtotal ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_subtotal ELSE 0 End) AS value
				FROM oc_invoiceitems I
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) {$additional_where}
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
			
			default:
				$query = "SELECT I.item_name AS name,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS count,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_subtotal ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_subtotal ELSE 0 End) AS value
				FROM oc_invoiceitems I
				WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) {$additional_where}
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_name";
				return $this->oneric->get_results($query);
				break;
		}
	}
	public function invoicedItemsSum($interval = false, $start = false, $end = false)
	{
		$rbac = new Rbac;
		if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
			$additional_where = ' AND user_id = '. USERID;
			$additional_unique_where = ' WHERE user_id = '. USERID;
		} else {
			$additional_where = '';
		}

		if ($interval) {
			switch ($interval) {
				case 'last_month':
					$query = "SELECT I.item_sku AS sku,
					SUM(CASE WHEN invoice_is_cancelled = 0 
						THEN item_subtotal ELSE 0 End) - 
					SUM(CASE WHEN invoice_is_cancelled = 1
							THEN item_subtotal ELSE 0 End) AS value
					FROM oc_invoiceitems I
					WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}
					GROUP BY item_sku";
					return $this->oneric->get_results($query);
					break;
				case 'this_month':
					$query = "SELECT I.item_sku AS sku,
					SUM(CASE WHEN invoice_is_cancelled = 0 
						THEN item_subtotal ELSE 0 End) - 
					SUM(CASE WHEN invoice_is_cancelled = 1
							THEN item_subtotal ELSE 0 End) AS value
					FROM oc_invoiceitems I
					WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) {$additional_where}
					AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
					GROUP BY item_sku";
					return $this->oneric->get_results($query);
					break;
				
				default:
					$query = "SELECT I.item_sku AS sku,
					SUM(CASE WHEN invoice_is_cancelled = 0 
						THEN item_subtotal ELSE 0 End) - 
					SUM(CASE WHEN invoice_is_cancelled = 1
							THEN item_subtotal ELSE 0 End) AS value
					FROM oc_invoiceitems I
					WHERE date_paid IS NOT NULL AND MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) {$additional_where}
					AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
					GROUP BY item_sku";
					return $this->oneric->get_results($query);
					break;
			}
		} else {
			$query = "SELECT I.item_sku AS sku,
			SUM(CASE WHEN invoice_is_cancelled = 0 
				THEN item_subtotal ELSE 0 End) - 
			SUM(CASE WHEN invoice_is_cancelled = 1
					THEN item_subtotal ELSE 0 End) AS value
			FROM oc_invoiceitems I
			WHERE date_paid BETWEEN '{$start}' AND '{$end}' {$additional_where}
			GROUP BY item_sku";
			return $this->oneric->get_results($query);
		}
	}
	public function invoicedItemsCount($interval)
	{
		$rbac = new Rbac;
		if ( $rbac->check('report_owner', USERID) AND ! $rbac->check('report_access_any', USERID)) {
			$additional_where = ' AND user_id = '. USERID;
		} else {
			$additional_where = '';
		}
		switch ($interval) {
			case 'last_month':
				$query = "SELECT I.item_sku AS sku,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS value
				FROM oc_invoiceitems I
				WHERE MONTH(date_paid) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH ) AND YEAR(date_paid) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH ) {$additional_where}
				GROUP BY item_sku";
				return $this->oneric->get_results($query);
				break;
			case 'this_month':
				$query = "SELECT I.item_sku AS sku,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS value
				FROM oc_invoiceitems I
				WHERE MONTH(date_paid) = MONTH(CURRENT_TIMESTAMP) {$additional_where}
				AND YEAR(date_paid) = YEAR(CURRENT_TIMESTAMP)
				GROUP BY item_sku";
				return $this->oneric->get_results($query);
				break;
			default:
				$query = "SELECT I.item_sku AS sku,
				SUM(CASE WHEN invoice_is_cancelled = 0 
					THEN item_quantity ELSE 0 End) - 
				SUM(CASE WHEN invoice_is_cancelled = 1
						THEN item_quantity ELSE 0 End) AS value
				FROM oc_invoiceitems I {$additional_unique_where}
				GROUP BY item_sku";
				return $this->oneric->get_results($query);
				break;
		}
	}
}