<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 */
class Ajax extends Ajax_Controller
{
	/**
	 * Description
	 * @return type
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('services_model', 'services');
	}
	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function create_group($id = NULL)
	{
		$post_array = array(
			'group_name'					=> $this->input->post('group_name'),
			'group_description'				=> $this->input->post('description'),
			'is_service'					=> $this->input->post('is_service')
			);
		$config = array(
			array(
                    'field' => 'group_name',
                    'label' => lang('group_name'),
                    'rules' => 'required',
                    'errors' => array(
                            'required' => lang('error_required_group')
                            )
                )
			);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('group_id');
		$is_modal = $this->input->post('is_modal');

		if ($id === NULL)
		{
			if (!$is_modal)
			{
				$this->services->set_table('items_groups');
				$this->response = ($this->form_validation->run() === TRUE && $this->services->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors());
			}
			else
			{
				$this->services->set_table('items_groups');
				$this->response = ($this->form_validation->run() === TRUE && $this->services->save($post_array) != 0) ?
				array('status' => 1) :
				array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			}
			echo json_encode($this->response);
		}
		else
		{
			$this->services->set_table('items_groups');
			$this->services->set_primary_key('group_id');
			$this->response = ($this->form_validation->run() == TRUE && $this->services->save($post_array, $id) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			echo json_encode($this->response);
		}
	}
	/**
	 * Description
	 * @param type|null $id 
	 * @return type
	 */
	public function add_service($id=false)
	{
		
		if ($this->input->post('product_group') != -1)
		{
			$post_array['group_id'] 			= $this->input->post('product_group');
		}
		else
		{
			$post_array['group_id'] = 0;
		}
		if ($this->input->post('tax_id') != -1)
		{
			$post_array['tax_id'] 			= $this->input->post('tax_id');
		}
		$post_array['sku'] 					= $this->input->post('product_sku');
		$post_array['name'] 				= $this->input->post('product_name');
		$post_array['description'] 			= $this->input->post('product_description');
		$post_array['price'] 				= $this->input->post('product_price');
		$post_array['purchase_price'] 		= $this->input->post('purchase_price');
		$post_array['item_profit'] 			= $this->input->post('item_profit');
		$purchase_price 		            = isset($post_array['purchase_price']) ? $post_array['purchase_price']: 0;
		$post_array['current_stock'] 		= $this->input->post('current_stock');
		$post_array['provider_name'] 		= $this->input->post('provider_name');
		$post_array['provider_contact'] 	= $this->input->post('provider_contact');
		$post_array['is_service'] 			= $this->input->post('is_service');
		$item_status	                    = $this->input->post('item_status');
		$post_array['item_status']          = isset($item_status) ? $item_status : 1;
		$config = array(
                array(
                        'field' => 'product_name',
                        'label' => lang('label_name'),
                        'rules' => 'required',
                        'errors' => array(
                        'required' => lang('error_required_name').'<br />',
                        ),
                ),
                array(
                        'field' => 'product_sku',
                        'label' => __('label_sku'),
                        'rules' => 'required',
                        'errors' => array(
                        'required' => __('error_required_sku').'<br />',
                        ),
                ),
                array(
                        'field' => 'product_description',
                        'label' => lang('description'),
                        'rules' => ''
                ),
                array(
                        'field' => 'product_price',
                        'label' => lang('price'),
                        'rules' => 'required',
                        'errors' => array(
                        'required' => lang('error_required_price').'<br />',
                        ),
                )
        	);
		$this->form_validation->set_rules($config);
		$id = $this->input->post('item_id');
		if (!$id)
		{
			$this->services->set_table('items');
			$db_data = array(
				'charges_name' 		=> $post_array['name'],
				'charges_category' 	=> __('charges_purchases'),
				'charges_value'	    => floatval(0),
				'created_on' 	    => 'NOW()',
				'item_sku'			=> $post_array['sku']
				);
			record_charges($db_data);
			$this->response = ($this->form_validation->run() === TRUE && $this->services->save($post_array) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors());
			echo json_encode($this->response);
		}
		else
		{
			$this->services->set_table('items');
			$this->services->set_primary_key('item_id');
			$this->response = ($this->form_validation->run() == TRUE && $this->services->save($post_array, $id) != 0) ?
					array('status' => 1) :
					array('status' => 0, 'error' => validation_errors('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>'));
			$this->services->update_invoiced_items_group($id, $post_array['group_id']);
			echo json_encode($this->response);
		}
	}
}