<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * 
 */
class Services extends Admin_Controller {
	/**
	 * Description
	 * @return type
	 */

	public function __construct(){
		parent::__construct();
		$this->load->model('services_model', 'services');
		$this->load->model('products/products_model', 'items');
		$this->view_data['pageJs'] = array(
            'products.js',
            'taxes.js',
        );
		$this->view_data['modal'] = array(
			$this->Template->render('services', 'add_service_modal.phtml', '', true),
			$this->Template->render('providers', 'add_provider_modal.phtml', '', true)
		);
		$this->data['breadcrumb'] = anchor('services', __('link_services'));
		$this->view_data['content'] = $this->Template->render('users', 'access_deny.phtml', $this->data, TRUE);
	}

	/**
	 * Description
	 * @param type|string $a 
	 * @param type|null $id 
	 * @return type
	 */

	public function index()
	{
		$data = array(
			'breadcrumb' 		=> anchor('services', __('link_services')),
			'toolbar'    		=> "",
			'page_title' 		=> __('services_services'),
			'page_description' 	=> __('message_manage') . ' ' . __('services_services'),
			'items' 			=> array(),
			'filter'			=> null
			);
		if (can_access('items')) {
			$this->view_data['content'] = $this->Template->render('services', 'index.phtml', $data, true);
		}
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function add_service()
	{
		$data = array(
			'breadcrumb' 		=> anchor('services', __('link_services')),
			'toolbar'    		=> "",
			'page_title' 		=> __('services_services'),
			'page_description' 	=> __('link_add_new') . ' ' . __('services_service'),
			'providers' => providers()
			);
		$this->view_data['page_header'] = $this->Template->render('products', 'page_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('services', 'add_service_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit()
	{
		$id = isset($_REQUEST['id']) ?  $_REQUEST['id'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('services', __('link_services')),
			'toolbar'    		=> "",
			'page_title' 		=> __('services_services'),
			'page_description' 	=> __('message_manage') . ' ' . __('services_service'),
			'groups' => $this->products_groups(),
			'providers' => providers(),
			'items'	=> $this->services->get_item($id), // with join clauses
			'item_status' => array(
				'1' => __('label_available'),
				'0' => __('label_out_of_stock')
				)
			);
		$this->view_data['page_header'] = $this->Template->render('products', 'page_header.phtml', '', true);
		$this->view_data['content'] = $this->Template->render('services', 'edit_service_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	public function edit_group()
	{
		$id = isset($_REQUEST['id']) ?  $_REQUEST['id'] : NULL;
		$data = array(
			'breadcrumb' 		=> anchor('services', __('link_services')),
			'toolbar'    		=> "",
			'page_title' 		=> "",
			'page_description' 	=> "",
			'groups'	=> $this->services->get_group($id)
			);
		$this->view_data['content'] = $this->Template->render('services', 'edit_category_form.phtml', $data, true);
		$this->Template->render('templates', 'layout.phtml', $this->view_data);
	}
	
	/**
	 * Description
	 * @return type
	 */
	public function get_products_groups()
	{
		echo json_encode($this->services->get_services_groups());
	}
	public function products_groups()
	{
		return $this->services->get_services_groups();
	}
	/**
	 * Description
	 * @return type
	 */
	public function delete_item()
	{
		$id = $this->input->post('id');
		$this->services->set_primary_key('item_id');
		
		$this->response = ($this->services->delete($id) != 0) ? true : false;
		echo json_encode($this->response); 
	}
	public function get_services_list()
	{
		$rows = [];
		$list = [];
		$pagination = false;
		$filter = isset($_REQUEST['filter']) ? $_REQUEST['filter'] : null;
		$order = isset($_REQUEST['order']) ? $_REQUEST['order'] : 'DESC';
		$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'name';
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 10;
		$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : null;

		if (1 == get_option('server_side_pagination')) {
			$pagination = true;
		}

		$items = $this->items->findAll(
			array(
				'status' => $filter,
				'order' => $order,
				'sort' => $sort,
				'offset' => $offset,
				'limit' => $limit, 
				'search' => $search,
				'pagination' => $pagination,
				'is_service' => 1
			)
		);
		if ($items)
		{
			foreach ($items as $item) {
				if (null !== $item->qrcode OR null !== $item->barcode) {
					$hasqrbar = 1;
				} else {
					$hasqrbar = 0;
				}
				array_push($rows, array(
					'item_id' 			  => $item->item_id,
					'sku'           	  => $item->sku,
					'name'   	 		  => $item->name,
					'group_name' 		  => $item->group_name,
					'group_id' 		  	  => $item->group_id,
					'price'		  		  =>format_number($item->price),
					'tax_percent'		  => $item->tax_percent,
					'item_status'         => $item->item_status,
					'item_status_str'     => '0.00' !== $item->current_stock ? $item->current_stock .'&nbsp;' .item_status_str($item->item_status) : '' .'&nbsp;' .item_status_str($item->item_status)
					)
				);
			}
			if ( $search) {
				$list = array(
					'total' => count($items),
					'totalNotFiltered' => count($items),
					'rows' => $rows
				);
			} else {
				$total = $this->items->count_items(true, $filter);
				$list = array(
					'total' => $total,
					'totalNotFiltered' => $total,
					'rows' => $rows

				);
			}
		}
		echo 1 == get_option('server_side_pagination') ? json_encode($list) :json_encode($rows);
	}
}